/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.model.bean.cadastro.exame.LabExternoBean;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.service.cadastro.exame.LabExternoService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.sql.SalvaDados;
import jalis.util.sql.SalvaDadosException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class IntegracaoLabExternoUtil {
    public static final int PROTOCOLO_PARDINI = 0;
    public static final int PROTOCOLO_ALVARO = 1;
    public static final int PROTOCOLO_MATRIX = 2;
    public static final int PROTOCOLO_SFRANCO = 3;
    public static final int PROTOCOLO_BALAGUE = 4;
    public static final int PROTOCOLO_REACAO = 5;
    public static final int PROTOCOLO_REDE = 6;
    public static final int PROTOCOLO_ATITUDE = 7;
    public static final int PROTOCOLO_DB = 8;
    public static final int PROTOCOLO_SOLUCAO = 9;
    public static final int PROTOCOLO_UNILAB = 10;
    public static final int PROTOCOLO_SYSLAB = 11;
    public static final int PROTOCOLO_SAOMARCOS = 12;
    public static final int PROTOCOLO_REDE_WS = 13;
    public static final int PROTOCOLO_INDLAB = 14;
    public static final int PROTOCOLO_MERCOLAB_WS = 15;
    public static final int PROTOCOLO_SHIFT = 16;
    public static final int PROTOCOLO_SOFTLAB = 17;
    public static final int PROTOCOLO_CONCENT = 1;
    public static final int PROTOCOLO_JALISWS = 1;
    public static final int PROTOCOLO_MARICONDI = 18;
    private static final Object[][] CAMPOS_PROTOCOLO = new Object[][]{{"ehp_codexame", "ehp_codmaterial", "ehp_descricaoexame", "ehp_xml"}, {"alv_codexame", "alv_codmaterial", "alv_descricaoexame", "alv_descricaomaterial", "alv_xml"}, {"mar_codexame", "mar_codexamenumerico", "mar_descricaoexame", "mar_xml"}, {"sgf_codigo", "sgf_descricao", "sgf_xml"}, {"bal_codexame", "bal_descricaoexame", "bal_descricaomaterial", "bal_xml"}, {"rea_codexame", "rea_codmaterial", "rea_descricaoexame", "rea_descricaomaterial", "rea_xml"}, {"red_codexame", "red_codmaterial", "red_descricaoexame", "red_descricaomaterial", "red_xml"}, {"ati_codexame", "ati_codmaterial", "ati_descricaoexame", "ati_descricaomaterial", "ati_xml"}, {"edb_codexame", "edb_descricaoexame", "edb_descricaomaterial", "edb_xml"}, {"eso_codexame", "eso_codmaterial", "eso_descricaoexame", "eso_xml"}, {"unl_codigoexame", "unl_codigomaterial", "unl_descricaoexame", "unl_xml", "unl_descricaomaterial"}, {"sys_codexame", "sys_descricaoexame", "sys_codmaterial", "sys_xml"}, {"sma_codexame", "sma_descricaoexame", "sma_codmaterial", "sma_descricaomaterial", "sma_xml"}, {"red_codexame", "red_codmaterial", "red_descricaoexame", "red_descricaomaterial", "red_xml"}, {"inl_codigoexame", "inl_descricaoexame", "inl_xml"}, {"eml_codexame", "eml_descricaoexame", "eml_xml"}, {"shi_codexame", "shi_descricaoexame", "shi_descricaomaterial", "shi_xml"}, new Object[0], {"mar_codexame", "mar_descricaoexame", "mar_xml"}};
    private static final Object[][] CAMPOS_CHAVE = new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0], new Object[0], new Object[0], new Object[0], new Object[0], new Object[0], new Object[0], {"unl_codigoexame", "unl_codigomaterial"}, {"sys_codexame"}, {"inl_codigoexame"}, new Object[0]};
    private static final int[][] CAMPOS_TIPO_CHAVE = new int[][]{new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], {0, 0}, {0}, {0}, new int[0]};
    private static final int[][] CAMPOS_TIPO = new int[][]{new int[0], {0, 0, 0, 0, 0}, {0, 2, 0, 0}, new int[0], {2, 0, 0, 0}, {0, 2, 0, 0, 0}, {0, 2, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0}, new int[0], {0, 0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0}, {0, 0, 0, 0}};
    public static final String[] TABELAS = new String[]{"examespardini", "examesalvaro", "examesmatrix", "examessergiofranco", "examesbalague", "examesreacao", "examesrede", "examesatitude", "examesdb", "examessolucao", "examesunilab", "examessyslab", "examessaomarcos", "examesrede", "examesindlab", "examesmercolab", "examesshift", "examessoftlab", "examesmatrix"};
    private static final int CAMPOS = 0;
    private static final int TIPO = 1;

    public static void deletaExame(Statement st, String filial, int codigoLabExterno, int protocolo, Object ... valores) throws SQLException, SalvaDadosException {
        IntegracaoLabExternoUtil.salvaExame(1, st, filial, codigoLabExterno, protocolo, valores);
    }

    public static void deletaExameUnicoPardini(Statement st, String filial, int codigoLabExterno, String codigoExame, String codigoMaterial) throws SQLException, SalvaDadosException {
        SalvaDados salvar = new SalvaDados(TABELAS[0], 1);
        salvar.setAdicionarAspasSimplesString(false);
        salvar.adicionaCampo("fil_codigo", 2, false, true, filial);
        salvar.adicionaCampo("lae_codigo", 2, false, true, codigoLabExterno);
        salvar.adicionaCampo("ehp_codexame", 0, false, true, StringUtil.textoDBEscape(codigoExame));
        salvar.adicionaCampo("ehp_codmaterial", 0, false, true, StringUtil.textoDBEscape(codigoMaterial));
        DBUtil.gravaAutoCopia(filial, st, salvar, "fil_codigo", ParametrosGerais.getCopiaLabExterno());
    }

    public static void removeLigacaoExameLabExterno(Statement st, String filial, int codigoLabExterno, String codigoExame, String descricaoExame) throws SQLException, SalvaDadosException {
        SalvaDados salvar = new SalvaDados("examematcoletalabexterno", 2);
        salvar.setAdicionarAspasSimplesString(false);
        salvar.adicionaCampo("fil_codigo", 2, false, true, filial);
        salvar.adicionaCampo("lae_codigo", 2, false, true, codigoLabExterno);
        salvar.adicionaCampo("exa_codigo", 0, false, true, StringUtil.textoDBEscape(codigoExame));
        salvar.adicionaCampo("mco_codigo", 0, false, true, StringUtil.textoDBEscape(descricaoExame));
        salvar.adicionaCampo("ele_xmllabexterno", 0, true, false, null);
        DBUtil.gravaAutoCopia(filial, st, salvar, "fil_codigo", ParametrosGerais.getCopiaLabExterno());
    }

    public static void updateExame(Statement st, String filial, int codigoLabExterno, int protocolo, Object ... valores) throws SQLException, SalvaDadosException {
        IntegracaoLabExternoUtil.salvaExame(2, st, filial, codigoLabExterno, protocolo, valores);
    }

    public static void insertExame(Statement st, String filial, int codigoLabExterno, int protocolo, Object ... valores) throws SQLException, SalvaDadosException {
        IntegracaoLabExternoUtil.salvaExame(0, st, filial, codigoLabExterno, protocolo, valores);
    }

    public static boolean existeExame(Statement st, String filial, int codigoLabExterno, int protocolo, Object ... camposChave) throws Exception {
        PreparedStatement ps;
        boolean retorno = false;
        StringBuilder query = new StringBuilder();
        query.append("select unl_codigoexame from ").append(TABELAS[protocolo]);
        query.append(" where ");
        query.append(" fil_codigo =  ? and ");
        query.append(" lae_codigo =  ? and ");
        if (CAMPOS_CHAVE[protocolo] != null && CAMPOS_CHAVE[protocolo].length == camposChave.length) {
            for (Object campo : CAMPOS_CHAVE[protocolo]) {
                if (campo == null) continue;
                query.append(campo.toString()).append(" =  ? and ");
            }
            int i = 1;
            ps = Conexao.getPreparedStatement(query.toString().substring(0, query.length() - 4));
            ps.setInt(i++, Integer.parseInt(filial));
            ps.setInt(i++, codigoLabExterno);
            for (int j = 0; j < camposChave.length; ++j) {
                if (camposChave[j] == null) continue;
                if (CAMPOS_TIPO_CHAVE[protocolo][j] == 0) {
                    ps.setString(i++, camposChave[j].toString());
                    continue;
                }
                if (CAMPOS_TIPO_CHAVE[protocolo][j] == 0) {
                    ps.setInt(i++, Integer.parseInt(camposChave[j].toString()));
                    continue;
                }
                throw new Exception("Par\u00e2metro do tipo n\u00e3o previsto campo" + CAMPOS_TIPO_CHAVE[protocolo][j] + " " + camposChave[j].toString());
            }
        } else {
            StringBuilder erro = new StringBuilder();
            throw new Exception("Protocolo inv\u00e1lido ou campos chave n\u00e3o atendem a necessidade para busca");
        }
        ResultSet rs = ps.executeQuery();
        retorno = rs != null && rs.next();
        ps.close();
        return retorno;
    }

    private static void salvaExame(int operacao, Statement st, String filial, int codigoLabExterno, int protocolo, Object ... valores) throws SQLException, SalvaDadosException {
        SalvaDados salvar = new SalvaDados(TABELAS[protocolo], operacao);
        salvar.setAdicionarAspasSimplesString(false);
        salvar.adicionaCampo("fil_codigo", 2, false, true, filial);
        salvar.adicionaCampo("lae_codigo", 2, false, true, codigoLabExterno);
        int i = -1;
        for (Object obj : valores) {
            ++i;
            if (obj == null) continue;
            Object campo = CAMPOS_PROTOCOLO[protocolo][i];
            int tipo = CAMPOS_TIPO[protocolo].length > 0 ? CAMPOS_TIPO[protocolo][i] : 0;
            String valorCampo = tipo == 0 ? StringUtil.textoDBEscape(obj.toString()) : obj.toString();
            salvar.adicionaCampo(campo.toString(), tipo, true, i < (protocolo == 3 || protocolo == 4 ? 1 : 2), valorCampo);
        }
        DBUtil.gravaAutoCopia(filial, st, salvar, "fil_codigo", ParametrosGerais.getCopiaLabExterno());
    }

    public static void salvaExameMatColetaLabExterno(Statement st, String filial, int codigoLabExterno, String exame, Integer material, String xml) throws SQLException, SalvaDadosException {
        SalvaDados salvar = new SalvaDados("examematcoletalabexterno", 2);
        salvar.adicionaCampo("fil_codigo", 2, false, true, filial);
        salvar.adicionaCampo("lae_codigo", 2, false, true, codigoLabExterno);
        if (exame != null) {
            salvar.adicionaCampo("exa_codigo", 0, false, true, exame);
        }
        if (material != null) {
            salvar.adicionaCampo("mco_codigo", 2, false, true, material);
        }
        salvar.adicionaCampo("ele_xmllabexterno", 0, true, false, xml);
        DBUtil.gravaAutoCopia(filial, st, salvar, "fil_codigo", ParametrosGerais.getCopiaLabExterno());
    }

    public static void atualizaDataUltimaImportacaoExames(String filial, int codigoLabExterno) throws Exception {
        LabExternoBean bean = new LabExternoBean();
        bean.setCodigo(codigoLabExterno);
        FilialVO filialVO = new FilialVO();
        filialVO.setCodigo(Integer.parseInt(filial));
        bean.setFilial(filialVO);
        bean.setUltimaImportacaoExames(Funcoes.getDataHoraServidor());
        new LabExternoService().update(bean, null, filial, ParametrosGerais.getCopiaLabExterno());
    }

    public static String atualizaNumeroLote(String xmlString, int novoLote) {
        if (!Funcoes.textoVazio(xmlString)) {
            String tag = "lote";
            String padrao = "<" + tag + ">(.*?)</" + tag + ">";
            String substituicao = "<" + tag + ">" + novoLote + "</" + tag + ">";
            return xmlString.replaceAll(padrao, substituicao);
        }
        return "";
    }
}

