/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers;

import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.util.parsers.AbstractImportadorResultadoLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.alvaro.ImportacaoResultadoAlvaro;
import jalis.laboratorio.util.parsers.balague.ImportacaoResultadoBalague;
import jalis.laboratorio.util.parsers.cerba.ImportacaoResultadoCerba;
import jalis.laboratorio.util.parsers.concent.ImportacaoResultadoConcent;
import jalis.laboratorio.util.parsers.db2.ImportacaoResultadoDB;
import jalis.laboratorio.util.parsers.db2.ImportacaoResultadoDBWS;
import jalis.laboratorio.util.parsers.indlab.ImportacaoResultadoIndLab;
import jalis.laboratorio.util.parsers.jalis.ws.ImportacaoResultadoJalis;
import jalis.laboratorio.util.parsers.jalisws.ImportacaoResultadoJalisWS;
import jalis.laboratorio.util.parsers.maricondi.ImportacaoResultadoMaricondi;
import jalis.laboratorio.util.parsers.matrix.ImportacaoResultadoCriesp;
import jalis.laboratorio.util.parsers.mercolabws.ImportacaoResultadoMercolab;
import jalis.laboratorio.util.parsers.pardini.ImportacaoResultadoHPardini;
import jalis.laboratorio.util.parsers.reacao.ImportacaoResultadoReacao;
import jalis.laboratorio.util.parsers.rede.ImportacaoResultadoRede;
import jalis.laboratorio.util.parsers.rede.ws.ImportacaoResultadoRedeWS;
import jalis.laboratorio.util.parsers.saocamilo.ImportacaoResultadoSaoCamilo;
import jalis.laboratorio.util.parsers.saomarcos.ImportacaoResultadoSaoMarcos;
import jalis.laboratorio.util.parsers.sf.ImportacaoResultadoSFranco;
import jalis.laboratorio.util.parsers.shift.ImportacaoResultadoShift;
import jalis.laboratorio.util.parsers.softlab.resultado.ImportacaoResultadoSoftLab;
import jalis.laboratorio.util.parsers.solucaov2.ImportacaoResultadoSolucao;
import jalis.laboratorio.util.parsers.syslab.resultado.ImportacaoResultadoSyslab;
import jalis.laboratorio.util.parsers.unilab.resultado.ImportacaoResultadoUnilab;
import jalis.util.Funcoes;
import jalis.util.StringUtil;

public class FabricaImportadorResultado {
    public static AbstractImportadorResultadoLabExterno novoImportadorResultadoLabExterno(int codigoLabExterno, Protocolo protocolo) {
        switch (protocolo) {
            case HPardini: {
                return new ImportacaoResultadoHPardini(codigoLabExterno);
            }
            case Solucao: {
                return new jalis.laboratorio.util.parsers.solucao.ImportacaoResultadoSolucao(codigoLabExterno);
            }
            case SolucaoV2: {
                return new ImportacaoResultadoSolucao(codigoLabExterno);
            }
            case Alvaro: {
                return new ImportacaoResultadoAlvaro(codigoLabExterno);
            }
            case Concent: {
                return new ImportacaoResultadoConcent(codigoLabExterno);
            }
            case DB: {
                return new jalis.laboratorio.util.parsers.db.ImportacaoResultadoDB(codigoLabExterno);
            }
            case DBV2: {
                LaboratorioExterno lab = LaboratorioExterno.getLabExterno(String.valueOf(codigoLabExterno));
                boolean enviarUsandoWS = lab != null && !Funcoes.textoVazio(StringUtil.getValor(lab.configuracao, "enviarLoteWebservice")) ? Boolean.valueOf(StringUtil.getValor(lab.configuracao, "enviarLoteWebservice")) : Boolean.FALSE;
                if (enviarUsandoWS) {
                    return new ImportacaoResultadoDBWS(codigoLabExterno, lab);
                }
                return new ImportacaoResultadoDB(codigoLabExterno);
            }
            case Jalis: {
                return new ImportacaoResultadoJalis(codigoLabExterno);
            }
            case SaoCamilo: {
                return new ImportacaoResultadoSaoCamilo(codigoLabExterno);
            }
            case SergioFranco: {
                return new ImportacaoResultadoSFranco(codigoLabExterno);
            }
            case Rede: {
                return new ImportacaoResultadoRede(codigoLabExterno);
            }
            case Reacao: {
                return new ImportacaoResultadoReacao(codigoLabExterno);
            }
            case Maricondi: {
                return new ImportacaoResultadoMaricondi(codigoLabExterno);
            }
            case Criesp: {
                return new ImportacaoResultadoCriesp(codigoLabExterno, Protocolo.Criesp);
            }
            case Balague: {
                return new ImportacaoResultadoBalague(codigoLabExterno);
            }
            case Unilab: {
                return new ImportacaoResultadoUnilab(codigoLabExterno);
            }
            case Cerba: {
                return new ImportacaoResultadoCerba(codigoLabExterno);
            }
            case Syslab: {
                return new ImportacaoResultadoSyslab(codigoLabExterno);
            }
            case SaoMarcos: {
                return new ImportacaoResultadoSaoMarcos(codigoLabExterno);
            }
            case RedeWS: {
                return new ImportacaoResultadoRedeWS(codigoLabExterno);
            }
            case INDLab: {
                return new ImportacaoResultadoIndLab(codigoLabExterno);
            }
            case JalisWS: {
                return new ImportacaoResultadoJalisWS(codigoLabExterno);
            }
            case MercolabWS: {
                return new ImportacaoResultadoMercolab(codigoLabExterno);
            }
            case Shift: {
                return new ImportacaoResultadoShift(codigoLabExterno);
            }
            case SoftLab: {
                return new ImportacaoResultadoSoftLab(codigoLabExterno);
            }
        }
        return null;
    }

    public static long getModuloAcesso(Protocolo protocolo) {
        switch (protocolo) {
            case HPardini: {
                return ImportacaoResultadoHPardini.getModuloAcesso();
            }
            case Solucao: {
                return jalis.laboratorio.util.parsers.solucao.ImportacaoResultadoSolucao.getModuloAcesso();
            }
            case SolucaoV2: {
                return ImportacaoResultadoSolucao.getModuloAcesso();
            }
            case Alvaro: {
                return ImportacaoResultadoAlvaro.getModuloAcesso();
            }
            case Concent: {
                return ImportacaoResultadoConcent.getModuloAcesso();
            }
            case DB: {
                return jalis.laboratorio.util.parsers.db.ImportacaoResultadoDB.getModuloAcesso();
            }
            case DBV2: {
                ImportacaoResultadoDB.getModuloAcesso();
            }
            case Jalis: {
                ImportacaoResultadoJalis.getModuloAcesso();
            }
            case SaoCamilo: {
                return ImportacaoResultadoSaoCamilo.getModuloAcesso();
            }
            case SergioFranco: {
                return ImportacaoResultadoSFranco.getModuloAcesso();
            }
            case Rede: {
                return ImportacaoResultadoRede.getModuloAcesso();
            }
            case Reacao: {
                return ImportacaoResultadoReacao.getModuloAcesso();
            }
            case Criesp: {
                return ImportacaoResultadoCriesp.getModuloAcesso();
            }
            case Balague: {
                return ImportacaoResultadoBalague.getModuloAcesso();
            }
            case Syslab: {
                return ImportacaoResultadoSyslab.getModuloAcesso();
            }
            case Maricondi: {
                return ImportacaoResultadoMaricondi.getModuloAcesso();
            }
            case Unilab: {
                return ImportacaoResultadoUnilab.getModuloAcesso();
            }
            case Cerba: {
                return ImportacaoResultadoCerba.getModuloAcesso();
            }
            case RedeWS: {
                return ImportacaoResultadoRedeWS.getModuloAcesso();
            }
            case SaoMarcos: {
                return ImportacaoResultadoSaoCamilo.getModuloAcesso();
            }
            case MercolabWS: {
                return ImportacaoResultadoMercolab.getModuloAcesso();
            }
            case SoftLab: {
                return ImportacaoResultadoSoftLab.getModuloAcesso();
            }
            case Shift: {
                return ImportacaoResultadoShift.getModuloAcesso();
            }
        }
        return -1L;
    }
}

