/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers;

import jalis.laboratorio.util.parsers.AbstractImportadorLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.alvaro.ImportacaoAlvaro;
import jalis.laboratorio.util.parsers.balague.ImportacaoBalague;
import jalis.laboratorio.util.parsers.cerba.ImportacaoCerba;
import jalis.laboratorio.util.parsers.concent.ImportacaoConcent;
import jalis.laboratorio.util.parsers.db.ImportacaoDB;
import jalis.laboratorio.util.parsers.indlab.ImportacaoIndlab;
import jalis.laboratorio.util.parsers.jalis.ws.ImportacaoJalis;
import jalis.laboratorio.util.parsers.jalisws.ImportadorJalisWS;
import jalis.laboratorio.util.parsers.maricondi.ImportacaoMaricondi;
import jalis.laboratorio.util.parsers.matrix.ImportacaoCriesp;
import jalis.laboratorio.util.parsers.mercolabws.ImportacaoMercolabWS;
import jalis.laboratorio.util.parsers.pardini.ImportacaoHPardini;
import jalis.laboratorio.util.parsers.reacao.ImportacaoReacao;
import jalis.laboratorio.util.parsers.rede.ImportacaoRede;
import jalis.laboratorio.util.parsers.rede.ws.ImportacaoRedeWS;
import jalis.laboratorio.util.parsers.saocamilo.ImportacaoSaoCamilo;
import jalis.laboratorio.util.parsers.saomarcos.ImportacaoSaoMarcos;
import jalis.laboratorio.util.parsers.sf.ImportacaoSFranco;
import jalis.laboratorio.util.parsers.shift.ImportacaoShift;
import jalis.laboratorio.util.parsers.softlab.ImportacaoSoftLab;
import jalis.laboratorio.util.parsers.solucao.ImportacaoSolucao;
import jalis.laboratorio.util.parsers.syslab.ImportacaoSyslab;
import jalis.laboratorio.util.parsers.unilab.ImportacaoUnilab;

public class FabricaImportador {
    public static AbstractImportadorLabExterno novoImportadorLabExterno(int codigoLabExterno, Protocolo protocolo) {
        switch (protocolo) {
            case HPardini: {
                return new ImportacaoHPardini(codigoLabExterno);
            }
            case Solucao: {
                return new ImportacaoSolucao(codigoLabExterno);
            }
            case SolucaoV2: {
                new jalis.laboratorio.util.parsers.solucaov2.ImportacaoSolucao(codigoLabExterno);
            }
            case Jalis: {
                return new ImportacaoJalis(codigoLabExterno);
            }
            case SaoCamilo: {
                new ImportacaoSaoCamilo(codigoLabExterno);
            }
            case Alvaro: {
                return new ImportacaoAlvaro(codigoLabExterno);
            }
            case Concent: {
                return new ImportacaoConcent(codigoLabExterno);
            }
            case SergioFranco: {
                new ImportacaoSFranco(codigoLabExterno);
            }
            case Reacao: {
                return new ImportacaoReacao(codigoLabExterno);
            }
            case Rede: {
                return new ImportacaoRede(codigoLabExterno);
            }
            case DB: {
                return new ImportacaoDB(codigoLabExterno);
            }
            case DBV2: {
                return new jalis.laboratorio.util.parsers.db2.ImportacaoDB(codigoLabExterno);
            }
            case Maricondi: {
                return new ImportacaoMaricondi(codigoLabExterno);
            }
            case Criesp: {
                return new ImportacaoCriesp(codigoLabExterno);
            }
            case Balague: {
                return new ImportacaoBalague(codigoLabExterno);
            }
            case Unilab: {
                return new ImportacaoUnilab(codigoLabExterno);
            }
            case Cerba: {
                return new ImportacaoCerba(codigoLabExterno);
            }
            case Syslab: {
                return new ImportacaoSyslab(codigoLabExterno);
            }
            case SaoMarcos: {
                return new ImportacaoSaoMarcos(codigoLabExterno);
            }
            case RedeWS: {
                return new ImportacaoRedeWS(codigoLabExterno);
            }
            case INDLab: {
                return new ImportacaoIndlab(codigoLabExterno);
            }
            case JalisWS: {
                return new ImportadorJalisWS(codigoLabExterno);
            }
            case MercolabWS: {
                return new ImportacaoMercolabWS(codigoLabExterno);
            }
            case Shift: {
                return new ImportacaoShift(codigoLabExterno);
            }
            case SoftLab: {
                return new ImportacaoSoftLab(codigoLabExterno);
            }
        }
        return null;
    }

    private static boolean protocoloSaoMarcos(Protocolo protocolo) {
        return protocolo == Protocolo.SaoMarcos;
    }

    public static long getModuloAcesso(Protocolo protocolo) {
        switch (protocolo) {
            case HPardini: {
                return ImportacaoHPardini.getModuloAcesso();
            }
            case Solucao: {
                return ImportacaoSolucao.getModuloAcesso();
            }
            case SolucaoV2: {
                return jalis.laboratorio.util.parsers.solucaov2.ImportacaoSolucao.getModuloAcesso();
            }
            case Alvaro: {
                return ImportacaoAlvaro.getModuloAcesso();
            }
            case Concent: {
                return ImportacaoConcent.getModuloAcesso();
            }
            case DB: {
                return ImportacaoDB.getModuloAcesso();
            }
            case DBV2: {
                return jalis.laboratorio.util.parsers.db2.ImportacaoDB.getModuloAcesso();
            }
            case Jalis: {
                return jalis.laboratorio.util.parsers.jalis.ImportacaoJalis.getModuloAcesso();
            }
            case SaoCamilo: {
                return ImportacaoSaoCamilo.getModuloAcesso();
            }
            case SergioFranco: {
                return ImportacaoSFranco.getModuloAcesso();
            }
            case Rede: {
                return ImportacaoRede.getModuloAcesso();
            }
            case Reacao: {
                return ImportacaoReacao.getModuloAcesso();
            }
            case Criesp: {
                return ImportacaoCriesp.getModuloAcesso();
            }
            case Balague: {
                return ImportacaoBalague.getModuloAcesso();
            }
            case Syslab: {
                return ImportacaoSyslab.getModuloAcesso();
            }
            case Maricondi: {
                return ImportacaoMaricondi.getModuloAcesso();
            }
            case Unilab: {
                return ImportacaoUnilab.getModuloAcesso();
            }
            case Cerba: {
                return ImportacaoCerba.getModuloAcesso();
            }
            case SaoMarcos: {
                return ImportacaoSaoMarcos.getModuloAcesso();
            }
            case RedeWS: {
                return ImportacaoRedeWS.getModuloAcesso();
            }
            case INDLab: {
                return ImportacaoIndlab.getModuloAcesso();
            }
            case JalisWS: {
                return ImportadorJalisWS.getModuloAcesso();
            }
            case MercolabWS: {
                return ImportacaoMercolabWS.getModuloAcesso();
            }
            case Shift: {
                return ImportacaoShift.getModuloAcesso();
            }
        }
        return -1L;
    }
}

