/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers;

import jalis.laboratorio.util.parsers.AbstractConfigurador;
import jalis.laboratorio.util.parsers.AbstractConfiguradorProtocolo;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.alvaro.ConfiguradorAlvaro;
import jalis.laboratorio.util.parsers.alvaro.ConfiguradorProtocoloAlvaro;
import jalis.laboratorio.util.parsers.balague.ConfiguradorBalague;
import jalis.laboratorio.util.parsers.cerba.ConfiguradorCerba;
import jalis.laboratorio.util.parsers.cerba.ConfiguradorProtocoloCerba;
import jalis.laboratorio.util.parsers.concent.ConfiguradorConcent;
import jalis.laboratorio.util.parsers.concent.ConfiguradorProtocoloConcent;
import jalis.laboratorio.util.parsers.db.ConfiguradorDB;
import jalis.laboratorio.util.parsers.db.ConfiguradorProtocoloDB;
import jalis.laboratorio.util.parsers.indlab.ConfiguradorIndlab;
import jalis.laboratorio.util.parsers.indlab.ConfiguradorProtocoloIndLab;
import jalis.laboratorio.util.parsers.jalis.ConfiguradorJalis;
import jalis.laboratorio.util.parsers.jalis.ConfiguradorProtocoloJalis;
import jalis.laboratorio.util.parsers.jalisws.ConfiguradorJalisWS;
import jalis.laboratorio.util.parsers.jalisws.ConfiguradorProtocoloJalisWS;
import jalis.laboratorio.util.parsers.maricondi.ConfiguradorProtocoloMaricondi;
import jalis.laboratorio.util.parsers.matrix.ConfiguradorCriesp;
import jalis.laboratorio.util.parsers.matrix.ConfiguradorMaricondi;
import jalis.laboratorio.util.parsers.matrix.ConfiguradorProtocoloCriesp;
import jalis.laboratorio.util.parsers.mercolabws.ConfiguradorMercolabWS;
import jalis.laboratorio.util.parsers.mercolabws.ConfiguradorProtocoloMercolabWS;
import jalis.laboratorio.util.parsers.pardini.ConfiguradorHPardini;
import jalis.laboratorio.util.parsers.pardini.ConfiguradorProtocoloHPardini;
import jalis.laboratorio.util.parsers.reacao.ConfiguradorProtocoloReacao;
import jalis.laboratorio.util.parsers.reacao.ConfiguradorReacao;
import jalis.laboratorio.util.parsers.rede.ConfiguradorProtocoloRede;
import jalis.laboratorio.util.parsers.rede.ConfiguradorRede;
import jalis.laboratorio.util.parsers.rede.ws.ConfiguradorProtocoloRedeWS;
import jalis.laboratorio.util.parsers.rede.ws.ConfiguradorRedeWS;
import jalis.laboratorio.util.parsers.saocamilo.ConfiguradorProtocoloSaoCamilo;
import jalis.laboratorio.util.parsers.saocamilo.ConfiguradorSaoCamilo;
import jalis.laboratorio.util.parsers.saomarcos.ConfiguradorProtocoloSaoMarcos;
import jalis.laboratorio.util.parsers.saomarcos.ConfiguradorSaoMarcos;
import jalis.laboratorio.util.parsers.sf.ConfiguradorProtocoloSFranco;
import jalis.laboratorio.util.parsers.sf.ConfiguradorSFranco;
import jalis.laboratorio.util.parsers.shift.ConfiguradorProtocoloShift;
import jalis.laboratorio.util.parsers.shift.ConfiguradorShift;
import jalis.laboratorio.util.parsers.softlab.ConfiguradorProtocoloSoftLab;
import jalis.laboratorio.util.parsers.softlab.ConfiguradorSoftLab;
import jalis.laboratorio.util.parsers.solucao.ConfiguradorProtocoloSolucao;
import jalis.laboratorio.util.parsers.solucao.ConfiguradorSolucao;
import jalis.laboratorio.util.parsers.syslab.ConfiguradorProtocoloSyslab;
import jalis.laboratorio.util.parsers.syslab.ConfiguradorSyslab;
import jalis.laboratorio.util.parsers.unilab.ConfiguradorProtocoloUnilab;
import jalis.laboratorio.util.parsers.unilab.ConfiguradorUnilab;
import jalis.util.ExameUtil;
import java.sql.SQLException;

public class FabricaConfigurador {
    public static String getDescricaoExameSelecionado(Protocolo protocolo, String codigoLabExterno, String xml) {
        switch (protocolo) {
            case HPardini: {
                return ConfiguradorHPardini.getDescricaoExameSelecionado(xml);
            }
            case Solucao: {
                return ConfiguradorSolucao.getDescricaoExameSelecionado(xml);
            }
            case SolucaoV2: {
                return jalis.laboratorio.util.parsers.solucaov2.ConfiguradorSolucao.getDescricaoExameSelecionado(xml);
            }
            case Jalis: {
                return ConfiguradorJalis.getDescricaoExameSelecionado(codigoLabExterno, xml);
            }
            case SaoCamilo: {
                return ConfiguradorSaoCamilo.getDescricaoExameSelecionado(xml);
            }
            case DB: {
                return ConfiguradorDB.getDescricaoExameSelecionado(xml);
            }
            case DBV2: {
                return jalis.laboratorio.util.parsers.db2.ConfiguradorDB.getDescricaoExameSelecionado(xml);
            }
            case Alvaro: {
                return ConfiguradorAlvaro.getDescricaoExameSelecionado(xml);
            }
            case Concent: {
                return ConfiguradorConcent.getDescricaoExameSelecionado(xml);
            }
            case SergioFranco: {
                return ConfiguradorSFranco.getDescricaoExameSelecionado(xml);
            }
            case Reacao: {
                return ConfiguradorReacao.getDescricaoExameSelecionado(xml);
            }
            case Rede: {
                return ConfiguradorRede.getDescricaoExameSelecionado(xml);
            }
            case Maricondi: {
                return ConfiguradorMaricondi.getDescricaoExameSelecionado(xml);
            }
            case Criesp: {
                return ConfiguradorCriesp.getDescricaoExameSelecionado(xml);
            }
            case Balague: {
                return ConfiguradorBalague.getDescricaoExameSelecionado(xml);
            }
            case Unilab: {
                return ConfiguradorUnilab.getDescricaoExameSelecionado(xml);
            }
            case Cerba: {
                return ConfiguradorCerba.getDescricaoExameSelecionado(xml);
            }
            case Syslab: {
                return ConfiguradorSyslab.getDescricaoExameSelecionado(xml);
            }
            case SaoMarcos: {
                return ConfiguradorSaoMarcos.getDescricaoExameSelecionado(xml);
            }
            case RedeWS: {
                return ConfiguradorRedeWS.getDescricaoExameSelecionado(xml);
            }
            case INDLab: {
                return ConfiguradorIndlab.getDescricaoExameSelecionado(xml);
            }
            case JalisWS: {
                return ConfiguradorJalisWS.getDescricaoExameSelecionado(xml);
            }
            case MercolabWS: {
                return ConfiguradorMercolabWS.getDescricaoExameSelecionado(xml);
            }
            case Shift: {
                return ConfiguradorShift.getDescricaoExameSelecionado(xml);
            }
            case SoftLab: {
                return ConfiguradorSoftLab.getDescricaoExameSelecionado(xml);
            }
        }
        return "";
    }

    public static String getCodigoIdentExameLabExternoSelecionado(Protocolo protocolo, String codigoLabExterno, String xml) {
        switch (protocolo) {
            case HPardini: {
                return ConfiguradorHPardini.getCodigoIdentExameLabExterno(xml);
            }
            case Solucao: {
                return ConfiguradorSolucao.getCodigoIdentExameLabExterno(xml);
            }
            case SolucaoV2: {
                return jalis.laboratorio.util.parsers.solucaov2.ConfiguradorSolucao.getCodigoIdentExameLabExterno(xml);
            }
            case Alvaro: {
                return ConfiguradorAlvaro.getCodigoIdentExameLabExterno(xml);
            }
            case Concent: {
                return ConfiguradorConcent.getCodigoIdentExameLabExterno(xml);
            }
            case DB: {
                return ConfiguradorDB.getCodigoIdentExameLabExterno(xml);
            }
            case DBV2: {
                return jalis.laboratorio.util.parsers.db2.ConfiguradorDB.getCodigoIdentExameLabExterno(xml);
            }
            case Reacao: {
                return ConfiguradorReacao.getCodigoIdentExameLabExterno(xml);
            }
            case Rede: {
                return ConfiguradorRede.getCodigoIdentExameLabExterno(xml);
            }
            case SaoCamilo: {
                return ConfiguradorAlvaro.getCodigoIdentExameLabExterno(xml);
            }
            case Maricondi: {
                return ConfiguradorMaricondi.getCodigoIdentExameLabExterno(xml);
            }
            case Criesp: {
                return ConfiguradorCriesp.getCodigoIdentExameLabExterno(xml);
            }
            case Balague: {
                return ConfiguradorBalague.getCodigoIdentExameLabExterno(xml);
            }
            case Unilab: {
                return ConfiguradorUnilab.getCodigoIdentExameLabExterno(xml);
            }
            case Cerba: {
                return ConfiguradorCerba.getCodigoIdentExameLabExterno(xml);
            }
            case Syslab: {
                return ConfiguradorSyslab.getCodigoIdentExameLabExterno(xml);
            }
            case SaoMarcos: {
                return ConfiguradorSaoMarcos.getCodigoIdentExameLabExterno(xml);
            }
            case RedeWS: {
                return ConfiguradorRedeWS.getCodigoIdentExameLabExterno(xml);
            }
            case INDLab: {
                return ConfiguradorIndlab.getCodigoIdentExameLabExterno(xml);
            }
            case JalisWS: {
                return ConfiguradorJalisWS.getCodigoIdentExameLabExterno(xml);
            }
            case MercolabWS: {
                return ConfiguradorMercolabWS.getCodigoIdentExameLabExterno(xml);
            }
            case Shift: {
                return ConfiguradorShift.getCodigoIdentExameLabExterno(xml);
            }
            case SoftLab: {
                return ConfiguradorSoftLab.getCodigoIdentExameLabExterno(xml);
            }
        }
        return "";
    }

    public static AbstractConfigurador novoConfigurador(Object pai, Protocolo protocolo, String codigoLabExterno) {
        switch (protocolo) {
            case HPardini: {
                return ConfiguradorHPardini.novaInstancia(pai, codigoLabExterno);
            }
            case Solucao: {
                return ConfiguradorSolucao.novaInstancia(pai, codigoLabExterno);
            }
            case SolucaoV2: {
                return jalis.laboratorio.util.parsers.solucaov2.ConfiguradorSolucao.novaInstancia(pai, codigoLabExterno);
            }
            case Jalis: {
                return ConfiguradorJalis.novaInstancia(pai, codigoLabExterno);
            }
            case SaoCamilo: {
                return ConfiguradorSaoCamilo.novaInstancia(pai, codigoLabExterno);
            }
            case Alvaro: {
                return ConfiguradorAlvaro.novaInstancia(pai, codigoLabExterno);
            }
            case Concent: {
                return ConfiguradorConcent.novaInstancia(pai, codigoLabExterno);
            }
            case DB: {
                return ConfiguradorDB.novaInstancia(pai, codigoLabExterno);
            }
            case DBV2: {
                return jalis.laboratorio.util.parsers.db2.ConfiguradorDB.novaInstancia(pai, codigoLabExterno);
            }
            case SergioFranco: {
                return ConfiguradorSFranco.novaInstancia(pai, codigoLabExterno);
            }
            case Reacao: {
                return ConfiguradorReacao.novaInstancia(pai, codigoLabExterno);
            }
            case Rede: {
                return ConfiguradorRede.novaInstancia(pai, codigoLabExterno);
            }
            case Maricondi: {
                return ConfiguradorMaricondi.novaInstancia(pai, codigoLabExterno, "Configura\u00e7\u00e3o para exames do Laborat\u00f3rio Maricondi");
            }
            case Criesp: {
                return ConfiguradorCriesp.novaInstancia(pai, codigoLabExterno, "Configura\u00e7\u00e3o para exames do Laborat\u00f3rio Criesp");
            }
            case Balague: {
                return ConfiguradorBalague.novaInstancia(pai, codigoLabExterno);
            }
            case Unilab: {
                return ConfiguradorUnilab.novaInstancia(pai, codigoLabExterno);
            }
            case Cerba: {
                return ConfiguradorCerba.novaInstancia(pai, codigoLabExterno);
            }
            case Syslab: {
                return ConfiguradorSyslab.novaInstancia(pai, codigoLabExterno, "Configura\u00e7\u00e3o para exames do Laborat\u00f3rio Syslab");
            }
            case SaoMarcos: {
                return ConfiguradorSaoMarcos.novaInstancia(pai, codigoLabExterno, "Configura\u00e7\u00e3o para exames do Laborat\u00f3rio S\u00e3o Marcos");
            }
            case RedeWS: {
                return ConfiguradorRedeWS.novaInstancia(pai, codigoLabExterno);
            }
            case INDLab: {
                return ConfiguradorIndlab.novaInstancia(pai, codigoLabExterno, "Configura\u00e7\u00e3o para exames do Laborat\u00f3rio IndLab");
            }
            case JalisWS: {
                return ConfiguradorJalisWS.novaInstancia(pai, codigoLabExterno);
            }
            case MercolabWS: {
                return ConfiguradorMercolabWS.novaInstancia(pai, codigoLabExterno, "Configura\u00e7\u00e3o para exames do Laborat\u00f3rio Mercolab");
            }
            case Shift: {
                return ConfiguradorShift.novaInstancia(pai, codigoLabExterno, "Configura\u00e7\u00e3o para exames do Laborat\u00f3rio Shift");
            }
            case SoftLab: {
                return ConfiguradorSoftLab.novaInstancia(pai, codigoLabExterno);
            }
        }
        return null;
    }

    public static int qtExamesImportados(Protocolo protocolo, String codigoLabExterno) throws NumberFormatException, SQLException {
        if (protocolo == Protocolo.HPardini) {
            return ExameUtil.getQtdeExamesImportados(codigoLabExterno, "examespardini");
        }
        if (protocolo == Protocolo.Solucao) {
            return ExameUtil.getQtdeExamesImportados(codigoLabExterno, "examessolucao");
        }
        if (protocolo == Protocolo.Jalis) {
            return ExameUtil.getQtdeExamesImportados(codigoLabExterno, "examesjalis");
        }
        if (protocolo == Protocolo.SaoCamilo || protocolo == Protocolo.Alvaro || protocolo == Protocolo.Concent || protocolo == Protocolo.DB || protocolo == Protocolo.SolucaoV2 || protocolo == Protocolo.JalisWS) {
            return ExameUtil.getQtdeExamesImportados(codigoLabExterno, "examesalvaro");
        }
        if (protocolo == Protocolo.DBV2) {
            return ExameUtil.getQtdeExamesImportados(codigoLabExterno, "examesdb");
        }
        if (protocolo == Protocolo.SergioFranco) {
            return ExameUtil.getQtdeExamesImportados(codigoLabExterno, "examessergiofranco");
        }
        if (protocolo == Protocolo.Reacao) {
            return ExameUtil.getQtdeExamesImportados(codigoLabExterno, "examesreacao");
        }
        if (protocolo == Protocolo.Rede || protocolo == Protocolo.RedeWS) {
            return ExameUtil.getQtdeExamesImportados(codigoLabExterno, "examesrede");
        }
        if (protocolo == Protocolo.Maricondi || protocolo == Protocolo.Criesp) {
            return ExameUtil.getQtdeExamesImportados(codigoLabExterno, "examesmatrix");
        }
        if (protocolo == Protocolo.Balague) {
            return ExameUtil.getQtdeExamesImportados(codigoLabExterno, "examesbalague");
        }
        if (protocolo == Protocolo.Unilab) {
            return ExameUtil.getQtdeExamesImportados(codigoLabExterno, "examesunilab");
        }
        if (protocolo == Protocolo.Syslab) {
            return ExameUtil.getQtdeExamesImportados(codigoLabExterno, "examessyslab");
        }
        if (protocolo == Protocolo.SaoMarcos) {
            return ExameUtil.getQtdeExamesImportados(codigoLabExterno, "examessaomarcos");
        }
        if (protocolo == Protocolo.INDLab) {
            return ExameUtil.getQtdeExamesImportados(codigoLabExterno, "examesindlab");
        }
        if (protocolo == Protocolo.MercolabWS) {
            return ExameUtil.getQtdeExamesImportados(codigoLabExterno, "examesmercolab");
        }
        if (protocolo == Protocolo.Shift) {
            return ExameUtil.getQtdeExamesImportados(codigoLabExterno, "examesshift");
        }
        if (protocolo == Protocolo.SoftLab) {
            return ExameUtil.getQtdeExamesImportados(codigoLabExterno, "examessoftlab");
        }
        return 0;
    }

    public static AbstractConfiguradorProtocolo novoConfiguradorProtocolo(Object pai, Protocolo protocolo, String codigoLaboratorio) {
        switch (protocolo) {
            case HPardini: {
                return ConfiguradorProtocoloHPardini.novaInstancia(pai, codigoLaboratorio);
            }
            case Solucao: {
                return ConfiguradorProtocoloSolucao.novaInstancia(pai, codigoLaboratorio);
            }
            case SolucaoV2: {
                return jalis.laboratorio.util.parsers.solucaov2.ConfiguradorProtocoloSolucao.novaInstancia(pai, codigoLaboratorio);
            }
            case Jalis: {
                return ConfiguradorProtocoloJalis.novaInstancia(pai, codigoLaboratorio);
            }
            case SaoCamilo: {
                return ConfiguradorProtocoloSaoCamilo.novaInstancia(pai, codigoLaboratorio);
            }
            case Concent: {
                return ConfiguradorProtocoloConcent.novaInstancia(pai, codigoLaboratorio);
            }
            case Alvaro: {
                return ConfiguradorProtocoloAlvaro.novaInstancia(pai, codigoLaboratorio);
            }
            case DB: {
                return ConfiguradorProtocoloDB.novaInstancia(pai, codigoLaboratorio);
            }
            case DBV2: {
                return jalis.laboratorio.util.parsers.db2.ConfiguradorProtocoloDB.novaInstancia(pai, codigoLaboratorio);
            }
            case SergioFranco: {
                return ConfiguradorProtocoloSFranco.novaInstancia(pai, codigoLaboratorio);
            }
            case Reacao: {
                return ConfiguradorProtocoloReacao.novaInstancia(pai, codigoLaboratorio);
            }
            case Rede: {
                return ConfiguradorProtocoloRede.novaInstancia(pai, codigoLaboratorio);
            }
            case Maricondi: {
                return ConfiguradorProtocoloMaricondi.novaInstancia(pai, codigoLaboratorio);
            }
            case Criesp: {
                return ConfiguradorProtocoloCriesp.novaInstancia(pai, codigoLaboratorio);
            }
            case Unilab: {
                return ConfiguradorProtocoloUnilab.novaInstancia(pai, codigoLaboratorio);
            }
            case Cerba: {
                return ConfiguradorProtocoloCerba.novaInstancia(pai, codigoLaboratorio);
            }
            case Syslab: {
                return ConfiguradorProtocoloSyslab.novaInstancia(pai, codigoLaboratorio);
            }
            case SaoMarcos: {
                return ConfiguradorProtocoloSaoMarcos.novaInstancia(pai, codigoLaboratorio);
            }
            case RedeWS: {
                return ConfiguradorProtocoloRedeWS.novaInstancia(pai, codigoLaboratorio);
            }
            case INDLab: {
                return ConfiguradorProtocoloIndLab.novaInstancia(pai, codigoLaboratorio);
            }
            case JalisWS: {
                return ConfiguradorProtocoloJalisWS.novaInstancia(pai, codigoLaboratorio);
            }
            case MercolabWS: {
                return ConfiguradorProtocoloMercolabWS.novaInstancia(pai, codigoLaboratorio);
            }
            case Shift: {
                return ConfiguradorProtocoloShift.novaInstancia(pai, codigoLaboratorio);
            }
            case SoftLab: {
                return ConfiguradorProtocoloSoftLab.novaInstancia(pai, codigoLaboratorio);
            }
        }
        return null;
    }
}

