/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.model.bean.log.LogImportacaoLabExternoBean;
import jalis.service.log.LogImportacaoLabExternoService;
import jalis.util.ModeloGridTable;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DialogoImportacaoLabExterno
extends AbstractDialogoOKCancelar {
    private static final int COLUNA_DATA = 0;
    private JPanel panelLog = new JPanel(new GridBagLayout());
    private JTextArea textMotivo = new JTextArea();
    private ModeloGridTable modeloDatas = new ModeloGridTable(new String[]{"Data"});
    private JTable tabelaDatas = new JTable(this.modeloDatas);
    private JPanel panelDatas = ComponenteFactory.novoJPanelBorderLayout("Datas", new JScrollPane(this.tabelaDatas));
    private LogImportacaoLabExternoService importacaoLabExternoService = new LogImportacaoLabExternoService();

    public DialogoImportacaoLabExterno(Dialog pai, String titulo, String fil_codigo, String lae_codigo) {
        super(pai, titulo);
        this.iniciar(fil_codigo, lae_codigo);
    }

    public DialogoImportacaoLabExterno(Frame pai, String titulo, String fil_codigo, String lae_codigo) {
        super(pai, titulo);
        this.iniciar(fil_codigo, lae_codigo);
    }

    public static DialogoImportacaoLabExterno novaInstancia(Object owner, String fil_codigo, String lae_codigo) {
        if (owner instanceof Frame) {
            return new DialogoImportacaoLabExterno((Frame)owner, "Logs de importa\u00e7\u00e3o", fil_codigo, lae_codigo);
        }
        return new DialogoImportacaoLabExterno((Dialog)owner, "Logs de importa\u00e7\u00e3o", fil_codigo, lae_codigo);
    }

    private void iniciar(String fil_codigo, String lae_codigo) {
        this.setSize(new Dimension(720, 550));
        this.setLocationRelativeTo(this.getParent());
        this.modeloDatas.setColumnSize(new int[]{0}, this.tabelaDatas);
        this.getBotaoCancelar().setVisible(false);
        this.getBotaoOK().setText("Fechar");
        JPanel panelCentro = this.getPanelCentral();
        panelCentro.setLayout(new BorderLayout());
        this.panelDatas.setPreferredSize(new Dimension(200, 100));
        this.panelDatas.setMinimumSize(this.panelDatas.getPreferredSize());
        panelCentro.add((Component)this.panelDatas, "West");
        panelCentro.add((Component)this.panelLog, "Center");
        this.tabelaDatas.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DialogoImportacaoLabExterno.this.mostraLog(DialogoImportacaoLabExterno.this.tabelaDatas.getSelectedRow());
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        ++c.gridx;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        JScrollPane scroll = new JScrollPane(this.textMotivo);
        this.panelLog.add((Component)scroll, c);
        this.textMotivo.setFont(new Font("Monospaced", 0, 12));
        this.textMotivo.setEditable(false);
        this.textMotivo.scrollRectToVisible(new Rectangle(0, this.textMotivo.getHeight() - 2, 1, 1));
        this.carregaTabelaDatas(fil_codigo, lae_codigo);
    }

    private void carregaTabelaDatas(String fil_codigo, String lae_codigo) {
        String where = " where fil_codigo = " + fil_codigo + " and lae_codigo = " + lae_codigo + " order by lil_datahora;";
        Set beans = null;
        try {
            beans = this.importacaoLabExternoService.load(where);
            if (beans != null) {
                for (LogImportacaoLabExternoBean bean : beans) {
                    this.modeloDatas.addLine(new Object[]{bean});
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi possivel buscar log de importa\u00e7\u00e3o.", e.getStackTrace());
        }
    }

    private void mostraLog(int linha) {
        LogImportacaoLabExternoBean bean = (LogImportacaoLabExternoBean)this.modeloDatas.getValueAt(linha, 0);
        this.textMotivo.setText(bean.getLil_log());
    }
}

