/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.util.parsers.CamposImportacao;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SteppedComboBox;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;

public abstract class DialogoCamposImportacaoSelecionavel
extends AbstractDialogoOKCancelar {
    private Object campoImportacao = "";
    protected ArrayList<CamposImportacao> listaExamesDesmLabExterno = null;
    protected SteppedComboBox comboDesm = new SteppedComboBox();
    protected Map<Object, CamposImportacao> mapTabs = new HashMap<Object, CamposImportacao>();
    public ModeloGridTable modelo = new ModeloGridTable(new String[]{"Linha", "Descri\u00e7\u00e3o"});
    public JTable table = ComponenteFactory.novoJTable((TableModel)this.modelo, 135, 0);
    public JScrollPane scroll = new JScrollPane(this.table);
    public String versaoSelecionada;

    public DialogoCamposImportacaoSelecionavel(Dialog pai, String titulo, Object camposImportacao, ArrayList<CamposImportacao> listaExamesDesmLabExterno) {
        super(pai, titulo);
        this.listaExamesDesmLabExterno = listaExamesDesmLabExterno;
        this.campoImportacao = camposImportacao;
        this.iniciar(camposImportacao);
    }

    public DialogoCamposImportacaoSelecionavel(Frame pai, String titulo, Object camposImportacao, ArrayList<CamposImportacao> listaExamesDesmLabExterno) {
        super(pai, titulo);
        this.listaExamesDesmLabExterno = listaExamesDesmLabExterno;
        this.campoImportacao = camposImportacao;
        this.iniciar(camposImportacao);
    }

    public DialogoCamposImportacaoSelecionavel(Dialog pai, String titulo, Object camposImportacao, ArrayList<CamposImportacao> listaExamesDesmLabExterno, String versaoSelecionada) {
        super(pai, titulo);
        this.listaExamesDesmLabExterno = listaExamesDesmLabExterno;
        this.campoImportacao = camposImportacao;
        this.versaoSelecionada = versaoSelecionada;
        this.iniciar(camposImportacao);
    }

    public DialogoCamposImportacaoSelecionavel(Frame pai, String titulo, Object camposImportacao, ArrayList<CamposImportacao> listaExamesDesmLabExterno, String versaoSelecionada) {
        super(pai, titulo);
        this.listaExamesDesmLabExterno = listaExamesDesmLabExterno;
        this.campoImportacao = camposImportacao;
        this.versaoSelecionada = versaoSelecionada;
        this.iniciar(camposImportacao);
    }

    public void iniciar(Object camposImportacao) {
        this.getPanelCentral().setLayout(new BorderLayout());
        if (this.listaExamesDesmLabExterno != null && !this.listaExamesDesmLabExterno.isEmpty()) {
            for (CamposImportacao campo : this.listaExamesDesmLabExterno) {
                this.comboDesm.addItem(campo.getCodigoExame());
                this.mapTabs.put(campo.getCodigoExame(), campo);
            }
            this.carregaCamposImportacao(this.listaExamesDesmLabExterno.get(0).getCamposImportacao());
            this.getComboDesm().setBorder(new TitledBorder("Desmembramento"));
            this.getPanelCentral().add((Component)this.comboDesm, "North");
        } else {
            this.carregaCamposImportacao(camposImportacao);
        }
        this.comboDesm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CamposImportacao campo = DialogoCamposImportacaoSelecionavel.this.getMapTabs().get(DialogoCamposImportacaoSelecionavel.this.getComboDesm().getSelectedItem());
                DialogoCamposImportacaoSelecionavel.this.carregaCamposImportacao(campo.getCamposImportacao());
            }
        });
        this.getPanelCentral().add((Component)this.scroll, "Center");
        this.getPanelCentral().add((Component)new JPanel(), "South");
        this.setSize(new Dimension(600, 700));
        ScreenUtil.centralizar(this);
    }

    private void carregaCamposImportacao(Object camposImportacao) {
        this.modelo.clear();
        HashMap linhas = (HashMap)camposImportacao;
        for (String s : linhas.keySet()) {
            Object[] linha = new String[]{s, (String)linhas.get(s)};
            this.modelo.addLine(linha);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(true);
    }

    @Override
    public boolean getOK() {
        return this.ok;
    }

    public String getCampoSelecionado() {
        String campoSelecionado = null;
        if (this.table.getSelectedRow() > -1) {
            String exameDesmSelecionado = this.listaExamesDesmLabExterno != null && !this.listaExamesDesmLabExterno.isEmpty() ? "@" + this.getComboDesm().getSelectedItem() : "";
            campoSelecionado = this.table.getValueAt(this.table.getSelectedRow(), 0).toString();
            String string = campoSelecionado = !Funcoes.textoVazio(campoSelecionado) ? campoSelecionado + exameDesmSelecionado : "";
            if (this.listaExamesDesmLabExterno != null && !this.listaExamesDesmLabExterno.isEmpty()) {
                return campoSelecionado + "#" + this.mapTabs.get(this.getComboDesm().getSelectedItem().toString()).getMaterialPaiDesm();
            }
            return campoSelecionado;
        }
        return "";
    }

    public void setCampoSelecionado(String campoSelecionado) {
        if (!Funcoes.textoVazio(campoSelecionado) && campoSelecionado.contains("@") && campoSelecionado.contains("#")) {
            Scanner scanner = new Scanner(campoSelecionado).useDelimiter("\\@");
            campoSelecionado = scanner.next();
            scanner = new Scanner(scanner.next()).useDelimiter("\\#");
            String exameDesmSelecionado = scanner.next();
            String materialPaiDesm = scanner.next();
            this.getComboDesm().setSelectedItem(exameDesmSelecionado.trim());
        } else if (!Funcoes.textoVazio(campoSelecionado) && campoSelecionado.contains("#")) {
            String exameDesmSelecionado = campoSelecionado.split("#")[1];
            campoSelecionado = campoSelecionado.split("#")[0].trim();
            this.getComboDesm().setSelectedItem(exameDesmSelecionado.trim());
        }
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (!this.table.getValueAt(i, 0).toString().equalsIgnoreCase(campoSelecionado)) continue;
            this.table.setRowSelectionInterval(i, i);
        }
    }

    public SteppedComboBox getComboDesm() {
        return this.comboDesm;
    }

    public Map<Object, CamposImportacao> getMapTabs() {
        return this.mapTabs;
    }

    public JTable getTable() {
        return this.table;
    }

    public JScrollPane getScroll() {
        return this.scroll;
    }

    public ArrayList<CamposImportacao> getListaExamesDesmLabExterno() {
        return this.listaExamesDesmLabExterno;
    }
}

