/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers;

import jalis.comum.Conexao;
import jalis.util.ExameUtil;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class AbstractImportadorResultadoLabExternoDao {
    public static final String CODIGO_LAYOUT = "codigo-layout";
    public static final String CABECALHO = "cabecalho";
    public static final String FORMATO = "formato";
    public static final String FORMATACAO = "formatacao";

    public Registro pesquisarExameRequisicao(Statement st, String fil, String req, String exa, String mco, int codigoLabExterno) throws SQLException {
        ResultSet res;
        StringBuilder sql = new StringBuilder("select \n");
        sql.append(" a.fil_codigo, a.req_codigo, a.des_codigo, a.con_codigo, a.pac_codigo, a.req_idade, a.req_anomes, \n");
        sql.append(" b.exa_codigo, b.mco_codigo, b.exr_situacao, pegaResultadoExame(b.fil_codigo, b.req_codigo, b.exa_codigo, b.mco_codigo) as exr_resultado, coalesce(g.met_codigo, e.met_codigo) as met_codigo, \n");
        sql.append(" c.pac_idade, c.pac_anomes, b.exr_datamaterial, \n");
        sql.append(" d.exa_salvaparcial, g.ele_xmllabexterno, null as examePai, a.req_xmlagendamentoids as xmlAgendamentoIDS, a.req_integracaohospital, b.exr_resposta, \n");
        sql.append(" a.req_guia, b.exr_solicitadotiss, b.exr_codautorizacao, le.lae_configuracao, le.lae_codigo \n");
        sql.append(" from requisicao a \n");
        sql.append(" left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo \n");
        sql.append(" left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo \n");
        sql.append(" left join exames d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo \n");
        sql.append(" left join examematcoleta e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and b.mco_codigo = e.mco_codigo \n");
        sql.append(" left join loteexternoexamerequisicao f on b.fil_codigo = f.fil_kodigo and b.req_codigo = f.req_codigo and b.exa_codigo = f.exa_codigo and b.mco_codigo = f.mco_codigo \n");
        sql.append(" left join examematcoletalabexterno g on f.fil_codigo = g.fil_codigo and f.exa_codigo = g.exa_codigo and f.mco_codigo = g.mco_codigo and f.lae_codigo = g.lae_codigo and g.ele_xmllabexterno is not null and g.ele_xmllabexterno <> '' \n");
        sql.append(" left join labexterno le on g.fil_codigo = le.fil_codigo and g.lae_codigo = le.lae_codigo ");
        sql.append(" where \n");
        sql.append(" a.fil_codigo = ").append(fil).append(" and \n");
        sql.append(" a.req_codigo = ").append(req).append(" and \n");
        sql.append(" b.exa_codigo = '").append(exa).append("' and \n");
        sql.append(" b.mco_codigo = ").append(mco).append(" and \n");
        sql.append(" f.lae_codigo = ").append(codigoLabExterno);
        sql.append(" and a.req_excluida = false and b.exr_excluido = false \n");
        if (st != null && (res = Conexao.executeQuery(st, sql.toString())).next()) {
            Registro reg = new Registro(res);
            reg.setValor(CODIGO_LAYOUT, ExameUtil.getCodigoLayout(fil, res.getString("con_codigo"), res.getString("des_codigo")));
            reg.setValor(CABECALHO, ExameUtil.getCabecalhoRodape(fil, reg.getString(CODIGO_LAYOUT)));
            Registro formatacao = new Registro();
            formatacao.setValor(FORMATO, reg.getValor("exr_resultado"));
            formatacao.setValor("met_codigo", reg.getValor("met_codigo"));
            reg.setValor(FORMATACAO, formatacao);
            return reg;
        }
        return new Registro();
    }
}

