/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers;

import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.integracaohospitais.sistemas.AbstractIntegracaoHospital;
import jalis.integracaohospitais.sistemas.ghosp.IntegracaoHospitalGHosp;
import jalis.integracaohospitais.sistemas.sigh.IntegracaoHospitalSigh;
import jalis.integracaohospitais.sistemas.sinconecta.SinconectaLogUtil;
import jalis.integracaohospitais.sistemas.warelineBD.WarelineBDService;
import jalis.integracaohospitais.util.FabricaIntegracaoHospital;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.integracaohospitais.util.sinconecta.service.SinconectaService;
import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.ipmsaude.IPMSaudeService;
import jalis.integracaooperadoras.sistemas.ipmsaude.IntegracaoOperadoraIPMSaude;
import jalis.integracaooperadoras.sistemas.mksaude.IntegracaoOperadoraMKSaude;
import jalis.integracaooperadoras.sistemas.sdh.IntegracaoOperadoraSDH;
import jalis.integracaooperadoras.sistemas.simus.IntegracaoOperadoraSimus;
import jalis.integracaooperadoras.sistemas.unimed.sinos.IntegracaoOperadoraUnimedValeSinos;
import jalis.integracaooperadoras.sistemas.unimed.sinos.ValeDosSinosDTO;
import jalis.integracaooperadoras.sistemas.unimed.vtrp.IntegracaoOperadoraUnimedVTRP;
import jalis.integracaooperadoras.sistemas.upy.IntegracaoOperadoraUpy;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.exportacao.thread.ExportaWeb2;
import jalis.laboratorio.resultados.IntegracaoIDSSaude;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.parsers.Exame;
import jalis.laboratorio.util.parsers.ExameDesmembrado;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.FilialVOAux;
import jalis.model.vo.cadastro.exame.LabExternoVO;
import jalis.service.cadastro.ConvenioService;
import jalis.service.cadastro.FilialService;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.CertificadoException;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public abstract class AbstractImportadorResultadoLabExterno
extends JPanel
implements Runnable,
ActionListener {
    protected static final String FORMATO = "formato";
    protected static final String FORMATO_TEXTO = "formatotexto";
    protected static final String CODIGO_LAYOUT = "codigo-layout";
    protected static final String FORMATACAO = "formatacao";
    protected static final String MSG_IMPORTACAO_PDF = "\nResultado recebido para: %s%s|%s - Formato PDF - %s";
    protected static final String MSG_IMPORTACAO_LAYOUT = "\nResultado recebido para: %s%s|%s - Formato XML - %s";
    protected JTextArea textInformacoes = new JTextArea();
    protected JButton buttonImportar = ComponenteFactory.novoJButton("Importar", 'm', this);
    protected JButton buttonImportarWS = ComponenteFactory.novoJButton("Importar Webservice", 'I', this, null, null, false);
    protected JButton buttonConsultarPendencias = ComponenteFactory.novoJButton("Consultar Pend\u00eancias", 'C', this, null, null, false);
    protected JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    protected JProgressBar progress = ComponenteFactory.novoJProgressBar("Importando: ", false);
    protected int codigoLabExterno;
    protected Protocolo protocolo;
    protected boolean isWebService = false;
    private JPanel panelAdicional = new JPanel();

    public AbstractImportadorResultadoLabExterno(String titulo, String descricao, int codigoLabExterno, Protocolo protocolo) {
        this(titulo, descricao, codigoLabExterno, protocolo, null);
    }

    public AbstractImportadorResultadoLabExterno(String titulo, String descricao, int codigoLabExterno, Protocolo protocolo, JPanel panelAdicional) {
        this.codigoLabExterno = codigoLabExterno;
        this.protocolo = protocolo;
        JPanel panel = new JPanel(new GridBagLayout());
        JPanel panelBotoes = new JPanel(new FlowLayout(2));
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, titulo, descricao, this.adicionaExtensaoJPG(this.protocolo.getImgImpResultado(false)));
        this.add((Component)panel, "South");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 2;
        c.anchor = 13;
        panel.add((Component)panelBotoes, c);
        this.buttonImportarWS.setVisible(false);
        this.buttonConsultarPendencias.setVisible(false);
        panelBotoes.add(this.buttonImportarWS);
        panelBotoes.add(this.buttonImportar);
        panelBotoes.add(this.buttonConsultarPendencias);
        panelBotoes.add(this.buttonFechar);
        c.gridx = 0;
        c.weightx = 1.0;
        c.anchor = 17;
        if (panelAdicional != null) {
            this.panelAdicional = panelAdicional;
            panel.add((Component)this.panelAdicional, c);
        } else {
            panel.add((Component)this.panelAdicional, c);
        }
        panel = ComponenteFactory.novoJPanel(new BorderLayout(), BorderFactory.createTitledBorder("Informa\u00e7\u00f5es"));
        this.add((Component)panel, "Center");
        this.textInformacoes.setFont(new Font("Monospaced", 0, 12));
        this.textInformacoes.setEditable(false);
        panel.add((Component)new JScrollPane(this.textInformacoes), "Center");
        panel.add((Component)this.progress, "South");
    }

    private String adicionaExtensaoJPG(String imagem) {
        return imagem.toUpperCase().endsWith(".JPG") ? imagem : imagem.concat(".jpg");
    }

    public JPanel getPanelAdicional() {
        return this.panelAdicional;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonFechar) {
            this.fechar();
        } else if (o == this.buttonImportar) {
            this.habilitarBotoes(false);
            new Thread(this).start();
        } else if (o == this.buttonImportarWS) {
            this.habilitarBotoes(false);
            this.isWebService = true;
            new Thread(this).start();
        } else if (o == this.buttonConsultarPendencias) {
            this.isWebService = true;
            new Thread(() -> this.consultarPendencias()).start();
        }
    }

    protected void fechar() {
        if (this.getParent() != null) {
            this.getParent().removeAll();
        }
        this.setVisible(false);
    }

    @Override
    public void run() {
        if (this.isWebService) {
            this.importarResultadoWs();
        } else {
            this.importarResultado();
        }
        this.habilitarBotoes(true);
    }

    protected abstract void importarResultado();

    protected abstract void importarResultadoWs();

    protected void consultarPendencias() {
    }

    protected void setTextoInformacoes(String texto) {
        this.textInformacoes.setText(texto);
    }

    protected void anexarTextoInformacoes(String texto) {
        this.textInformacoes.append(texto);
        this.textInformacoes.scrollRectToVisible(new Rectangle(0, this.textInformacoes.getHeight() - 2, 1, 1));
    }

    protected void setTextoInformacoes(String texto, boolean limparTextoAnterior) {
        if (!limparTextoAnterior) {
            this.textInformacoes.append(texto);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AbstractImportadorResultadoLabExterno.this.textInformacoes.scrollRectToVisible(new Rectangle(0, AbstractImportadorResultadoLabExterno.this.textInformacoes.getHeight() - 2, 1, 1));
                }
            };
            SwingUtilities.invokeLater(runnable);
        } else {
            this.textInformacoes.setText(texto);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void salvarTabelaExameRequisicao(Statement st, Component owner, String resultado, String novaSituacao, String met_codigo, Registro dadosRequisicao, Registro dadosExame, boolean conferir, String usuarioConferencia, boolean validacaoCompulsoria, boolean validacaoResultadoCritico) throws SQLException, CertificadoException, Exception {
        Date dataAssinatura = new Date();
        String xmlAssinado = null;
        String paciente = "";
        String pacSexo = "";
        String pacNasc = "";
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        sql.append("select pac_nome, pac_sexo, pac_datanasc ");
        sql.append("  from paciente ");
        sql.append(" where pac_codigo = ").append(dadosRequisicao.getString("pac_codigo"));
        sql.append("   and fil_codigo = ").append(dadosRequisicao.getString("fil_codigo"));
        try (ResultSet rs = null;){
            rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                paciente = rs.getString("pac_nome");
                pacSexo = rs.getString("pac_sexo");
                pacNasc = Funcoes.formataData("dd/MM/yyyy", rs.getDate("pac_datanasc"));
            }
        }
        if (conferir && !novaSituacao.equals("C")) {
            novaSituacao = "C";
            xmlAssinado = ResultadosUtil.assinarXML(st, dadosRequisicao.getString("fil_codigo"), StringUtil.textoDB(resultado), dadosRequisicao.getString("req_codigo"), dadosExame.getString("exa_codigo"), dadosExame.getString("mco_codigo"), paciente, pacSexo, pacNasc, dataAssinatura);
        }
        sql.setLength(0);
        sql.append("update examerequisicao set \n");
        sql.append("  exr_compulsorio = ").append(validacaoCompulsoria).append(", \n");
        sql.append("  exr_resultado = '").append(xmlAssinado != null ? xmlAssinado : StringUtil.textoDB(resultado)).append("', \n");
        sql.append("  exr_situacao = '").append(novaSituacao).append("', \n");
        sql.append("  exr_datadigita = current_timestamp, \n");
        sql.append("  usr_coddigitador = '").append(Variaveis.login).append("' \n");
        sql.append(", exr_dataresultadocritico = ").append(validacaoResultadoCritico ? "'" + Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new Date()) + "'" : "null");
        if (conferir) {
            sql.append("  ,exr_dataassina = current_timestamp \n");
            if (usuarioConferencia != null && !Funcoes.textoVazio(usuarioConferencia)) {
                sql.append("  ,usr_codassina = ").append(StringUtil.textoDBEscape(usuarioConferencia));
            }
        }
        sql.append("  ,met_codigo = ").append(met_codigo).append(" \n");
        sql.append("where \n");
        sql.append("  fil_codigo = ").append(dadosRequisicao.getString("fil_codigo")).append(" and \n");
        sql.append("  req_codigo = ").append(dadosRequisicao.getString("req_codigo")).append(" and \n");
        sql.append("  exa_codigo = '").append(dadosExame.getString("exa_codigo")).append("' and \n");
        sql.append("  mco_codigo = ").append(dadosExame.getString("mco_codigo"));
        if (conferir) {
            String tipoIntegracaoOperadoraConvenio;
            String codRequisicao;
            if (xmlAssinado != null) {
                ResultadosUtil.atualizaAssinaturaExameRequisicao(dadosRequisicao.getString("fil_codigo"), dadosRequisicao.getString("req_codigo"), dadosExame.getString("exa_codigo"), dadosExame.getString("mco_codigo"), st, dataAssinatura);
                ResultadosUtil.gravarHashResultado(st, dadosRequisicao.getString("fil_codigo"), dadosRequisicao.getString("req_codigo"), dadosExame.getString("exa_codigo"), dadosExame.getString("mco_codigo"), paciente, xmlAssinado);
            }
            if (ParametrosGerais.isIntegracaoIds() && !Funcoes.textoVazio(dadosRequisicao.getString("xmlAgendamentoIDS"))) {
                dadosExame.setValor("exr_resultado", xmlAssinado != null ? xmlAssinado : resultado);
                dadosRequisicao.setValor("exame", dadosExame);
                IntegracaoIDSSaude.inserirLogComValidacao(st, dadosRequisicao.getInt("fil_codigo"), dadosRequisicao.getInt("req_codigo"), dadosRequisicao.getInt("req_idade"), dadosRequisicao.getString("req_anomes"), dadosExame.getString("exa_codigo"), dadosExame.getInt("mco_codigo"), dadosExame.getString("lay_codigo"), met_codigo);
            }
            if (ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.SIGH) {
                IntegracaoHospitalSigh integracaoSigh = (IntegracaoHospitalSigh)FabricaIntegracaoHospital.novaIntegracaoHospital(ParametrosGerais.getProtocoloIntegracaoHospital(), ParametrosLocais.getParametro("xmlHospital"));
                boolean cobranca = integracaoSigh.getCobrancaContaPaciente(dadosRequisicao.getString("fil_codigo"), dadosRequisicao.getString("con_codigo"));
                if (ParametrosGerais.getEventoGeradorIntegracaoHospital().equalsIgnoreCase("R") && !cobranca && IntegracaoHospitalSigh.validaExportacaoRequisicaoSituacaoI(dadosRequisicao.getString("fil_codigo"), dadosRequisicao.getString("req_codigo"), dadosExame.getString("exa_codigo"), dadosExame.getString("mco_codigo"))) {
                    IntegracaoHospitalSigh.insereIntegracaoHospital(ParametrosGerais.getProtocoloIntegracaoHospital(), dadosRequisicao.getString("fil_codigo"), "I", "filial", dadosRequisicao.getString("fil_codigo"), "codReq", dadosRequisicao.getString("req_codigo"), "codExa", dadosExame.getString("exa_codigo"), "codMat", dadosExame.getString("mco_codigo"));
                }
                if (!Funcoes.textoVazio(dadosRequisicao.getString("req_integracaohospital"))) {
                    IntegracaoHospitalSigh.insereIntegracaoHospital(ParametrosGerais.getProtocoloIntegracaoHospital(), dadosRequisicao.getString("fil_codigo"), "O", "filial", dadosRequisicao.getString("fil_codigo"), "codReq", dadosRequisicao.getString("req_codigo"), "codExa", dadosExame.getString("exa_codigo"), "codMat", dadosExame.getString("mco_codigo"));
                }
            }
            if (ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.MV && !Funcoes.textoVazio(dadosRequisicao.getString("req_integracaohospital"))) {
                AbstractIntegracaoHospital.insereIntegracaoHospital(ParametrosGerais.getProtocoloIntegracaoHospital(), dadosRequisicao.getString("fil_codigo"), "R", "filial", dadosRequisicao.getString("fil_codigo"), "codReq", dadosRequisicao.getString("req_codigo"), "codExa", dadosExame.getString("exa_codigo"), "codMat", dadosExame.getString("mco_codigo"));
            }
            if (ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.TASY && !Funcoes.textoVazio(dadosRequisicao.getString("req_integracaohospital"))) {
                AbstractIntegracaoHospital.insereIntegracaoHospital(ParametrosGerais.getProtocoloIntegracaoHospital(), dadosRequisicao.getString("fil_codigo"), "R", "filial", dadosRequisicao.getString("fil_codigo"), "codReq", dadosRequisicao.getString("req_codigo"), "codExa", dadosExame.getString("exa_codigo"), "codMat", dadosExame.getString("mco_codigo"));
            }
            if (ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.WARELINE && !Funcoes.textoVazio(dadosRequisicao.getString("req_integracaohospital"))) {
                AbstractIntegracaoHospital.insereIntegracaoHospital(ParametrosGerais.getProtocoloIntegracaoHospital(), dadosRequisicao.getString("fil_codigo"), "R", "filial", dadosRequisicao.getString("fil_codigo"), "codReq", dadosRequisicao.getString("req_codigo"), "codExa", dadosExame.getString("exa_codigo"), "codMat", dadosExame.getString("mco_codigo"));
            }
            if (ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.WARELINEBD && !Funcoes.textoVazio(dadosRequisicao.getString("req_integracaohospital"))) {
                WarelineBDService service = new WarelineBDService();
                String codFilial = dadosRequisicao.getString("fil_codigo");
                codRequisicao = dadosRequisicao.getString("req_codigo");
                String codExame = dadosExame.getString("exa_codigo");
                String codMaterial = dadosExame.getString("mco_codigo");
                service.gerarLogExportacaoWarelineBD(codFilial, dadosRequisicao.getString("con_codigo"), codRequisicao, codExame, codMaterial);
            }
            if (ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.G_HOSP && !Funcoes.textoVazio(dadosRequisicao.getString("req_integracaohospital"))) {
                IntegracaoHospitalGHosp.insereIntegracaoHospital(ParametrosGerais.getProtocoloIntegracaoHospital(), Variaveis.filialPadrao, dadosRequisicao.getString("req_codigo"), dadosExame.getString("exa_codigo"), dadosExame.getString("mco_codigo"), "R", new String[]{"filial", dadosRequisicao.getString("fil_codigo"), "codReq", dadosRequisicao.getString("req_codigo"), "codExa", dadosExame.getString("exa_codigo"), "codMat", dadosExame.getString("mco_codigo")});
            }
            if (ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.SINCONECTA && (novaSituacao.equalsIgnoreCase("C") || novaSituacao.equalsIgnoreCase("I"))) {
                SinconectaService serviceSinconecta = new SinconectaService();
                String codFilial = dadosRequisicao.getString("fil_codigo");
                codRequisicao = dadosRequisicao.getString("req_codigo");
                if (serviceSinconecta.convenioIntegradoSinconecta(codFilial, dadosRequisicao.getString("con_codigo")) && novaSituacao.equals("C") && dadosExame.getBoolean("exr_solicitadotiss")) {
                    SinconectaLogUtil.salvarLogSinconecta(dadosRequisicao.getString("req_codigo"), dadosExame.getString("exa_codigo"), dadosExame.getString("mco_codigo"), dadosRequisicao.getString("fil_codigo"), dadosExame.getString("exr_codautorizacao"), dadosRequisicao.getString("req_guia"));
                }
            }
            if (!Funcoes.textoVazio(tipoIntegracaoOperadoraConvenio = new ConvenioService().getTipoIntegracaoOperadoraSaude(dadosRequisicao.getString("fil_codigo"), dadosRequisicao.getString("con_codigo")))) {
                if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals("U")) {
                    IntegracaoOperadoraUpy.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), dadosRequisicao.getString("fil_codigo"), dadosRequisicao.getString("con_codigo"), dadosRequisicao.getString("req_codigo"), dadosRequisicao.getString("pac_codigo"), dadosExame.getString("exa_codigo"), dadosExame.getString("mco_codigo"), AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), new String[]{"filial", dadosRequisicao.getString("fil_codigo"), "codreq", dadosRequisicao.getString("req_codigo"), "codexa", dadosExame.getString("exa_codigo"), "codmat", dadosExame.getString("mco_codigo")});
                } else if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals("V")) {
                    IntegracaoOperadoraUnimedVTRP.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), dadosRequisicao.getString("fil_codigo"), dadosRequisicao.getString("con_codigo"), dadosRequisicao.getString("req_codigo"), dadosRequisicao.getString("pac_codigo"), dadosExame.getString("exa_codigo"), dadosExame.getString("mco_codigo"), AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), new String[]{"filial", dadosRequisicao.getString("fil_codigo"), "codreq", dadosRequisicao.getString("req_codigo"), "codexa", dadosExame.getString("exa_codigo"), "codmat", dadosExame.getString("mco_codigo")});
                } else if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals("M")) {
                    IntegracaoOperadoraMKSaude.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), dadosRequisicao.getString("fil_codigo"), dadosRequisicao.getString("con_codigo"), dadosRequisicao.getString("req_codigo"), dadosRequisicao.getString("pac_codigo"), dadosExame.getString("exa_codigo"), dadosExame.getString("mco_codigo"), AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_LAUDO.toString(), new String[]{"filial", dadosRequisicao.getString("fil_codigo"), "codreq", dadosRequisicao.getString("req_codigo"), "codexa", dadosExame.getString("exa_codigo"), "codmat", dadosExame.getString("mco_codigo")});
                } else if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals("D")) {
                    IntegracaoOperadoraSDH.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), dadosRequisicao.getString("fil_codigo"), dadosRequisicao.getString("con_codigo"), dadosRequisicao.getString("req_codigo"), dadosRequisicao.getString("pac_codigo"), dadosExame.getString("exa_codigo"), dadosExame.getString("mco_codigo"), AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_LAUDO.toString(), new String[]{"filial", dadosRequisicao.getString("fil_codigo"), "codreq", dadosRequisicao.getString("req_codigo"), "codexa", dadosExame.getString("exa_codigo"), "codmat", dadosExame.getString("mco_codigo"), "codGuia", dadosRequisicao.getString("req_guia")});
                } else if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals("S")) {
                    ValeDosSinosDTO valeDosSinosDTO = new ValeDosSinosDTO(dadosRequisicao.getString("fil_codigo"), dadosRequisicao.getString("con_codigo"), dadosRequisicao.getString("req_codigo"), dadosRequisicao.getString("pac_codigo"), dadosExame.getString("exa_codigo"), dadosExame.getString("mco_codigo"));
                    IntegracaoOperadoraUnimedValeSinos.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), valeDosSinosDTO, AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_LAUDO.toString(), new String[]{"filial", dadosRequisicao.getString("fil_codigo"), "codreq", dadosRequisicao.getString("req_codigo"), "codexa", dadosExame.getString("exa_codigo"), "codmat", dadosExame.getString("mco_codigo")});
                } else if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals("P")) {
                    IPMSaudeService ipmSaudeService = new IPMSaudeService();
                    Registro dadosReq = ipmSaudeService.getInformacaoRequisicao(dadosRequisicao.getString("fil_codigo"), dadosRequisicao.getString("req_codigo"));
                    if (!(Funcoes.objectIsNull(dadosReq) || Funcoes.textoVazio(dadosReq.getString("req_codigoipm")) || Funcoes.textoVazio(dadosReq.getString("exr_codigoipm")))) {
                        IntegracaoOperadoraIPMSaude.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), dadosRequisicao.getString("fil_codigo"), dadosRequisicao.getString("con_codigo"), dadosRequisicao.getString("req_codigo"), dadosRequisicao.getString("pac_codigo"), dadosExame.getString("exa_codigo"), dadosExame.getString("mco_codigo"), AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), new String[]{"filial", dadosRequisicao.getString("fil_codigo"), "codreq", dadosRequisicao.getString("req_codigo"), "codexa", dadosExame.getString("exa_codigo"), "codmat", dadosExame.getString("mco_codigo"), "codGuia", dadosReq.getString("req_guia")});
                    }
                } else if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SIMUS.getCodigo())) {
                    IntegracaoOperadoraSimus.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), dadosRequisicao.getString("fil_codigo"), dadosRequisicao.getString("con_codigo"), dadosRequisicao.getString("req_codigo"), dadosRequisicao.getString("pac_codigo"), dadosExame.getString("exa_codigo"), dadosExame.getString("mco_codigo"), AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), new String[]{"filial", dadosRequisicao.getString("fil_codigo"), "codreq", dadosRequisicao.getString("req_codigo"), "codexa", dadosExame.getString("exa_codigo"), "codmat", dadosExame.getString("mco_codigo")});
                } else {
                    AbstractIntegracaoOperadora.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), dadosRequisicao.getString("fil_codigo"), dadosRequisicao.getString("con_codigo"), AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), "filial", dadosRequisicao.getString("fil_codigo"), "codreq", dadosRequisicao.getString("req_codigo"), "codexa", dadosExame.getString("exa_codigo"), "codmat", dadosExame.getString("mco_codigo"));
                }
            }
        }
        DBUtil.gravaLogSituacaoExameRequisicao(st, dadosRequisicao.getString("fil_codigo"), dadosRequisicao.getString("req_codigo"), dadosExame.getString("exa_codigo"), dadosExame.getString("mco_codigo"), novaSituacao, false);
        Conexao.executeUpdate(dadosRequisicao.getString("fil_codigo"), st, sql.toString());
    }

    protected void inserirDadosRequisicao(Statement st, int codigoLabExterno, String codigoReqApoio, String filial, int requisicao) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into requisicaolabexterno (fil_codigo, lae_codigo, rle_codigo, req_codigo) values (");
        sql.append(filial).append(",");
        sql.append(codigoLabExterno).append(", '");
        sql.append(StringUtil.textoDB(codigoReqApoio)).append("', ");
        sql.append(requisicao).append(")");
        Conexao.executeUpdate(filial, st, sql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean existeRequisicaoLabExterno(int filial, int codigoLabExterno, int requisicao, String reqLabExterno) {
        boolean bl;
        StringBuilder sql = new StringBuilder();
        sql.append("select rle.req_codigo ");
        sql.append("from requisicaolabexterno rle ");
        sql.append("where rle.fil_codigo = ").append(filial);
        sql.append(" and rle.lae_codigo = ").append(codigoLabExterno);
        sql.append(" and rle.req_codigo = ").append(requisicao);
        Statement st = Conexao.getStatement();
        try {
            ResultSet res = Conexao.executeQuery(st, sql);
            bl = res.next();
        }
        catch (Exception e) {
            boolean bl2;
            try {
                bl2 = true;
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return bl2;
        }
        Conexao.fecharStatement(st);
        return bl;
    }

    protected boolean exportarBaseWeb(String filial) {
        try {
            Statement st = Conexao.getStatement();
            FilialService filService = new FilialService();
            FilialVOAux filialVO = filService.getDadosExportaBaseWeb(st, filial);
            if (this.carregouVO(filialVO)) {
                return this.isExportarBaseWeb(filialVO);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoAlvaro: 261");
        }
        return false;
    }

    protected boolean carregouVO(FilialVOAux filialVO) {
        return filialVO != null;
    }

    private boolean isExportarBaseWeb(FilialVOAux filialVO) {
        return !Funcoes.textoVazio(filialVO.getTipoBase()) && filialVO.isWebStandAlone() == false;
    }

    protected Registro localizarFormatacao(Registro reg) {
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                int codLay = Integer.parseInt(reg.getString(CODIGO_LAYOUT));
                StringBuilder bui = new StringBuilder("select \n");
                bui.append("  c.met_codigo, \n");
                bui.append("  b.lay_codigo, b.ela_idadeini, b.ela_idadefim, b.ela_idadeinitipo, b.ela_idadefimtipo, b.ela_padrao \n");
                bui.append("from examematcoleta a \n");
                bui.append("left join examelayout b \n");
                bui.append("  on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo and a.mco_codigo = b.mco_codigo \n");
                bui.append("left join examematcoletalabexterno c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo ");
                bui.append("where \n");
                bui.append("  a.fil_codigo = ").append(reg.getString("fil_codigo")).append(" and \n");
                bui.append("  a.exa_codigo = '").append(reg.getString("exa_codigo")).append("' and \n");
                bui.append("  a.mco_codigo = ").append(reg.getString("mco_codigo")).append(" and \n");
                bui.append("  c.lae_codigo =").append(this.codigoLabExterno);
                ResultSet rs = Conexao.executeQuery(st, bui.toString());
                int linha = 0;
                while (rs.next()) {
                    boolean idadeZero;
                    boolean padrao = rs.getBoolean("ela_padrao");
                    boolean interValido = codLay == rs.getInt("lay_codigo") && this.pertenceAoIntervalo(rs, reg);
                    boolean bl = idadeZero = codLay == rs.getInt("lay_codigo") && rs.getInt("ela_idadeini") == 0 && rs.getInt("ela_idadefim") == 0;
                    if ((!padrao || linha != 0) && !idadeZero && !interValido) continue;
                    linha = rs.getRow();
                    if (!interValido) continue;
                    break;
                }
                if (linha > 0) {
                    rs.first();
                    while (rs.getRow() < linha && rs.next()) {
                    }
                    bui.setLength(0);
                    bui.append("select \n");
                    bui.append("  a.elm_formato as ").append(FORMATO).append(", \n");
                    bui.append("  a.elm_exportartexto as ").append(FORMATO_TEXTO).append(", \n");
                    bui.append("  b.met_codigo \n");
                    bui.append("from examelayoutmetodo a \n");
                    bui.append("left join metodologia b \n");
                    bui.append("  on a.fil_codigo = b.fil_codigo and a.met_codigo = b.met_codigo \n");
                    bui.append("where \n");
                    bui.append("  a.fil_codigo = ").append(reg.getString("fil_codigo")).append(" and \n");
                    bui.append("  a.exa_codigo = '").append(reg.getString("exa_codigo")).append("' and \n");
                    bui.append("  a.mco_codigo = ").append(reg.getString("mco_codigo")).append(" and \n");
                    bui.append("  a.lay_codigo = ").append(rs.getString("lay_codigo")).append(" and \n");
                    bui.append("  a.ela_idadeini = ").append(rs.getString("ela_idadeini")).append(" and \n");
                    bui.append("  a.ela_idadefim = ").append(rs.getString("ela_idadefim")).append(" and \n");
                    bui.append("  a.ela_idadeinitipo = '").append(rs.getString("ela_idadeinitipo")).append("' and \n");
                    bui.append("  a.ela_idadefimtipo = '").append(rs.getString("ela_idadefimtipo")).append("' and \n");
                    bui.append("  b.met_codigo = ").append(rs.getString("met_codigo"));
                    rs = Conexao.executeQuery(st, bui.toString());
                    if (rs.next()) {
                        return new Registro(rs);
                    }
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoAlvaro: 1241");
            }
        }
        return null;
    }

    protected boolean pertenceAoIntervalo(ResultSet res, Registro pac) throws SQLException {
        int idadePac = pac.getInt("req_idade") * this.diasTipo(pac.getString("req_anomes"));
        int ini = res.getInt("ela_idadeini") * this.diasTipo(res.getString("ela_idadeinitipo"));
        int fim = res.getInt("ela_idadefim") * this.diasTipo(res.getString("ela_idadefimtipo"));
        return ini <= idadePac && idadePac <= fim;
    }

    protected int diasTipo(String tipo) {
        if ("A".equals(tipo)) {
            return 365;
        }
        if ("M".equals(tipo)) {
            return 31;
        }
        return 1;
    }

    protected void exportarParaWeb(Statement st, String codigoBaseWeb, String situacao, Registro reg, Map mapa, String resultadoOriginal, String formatoTexto) throws Exception {
        if (mapa != null && !Funcoes.textoVazio(codigoBaseWeb)) {
            boolean resultadoPdf = ExportaWeb.isGerarPdfResultado(st, reg.getString("fil_codigo"));
            ArrayList<String> chave = new ArrayList<String>();
            chave.add("codigoRequisicao");
            chave.add(IntegracaoUtil.formataCodigoRequisicao(reg.getString("fil_codigo"), reg.getString("req_codigo"), st));
            chave.add("codigoBase");
            chave.add(codigoBaseWeb);
            chave.add("codigoExameRequisicao");
            chave.add(reg.getString("exa_codigo"));
            chave.add("materialExameRequisicao");
            chave.add(reg.getString("mco_codigo"));
            ArrayList<String> temp = new ArrayList<String>(chave);
            String laudo = mapa.get("laudo") != null ? StringUtil.textoDB((String)mapa.get("laudo")) : "";
            String exportaTexto = mapa.get("laudo") != null ? formatoTexto : "";
            temp.add("dataEnvioExameRequisicao");
            temp.add("current_timestamp");
            temp.add("situacaoExameRequisicao");
            temp.add(situacao);
            temp.add("resultadoExameRequisicao");
            temp.add(laudo);
            temp.add("resultadoTextoExameRequisicao");
            temp.add(ResultadosUtil.geraResultadoTextoParaWeb(resultadoOriginal, exportaTexto));
            DBUtil.insereExportaWeb(reg.getString("fil_codigo"), st, "requisicaoexame", "A", true, temp.toArray(new String[temp.size()]));
            Map imagens = (Map)mapa.get("imagens");
            if (imagens != null && !imagens.isEmpty()) {
                DBUtil.insereExportaWeb(reg.getString("fil_codigo"), st, "requisicaoexameimagem", "D", chave.toArray(new String[chave.size()]));
                temp.clear();
                for (Integer indice : imagens.keySet()) {
                    temp.addAll(chave);
                    temp.add("codigoImagemExame");
                    temp.add(indice.toString());
                    temp.add("imagemExame");
                    temp.add((String)imagens.get(indice));
                    DBUtil.insereExportaWeb(reg.getString("fil_codigo"), st, "requisicaoexameimagem", "I", false, temp.toArray(new String[temp.size()]));
                    temp.clear();
                }
            }
            ExportaWeb2.atualizaPaginaOrdemExameWeb(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), codigoBaseWeb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCodigoBaseWeb(String fil_codigo) {
        String retorno = "";
        Statement st = Conexao.getStatement();
        try {
            retorno = ExportaWeb.getCodigoBaseWeb(st, fil_codigo);
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "AbstractImportadorResultadoLabExterno");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    protected void atualizarTabelaExamesControle(Statement st, Registro reg, String resultadoAnterior) throws SQLException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("fil_codigo", reg.getString("fil_codigo"));
            params.put("pac_codigo", reg.getString("pac_codigo"));
            params.put("exa_codigo", reg.getString("exa_codigo"));
            params.put("mco_codigo", reg.getString("mco_codigo"));
            params.put("req_codigo", reg.getString("req_codigo"));
            params.put("met_codigo", reg.getString("met_codigo"));
            params.put("exc_resultado", StringUtil.textoDB(resultadoAnterior));
            ExameUtil.obterDataHoraExamesControle(params, ParametrosGerais.getDataAnterioresUsandoColeta(), reg.getDate("exr_datamaterial"));
            ExameUtil.deletaExamesControle(params, st);
            ExameUtil.insereExameControle(params, st, false);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoRede");
        }
    }

    protected void habilitarBotoes(boolean habilitar) {
        this.buttonImportar.setEnabled(habilitar);
        this.buttonFechar.setEnabled(habilitar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExameDesmembrado getExamesDesmembrados(String filial, String reqCodigo, String laeCodigo, String exaFilho, String mcoFilho) {
        Statement st;
        block4: {
            ExameDesmembrado exameDesmembrado;
            st = Conexao.getStatement();
            try {
                if (st == null) break block4;
                StringBuilder buf = new StringBuilder();
                buf.append(" select a.exa_codigo ,a.mco_codigo ,p.ele_xmllabexterno ");
                buf.append(" from loteexternoexamerequisicaodesm a ");
                buf.append(" left join examematcoletalabexterno p on a.fil_kodigo = p.fil_codigo and a.exa_kodigo = p.exa_codigo and a.mco_kodigo = p.mco_codigo and a.lae_codigo = p.lae_codigo ");
                buf.append(" where a.fil_kodigo = ").append(filial);
                buf.append(" and a.req_codigo  = ").append(reqCodigo);
                buf.append(" and a.exa_kodigo = ").append(StringUtil.textoDBEscape(exaFilho));
                buf.append(" and a.mco_kodigo = ").append(mcoFilho);
                buf.append(" and a.lae_codigo = ").append(laeCodigo);
                ResultSet res = Conexao.executeQuery(st, buf.toString());
                if (!res.next()) break block4;
                ExameDesmembrado ex = new ExameDesmembrado(res.getString("exa_codigo"), res.getInt("mco_codigo"));
                ex.addFilho(new Exame(exaFilho, Integer.parseInt(mcoFilho), res.getString("ele_xmllabexterno")));
                exameDesmembrado = ex;
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoAlvaro: 261");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
            return exameDesmembrado;
        }
        Conexao.fecharStatement(st);
        return null;
    }

    protected LabExternoVO pesquisarPorCodLabExterno(int codLabExterno) throws Exception {
        LabExternoVO vo = new LabExternoVO();
        Statement st = Conexao.getStatement();
        StringBuilder sql = new StringBuilder(" select ");
        sql.append(" fil_codigo, ");
        sql.append(" lae_codigo, ");
        sql.append(" lae_configuracao, ");
        sql.append(" coalesce(lae_conferirautomatico, false) as lae_conferirautomatico, ");
        sql.append(" usr_codconferir, lae_agruparmultiguias, ");
        sql.append(" lae_codigomodeloweb ");
        sql.append(" from labexterno ");
        sql.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" and lae_codigo = ").append(codLabExterno);
        try {
            ResultSet rs = ConexaoTemporaria.executeQuery(st, sql);
            if (rs.next()) {
                FilialVO filial = new FilialVO();
                filial.setCodigo(rs.getInt("fil_codigo"));
                vo.setCodigo(rs.getInt("lae_codigo"));
                vo.setFilial(filial);
                vo.setConferirAutomatico(rs.getBoolean("lae_conferirautomatico"));
                vo.setCodigoUsuarioConferir(rs.getString("usr_codconferir"));
                vo.setCodigoModeloWeb(rs.getInt("lae_codigomodeloweb"));
                vo.setAgruparmultiguias(rs.getBoolean("lae_agruparmultiguias"));
                vo.setConfiguracao(rs.getString("lae_configuracao"));
            }
        }
        catch (Exception e) {
            ConexaoTemporaria.anulaSQL();
            throw e;
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
        return vo;
    }

    protected Integer[] verificarRequisicaoMultiguia(String codFilial, String codRequisicao, boolean labExternoAgrupaMultguias) {
        Integer[] multiguias = null;
        try {
            multiguias = ParametrosGerais.isAgruparGuiasInterface() || labExternoAgrupaMultguias ? RecepcaoUtil.verificaMultiGuias(codFilial, codRequisicao, true) : new Integer[]{Integer.parseInt(codRequisicao)};
        }
        catch (Exception e) {
            return multiguias;
        }
        return multiguias;
    }

    protected static enum Situacao {
        LANCADO("Lan\u00e7ado"),
        CONFERIDO("Conferido"),
        LANCADO_PARCIALMENTE("Lan\u00e7ado Parcialmente"),
        ENTREGUE("Entregue"),
        IMPRESSO("Impresso"),
        NAO_LOCALIZADO("N\u00e3o Localizado"),
        JA_LANCADO("J\u00e1 lan\u00e7ado"),
        VERSAO_INCOMPATIVEL("Vers\u00e3o incompat\u00edvel"),
        CONDICAO_INSATISFEITA("Condi\u00e7\u00e3o insatisfeita"),
        VALIDACAO_INSATISFEITA("Express\u00e3o de valida\u00e7\u00e3o insatisfeita"),
        SEM_RELACIONAMENTO("Sem relacionamento"),
        SEM_MATERIAL("Sem material"),
        LAYOUT_ATUALIZADO("Layout atualizado, mas n\u00e3o relacionado"),
        SEM_COD_EXM_LAB("XML sem campo CodExmLab");

        public String descricao;

        private Situacao(String descricao) {
            this.descricao = descricao;
        }
    }
}

