/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.model.bean.log.LogImportacaoLabExternoBean;
import jalis.service.cadastro.exame.LabExternoService;
import jalis.service.log.LogImportacaoLabExternoService;
import jalis.util.Funcoes;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public abstract class AbstractImportadorLabExterno
extends JPanel
implements Runnable,
ActionListener {
    private JTextArea textInformacoes = new JTextArea();
    private JButton buttonImportar = ComponenteFactory.novoJButton("Importar", 'I', this);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private JPanel panelBotoes = ComponenteFactory.novoJPanelFlowLayout(2, this.buttonImportar, this.buttonFechar);
    protected JProgressBar progress = ComponenteFactory.novoJProgressBar("Importando: ", false);
    protected int codigoLabExterno;
    protected Protocolo protocolo;

    public AbstractImportadorLabExterno(String titulo, String descricao, int codigoLabExterno, Protocolo protocolo) {
        this(titulo, descricao, codigoLabExterno, protocolo, null);
    }

    public AbstractImportadorLabExterno(String titulo, String descricao, int codigoLabExterno, Protocolo protocolo, JPanel panelAdicional) {
        this.codigoLabExterno = codigoLabExterno;
        this.protocolo = protocolo;
        JPanel panel = new JPanel(new GridBagLayout());
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, titulo, descricao, this.adicionaExtensaoJPG(this.protocolo.getImgImpExames(false)));
        this.add((Component)panel, "South");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 2;
        c.anchor = 13;
        panel.add((Component)this.panelBotoes, c);
        c.gridx = 0;
        c.weightx = 1.0;
        c.anchor = 17;
        if (panelAdicional != null) {
            panel.add((Component)panelAdicional, c);
        } else {
            panel.add((Component)new JPanel(), c);
        }
        panel = ComponenteFactory.novoJPanel(new BorderLayout(), BorderFactory.createTitledBorder("Informa\u00e7\u00f5es"));
        this.add((Component)panel, "Center");
        this.textInformacoes.setFont(new Font("Monospaced", 0, 12));
        this.textInformacoes.setEditable(false);
        panel.add((Component)new JScrollPane(this.textInformacoes), "Center");
        panel.add((Component)this.progress, "South");
    }

    private String adicionaExtensaoJPG(String imagem) {
        return imagem.toUpperCase().endsWith(".JPG") ? imagem : imagem.concat(".jpg");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonFechar) {
            if (this.getParent() != null) {
                this.getParent().removeAll();
            }
            this.setVisible(false);
        } else if (o == this.buttonImportar) {
            this.habilitarBotoes(false);
            new Thread(this).start();
        }
    }

    @Override
    public void run() {
        if (this.importarArquivo()) {
            try {
                new LabExternoService().atualizaDataUltimaImportacaoExames(Variaveis.filialPadrao, this.codigoLabExterno);
                LogImportacaoLabExternoBean importacaoLabExternoBean = new LogImportacaoLabExternoBean();
                importacaoLabExternoBean.setFil_codigo(Integer.parseInt(Variaveis.filialPadrao));
                importacaoLabExternoBean.setLae_codigo(this.codigoLabExterno);
                importacaoLabExternoBean.setLil_datahora(Funcoes.getDataHoraServidor());
                importacaoLabExternoBean.setLil_log(this.textInformacoes.getText().replaceAll("\\t", ""));
                new LogImportacaoLabExternoService().insert(importacaoLabExternoBean, null, Variaveis.filialPadrao, null);
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi possivel atualizar a data de importa\u00e7\u00e3o do lab. externo\n" + e.getMessage(), e.getStackTrace());
            }
        }
        this.habilitarBotoes(true);
    }

    public String getRetornoExportacao() {
        return this.textInformacoes.getText();
    }

    protected abstract boolean importarArquivo();

    protected JPanel getPanelBotoes() {
        return this.panelBotoes;
    }

    protected JButton getButtonImportar() {
        return this.buttonImportar;
    }

    public JButton getButtonFechar() {
        return this.buttonFechar;
    }

    protected JTextArea getTextAreaInformacoes() {
        return this.textInformacoes;
    }

    protected void setTextoInformacoes(String texto) {
        this.textInformacoes.setText(texto);
    }

    protected void anexarTextoInformacoes(String texto) {
        this.textInformacoes.append(texto);
        this.textInformacoes.scrollRectToVisible(new Rectangle(0, this.textInformacoes.getHeight() - 2, 1, 1));
    }

    protected void setTextoInformacoes(String texto, boolean limparTextoAnterior) {
        if (!limparTextoAnterior) {
            this.textInformacoes.append(texto);
            this.textInformacoes.scrollRectToVisible(new Rectangle(0, this.textInformacoes.getHeight() - 2, 1, 1));
            this.textInformacoes.revalidate();
            this.textInformacoes.repaint();
        } else {
            this.textInformacoes.setText(texto);
        }
    }

    protected void setTextoInformacoesAdicionandoEnter(String texto, boolean limparTextoAnterior) {
        if (!texto.endsWith(System.lineSeparator())) {
            texto = texto + System.lineSeparator();
        }
        this.setTextoInformacoes(texto, limparTextoAnterior);
    }

    protected void habilitarBotoes(boolean habilitar) {
        this.buttonImportar.setEnabled(habilitar);
        this.buttonFechar.setEnabled(habilitar);
    }
}

