/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.util.parsers.pardini.ConfiguradorException;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class AbstractConfiguradorProtocolo
extends AbstractDialogoOKCancelar
implements ActionListener {
    protected TTextField textLote = new TTextField(10, 1);
    protected TTextField textCodigo = new TTextField(6, 1);
    protected final String codigoLabExterno;
    protected boolean enviarMedico = false;

    public AbstractConfiguradorProtocolo(Frame pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo);
        this.codigoLabExterno = codigoLaboratorio == null ? "" : codigoLaboratorio;
    }

    public AbstractConfiguradorProtocolo(Dialog pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo);
        this.codigoLabExterno = codigoLaboratorio == null ? "" : codigoLaboratorio;
    }

    @Override
    public boolean acaoOk() {
        if (!this.textLote.getText().matches("\\d+")) {
            Funcoes.mensagem(this, "N\u00e3o foi especificado um n\u00famero de lote v\u00e1lido", 1);
        } else if (!this.textCodigo.getText().matches("\\d+")) {
            Funcoes.mensagem(this, "N\u00e3o foi especificado um c\u00f3digo v\u00e1lido", 1);
        } else if (this.codigoLabExterno.matches("\\d+") && Integer.parseInt(this.textLote.getText()) < this.getMaiorLote()) {
            Funcoes.mensagem(this, "J\u00e1 existe lote criado com o valor \"" + this.textLote.getText() + "\"", 1);
        } else {
            return true;
        }
        ScreenUtil.requisitarFoco(this.textLote);
        return false;
    }

    public final String getCodigoConvenio() {
        return this.textCodigo.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumeroLote() {
        Statement st;
        block4: {
            int n;
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            String numeroLote = "";
            buf.append("SELECT last_value from codigolote_").append(Variaveis.filialPadrao).append("_").append(this.codigoLabExterno).append("_sequence");
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) break block4;
                numeroLote = Variaveis.filialPadrao + Funcoes.preencheZero(rs.getInt("last_value"), 7);
                n = Integer.parseInt(numeroLote);
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
            return n;
        }
        Conexao.fecharStatement(st);
        return 0;
    }

    public String getAdicionalLote() {
        return "";
    }

    public boolean isNaoEnviarObsRequisicao() {
        return false;
    }

    public void setNumeroLote(int numeroLote) throws ConfiguradorException {
        if (numeroLote < this.getNumeroLote()) {
            throw new ConfiguradorException("O n\u00famero de lote especificado n\u00e3o pode ser menor ou igual ao n\u00famero do lote atual");
        }
        this.textLote.setText(String.valueOf(numeroLote));
    }

    public abstract String getXML();

    public abstract void setXML(String var1, boolean var2);

    private int getMaiorLote() {
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                StringBuilder sql = new StringBuilder("select \n");
                sql.append("  max(lex_codigo) as maior \n");
                sql.append("from loteexterno \n");
                sql.append("where \n");
                sql.append("  fil_codigo = ").append(Variaveis.filialPadrao).append(" and \n");
                sql.append("  lae_codigo = ").append(this.codigoLabExterno);
                ResultSet res = Conexao.executeQuery(st, sql);
                if (res.next()) {
                    return res.getInt("maior");
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "AbstractConfiguradorProtocolo: 84");
            }
        }
        return 0;
    }

    public boolean isEnviarMedico() {
        return this.enviarMedico;
    }
}

