/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.interfaceamento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.interfaceamento.TuboInterface;
import jalis.util.DBUtil;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class ExportarInterface {
    public static void criaInterface(String filial, String requisicao, String tela) throws SQLException {
        ExportarInterface.criaInterface(filial, requisicao, tela, Conexao.getStatement(), Conexao.getStatement());
    }

    public static void criaInterface(String filial, String requisicao, String tela, Statement statement, Statement stDesmembrar) throws SQLException {
        ExportarInterface.criaInterface(false, filial, requisicao, tela, statement, stDesmembrar, false, ParametrosGerais.getTipoExportacaoInterface(), ParametrosGerais.getAgruparInterface());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void criaInterface(boolean isColetaWeb, String filial, String requisicao, String tela, Statement statement, Statement stDesmembrar, Boolean gerarInterfaceApoio, String tipoExportacaoInterface, int agruparInterface) throws SQLException {
        if (tipoExportacaoInterface.equals("N")) {
            return;
        }
        StringBuilder buf = new StringBuilder("select a.exa_codigo, c.rec_capacidade, b.rec_codigo, interface.int_codigo, interface.emi_curva, ");
        buf.append("d.mco_abreviatura, d.mco_codigo, d.mco_descricao, a.req_codigo, f.pac_nome, c.rec_capacidade, c.unm_codigo, ");
        buf.append("s.set_codigo, s.set_descricao, s.set_sigla, a.fil_codigo, filial.fil_descricao, e.con_codigo, e.des_codigo, coalesce(interface.emi_bloqueado, false) as emi_bloqueado ");
        buf.append("from examerequisicao a ");
        buf.append("left join requisicao e on a.fil_codigo = e.fil_codigo and a.req_codigo = e.req_codigo ");
        buf.append("left join paciente f on e.fil_codigo = f.fil_codigo and e.pac_codigo = f.pac_codigo ");
        if (agruparInterface == 0) {
            buf.append("left join recipcoleta b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo and a.mco_codigo = b.mco_codigo and b.rco_interface = true ");
        } else {
            buf.append("left join reciptriagem b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo and a.mco_codigo = b.mco_codigo and b.rtr_interface = true ");
        }
        buf.append("join recipientes c on b.fil_codigo = c.fil_codigo and b.rec_codigo = c.rec_codigo ");
        buf.append("left join materialcoleta d on a.fil_codigo = d.fil_codigo and a.mco_codigo = d.mco_codigo ");
        buf.append("left join examesetor es on a.fil_codigo = es.fil_codigo and a.exa_codigo = es.exa_codigo and es.ese_default = true ");
        buf.append("left join setores s on es.fil_codigo = s.fil_codigo and es.set_codigo = s.set_codigo ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo ");
        buf.append("left join examematinterface interface on a.fil_codigo = interface.fil_codigo and a.exa_codigo = interface.exa_codigo and a.mco_codigo = interface.mco_codigo ");
        if (tipoExportacaoInterface.equals("P")) {
            buf.append(" and interface.emi_padrao = true ");
        }
        buf.append("where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and a.req_codigo = ");
        buf.append(requisicao);
        buf.append(" and a.exr_excluido = false and e.req_excluida = false ");
        buf.append(" and (a.exr_situacao = '' or a.exr_situacao = ' ' or a.exr_situacao is null ");
        if (gerarInterfaceApoio.booleanValue()) {
            buf.append(" or a.exr_situacao = '").append("F").append("' ");
        }
        buf.append(") ");
        buf.append(" and (a.exr_interfaciado = false or a.exr_interfaciado is null)");
        buf.append(" order by s.set_codigo, b.rec_codigo, a.mco_codigo, a.exa_codigo");
        ArrayList<TuboInterface> lista = new ArrayList<TuboInterface>();
        try (ResultSet rsColeta = null;){
            rsColeta = statement.executeQuery(buf.toString());
            while (rsColeta.next()) {
                int qtde = 1;
                int pos = -1;
                for (int i = 0; i < qtde; ++i) {
                    if (rsColeta.getBoolean("emi_bloqueado") || DBUtil.campoNull(rsColeta.getString("rec_codigo")) || DBUtil.campoNull(rsColeta.getString("int_codigo"))) continue;
                    pos = ExportarInterface.localizar(0, rsColeta.getString("set_codigo"), rsColeta.getString("rec_codigo"), rsColeta.getString("int_codigo"), lista);
                    if (pos > -1) {
                        ExportarInterface.adicionaTubo(lista, pos, rsColeta.getString("rec_codigo"), rsColeta.getString("exa_codigo"), rsColeta.getString("mco_codigo"), rsColeta.getString("req_codigo"), rsColeta.getString("fil_codigo"), rsColeta.getString("set_codigo"), rsColeta.getString("int_codigo"), rsColeta.getBoolean("emi_curva"));
                        continue;
                    }
                    lista.add(new TuboInterface(rsColeta.getString("rec_codigo"), rsColeta.getString("exa_codigo"), rsColeta.getString("mco_codigo"), rsColeta.getString("req_codigo"), rsColeta.getString("fil_codigo"), rsColeta.getString("set_codigo"), rsColeta.getString("int_codigo"), rsColeta.getBoolean("emi_curva")));
                }
            }
        }
        if (!lista.isEmpty()) {
            for (int i = 0; i < lista.size(); ++i) {
                TuboInterface dados = (TuboInterface)lista.get(i);
                buf.delete(0, buf.length());
                buf.append("select req_codigo from interfaceexamerequisicao ");
                buf.append(" where fil_codigo = ");
                buf.append(dados.codigoFilial);
                buf.append(" and int_codigo =  ");
                buf.append(dados.codigoInterface);
                buf.append(" and req_codigo = ");
                buf.append(dados.codigoRequisicaoTubo);
                buf.append(" and exa_codigo = '");
                buf.append(dados.exame);
                buf.append("' and mco_codigo = ");
                buf.append(dados.codigoMaterial);
                buf.append(" and rec_codigo = ");
                buf.append(dados.tubo);
                ResultSet rs = statement.executeQuery(buf.toString());
                if (rs.next()) {
                    buf.setLength(0);
                    buf.delete(0, buf.length());
                    buf.append("delete from interfaceexamerequisicaodesm where fil_codigo = ");
                    buf.append(dados.codigoFilial);
                    buf.append(" and exa_codigo = '");
                    buf.append(dados.exame);
                    buf.append("' and mco_codigo = ");
                    buf.append(dados.codigoMaterial);
                    buf.append(" and int_codigo = ");
                    buf.append(dados.codigoInterface);
                    buf.append(" and req_codigo = ");
                    buf.append(dados.codigoRequisicaoTubo);
                    buf.append(" and rec_codigo = ");
                    buf.append(dados.tubo);
                    if (isColetaWeb) {
                        stDesmembrar.execute(buf.toString());
                    } else {
                        Conexao.execute(dados.codigoFilial, stDesmembrar, buf.toString());
                    }
                } else {
                    buf.delete(0, buf.length());
                    buf.append("insert into interfaceexamerequisicao (fil_codigo, int_codigo, req_codigo, ");
                    buf.append(" exa_codigo, mco_codigo, rec_codigo, ier_situacao) values (");
                    buf.append(dados.codigoFilial);
                    buf.append(", ");
                    buf.append(dados.codigoInterface);
                    buf.append(", ");
                    buf.append(dados.codigoRequisicaoTubo);
                    buf.append(", '");
                    buf.append(dados.exame);
                    buf.append("', ");
                    buf.append(dados.codigoMaterial);
                    buf.append(", ");
                    buf.append(dados.tubo);
                    buf.append(", 0)");
                    if (isColetaWeb) {
                        stDesmembrar.execute(buf.toString());
                    } else {
                        Conexao.execute(dados.codigoFilial, stDesmembrar, buf.toString());
                    }
                }
                buf.delete(0, buf.length());
                buf.append("select exa_kodigo, mco_kodigo from examematintdesmembrar where fil_codigo = ");
                buf.append(filial);
                buf.append(" and exa_codigo = '");
                buf.append(dados.exame);
                buf.append("' and mco_codigo = ");
                buf.append(dados.codigoMaterial);
                buf.append(" and int_codigo = ");
                buf.append(dados.codigoInterface);
                try {
                    rs = stDesmembrar.executeQuery(buf.toString());
                    while (rs.next()) {
                        ArrayList<String> codigosTuboFilho = new ArrayList<String>();
                        if (dados.curva) {
                            buf.setLength(0);
                            buf.append("select a.rec_codigo ");
                            buf.append("from ");
                            if (agruparInterface == 0) {
                                buf.append("recipcoleta a ");
                                buf.append("where a.fil_codigo = ").append(filial);
                                buf.append(" and a.exa_codigo = '").append(StringUtil.textoDB(rs.getString("exa_kodigo"))).append("'");
                                buf.append(" and a.mco_codigo = ").append(rs.getString("mco_kodigo"));
                                buf.append(" and a.rco_interface = true ");
                            } else {
                                buf.append("reciptriagem a ");
                                buf.append("where a.fil_codigo = ").append(filial);
                                buf.append(" and a.exa_codigo = '").append(StringUtil.textoDB(rs.getString("exa_kodigo"))).append("'");
                                buf.append(" and a.mco_codigo = ").append(rs.getString("mco_kodigo"));
                                buf.append(" and a.rtr_interface = true ");
                            }
                            try (ResultSet rsTubos = null;){
                                rsTubos = statement.executeQuery(buf.toString());
                                while (rsTubos.next()) {
                                    codigosTuboFilho.add(rsTubos.getString("rec_codigo"));
                                }
                            }
                        }
                        if (codigosTuboFilho.isEmpty()) {
                            codigosTuboFilho.add(dados.tubo);
                        }
                        for (String codigoTuboFilho : codigosTuboFilho) {
                            buf.delete(0, buf.length());
                            buf.append("insert into interfaceexamerequisicaodesm (fil_codigo, int_codigo, exa_codigo, mco_codigo,");
                            buf.append("req_codigo, rec_codigo, exa_kodigo, mco_kodigo, erd_situacao, rec_kodigo) values (");
                            buf.append(dados.codigoFilial);
                            buf.append(", ");
                            buf.append(dados.codigoInterface);
                            buf.append(", '");
                            buf.append(dados.exame);
                            buf.append("', ");
                            buf.append(dados.codigoMaterial);
                            buf.append(", ");
                            buf.append(dados.codigoRequisicaoTubo);
                            buf.append(", ");
                            buf.append(dados.tubo);
                            buf.append(", '");
                            buf.append(rs.getString("exa_kodigo"));
                            buf.append("', ");
                            buf.append(rs.getString("mco_kodigo"));
                            buf.append(", 0 ");
                            buf.append(",").append(codigoTuboFilho);
                            buf.append(")");
                            if (isColetaWeb) {
                                statement.execute(buf.toString());
                                continue;
                            }
                            Conexao.execute(dados.codigoFilial, statement, buf.toString());
                        }
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
                buf.delete(0, buf.length());
                buf.append("update examerequisicao set exr_interfaciado = true where fil_codigo = ");
                buf.append(dados.codigoFilial);
                buf.append(" and req_codigo = ");
                buf.append(dados.codigoRequisicaoTubo);
                buf.append(" and exa_codigo = '");
                buf.append(dados.exame);
                buf.append("' and mco_codigo = ");
                buf.append(dados.codigoMaterial);
                if (isColetaWeb) {
                    statement.execute(buf.toString());
                    continue;
                }
                Conexao.execute(dados.codigoFilial, statement, buf.toString());
            }
        }
    }

    public static void updateInterfaceExameRequisicao(String codigoFilial, String requisicao, String codigoExame, int codigoMaterial) {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        buf.append("update interfaceexamerequisicao set ");
        buf.append("ier_situacao = ").append(0);
        buf.append(", ier_xmlvalores = ''");
        buf.append(" where fil_codigo = ").append(codigoFilial);
        buf.append(" and req_codigo = ").append(requisicao);
        buf.append(" and exa_codigo = '").append(codigoExame).append("'");
        buf.append(" and mco_codigo = ").append(codigoMaterial);
        try {
            Conexao.executeUpdate(codigoFilial, st, buf.toString());
        }
        catch (SQLException e) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException e1) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "DigitacaoConferencia: 724");
            }
        }
    }

    private static int localizar(int posini, String setor, String tubo, String codinterface, ArrayList<TuboInterface> lista) {
        int retorno = -1;
        if (posini < lista.size() && lista.size() > 0) {
            for (int i = posini; i < lista.size(); ++i) {
                TuboInterface o = lista.get(i);
                if (!o.tubo.equals(tubo) || !o.codigoSetor.equals(setor) || !o.codigoInterface.equals(codinterface)) continue;
                retorno = i;
                break;
            }
        }
        return retorno;
    }

    private static void adicionaTubo(ArrayList<TuboInterface> lista, int pos, String tubo, String exame, String codigoMaterial, String codigoRequisicaoTubo, String codigoFilial, String codigoSetor, String codinterface, boolean curva) {
        TuboInterface s = lista.get(pos);
        if ((pos = ExportarInterface.localizar(pos + 1, codigoSetor, tubo, codinterface, lista)) < 0) {
            lista.add(new TuboInterface(tubo, exame, codigoMaterial, codigoRequisicaoTubo, codigoFilial, codigoSetor, codinterface, curva));
        } else {
            ExportarInterface.adicionaTubo(lista, pos, tubo, exame, codigoMaterial, codigoRequisicaoTubo, codigoFilial, codigoSetor, codinterface, curva);
        }
    }
}

