/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.remover;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.interfaceamento.ExportarInterface;
import jalis.relatorio.Gerador;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.impressao.termica.ImpressaoTermica;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;

public class ImprimirEtqTriagem {
    private static final int COLUNA_CODIGO = 0;
    private static final int COLUNA_EXAME = 1;
    private static final int COLUNA_CODIGO_MATERIAL = 2;
    private static final int COLUNA_DESCRICAO_MATERIAL = 3;
    private static final int COLUNA_ABREVIATURA = 4;
    private static final int COLUNA_QTDE = 5;
    private static final int COLUNA_VOLUME = 6;
    private static final int COLUNA_CAPACIDADE = 7;
    private static final int COLUNA_REQUISICAO_TUBO = 8;
    private static final int COLUNA_PACIENTE = 9;
    private static final int COLUNA_CODIGO_FILIAL = 10;
    private static final int COLUNA_NOME_FILIAL = 11;
    private static final int COLUNA_UNIDADE = 12;
    private static final int COLUNA_CODIGO_SETOR = 13;
    private static final int COLUNA_DESCRICAO_SETOR = 14;
    private static final int COLUNA_SIGLA_SETOR = 15;
    private static final int COLUNA_DATA_HORA_COLETA = 16;
    private static final int COLUNA_DESCRICAO_TUBO = 17;
    private static final int COLUNA_CODIGO_COLETA = 18;
    private static final int COLUNA_DESCRICAO_COLETA = 19;
    private static final int COLUNA_CODIGO_CONVENIO = 20;
    private static final int COLUNA_RAZAO_CONVENIO = 21;
    private static final int COLUNA_FANTASIA_CONVENIO = 22;
    private static final int COLUNA_DATAHORA_ATUAL = 23;
    private static final int COLUNA_PESO = 24;
    private static final int COLUNA_ALTURA = 25;
    private static final int COLUNA_IDADE = 26;
    private static final int COLUNA_JEJUM = 27;
    private static final int COLUNA_DIURESE = 28;
    private static final int COLUNA_TEMPO_DIURESE = 29;
    private static final int COLUNA_GESTANTE = 30;
    private static final int COLUNA_MATERIAL_INFORMADO = 31;
    private static final int COLUNA_URGENTE = 32;
    private static final int COLUNA_DATA_HORA_TRIAGEM = 33;
    private static String codigoConvenio;
    private static String codigoDestino;

    public static void imprimir(String filial, String requisicao, String usuario) throws SQLException {
        ImprimirEtqTriagem.imprimir(filial, requisicao, null, usuario, false);
    }

    public static void imprimir(String filial, String requisicao, String usuario, boolean reimprimir) throws SQLException {
        ImprimirEtqTriagem.imprimir(filial, requisicao, null, usuario, reimprimir);
    }

    public static void imprimir(String filial, String requisicao, String codigoExame, int codigoMaterial, String usuario) throws SQLException {
        ImprimirEtqTriagem.imprimir(filial, requisicao, new String[]{codigoExame, String.valueOf(codigoMaterial)}, usuario, true);
    }

    public static void imprimir(String filial, String requisicao, String codigoExame, int codigoMaterial, String usuario, boolean reimprimir) throws SQLException {
        ImprimirEtqTriagem.imprimir(filial, requisicao, new String[]{codigoExame, String.valueOf(codigoMaterial)}, usuario, reimprimir);
    }

    public static void imprimir(String filial, String requisicao, String[] exames, int[] materiais, String usuario, boolean reimprimir) throws SQLException {
        if ((exames == null || materiais == null) && exames.length != materiais.length) {
            return;
        }
        String[] temp = new String[exames.length + materiais.length];
        int count = 0;
        for (int i = 0; i < exames.length; ++i) {
            temp[count++] = exames[i];
            temp[count++] = String.valueOf(materiais[i]);
        }
        ImprimirEtqTriagem.imprimir(filial, requisicao, temp, usuario, reimprimir);
    }

    public static void imprimir(String filial, String requisicao, String[] exames, String usuario, boolean reimprimir) throws SQLException {
        ArrayList listaEtiquetas = ImprimirEtqTriagem.criaEtiqueta(filial, requisicao, exames, usuario, reimprimir);
        String[] campos = Impressao.CAMPOS_ETQ_TRIAGEM;
        ModeloGridTable modeloDados = new ModeloGridTable(campos);
        if (listaEtiquetas != null && listaEtiquetas.size() > 0) {
            int ultimaPosicao = 0;
            int linha = 0;
            for (int i = 0; i < listaEtiquetas.size(); ++i) {
                ultimaPosicao = 0;
                Object[] c = (Object[])listaEtiquetas.get(i);
                modeloDados.addLine(new Object[c.length]);
                linha = modeloDados.getRowCount() - 1;
                for (int j = 0; j < campos.length; ++j) {
                    if (campos[j].equals("codigoTubo")) {
                        modeloDados.setValueAt(c[0], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("codigosExames")) {
                        modeloDados.setValueAt(c[1], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("nomePaciente")) {
                        modeloDados.setValueAt(c[9], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("codigoMaterial")) {
                        modeloDados.setValueAt(c[2], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("descricaoMaterial")) {
                        modeloDados.setValueAt(c[3], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("abreviaturaMaterial")) {
                        modeloDados.setValueAt(c[4], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("codigoRequisicao")) {
                        modeloDados.setValueAt(c[8], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("codigoFilial")) {
                        modeloDados.setValueAt(c[10], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("descricaoFilial")) {
                        modeloDados.setValueAt(c[11], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("capacidadeRecipiente")) {
                        modeloDados.setValueAt(c[7], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("unidadeRecipiente")) {
                        modeloDados.setValueAt(c[12], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("codigoSetor")) {
                        modeloDados.setValueAt(c[13], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("descricaoSetor")) {
                        modeloDados.setValueAt(c[14], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("siglaSetor")) {
                        modeloDados.setValueAt(c[15], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("dataHoraColeta")) {
                        modeloDados.setValueAt(c[16], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("descricaoRecipiente")) {
                        modeloDados.setValueAt(c[17], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("codigoColeta")) {
                        modeloDados.setValueAt(c[18], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("descricaoColeta")) {
                        modeloDados.setValueAt(c[19], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("codigoConvenio")) {
                        modeloDados.setValueAt(c[20], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("razaoConvenio")) {
                        modeloDados.setValueAt(c[21], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("fantasiaConvenio")) {
                        modeloDados.setValueAt(c[22], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("dataHoraAtual")) {
                        modeloDados.setValueAt(c[23], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("pesoPaciente")) {
                        modeloDados.setValueAt(c[24], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("alturaPaciente")) {
                        modeloDados.setValueAt(c[25], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("idadePaciente")) {
                        modeloDados.setValueAt(c[26], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("gestantePaciente")) {
                        modeloDados.setValueAt(c[30], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("descricaoMaterialInformado")) {
                        modeloDados.setValueAt(c[31], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("tempoJejumExame")) {
                        modeloDados.setValueAt(c[27], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("volumeDiureseExame")) {
                        modeloDados.setValueAt(c[28], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("tempoDiureseExame")) {
                        modeloDados.setValueAt(c[29], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("urgenteRequisicao")) {
                        modeloDados.setValueAt(c[32], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("dataHoraTriagem")) {
                        modeloDados.setValueAt(c[33], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("volumeUtilizadoRecipiente")) {
                        modeloDados.setValueAt(c[6], linha, ultimaPosicao++);
                        continue;
                    }
                    modeloDados.setValueAt("", linha, ultimaPosicao++);
                }
            }
            String codigoLayout = ExameUtil.getCodigoLayout(filial, codigoConvenio, codigoDestino);
            StringBuffer buf = new StringBuffer("");
            Statement st = Conexao.getStatement();
            buf.delete(0, buf.length());
            buf.append("select lay_etqtri, lay_tipoetqtri from layout where fil_codigo = ");
            buf.append(filial);
            buf.append(" and lay_codigo = ");
            buf.append(codigoLayout);
            ResultSet rsLayout = Conexao.executeQuery(st, buf.toString());
            if (rsLayout.next() && !Funcoes.textoVazio(rsLayout.getString("lay_etqtri"))) {
                String tipo = rsLayout.getString("lay_tipoetqtri");
                if (tipo.equalsIgnoreCase("C")) {
                    Gerador gerador = new Gerador(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                    gerador.setImpressora(Impressao.comparaNomeImpressoraReduzido(ParametrosLocais.getParametro("impressoraEtqTriagem")));
                    gerador.executar(rsLayout.getString("lay_etqtri"), modeloDados);
                } else if (tipo.equalsIgnoreCase("T")) {
                    ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(ParametrosLocais.getParametro("impressoraEtqTriagem")), false);
                    termica.setDados(modeloDados);
                    termica.imprimir(rsLayout.getString("lay_etqtri"));
                }
                if (ParametrosGerais.getExportarInterface() == 2) {
                    ExportarInterface.criaInterface(filial, requisicao, "etiquetatriagem");
                }
            } else {
                Funcoes.mensagem(null, "Modelo n\u00e3o localizado ou n\u00e3o definido", 1);
            }
            rsLayout.close();
            st.close();
        }
    }

    private static ArrayList criaEtiqueta(String filial, String requisicao, String[] exames, String usuario, boolean reimprimir) throws SQLException {
        Statement statement = Conexao.getStatement();
        Statement stSalvar = Conexao.getStatement();
        StringBuffer buf = new StringBuffer("select a.exa_codigo, c.rec_capacidade, b.rec_codigo, b.rtr_qtde, b.rtr_volume, ");
        buf.append("d.mco_abreviatura, d.mco_codigo, d.mco_descricao, a.req_codigo, f.pac_nome, c.rec_capacidade, c.unm_codigo, ");
        buf.append("s.set_codigo, s.set_descricao, s.set_sigla, a.fil_codigo, filial.fil_descricao, e.con_codigo, e.des_codigo, ");
        buf.append("a.exr_datamaterial, a.exr_datatriagem, c.rec_descricao, coletas.col_codigo, coletas.col_descricao, ");
        buf.append("con.con_codigo, con.con_razao, con.con_fantasia, ");
        buf.append("current_timestamp as dataHoraAtual, e.req_urgente, ");
        buf.append("e.req_peso, e.req_altura, e.req_idade, e.req_anomes, ");
        buf.append("a.exr_tempojejum, a.exr_volumediurese, a.exr_tempodiurese, ");
        buf.append("e.req_gestante, a.exr_descricaomaterial ");
        buf.append("from examerequisicao a ");
        buf.append("left join requisicao e on a.fil_codigo = e.fil_codigo and a.req_codigo = e.req_codigo ");
        buf.append("left join paciente f on e.fil_codigo = f.fil_codigo and e.pac_codigo = f.pac_codigo ");
        buf.append("left join reciptriagem b on a.fil_codigo = b.fil_codigo and upper(a.exa_codigo) = upper(b.exa_codigo) and a.mco_codigo = b.mco_codigo ");
        buf.append("join recipientes c on b.fil_codigo = c.fil_codigo and b.rec_codigo = c.rec_codigo ");
        buf.append("left join materialcoleta d on a.fil_codigo = d.fil_codigo and a.mco_codigo = d.mco_codigo ");
        buf.append("left join examesetor es on a.fil_codigo = es.fil_codigo and upper(a.exa_codigo) = upper(es.exa_codigo) ");
        buf.append("left join setores s on es.fil_codigo = s.fil_codigo and es.set_codigo = s.set_codigo ");
        buf.append("left join coletas on e.fil_codigo = coletas.fil_codigo and e.col_codigo = coletas.col_codigo ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo ");
        buf.append("left join convenios con on e.fil_codigo = con.fil_codigo and e.con_codigo = con.con_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and a.req_codigo = ");
        buf.append(requisicao);
        if (exames != null && exames.length > 0) {
            buf.append(" and (");
            for (int i = 0; i < exames.length; i += 2) {
                buf.append("(a.exa_codigo = '");
                buf.append(exames[i]);
                buf.append("' and a.mco_codigo = ");
                buf.append(exames[i + 1]);
                buf.append(") ");
                if (i + 1 >= exames.length - 1) continue;
                buf.append(" or ");
            }
            buf.append(") ");
        }
        buf.append(" and (a.exr_situacao is null or a.exr_situacao = '' or a.exr_situacao = '");
        buf.append("T");
        if (ParametrosLocais.getParametro("imprimirEtiquetaTriagemSemMaterial") != null && ParametrosLocais.getParametro("imprimirEtiquetaTriagemSemMaterial").equals("1")) {
            buf.append("' or a.exr_situacao = '").append("F");
            buf.append("' or a.exr_situacao = '").append("R");
        }
        buf.append("') and ");
        if (!reimprimir) {
            buf.append(" a.exr_dataetqtriagem is null and ");
        }
        buf.append(" es.ese_printetqtriagem = true ");
        buf.append(" order by s.set_codigo, b.rec_codigo, a.mco_codigo, b.rtr_qtde, a.exa_codigo");
        ResultSet rsTriagem = Conexao.executeQuery(statement, buf.toString());
        ArrayList<Object[]> lista = new ArrayList<Object[]>();
        while (rsTriagem.next()) {
            codigoConvenio = rsTriagem.getString("con_codigo");
            codigoDestino = rsTriagem.getString("des_codigo");
            StringBuilder bui = new StringBuilder("update examerequisicao set exr_dataetqtriagem = current_timestamp, usr_codetqtriagem = '");
            bui.append(usuario);
            bui.append("' where fil_codigo = ");
            bui.append(filial);
            bui.append(" and req_codigo = ");
            bui.append(rsTriagem.getString("req_codigo"));
            bui.append(" and exa_codigo = '");
            bui.append(rsTriagem.getString("exa_codigo"));
            bui.append("' and mco_codigo = ");
            bui.append(rsTriagem.getString("mco_codigo"));
            Conexao.execute(filial, stSalvar, bui.toString());
            int qtde = DBUtil.campoNull(rsTriagem.getString("rtr_qtde")) ? 1 : rsTriagem.getInt("rtr_qtde");
            int pos = -1;
            for (int i = 0; i < qtde; ++i) {
                pos = ImprimirEtqTriagem.localizar(0, rsTriagem.getString("set_codigo"), rsTriagem.getString("rec_codigo"), lista);
                if (qtde > 1 && i > 0) {
                    pos = -1;
                }
                String codigoTubo = Funcoes.preencheZero(filial, ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(rsTriagem.getString("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao()) + Funcoes.preencheZero(DBUtil.campoNull(rsTriagem.getString("rec_codigo")) ? "0" : rsTriagem.getString("rec_codigo"), ParametrosGerais.getDigitosTuboTubo());
                if (pos > -1) {
                    ImprimirEtqTriagem.adicionaTubo(lista, pos, rsTriagem.getString("rec_codigo"), rsTriagem.getString("exa_codigo"), rsTriagem.getString("mco_codigo"), rsTriagem.getString("mco_descricao"), rsTriagem.getString("mco_abreviatura"), String.valueOf(qtde), rsTriagem.getString("rtr_volume"), rsTriagem.getString("rec_capacidade"), codigoTubo, rsTriagem.getString("pac_nome"), rsTriagem.getString("fil_codigo"), rsTriagem.getString("fil_descricao"), rsTriagem.getString("unm_codigo"), rsTriagem.getString("set_codigo"), rsTriagem.getString("set_descricao"), rsTriagem.getString("set_sigla"), rsTriagem.getTimestamp("exr_datamaterial"), rsTriagem.getString("rec_descricao"), rsTriagem.getString("col_codigo"), rsTriagem.getString("col_descricao"), rsTriagem.getString("con_codigo"), rsTriagem.getString("con_razao"), rsTriagem.getString("con_fantasia"), rsTriagem.getTimestamp("dataHoraAtual"), rsTriagem.getDouble("req_peso"), rsTriagem.getDouble("req_altura"), rsTriagem.getString("req_idade") + " " + Tipos.tipoIdade(rsTriagem.getString("req_anomes")), rsTriagem.getString("exr_tempojejum"), rsTriagem.getDouble("exr_volumediurese"), rsTriagem.getString("exr_tempodiurese"), rsTriagem.getBoolean("req_gestante"), rsTriagem.getString("exr_descricaomaterial"), rsTriagem.getBoolean("req_urgente"), rsTriagem.getTimestamp("exr_datatriagem"));
                    continue;
                }
                lista.add(new Object[]{rsTriagem.getString("rec_codigo"), rsTriagem.getString("exa_codigo"), rsTriagem.getString("mco_codigo"), rsTriagem.getString("mco_descricao"), rsTriagem.getString("mco_abreviatura"), String.valueOf(qtde), rsTriagem.getString("rtr_volume"), rsTriagem.getString("rec_capacidade"), codigoTubo, rsTriagem.getString("pac_nome"), rsTriagem.getString("fil_codigo"), rsTriagem.getString("fil_descricao"), rsTriagem.getString("unm_codigo"), rsTriagem.getString("set_codigo"), rsTriagem.getString("set_descricao"), rsTriagem.getString("set_sigla"), rsTriagem.getTimestamp("exr_datamaterial"), rsTriagem.getString("rec_descricao"), rsTriagem.getString("col_codigo"), rsTriagem.getString("col_descricao"), rsTriagem.getString("con_codigo"), rsTriagem.getString("con_razao"), rsTriagem.getString("con_fantasia"), rsTriagem.getTimestamp("dataHoraAtual"), rsTriagem.getDouble("req_peso"), rsTriagem.getDouble("req_altura"), rsTriagem.getString("req_idade") + " " + Tipos.tipoIdade(rsTriagem.getString("req_anomes")), rsTriagem.getString("exr_tempojejum"), rsTriagem.getDouble("exr_volumediurese"), rsTriagem.getString("exr_tempodiurese"), rsTriagem.getBoolean("req_gestante"), rsTriagem.getString("exr_descricaoMaterial"), rsTriagem.getBoolean("req_urgente"), rsTriagem.getTimestamp("exr_datatriagem")});
            }
        }
        return lista;
    }

    private static int localizar(int posini, String setor, String tubo, ArrayList lista) {
        int retorno = -1;
        if (posini < lista.size() && lista.size() > 0) {
            for (int i = posini; i < lista.size(); ++i) {
                Object[] o = (Object[])lista.get(i);
                if (!(o[0] instanceof String) || !o[0].equals(tubo) || !o[13].equals(setor)) continue;
                retorno = i;
                break;
            }
        }
        return retorno;
    }

    private static ArrayList adicionaTubo(ArrayList lista, int pos, String tubo, String exame, String codigoMaterial, String descricaoMaterial, String abrv, String qtde, String volume, String capacidade, String codigoRequisicaoTubo, String nomePaciente, String codigoFilial, String descricaoFilial, String unidadeRecipiente, String codigoSetor, String descricaoSetor, String siglaSetor, Timestamp dataHora, String descricaoTubo, String codigoColeta, String descricaoColeta, String codigoConvenio, String razaoConvenio, String fantasiaConvenio, Timestamp dataHoraAtual, Double peso, Double altura, String idade, String jejum, double diurese, String tempoDiurese, boolean gestante, String descricaoMaterialInformado, boolean urgente, Timestamp dataHoraTriagem) {
        Object[] s = (Object[])lista.get(pos);
        double capacity = 0.0;
        double volumeUtilizado = 0.0;
        double novoVolume = 0.0;
        if (Funcoes.isNumeric(s[7].toString())) {
            capacity = Double.parseDouble(Funcoes.limpaDecimal(s[7].toString()));
        }
        if (Funcoes.isNumeric(s[6].toString())) {
            volumeUtilizado = Double.parseDouble(Funcoes.limpaDecimal(s[6].toString()));
        }
        if (Funcoes.isNumeric(volume)) {
            novoVolume = Double.parseDouble(volume);
        }
        if (capacity == 0.0 || capacity > 0.0 && capacity - volumeUtilizado >= novoVolume) {
            s[6] = String.valueOf(volumeUtilizado + novoVolume);
            StringBuilder tmp = new StringBuilder(s[1].toString());
            tmp.append(" ");
            tmp.append(Funcoes.preencheVazio(exame, 5, 2));
            s[1] = tmp.toString();
        } else if ((pos = ImprimirEtqTriagem.localizar(pos + 1, codigoSetor, tubo, lista)) < 0) {
            lista.add(new Object[]{tubo, Funcoes.preencheVazio(exame, 5, 2), codigoMaterial, descricaoMaterial, abrv, qtde, volume, capacidade, codigoRequisicaoTubo, nomePaciente, codigoFilial, descricaoFilial, unidadeRecipiente, codigoSetor, descricaoSetor, siglaSetor, dataHora, descricaoTubo, codigoColeta, descricaoColeta, codigoConvenio, razaoConvenio, fantasiaConvenio, dataHoraAtual, peso, altura, idade, jejum, diurese, tempoDiurese, gestante, descricaoMaterialInformado, urgente, dataHoraTriagem});
        } else {
            lista = ImprimirEtqTriagem.adicionaTubo(lista, pos, tubo, exame, codigoMaterial, descricaoMaterial, abrv, qtde, volume, capacidade, codigoRequisicaoTubo, nomePaciente, codigoFilial, descricaoFilial, unidadeRecipiente, codigoSetor, descricaoSetor, siglaSetor, dataHora, descricaoTubo, codigoColeta, descricaoColeta, codigoConvenio, razaoConvenio, fantasiaConvenio, dataHoraAtual, peso, altura, idade, jejum, diurese, tempoDiurese, gestante, descricaoMaterialInformado, urgente, dataHoraTriagem);
        }
        return lista;
    }
}

