/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.remover;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.interfaceamento.ExportarInterface;
import jalis.relatorio.Gerador;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.impressao.termica.ImpressaoTermica;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;

public class ImprimirEtqColeta {
    private static final int COLUNA_CODIGO = 0;
    private static final int COLUNA_EXAME = 1;
    private static final int COLUNA_CODIGO_MATERIAL = 2;
    private static final int COLUNA_DESCRICAO_MATERIAL = 3;
    private static final int COLUNA_ABREVIATURA = 4;
    private static final int COLUNA_QTDE = 5;
    private static final int COLUNA_VOLUME = 6;
    private static final int COLUNA_CAPACIDADE = 7;
    private static final int COLUNA_REQUISICAO_TUBO = 8;
    private static final int COLUNA_PACIENTE = 9;
    private static final int COLUNA_CODIGO_FILIAL = 10;
    private static final int COLUNA_NOME_FILIAL = 11;
    private static final int COLUNA_UNIDADE = 12;
    private static final int COLUNA_CODIGO_SETOR = 13;
    private static final int COLUNA_DESCRICAO_SETOR = 14;
    private static final int COLUNA_SIGLA_SETOR = 15;
    private static final int COLUNA_DATA_HORA = 16;
    private static final int COLUNA_DESCRICAO_TUBO = 17;
    private static final int COLUNA_CODIGO_COLETA = 18;
    private static final int COLUNA_DESCRICAO_COLETA = 19;
    private static final int COLUNA_CODIGO_CONVENIO = 20;
    private static final int COLUNA_RAZAO_CONVENIO = 21;
    private static final int COLUNA_FANTASIA_CONVENIO = 22;
    private static final int COLUNA_DATAHORA_ATUAL = 23;
    private static final int COLUNA_PESO = 24;
    private static final int COLUNA_ALTURA = 25;
    private static final int COLUNA_IDADE = 26;
    private static final int COLUNA_JEJUM = 27;
    private static final int COLUNA_DIURESE = 28;
    private static final int COLUNA_TEMPO_DIURESE = 29;
    private static final int COLUNA_GESTANTE = 30;
    private static final int COLUNA_MATERIAL_INFORMADO = 31;
    private static final int COLUNA_URGENTE = 32;
    private static final int COLUNA_PAC_CODIGO = 33;
    private static String codigoConvenio;
    private static String codigoDestino;

    public static void imprimir(String filial, String requisicao, boolean reimprimir) throws SQLException {
        ImprimirEtqColeta.imprimir(filial, requisicao, null, null, reimprimir);
    }

    public static void imprimir(String filial, String requisicao) throws SQLException {
        ImprimirEtqColeta.imprimir(filial, requisicao, null, null, true);
    }

    private static ModeloGridTable geraModeloDados(String filial, String requisicao, String[] exames, int[] materiais, boolean reimprimir, String[] campos, String situacaoAdicional, Statement st1, Statement st2) throws SQLException {
        ArrayList listaEtiquetas = null;
        listaEtiquetas = ImprimirEtqColeta.criaEtiqueta(filial, requisicao, exames, materiais, reimprimir, situacaoAdicional, st1, st2);
        ModeloGridTable modeloDados = new ModeloGridTable(campos);
        if (listaEtiquetas != null && listaEtiquetas.size() > 0) {
            int ultimaPosicao = 0;
            int linha = 0;
            for (int i = 0; i < listaEtiquetas.size(); ++i) {
                ultimaPosicao = 0;
                Object[] c = (Object[])listaEtiquetas.get(i);
                modeloDados.addLine(new Object[c.length]);
                linha = modeloDados.getRowCount() - 1;
                for (int j = 0; j < campos.length; ++j) {
                    if (campos[j].equals("codigoTubo")) {
                        modeloDados.setValueAt(c[0], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("codigosExames")) {
                        modeloDados.setValueAt(c[1], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("nomePaciente")) {
                        modeloDados.setValueAt(c[9], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("codigoMaterial")) {
                        modeloDados.setValueAt(c[2], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("descricaoMaterial")) {
                        modeloDados.setValueAt(c[3], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("abreviaturaMaterial")) {
                        modeloDados.setValueAt(c[4], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("codigoRequisicao")) {
                        modeloDados.setValueAt(c[8], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("codigoFilial")) {
                        modeloDados.setValueAt(c[10], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("descricaoFilial")) {
                        modeloDados.setValueAt(c[11], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("capacidadeRecipiente")) {
                        modeloDados.setValueAt(c[7], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("unidadeRecipiente")) {
                        modeloDados.setValueAt(c[12], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("codigoSetor")) {
                        modeloDados.setValueAt(c[13], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("descricaoSetor")) {
                        modeloDados.setValueAt(c[14], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("siglaSetor")) {
                        modeloDados.setValueAt(c[15], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("descricaoRecipiente")) {
                        modeloDados.setValueAt(c[17], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("dataHoraColeta")) {
                        modeloDados.setValueAt(c[16], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("codigoColeta")) {
                        modeloDados.setValueAt(c[18], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("descricaoColeta")) {
                        modeloDados.setValueAt(c[19], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("codigoConvenio")) {
                        modeloDados.setValueAt(c[20], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("razaoConvenio")) {
                        modeloDados.setValueAt(c[21], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equals("fantasiaConvenio")) {
                        modeloDados.setValueAt(c[22], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("dataHoraAtual")) {
                        modeloDados.setValueAt(c[23], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("pesoPaciente")) {
                        modeloDados.setValueAt(c[24], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("alturaPaciente")) {
                        modeloDados.setValueAt(c[25], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("idadePaciente")) {
                        modeloDados.setValueAt(c[26], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("gestantePaciente")) {
                        modeloDados.setValueAt(c[30], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("descricaoMaterialInformado")) {
                        modeloDados.setValueAt(c[31], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("tempoJejumExame")) {
                        modeloDados.setValueAt(c[27], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("volumeDiureseExame")) {
                        modeloDados.setValueAt(c[28], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("tempoDiureseExame")) {
                        modeloDados.setValueAt(c[29], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("urgenteRequisicao")) {
                        modeloDados.setValueAt(c[32], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("volumeUtilizadoRecipiente")) {
                        modeloDados.setValueAt(c[6], linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("codigoPaciente")) {
                        modeloDados.setValueAt(c[33], linha, ultimaPosicao++);
                        continue;
                    }
                    modeloDados.setValueAt("", linha, ultimaPosicao++);
                }
            }
        }
        return modeloDados;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void imprimir(String filial, String requisicao, String[] exames, int[] materiais, boolean reimprimir) throws SQLException {
        ModeloGridTable modeloDados = ImprimirEtqColeta.geraModeloDados(filial, requisicao, exames, materiais, reimprimir, Impressao.CAMPOS_ETQ_COLETA, "", Conexao.getStatement(), Conexao.getStatement());
        if (modeloDados.getRowCount() > 0) {
            String codigoLayout = ExameUtil.getCodigoLayout(filial, codigoConvenio, codigoDestino);
            StringBuffer buf = new StringBuffer("");
            Statement st = Conexao.getStatement();
            buf.delete(0, buf.length());
            buf.append("select lay_etqcol, lay_tipoetqcol from layout where fil_codigo = ");
            buf.append(filial);
            buf.append(" and lay_codigo = ");
            buf.append(codigoLayout);
            try (ResultSet rsLayout = null;){
                rsLayout = st.executeQuery(buf.toString());
                if (rsLayout.next() && !Funcoes.textoVazio(rsLayout.getString("lay_etqcol"))) {
                    String tipo = rsLayout.getString("lay_tipoetqcol");
                    if (tipo.equalsIgnoreCase("C")) {
                        Gerador gerador = new Gerador(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        gerador.setImpressora(Impressao.comparaNomeImpressoraReduzido(ParametrosLocais.getParametro("impressoraEtqColeta")));
                        gerador.executar(rsLayout.getString("lay_etqcol"), modeloDados);
                    } else if (tipo.equalsIgnoreCase("T")) {
                        ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(ParametrosLocais.getParametro("impressoraEtqColeta")), false);
                        termica.setDados(modeloDados);
                        termica.imprimir(rsLayout.getString("lay_etqcol"));
                    }
                    if (ParametrosGerais.getExportarInterface() == 1) {
                        ExportarInterface.criaInterface(filial, requisicao, "etiquetacoleta");
                    }
                } else {
                    Funcoes.mensagem(null, "Modelo n\u00e3o localizado ou n\u00e3o definido", 1);
                }
            }
            st.close();
        }
    }

    public static String getEtiquetasTermica(String filial, String requisicao) throws Exception {
        return ImprimirEtqColeta.getEtiquetasTermica(filial, requisicao, null, null, false);
    }

    public static String getEtiquetasTermicaApoio(String filial, String requisicao, boolean reimprimir) throws Exception {
        return ImprimirEtqColeta.getEtiquetasTermica(filial, requisicao, null, null, "lay_tipoetqapoio", "lay_etqapoio", reimprimir, Impressao.CAMPOS_ETQ_APOIO, "F");
    }

    public static String getEtiquetasTermicaApoio(String filial, String requisicao) throws Exception {
        return ImprimirEtqColeta.getEtiquetasTermica(filial, requisicao, null, null, "lay_tipoetqapoio", "lay_etqapoio", true, Impressao.CAMPOS_ETQ_APOIO, "F");
    }

    public static String getEtiquetasTermicaApoio(String filial, String requisicao, Statement st1, Statement st2) throws Exception {
        return ImprimirEtqColeta.getEtiquetasTermica(filial, requisicao, null, null, "lay_tipoetqapoio", "lay_etqapoio", true, Impressao.CAMPOS_ETQ_APOIO, "F", st1, st2);
    }

    public static String getEtiquetasTermica(String filial, String requisicao, String[] exames, int[] materiais, boolean reimprimir) throws Exception {
        return ImprimirEtqColeta.getEtiquetasTermica(filial, requisicao, exames, materiais, "lay_tipoetqcol", "lay_etqcol", reimprimir, Impressao.CAMPOS_ETQ_COLETA, "");
    }

    public static String getEtiquetasTermica(String filial, String requisicao, String[] exames, int[] materiais, String campoTipo, String campoLayout, boolean reimprimir, String[] campos, String situacaoAdicional) throws Exception {
        return ImprimirEtqColeta.getEtiquetasTermica(filial, requisicao, exames, materiais, campoTipo, campoLayout, reimprimir, campos, situacaoAdicional, Conexao.getStatement(), Conexao.getStatement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getEtiquetasTermica(String filial, String requisicao, String[] exames, int[] materiais, String campoTipo, String campoLayout, boolean reimprimir, String[] campos, String situacaoAdicional, Statement st1, Statement st2) throws Exception {
        String etiquetas = "";
        ModeloGridTable modeloDados = ImprimirEtqColeta.geraModeloDados(filial, requisicao, exames, materiais, reimprimir, campos, situacaoAdicional, st1, st2);
        if (modeloDados.getRowCount() > 0) {
            String codigoLayout = ExameUtil.getCodigoLayout(filial, codigoConvenio, codigoDestino, st1);
            StringBuffer buf = new StringBuffer("");
            buf.delete(0, buf.length());
            buf.append("select ");
            buf.append(campoTipo);
            buf.append(", ");
            buf.append(campoLayout);
            buf.append(" from layout where fil_codigo = ");
            buf.append(filial);
            buf.append(" and lay_codigo = ");
            buf.append(codigoLayout);
            try (ResultSet rsLayout = null;){
                rsLayout = st1.executeQuery(buf.toString());
                if (rsLayout.next() && !Funcoes.textoVazio(rsLayout.getString(campoLayout))) {
                    String tipo = rsLayout.getString(campoTipo);
                    if (tipo.equalsIgnoreCase("T")) {
                        ImpressaoTermica termica = new ImpressaoTermica();
                        termica.setDados(modeloDados);
                        etiquetas = termica.gerarEtiquetas(rsLayout.getString(campoLayout));
                    }
                    if (ParametrosGerais.getExportarInterface() == 1) {
                        ExportarInterface.criaInterface(filial, requisicao, "etiquetacoleta", st1, st2);
                    }
                }
            }
        }
        return etiquetas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList criaEtiqueta(String filial, String requisicao, String[] exames, int[] materiais, boolean reimprimir, String situacaoAdicional, Statement statement, Statement stInserir) throws SQLException {
        StringBuffer buf = new StringBuffer("select a.exa_codigo, c.rec_capacidade, b.rec_codigo, b.rco_qtde, b.rco_volume, ");
        buf.append("d.mco_abreviatura, d.mco_codigo, d.mco_descricao, a.req_codigo, f.pac_nome, c.rec_capacidade, c.unm_codigo, ");
        buf.append("s.set_codigo, s.set_descricao, s.set_sigla, a.fil_codigo, filial.fil_descricao, e.con_codigo, e.des_codigo, ");
        buf.append("a.exr_datamaterial, c.rec_descricao, coletas.col_codigo, coletas.col_descricao, ");
        buf.append("con.con_codigo, con.con_razao, con.con_fantasia, ");
        buf.append("current_timestamp as dataHoraAtual, e.req_urgente, ");
        buf.append("e.req_peso, e.req_altura, e.req_idade, e.req_anomes, ");
        buf.append("a.exr_tempojejum, a.exr_volumediurese, a.exr_tempodiurese, ");
        buf.append("e.req_gestante, a.exr_descricaomaterial, f.pac_codigo, COALESCE(a.exr_codigoapoiado, '') as exr_codigoapoiado ");
        buf.append("from examerequisicao a ");
        buf.append("left join requisicao e on a.fil_codigo = e.fil_codigo and a.req_codigo = e.req_codigo ");
        buf.append("left join paciente f on e.fil_codigo = f.fil_codigo and e.pac_codigo = f.pac_codigo ");
        buf.append("left join recipcoleta b on a.fil_codigo = b.fil_codigo and upper(a.exa_codigo) = upper(b.exa_codigo) and a.mco_codigo = b.mco_codigo ");
        buf.append("join recipientes c on b.fil_codigo = c.fil_codigo and b.rec_codigo = c.rec_codigo ");
        buf.append("left join materialcoleta d on a.fil_codigo = d.fil_codigo and a.mco_codigo = d.mco_codigo ");
        buf.append("left join examesetor es on a.fil_codigo = es.fil_codigo and upper(a.exa_codigo) = upper(es.exa_codigo) ");
        buf.append("left join setores s on es.fil_codigo = s.fil_codigo and es.set_codigo = s.set_codigo ");
        buf.append("left join coletas on e.fil_codigo = coletas.fil_codigo and e.col_codigo = coletas.col_codigo ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo ");
        buf.append("left join convenios con on e.fil_codigo = con.fil_codigo and e.con_codigo = con.con_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and a.req_codigo = ");
        buf.append(requisicao);
        buf.append(" and (a.exr_situacao = '' or a.exr_situacao is null or a.exr_situacao = '");
        buf.append("T");
        if (!Funcoes.textoVazio(situacaoAdicional)) {
            buf.append("' or a.exr_situacao = '");
            buf.append(situacaoAdicional);
        }
        if (ParametrosLocais.getParametro("imprimirEtiquetaColetaSemMaterial") != null && ParametrosLocais.getParametro("imprimirEtiquetaColetaSemMaterial").equals("1")) {
            buf.append("' or a.exr_situacao = '").append("F");
            buf.append("' or a.exr_situacao = '").append("R");
        }
        buf.append("')");
        if (exames != null && exames.length > 0 && exames.length == materiais.length) {
            buf.append(" and ( ");
            for (int i = 0; i < exames.length; ++i) {
                buf.append("(a.exa_codigo = '");
                buf.append(exames[i]);
                buf.append("' and a.mco_codigo = ");
                buf.append(materiais[i]);
                buf.append(") ");
                if (i >= exames.length - 1) continue;
                buf.append(" or ");
            }
            buf.append(") ");
        }
        if (!reimprimir) {
            buf.append(" and a.exr_dataetqcoleta is null ");
        }
        buf.append(" and es.ese_printetqcoleta = true ");
        buf.append(" order by s.set_codigo, b.rec_codigo, a.mco_codigo, b.rco_qtde, a.exa_codigo");
        ArrayList<Object[]> lista = new ArrayList<Object[]>();
        try (ResultSet rsColeta = null;){
            rsColeta = statement.executeQuery(buf.toString());
            while (rsColeta.next()) {
                codigoConvenio = rsColeta.getString("con_codigo");
                codigoDestino = rsColeta.getString("des_codigo");
                int qtde = DBUtil.campoNull(rsColeta.getString("rco_qtde")) ? 1 : rsColeta.getInt("rco_qtde");
                int pos = -1;
                for (int i = 0; i < qtde; ++i) {
                    pos = ImprimirEtqColeta.localizar(0, rsColeta.getString("set_codigo"), rsColeta.getString("rec_codigo"), lista);
                    if (qtde > 1 && i > 0) {
                        pos = -1;
                    }
                    StringBuilder bui = new StringBuilder();
                    bui.append("update examerequisicao set exr_dataetqcoleta = current_timestamp, usr_codetqcoleta = '");
                    bui.append(Variaveis.login);
                    bui.append("' where fil_codigo = ");
                    bui.append(filial);
                    bui.append(" and exa_codigo = '");
                    bui.append(rsColeta.getString("exa_codigo"));
                    bui.append("' and mco_codigo =  ");
                    bui.append(rsColeta.getString("mco_codigo"));
                    bui.append(" and req_codigo = ");
                    bui.append(rsColeta.getString("req_codigo"));
                    Conexao.executeUpdate(filial, stInserir, bui.toString());
                    String codigoTubo = Funcoes.preencheZero(filial, ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(rsColeta.getString("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao()) + Funcoes.preencheZero(DBUtil.campoNull(rsColeta.getString("rec_codigo")) ? "0" : rsColeta.getString("rec_codigo"), ParametrosGerais.getDigitosTuboTubo());
                    bui = new StringBuilder("select count(req_codigo) as contagem from examerequisicaorecipiente ");
                    bui.append("where fil_codigo = ");
                    bui.append(filial);
                    bui.append(" and exa_codigo = '");
                    bui.append(rsColeta.getString("exa_codigo"));
                    bui.append("' and mco_codigo =  ");
                    bui.append(rsColeta.getString("mco_codigo"));
                    bui.append(" and req_codigo = ");
                    bui.append(rsColeta.getString("req_codigo"));
                    bui.append(" and rec_codigo = ");
                    bui.append(rsColeta.getString("rec_codigo"));
                    try (ResultSet result = null;){
                        result = stInserir.executeQuery(bui.toString());
                        if (result.next()) {
                            if (result.getInt("contagem") <= 0) {
                                bui.delete(0, bui.length());
                                bui.append("insert into examerequisicaorecipiente(fil_codigo, exa_codigo,");
                                bui.append("mco_codigo, req_codigo, rec_codigo, ere_codigoapoiado) values (");
                                bui.append(filial);
                                bui.append(", '");
                                bui.append(rsColeta.getString("exa_codigo"));
                                bui.append("', ");
                                bui.append(rsColeta.getString("mco_codigo"));
                                bui.append(", ");
                                bui.append(rsColeta.getString("req_codigo"));
                                bui.append(", ");
                                bui.append(rsColeta.getString("rec_codigo"));
                                bui.append(", '");
                                bui.append(codigoTubo).append("' ");
                                bui.append(")");
                                Conexao.execute(filial, stInserir, bui.toString());
                            } else {
                                bui.delete(0, bui.length());
                                bui.append("update examerequisicaorecipiente set ere_codigoapoiado = '").append(codigoTubo).append("' ");
                                bui.append("  where ");
                                bui.append("    fil_codigo = ").append(filial);
                                bui.append("    and exa_codigo = '").append(rsColeta.getString("exa_codigo")).append("' ");
                                bui.append("    and mco_codigo = ").append(rsColeta.getString("mco_codigo"));
                                bui.append("    and req_codigo = ").append(rsColeta.getString("req_codigo"));
                                bui.append("    and rec_codigo = ").append(rsColeta.getString("rec_codigo"));
                                Conexao.execute(filial, stInserir, bui.toString());
                            }
                        }
                        if (pos > -1) {
                            ImprimirEtqColeta.adicionaTubo(lista, pos, rsColeta.getString("rec_codigo"), rsColeta.getString("exa_codigo"), rsColeta.getString("mco_codigo"), rsColeta.getString("mco_descricao"), rsColeta.getString("mco_abreviatura"), String.valueOf(qtde), rsColeta.getString("rco_volume"), rsColeta.getString("rec_capacidade"), codigoTubo, rsColeta.getString("pac_nome"), rsColeta.getString("fil_codigo"), rsColeta.getString("fil_descricao"), rsColeta.getString("unm_codigo"), rsColeta.getString("set_codigo"), rsColeta.getString("set_descricao"), rsColeta.getString("set_sigla"), rsColeta.getTimestamp("exr_datamaterial"), rsColeta.getString("rec_descricao"), rsColeta.getString("col_codigo"), rsColeta.getString("col_descricao"), rsColeta.getString("con_codigo"), rsColeta.getString("con_razao"), rsColeta.getString("con_fantasia"), rsColeta.getTimestamp("dataHoraAtual"), rsColeta.getDouble("req_peso"), rsColeta.getDouble("req_altura"), rsColeta.getString("req_idade") + " " + Tipos.tipoIdade(rsColeta.getString("req_anomes")), rsColeta.getString("exr_tempojejum"), rsColeta.getDouble("exr_volumediurese"), rsColeta.getString("exr_tempodiurese"), rsColeta.getBoolean("req_gestante"), rsColeta.getString("exr_descricaomaterial"), rsColeta.getBoolean("req_urgente"), rsColeta.getString("codigoPaciente"));
                            continue;
                        }
                        lista.add(new Object[]{rsColeta.getString("rec_codigo"), rsColeta.getString("exa_codigo"), rsColeta.getString("mco_codigo"), rsColeta.getString("mco_descricao"), rsColeta.getString("mco_abreviatura"), String.valueOf(qtde), rsColeta.getString("rco_volume"), rsColeta.getString("rec_capacidade"), codigoTubo, rsColeta.getString("pac_nome"), rsColeta.getString("fil_codigo"), rsColeta.getString("fil_descricao"), rsColeta.getString("unm_codigo"), rsColeta.getString("set_codigo"), rsColeta.getString("set_descricao"), rsColeta.getString("set_sigla"), rsColeta.getTimestamp("exr_datamaterial"), rsColeta.getString("rec_descricao"), rsColeta.getString("col_codigo"), rsColeta.getString("col_descricao"), rsColeta.getString("con_codigo"), rsColeta.getString("con_razao"), rsColeta.getString("con_fantasia"), rsColeta.getTimestamp("dataHoraAtual"), rsColeta.getDouble("req_peso"), rsColeta.getDouble("req_altura"), rsColeta.getString("req_idade") + " " + Tipos.tipoIdade(rsColeta.getString("req_anomes")), rsColeta.getString("exr_tempojejum"), rsColeta.getDouble("exr_volumediurese"), rsColeta.getString("exr_tempodiurese"), rsColeta.getBoolean("req_gestante"), rsColeta.getString("exr_descricaomaterial"), rsColeta.getBoolean("req_urgente")});
                        continue;
                    }
                }
            }
        }
        return lista;
    }

    private static int localizar(int posini, String setor, String tubo, ArrayList lista) {
        int retorno = -1;
        if (posini < lista.size() && lista.size() > 0) {
            for (int i = posini; i < lista.size(); ++i) {
                Object[] o = (Object[])lista.get(i);
                if (!(o[0] instanceof String) || !o[0].equals(tubo) || !ParametrosGerais.getTuboPrimario() && !o[13].equals(setor)) continue;
                retorno = i;
                break;
            }
        }
        return retorno;
    }

    private static ArrayList adicionaTubo(ArrayList lista, int pos, String tubo, String exame, String codigoMaterial, String descricaoMaterial, String abrv, String qtde, String volume, String capacidade, String codigoRequisicaoTubo, String nomePaciente, String codigoFilial, String descricaoFilial, String unidadeRecipiente, String codigoSetor, String descricaoSetor, String siglaSetor, Timestamp dataHora, String descricaoTubo, String codigoColeta, String descricaoColeta, String codigoConvenio, String razaoConvenio, String fantasiaConvenio, Timestamp dataHoraAtual, Double peso, Double altura, String idade, String jejum, double diurese, String tempoDiurese, boolean gestante, String descricaoMaterialColetado, boolean urgente, String codigoPaciente) {
        Object[] s = (Object[])lista.get(pos);
        double capacity = 0.0;
        double volumeUtilizado = 0.0;
        double novoVolume = 0.0;
        if (Funcoes.isNumeric(s[7].toString())) {
            capacity = Double.parseDouble(Funcoes.limpaDecimal(s[7].toString()));
        }
        if (Funcoes.isNumeric(s[6].toString())) {
            volumeUtilizado = Double.parseDouble(Funcoes.limpaDecimal(s[6].toString()));
        }
        if (Funcoes.isNumeric(volume)) {
            novoVolume = Double.parseDouble(volume);
        }
        if (ParametrosGerais.getTuboPrimario()) {
            capacity = 0.0;
        }
        if (capacity == 0.0 || capacity > 0.0 && capacity - volumeUtilizado >= novoVolume) {
            s[6] = String.valueOf(volumeUtilizado + novoVolume);
            StringBuilder tmp = new StringBuilder(s[1].toString());
            tmp.append(" ");
            tmp.append(Funcoes.preencheVazio(exame, 5, 2));
            s[1] = tmp.toString();
        } else if ((pos = ImprimirEtqColeta.localizar(pos + 1, codigoSetor, tubo, lista)) < 0) {
            lista.add(new Object[]{tubo, Funcoes.preencheVazio(exame, 5, 2), codigoMaterial, descricaoMaterial, abrv, qtde, volume, capacidade, codigoRequisicaoTubo, nomePaciente, codigoFilial, descricaoFilial, unidadeRecipiente, codigoSetor, descricaoSetor, siglaSetor, dataHora, descricaoTubo, codigoColeta, descricaoColeta, codigoConvenio, razaoConvenio, fantasiaConvenio, dataHoraAtual, peso, altura, idade, jejum, diurese, tempoDiurese, gestante, descricaoMaterialColetado, urgente, codigoPaciente});
        } else {
            lista = ImprimirEtqColeta.adicionaTubo(lista, pos, tubo, exame, codigoMaterial, descricaoMaterial, abrv, qtde, volume, capacidade, codigoRequisicaoTubo, nomePaciente, codigoFilial, descricaoFilial, unidadeRecipiente, codigoSetor, descricaoSetor, siglaSetor, dataHora, descricaoTubo, codigoColeta, descricaoColeta, codigoConvenio, razaoConvenio, fantasiaConvenio, dataHoraAtual, peso, altura, idade, jejum, diurese, tempoDiurese, gestante, descricaoMaterialColetado, urgente, codigoPaciente);
        }
        return lista;
    }
}

