/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.notificacao;

import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.digitacao.componente.CampoListaDigitacao;
import jalis.laboratorio.digitacao.componente.ImagemDigitacao;
import jalis.laboratorio.digitacao.componente.TextoDigitacao;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TelaNotificacao
extends JDialog
implements DisposeListener {
    public JPanel panelArea = new JPanel(null);
    private JScrollPane scroll = new JScrollPane(this.panelArea, 22, 31);
    private String notificacao;
    private String notificacaoCabecalho;
    private JPanel panelBotao = new JPanel(null);
    private JButton buttonFechar = new JButton("Salvar");
    private JButton buttonCancelar = new JButton("Cancelar");
    private Resultado resultado;
    private Boolean salvarNotificacao = false;

    public TelaNotificacao(Frame owner) {
        super(owner);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    public TelaNotificacao(Dialog owner) {
        super(owner);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    public void jbInit() throws Exception {
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setLayout(new BorderLayout());
        this.setTitle("Notifica\u00e7\u00e3o");
        this.setPreferredSize(new Dimension(543, 540));
        this.setSize(new Dimension(543, 540));
        this.setLocationRelativeTo(null);
        this.add((Component)this.scroll, "Center");
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone64x64.png").getImage());
        this.panelBotao.setPreferredSize(new Dimension(543, 30));
        this.panelBotao.setSize(new Dimension(543, 30));
        this.buttonFechar.setBounds(340, 5, 80, 20);
        this.panelBotao.add(this.buttonFechar);
        this.buttonCancelar.setBounds(425, 5, 95, 20);
        this.panelBotao.add(this.buttonCancelar);
        this.add((Component)this.panelBotao, "South");
        this.montaListener();
    }

    private void montaListener() {
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TelaNotificacao.this.dispose();
                TelaNotificacao.this.salvarNotificacao = true;
            }
        });
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Funcoes.mensagem(TelaNotificacao.this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
                    TelaNotificacao.this.dispose();
                    TelaNotificacao.this.salvarNotificacao = false;
                }
            }
        });
    }

    public void limparCampos() {
        this.notificacao = "";
        this.notificacaoCabecalho = "";
    }

    public String getNotificacao() {
        this.resultado.atualizarComponentes();
        this.notificacao = this.resultado.getResultado();
        return this.notificacao;
    }

    public Boolean getSalvarNotificacao() {
        return this.salvarNotificacao;
    }

    public String getNotificacaoCabecalho() {
        return this.notificacaoCabecalho;
    }

    public void setNotificacaoCabecalho(String notificacaoCabecalho) {
        this.notificacaoCabecalho = notificacaoCabecalho;
    }

    public void montaNotificacao(String layout, HashMap<String, Object> hash, String cabecalho, boolean visualizar) {
        if (visualizar) {
            this.buttonCancelar.setVisible(false);
            this.buttonFechar.setText("Fechar");
            this.buttonFechar.setBounds(440, 5, 80, 20);
        }
        Integer alturaMaxima = 0;
        Resultado cab = new Resultado(cabecalho, hash);
        this.resultado = new Resultado(layout, hash, !visualizar);
        alturaMaxima = this.adicionarComponente(cab, visualizar);
        alturaMaxima = cab.getAlturaResultado();
        Integer altura = this.adicionarComponente(this.resultado, alturaMaxima, visualizar);
        this.panelArea.setSize(new Dimension(this.panelArea.getWidth(), altura));
        this.panelArea.setPreferredSize(new Dimension(this.panelArea.getWidth(), altura));
    }

    private Integer adicionarComponente(Resultado resultado, boolean visualizar) {
        return this.adicionarComponente(resultado, 0, visualizar);
    }

    private Integer adicionarComponente(Resultado resultado, Integer alturaMaxima, boolean visualizar) {
        List<Component> cc = resultado.getComponentes();
        Integer altura = 0;
        for (Component comp : cc) {
            if (visualizar) {
                if (comp instanceof TextoDigitacao) {
                    ((TextoDigitacao)comp).setEditable(false);
                } else if (comp instanceof CampoListaDigitacao) {
                    ((CampoListaDigitacao)comp).setEnabled(false);
                } else if (comp instanceof ImagemDigitacao) {
                    ((ImagemDigitacao)comp).setEnabled(false);
                }
            }
            if (alturaMaxima > 0) {
                comp.setBounds(comp.getX(), comp.getY() + alturaMaxima, comp.getWidth(), comp.getHeight());
            }
            if (altura < comp.getY()) {
                altura = comp.getY() + comp.getHeight();
            }
            this.panelArea.add(comp);
        }
        return altura;
    }

    public void setNotificacao(String notificacao) {
        this.notificacao = notificacao;
    }

    public void definirTitulo(String codigoExame, String descricaoExame) {
        StringBuilder buf = new StringBuilder("Notifica\u00e7\u00e3o ");
        buf.append(codigoExame).append(" - ").append(descricaoExame);
        this.setTitle(buf.toString());
    }
}

