/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.notificacao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Digitacao;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.impressao.Documento;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.RetornoNotificacao;
import jalis.laboratorio.util.impressao.notificacao.NotificacaoDao;
import jalis.laboratorio.util.impressao.notificacao.TelaNotificacao;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JFrame;
import org.postgresql.util.PGInterval;

public class NotificacaoService {
    private NotificacaoDao dao = new NotificacaoDao();
    private String cabecalhoNotificacao;
    private String notificacaoPreenchida;

    public void visualizar(String filial, String requisicao, String codigoExame, int material, boolean visualizar, String notificacao, String codigoLayout) throws SQLException {
        Statement st = Conexao.getStatement();
        this.visualizar(filial, requisicao, codigoExame, material, visualizar, notificacao, codigoLayout, st, false);
        st.close();
    }

    public RetornoNotificacao visualizar(String filial, String requisicao, String codigoExame, int material, boolean visualizar, String notificacao, String codigoLayout, Statement st, boolean isColetaWeb) throws SQLException {
        HashMap<String, Object> hash = new HashMap();
        if (Funcoes.textoVazio(requisicao)) {
            Hashtable<String, String> exames = this.dao.getLayoutExame(codigoExame, st);
            String cabecalho = exames.get("cabecalhonotificacao");
            if (Funcoes.textoVazio(cabecalho)) {
                cabecalho = this.dao.getCabecalhoModelo(codigoLayout, st);
            }
            Registro registro = new Registro();
            registro.setValor("cabecalhonotificacao", cabecalho);
            registro.setValor("corponotificacao", notificacao);
            if (Funcoes.textoVazio(notificacao)) {
                registro.setValor("corponotificacao", exames.get("corponotificacao"));
            }
            registro.setValor("codigoexame", codigoExame);
            registro.setValor("codigomaterial", String.valueOf(material));
            registro.setValor("descricaoexame", exames.get("descricaoexame"));
            registro.setValor("codigolayout", codigoLayout);
            String layout = this.getLayout(registro, st);
            if (!isColetaWeb && !Funcoes.textoVazio(layout)) {
                this.exibirTela(registro, null, layout, visualizar);
            } else if (isColetaWeb) {
                hash = this.getDadosHash(registro, isColetaWeb);
                String corpoNotificacao = registro.getString("corponotificacao");
                if (!Funcoes.textoVazio(registro.getString("notificacaopreenchida"))) {
                    corpoNotificacao = registro.getString("notificacaopreenchida");
                }
                RetornoNotificacao retornoNotificacao = new RetornoNotificacao();
                retornoNotificacao.setCabecalho(layout);
                retornoNotificacao.setHashCamposDoBanco(hash);
                Digitacao digitacao = new Digitacao();
                if (!visualizar) {
                    digitacao.carregarCampos(corpoNotificacao, hash, null, null, null, null, true, 1, null, null);
                } else {
                    digitacao.carregarCampos(corpoNotificacao, null, null, null, null, null, false, 1, null, null);
                }
                retornoNotificacao.setDigitacao(digitacao);
                retornoNotificacao.setXmlNotificacoes(digitacao.getResultadoObj().gerarResultado("resultado", false, true));
                return retornoNotificacao;
            }
        } else {
            List<Registro> listaRegistro = this.getRequisicao(filial, requisicao, codigoExame, material, st);
            String layout = "";
            for (Registro registro : listaRegistro) {
                if (registro == null) continue;
                if (!Funcoes.textoVazio(notificacao)) {
                    registro.setValor("notificacaopreenchida", notificacao);
                }
                hash = this.getDadosHash(registro, isColetaWeb);
                layout = this.getLayout(registro, filial, st);
                if (!isColetaWeb && !Funcoes.textoVazio(layout)) {
                    this.exibirTela(registro, hash, layout, visualizar);
                    continue;
                }
                if (!isColetaWeb) continue;
                String corpoNotificacao = registro.getString("corponotificacao");
                if (!Funcoes.textoVazio(registro.getString("notificacaopreenchida"))) {
                    corpoNotificacao = registro.getString("notificacaopreenchida");
                }
                RetornoNotificacao retornoNotificacao = new RetornoNotificacao();
                retornoNotificacao.setCabecalho(layout);
                retornoNotificacao.setHashCamposDoBanco(hash);
                Digitacao digitacao = new Digitacao();
                if (!visualizar) {
                    digitacao.carregarCampos(corpoNotificacao, hash, null, null, null, null, true, 1, null, null);
                } else {
                    digitacao.carregarCampos(corpoNotificacao, null, null, null, null, null, false, 1, null, null);
                }
                retornoNotificacao.setDigitacao(digitacao);
                retornoNotificacao.setXmlNotificacoes(digitacao.getResultadoObj().gerarResultado("resultado", false, true));
                return retornoNotificacao;
            }
            return null;
        }
        return null;
    }

    private String[] exibirTela(Registro registro, HashMap<String, Object> hash, String layout, boolean visualizar) {
        TelaNotificacao tela = new TelaNotificacao(new JFrame());
        tela.definirTitulo(registro.getString("codigoexame"), registro.getString("descricaoexame"));
        String notificacao = registro.getString("corponotificacao");
        if (!Funcoes.textoVazio(registro.getString("notificacaopreenchida"))) {
            notificacao = registro.getString("notificacaopreenchida");
        }
        tela.montaNotificacao(notificacao, hash, layout, visualizar);
        tela.getNotificacao();
        tela.setVisible(true);
        String[] notificacaoArray = new String[]{tela.getNotificacao()};
        this.notificacaoPreenchida = tela.getSalvarNotificacao() != false ? tela.getNotificacao() : notificacao;
        tela.limparCampos();
        return notificacaoArray;
    }

    private String getLayout(Registro registro, Statement st) throws SQLException {
        return this.getLayout(registro, Variaveis.filialPadrao, st);
    }

    private String getLayout(Registro registro, String filialPadrao, Statement st) throws SQLException {
        String layout = "";
        layout = registro.getString("cabecalhonotificacao");
        if (Funcoes.textoVazio(layout)) {
            layout = this.getCabecalhoModelo(registro.getString("codigolayout"), filialPadrao, st);
        }
        return layout;
    }

    private String getLayoutExame(Registro registro) throws SQLException {
        String layout = "";
        layout = registro.getString("cabecalhonotificacao");
        if (Funcoes.textoVazio(layout)) {
            layout = this.getCabecalhoModelo(registro.getString("codigolayout"));
        }
        return layout;
    }

    public void imprimir(String filial, String requisicao, String codigoExame, int material, String notificacao) throws SQLException {
        TelaNotificacao tela = new TelaNotificacao(new JFrame());
        if (!Funcoes.textoVazio(requisicao)) {
            List<Registro> listaRegistro = this.getRequisicao(filial, requisicao, codigoExame, material);
            HashMap<String, Object> hash = new HashMap();
            String layout = "";
            for (Registro registro : listaRegistro) {
                if (!Funcoes.textoVazio(notificacao)) {
                    registro.setValor("notificacaopreenchida", notificacao);
                }
                hash = this.getDadosHash(registro, false);
                Statement st = Conexao.getStatement();
                layout = this.getLayout(registro, st);
                Conexao.fecharStatement(st);
                tela.montaNotificacao(notificacao, hash, layout, false);
                notificacao = new Resultado(notificacao, hash).getResultado();
                this.impressao(layout, hash, new String[]{notificacao});
            }
        }
    }

    public void imprimirRequisicao(String filtroExame, Registro reg) {
        Statement st = Conexao.getStatement();
        if (st != null) {
            StringBuilder buf = new StringBuilder();
            buf.append(" select \n");
            buf.append("  a.exa_codigo, a.mco_codigo, exr_notificacao ");
            buf.append(" from examerequisicao a \n");
            buf.append(" left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo \n");
            buf.append(" left join materialcoleta c on a.fil_codigo = c.fil_codigo and a.mco_codigo = c.mco_codigo \n");
            buf.append(" left join examematcoleta d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo \n");
            buf.append(" left join examesetor set on a.fil_codigo = set.fil_codigo and a.exa_codigo = set.exa_codigo and set.ese_default = true ");
            buf.append(" where a.fil_codigo = ").append(reg.getValor("fil_codigo"));
            buf.append("   and a.req_codigo = ").append(reg.getValor("req_codigo"));
            buf.append("   and a.exr_excluido = false ");
            buf.append("   and a.exr_notificacao <> '' ");
            buf.append("   and a.exr_notificacao is not null ");
            buf.append("   and exr_situacao IN ('").append("C").append("', '").append("I").append("', '").append("E").append("')");
            if (filtroExame != null) {
                buf.append("   and ").append(filtroExame);
            }
            buf.append(" order by d.emc_pagina ");
            buf.append("      ,d.emc_ordem ");
            buf.append("      ,a.exa_codigo ");
            buf.append("      ,a.mco_codigo ");
            try {
                boolean index = false;
                ResultSet res = Conexao.executeQuery(st, buf.toString());
                if (res.first()) {
                    do {
                        String exameCodigo = res.getString("exa_codigo");
                        String notificacao = res.getString("exr_notificacao");
                        int materialCodigo = Integer.parseInt(res.getString("mco_codigo"));
                        this.imprimir(reg.getString("fil_codigo"), reg.getString("req_codigo"), exameCodigo, materialCodigo, notificacao);
                    } while (res.next());
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "FrmImpressaoNotificacaoExame: 553");
            }
        }
    }

    private void impressao(String layout, HashMap<String, Object> hash, String[] notificacao) {
        Documento doc = new Documento();
        doc.setSempreReposicionarEntrePaginas(true);
        doc.setDadosBanco(hash);
        doc.setCabecalhoRodape(layout);
        doc.addResultados(null, notificacao);
        jalis.laboratorio.impressao.Impressao imp = new jalis.laboratorio.impressao.Impressao(Impressao.comparaNomeImpressoraReduzido(ParametrosLocais.getParametro("impressoraNotificacaoExames")));
        imp.imprimir(doc);
    }

    private HashMap<String, Object> getDadosHash(Registro registro, boolean isColetaWeb) {
        HashMap<String, Object> hash = new HashMap<String, Object>();
        for (int i = 0; i <= registro.getQtdeColunas(); ++i) {
            String campo = registro.getNomeColuna(i);
            if (Funcoes.textoVazio(campo)) continue;
            if (campo.equalsIgnoreCase("sexoPaciente")) {
                hash.put(campo, Tipos.tipoSexo(registro.getString(campo)));
                continue;
            }
            if (campo.equalsIgnoreCase("tipoLogradouroPaciente") || campo.equalsIgnoreCase("tipoLogradouroConvenio") || campo.equalsIgnoreCase("tipoLogradouroMedico")) {
                hash.put(campo, Tipos.tipoLogradouroDescricao(registro.getString(campo)));
                continue;
            }
            if (campo.equalsIgnoreCase("corPaciente")) {
                hash.put(campo, Tipos.tipoCor(registro.getString(campo)));
                continue;
            }
            if (campo.equalsIgnoreCase("estadoCivilPaciente")) {
                hash.put(campo, Tipos.tipoEstadoCivil(registro.getString(campo)));
                continue;
            }
            if (campo.equalsIgnoreCase("idadeRequisicaoPaciente")) {
                hash.put(campo, Funcoes.getIntervaloParaString((PGInterval)registro.getValor("idadeRequisicaoPaciente"), null));
                continue;
            }
            if (campo.equalsIgnoreCase("dataImpressao")) {
                if (!isColetaWeb) {
                    hash.put(campo, Funcoes.formataData(Funcoes.getDataServidor()));
                    continue;
                }
                hash.put(campo, Funcoes.formataData(new Date()));
                continue;
            }
            hash.put(campo, registro.getValor(campo));
        }
        hash.put("dataAtual", new Date());
        return hash;
    }

    public List<Registro> getRequisicao(String filial, String requisicao, String codigoExame, int material) throws SQLException {
        Statement st = Conexao.getStatement();
        List<Registro> listaRegistro = this.dao.getRequisicao(filial, requisicao, codigoExame, material, st);
        st.close();
        return listaRegistro;
    }

    public List<Registro> getRequisicao(String filial, String requisicao, String codigoExame, int material, Statement st) throws SQLException {
        return this.dao.getRequisicao(filial, requisicao, codigoExame, material, st);
    }

    public String getCabecalhoModelo(String codigoLayout) throws SQLException {
        Statement st = Conexao.getStatement();
        String retorno = this.dao.getCabecalhoModelo(codigoLayout, st);
        Conexao.fecharStatement(st);
        return retorno;
    }

    public String getCabecalhoModelo(String codigoLayout, String filialPadrao, Statement st) throws SQLException {
        return this.dao.getCabecalhoModelo(codigoLayout, filialPadrao, st);
    }

    public Hashtable getPesquisaNotificacao(String codigo) throws Exception {
        return this.dao.getPesquisaNotificacao(codigo);
    }

    public String getNotificacaoPreenchida() {
        return this.notificacaoPreenchida;
    }

    public void setNotificacaoPreenchida(String notificacaoPreenchida) {
        this.notificacaoPreenchida = notificacaoPreenchida;
    }

    public void atualizarExameRequisicao(String codigoFilial, String codigoRequisicao, String codigoExame, int codigoMaterial, String notificacaoPreenchida) throws SQLException {
        this.dao.atualizarExameRequisicao(codigoFilial, codigoRequisicao, codigoExame, codigoMaterial, notificacaoPreenchida);
    }
}

