/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.notificacao;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class NotificacaoDao {
    public List<Registro> getRequisicao(String filial, String requisicao, String codigoExame, int material, Statement st) throws SQLException {
        if (st == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer("");
        buf.append("select req.req_codigo as codigoRequisicao,");
        buf.append(" req.req_data as dataRequisicao,");
        buf.append(" req.req_dtfatura as dataFaturaRequisicao,");
        buf.append(" req.req_urgente as urgenteRequisicao,");
        buf.append(" req.req_dataentregaprev as dataEntregaRequisicao,");
        buf.append(" req.req_responsavel as responsavelPacienteRequisicao,");
        buf.append(" req.req_cpfresponsavel as cpfResponsavelPacienteRequisicao,");
        buf.append(" COALESCE(req.req_incapacitado,false) as incapacitadoPacienteRequisicao,");
        buf.append(" req.req_dclinicos as dadosClinicosRequisicao, \t");
        buf.append(" req.req_obs as obsRequisicao,");
        buf.append(" req.req_totpago as totalPagoRequisicao,");
        buf.append(" req.req_horaentregaprev as horaEntregaRequisicao,");
        buf.append(" req.req_total as totalRequisicao,");
        buf.append(" req.req_horafatura as horaFaturaRequisicao,");
        buf.append(" req.req_hora as horaRequisicao,");
        buf.append(" req.req_gestante as gestanteRequisicao,");
        buf.append(" req.req_dum as dumRequisicao,");
        buf.append(" req.req_idade as idadeRequisicao,");
        buf.append(" req.req_anomes as anoMesRequisicao,");
        buf.append(" req.req_matricula as matriculaRequisicao,");
        buf.append(" req.req_avisarpaciente as avisarPacienteRequisicao,");
        buf.append(" req.req_senhaweb as senhaWebRequisicao,");
        buf.append(" req.req_titular as titularRequisicao,");
        buf.append(" req.req_peso as pesoRequisicao,");
        buf.append(" req.req_altura as alturaRequisicao,");
        buf.append(" req.req_desconto as descontoRequisicao,");
        buf.append(" req.req_vlrdesconto as valorDescontoRequisicao,");
        buf.append(" req.req_notacaixa as notaCaixaRequisicao,");
        buf.append(" req.req_vlrexames as valorExamesRequisicao,");
        buf.append(" req.req_vlrmateriais as valorMateriaisRequisicao,");
        buf.append(" req.req_guia as guiaRequisicao,");
        buf.append(" req.req_acrescimo as acrescimoRequisicao,");
        buf.append(" req.req_vlracrescimo as valorAcrescimoRequisicao,");
        buf.append(" req.req_tipoultpagamento as tipoUltimoPagamentoRequisicao,");
        buf.append(" req.sit_codigo as codigoSituacao, ");
        buf.append(" req.usr_codigo as codigoUsuario, ");
        buf.append(" req.des_codigo as codigoDestino,\t");
        buf.append(" req.col_codigo as codigoColeta,\t");
        buf.append(" req.fil_codigo as codigoFilial,\t");
        buf.append(" req.req_procedencia as procedenciaRequisicao, \t");
        buf.append(" age(req.req_data, pac.pac_datanasc) as idadeRequisicaoPaciente, \t");
        buf.append(" req.req_periodogestacional as periodoGestacionalRequisicao, \t");
        buf.append(" pac.pac_responsavel as responsavelPaciente,");
        buf.append(" pac.pac_cpfresponsavel as cpfResponsavelPaciente,");
        buf.append(" COALESCE(pac.pac_incapacitado,false) as incapacitadoPaciente,");
        buf.append(" pac.pac_whatsapp as whatsAppPaciente,");
        buf.append(" pac.pac_codigo as codigoPaciente,");
        buf.append(" pac.pac_nome as nomepaciente,");
        buf.append(" pac.pac_sexo as sexoPaciente,");
        buf.append(" pac.pac_datanasc as dataNascimentoPaciente,");
        buf.append(" pac.pac_grpsangue as grupoSanguineoPaciente,");
        buf.append(" pac.pac_fatorrh as fatorRHPaciente,");
        buf.append(" pac.pac_fatordu as fatorDUPaciente,");
        buf.append(" pac.pac_cor as corPaciente,");
        buf.append(" pac.pac_profissao as profissaoPaciente,");
        buf.append(" pac.pac_rg as rgPaciente,");
        buf.append(" pac.pac_cpf as cpfPaciente,");
        buf.append(" pac.pac_estcivil as estadoCivilPaciente,");
        buf.append(" pac.pac_dum as dumPaciente,");
        buf.append(" pac.pac_fone as fonePaciente,");
        buf.append(" pac.pac_celular as celularPaciente,");
        buf.append(" pac.pac_fax as faxPaciente,");
        buf.append(" pac.pac_fonecomercial as foneComercialPaciente,");
        buf.append(" pac.pac_endereco as enderecoPaciente,");
        buf.append(" pac.pac_numeroendereco as numeroEnderecoPaciente,");
        buf.append(" pac.pac_tipologradouroendereco as tipoLogradouroPaciente,");
        buf.append(" pac.pac_complemento as complementoPaciente,");
        buf.append(" pac.pac_cep as cepPaciente,");
        buf.append(" pac.pac_email as emailPaciente,");
        buf.append(" pac.pac_fonecontato as foneContatoPaciente,");
        buf.append(" pac.pac_nomecontato as contatoPaciente,");
        buf.append(" pac.pac_senhaweb as senhaWebPaciente,");
        buf.append(" pac.pac_nomesocial as nomeSocialPaciente,");
        buf.append(" pac.pac_passaporte as passaportePaciente,");
        buf.append(" pac.pac_mae as maePaciente,");
        buf.append(" filial.fil_codigo as codigoFilial, ");
        buf.append(" filial.fil_descricao as descricaoFilial, \t");
        buf.append(" filial.fil_cnpj as cnpjFilial, \t");
        buf.append(" filial.fil_endereco as enderecoFilial, \t");
        buf.append(" filial.fil_complemento as complementoFilial, \t");
        buf.append(" filial.fil_cep as cepFilial, \t");
        buf.append(" filial.fil_fone as foneFilial, \t");
        buf.append(" filial.fil_fax as faxFilial, \t");
        buf.append(" filial.fil_razaosocial as razaoSocialFilial,\t");
        buf.append(" filial.fil_cnes as CNESFilial,\t");
        buf.append("exr.exa_codigo as codigoExame, \t");
        buf.append("exr.mco_codigo as materialColetadoExame, \t");
        buf.append(" exr.exr_vlrchexame as ambExame, \t");
        buf.append(" exr.exr_vlrchexame as chExame, \t");
        buf.append(" exr.exr_vlrexame as valorExame,\t");
        buf.append(" exr.exr_situacao as situacaoExame, \t");
        buf.append(" exr.exr_datamaterial as dataColetaExameRequisicao, \t");
        buf.append(" exr.exr_datamaterial as horaColetaExameRequisicao,\t");
        buf.append(" exr.exr_dataassina as dataAssinaturaExameRequisicao,\t");
        buf.append(" exr.exr_datadigita as dataDigitacaoExameRequisicao,\t");
        buf.append(" COALESCE(exr.exr_urgente, false) as urgenteExame,\t");
        buf.append(" exr.usr_codmaterial as usuarioColetaExame,\t");
        buf.append(" exr.exr_tempodiurese as tempoDiureseExame, \t");
        buf.append(" exr.exr_volumediurese as volumeDiureseExame,\t");
        buf.append(" exr.exr_descricaomaterial as materialInformadoExame, \t");
        buf.append(" exr.exr_dataentregaprev as dataEntregaExame, \t");
        buf.append(" exr.exr_dataentregaprev as horaEntregaExame,\t");
        buf.append(" exr.exr_resposta as respostaExameRequisicao,\t");
        buf.append(" exr.exr_notificacao as notificacaoPreenchida,\t");
        buf.append(" ex.exa_descricao as descricaoExame,\t");
        buf.append(" ex.exa_cabecalhonotificacao as cabecalhoNotificacao,\t");
        buf.append(" ex.exa_corponotificacao as corpoNotificacao,\t");
        buf.append(" filial.fil_codigo as codigoFilial, ");
        buf.append(" filial.fil_descricao as descricaoFilial, ");
        buf.append(" filial.fil_fone as foneFilial, ");
        buf.append(" cidfilial.cid_nome as nomeCidadeFilial, ");
        buf.append(" cidpaciente.cid_nome as descricaoCidadePaciente, ");
        buf.append(" cidfilial.cid_uf as estadoCidadeFilial, ");
        buf.append(" cidfilial.cid_uf as estadoCidadePaciente, ");
        buf.append(" filial.fil_endereco as enderecoFilial, ");
        buf.append(" filial.fil_complemento as complementoFilial, ");
        buf.append(" baifilial.bai_descricao as nomeBairro, ");
        buf.append(" baipaciente.bai_descricao as descricaoBairroPaciente, ");
        buf.append(" filial.fil_fax as faxFilial, ");
        buf.append(" filial.fil_cep as cepFilial, ");
        buf.append(" con.lay_codigo as codigoLayout, ");
        buf.append(" '' as dataImpressao ");
        buf.append("from requisicao req ");
        buf.append("inner join examerequisicao exr  on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
        buf.append("inner join convenios con  on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        buf.append("inner join paciente pac  on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("inner join filiais_postocoleta filial  on req.fil_codigo = filial.fil_codigo ");
        buf.append("inner join cidades cidfilial  on filial.fil_codigo = cidfilial.fil_codigo and filial.cid_codigo = cidfilial.cid_codigo ");
        buf.append("left join cidades cidpaciente  on pac.fil_codigo = cidpaciente.fil_codigo and pac.cid_codigo = cidpaciente.cid_codigo ");
        buf.append("inner join bairro baifilial  on filial.fil_codigo = baifilial.fil_codigo and filial.bai_codigo = baifilial.bai_codigo ");
        buf.append("left join bairro baipaciente  on pac.fil_codigo = baipaciente.fil_codigo and pac.bai_codigo = baipaciente.bai_codigo ");
        buf.append("inner join exames ex  on exr.fil_codigo = ex.fil_codigo and exr.exa_codigo = ex.exa_codigo ");
        buf.append("where req.fil_codigo = ");
        buf.append(filial);
        buf.append(" and req.req_codigo = ");
        buf.append(requisicao);
        buf.append(" and req.req_excluida = false ");
        buf.append(" and exr.exa_codigo =").append(StringUtil.textoDBEscape(codigoExame));
        buf.append(" and exr.mco_codigo = ").append(material);
        ResultSet rs = st.executeQuery(buf.toString());
        ArrayList<Registro> listaRegistros = new ArrayList<Registro>();
        while (rs.next()) {
            Registro registro = new Registro(rs);
            listaRegistros.add(registro);
        }
        rs.close();
        return listaRegistros;
    }

    public String getCabecalhoModelo(String codigoLayout, Statement st) throws SQLException {
        return this.getCabecalhoModelo(codigoLayout, Variaveis.filialPadrao, st);
    }

    public String getCabecalhoModelo(String codigoLayout, String filialPadrao, Statement st) throws SQLException {
        String notificacao = null;
        StringBuilder buf = new StringBuilder();
        buf.delete(0, buf.length());
        buf.append("select ");
        buf.append("lay_notificacao");
        buf.append(" from layout where fil_codigo = ");
        buf.append(filialPadrao);
        buf.append(" and lay_codigo = ");
        buf.append(codigoLayout);
        if (st == null) {
            return null;
        }
        ResultSet rsLayout = st.executeQuery(buf.toString());
        if (rsLayout.next()) {
            notificacao = rsLayout.getString("lay_notificacao");
        }
        rsLayout.close();
        return notificacao;
    }

    public Hashtable<String, String> getLayoutExame(String codigoExame, Statement st) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.delete(0, buf.length());
        buf.append("select ");
        buf.append("exa_cabecalhonotificacao, exa_corponotificacao, exa_descricao");
        buf.append(" from exames where fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and exa_codigo = '").append(codigoExame).append("'");
        if (st == null) {
            return null;
        }
        ResultSet rsExame = st.executeQuery(buf.toString());
        if (rsExame.next()) {
            Hashtable<String, String> exames = new Hashtable<String, String>();
            exames.put("cabecalhonotificacao", rsExame.getString("exa_cabecalhonotificacao") == null ? "" : rsExame.getString("exa_cabecalhonotificacao"));
            exames.put("corponotificacao", rsExame.getString("exa_corponotificacao") == null ? "" : rsExame.getString("exa_corponotificacao"));
            exames.put("descricaoexame", rsExame.getString("exa_descricao"));
            return exames;
        }
        return null;
    }

    public Hashtable getPesquisaNotificacao(String codigo) throws Exception {
        Statement st = Conexao.getStatement();
        Hashtable<String, String> notificacao = new Hashtable<String, String>();
        if (st != null) {
            StringBuilder buf = new StringBuilder("select exa_cabecalhonotificacao, exa_corponotificacao from exames where fil_codigo=");
            buf.append(Variaveis.filialPadrao);
            buf.append(" and upper(exa_codigo)=upper(").append(codigo.trim()).append(") ");
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs != null && rs.next()) {
                notificacao.put("exa_corponotificacao", "corpo");
                notificacao.put("exa_cabecalhonotificacao", "cabecalho");
                if (st != null) {
                    st.close();
                }
                return notificacao;
            }
            if (st != null) {
                st.close();
            }
            throw new Exception("Erro ao copiar a autoriza\u00e7\u00e3o");
        }
        return null;
    }

    public void atualizarExameRequisicao(String codigoFilial, String codigoRequisicao, String codigoExame, int codigoMaterial, String notificacaoPreenchida) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("update examerequisicao set exr_notificacao = '").append(StringUtil.textoDB(notificacaoPreenchida)).append("'");
        buf.append(" where fil_codigo = ").append(codigoFilial);
        buf.append(" and req_codigo = ").append(codigoRequisicao);
        buf.append(" and exa_codigo = '").append(codigoExame).append("'");
        buf.append(" and mco_codigo = ").append(codigoMaterial);
        Conexao.execute(codigoFilial, Conexao.getStatement(), buf.toString());
    }
}

