/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.exame.externo.softlab;

import jalis.comum.Variaveis;
import jalis.laboratorio.impressao.ImpressaoException;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.ExportacaoParaSoftLab;
import jalis.laboratorio.triagem.externo.exportadores.InfoComplementar;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.exame.ExameMaterial;
import jalis.laboratorio.util.impressao.exame.externo.CarregaExameRequisicao;
import jalis.laboratorio.util.impressao.exame.externo.CarregaExameRequisicaoPadrao;
import jalis.laboratorio.util.impressao.exame.externo.CarregarExameRequisicaoFilial;
import jalis.laboratorio.util.impressao.exame.externo.softlab.LoteSoftLabDao;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.service.recepcao.ExameRequisicaoService;
import jalis.util.Funcoes;
import jalis.util.tabela.Registro;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class LoteSoftLab {
    private final LoteSoftLabDao dao;
    private final ExportacaoParaSoftLab softlab = new ExportacaoParaSoftLab();

    public LoteSoftLab(LoteSoftLabDao dao) {
        this.dao = dao;
    }

    public RetornoImpressaoEtiquetas criarLotePadraoExame(LaboratorioExterno labExterno, String filial, String requisicao, String[] exames, int[] materiais, int tipoEtq, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, RetornoImpressaoEtiquetas retorno, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar) throws ImpressaoException {
        CarregaExameRequisicaoPadrao carregarExameRequisicao = new CarregaExameRequisicaoPadrao(this.softlab);
        return this.criarLote(labExterno, filial, requisicao, exames, materiais, carregarExameRequisicao, tipoEtq, isColetaWeb, agruparInterface, st, st2, st3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, retorno, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar);
    }

    public RetornoImpressaoEtiquetas criarLoteFilialExame(LaboratorioExterno labExterno, String filial, String requisicao, String[] exames, int[] materiais, int tipoEtq, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, RetornoImpressaoEtiquetas retorno, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar) throws ImpressaoException {
        CarregarExameRequisicaoFilial carregarExameRequisicao = new CarregarExameRequisicaoFilial(this.softlab);
        return this.criarLote(labExterno, filial, requisicao, exames, materiais, carregarExameRequisicao, tipoEtq, isColetaWeb, agruparInterface, st, st2, st3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, retorno, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar);
    }

    private RetornoImpressaoEtiquetas criarLote(LaboratorioExterno labExterno, String filial, String requisicao, String[] exames, int[] materiais, CarregaExameRequisicao carregarExameRequisicao, int tipoEtq, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, RetornoImpressaoEtiquetas retorno, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar) throws ImpressaoException {
        ArrayList<ExameMaterial> criados = new ArrayList<ExameMaterial>();
        try {
            ExportacaoParaSoftLab exportacaoSoftLab = new ExportacaoParaSoftLab();
            boolean etiquetaSelecionada = false;
            if (this.dao.haExamesEnviarSoftLab(filial, requisicao, exames, st)) {
                if (!LoteSoftLabDao.isEnvioAutomatico(labExterno)) {
                    return retorno;
                }
                List<Registro> listaRequisicoesSoftLab = this.carregaRequisicoesOrdenadas(isColetaWeb, labExterno, filial, requisicao, carregarExameRequisicao, agruparGuiasInterface, st, filial, agruparInterface, st, st2, st3, variaveisLogin, digitosTuboFilial, digitosTuboRequisicao, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, arquivar, anular);
                retorno = this.criaLote(requisicao, exames, tipoEtq, exportacaoSoftLab, etiquetaSelecionada, listaRequisicoesSoftLab, isColetaWeb, agruparInterface, st, st2, st3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, retorno, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar);
                List<Registro> examesComLote = LoteSoftLabDao.verificaExamesComLote(filial, requisicao, exames, materiais, st, agruparInterface);
                for (Registro r : examesComLote) {
                    ExameMaterial exameMaterial = new ExameMaterial(r.getString("codigoExame".toLowerCase()), r.getInt("codigoMaterial".toLowerCase()));
                    criados.add(exameMaterial);
                }
            }
            retorno.setExames(criados);
            return retorno;
        }
        catch (Exception e) {
            throw new ImpressaoException("Erro ao carregar requisicoes SoftLab\n" + e.getMessage(), e);
        }
    }

    private RetornoImpressaoEtiquetas criaLote(String requisicao, String[] exames, int tipoEtq, ExportacaoParaSoftLab exportacaoSoftLab, boolean etiquetaSelecionada, List<Registro> listaRequisicoesSoftLab, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, RetornoImpressaoEtiquetas retorno, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar) {
        ArrayList<Registro> listaRequisicoes = new ArrayList<Registro>();
        if (tipoEtq == 3 || tipoEtq == 4) {
            Registro exa = exportacaoSoftLab.getExameSelecionado(requisicao, exames, listaRequisicoesSoftLab);
            if (exa != null) {
                listaRequisicoes.add(exa);
            }
            listaRequisicoesSoftLab.clear();
            etiquetaSelecionada = true;
        }
        return exportacaoSoftLab.criarLote(listaRequisicoesSoftLab.isEmpty() ? listaRequisicoes : listaRequisicoesSoftLab, etiquetaSelecionada, isColetaWeb, agruparInterface, st, st2, st3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, retorno, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar);
    }

    private List<Registro> carregaRequisicoesOrdenadas(boolean isColetaWeb, LaboratorioExterno labExterno, String filial, String requisicao, CarregaExameRequisicao carregarExameRequisicao, boolean agruparGuiasInterface, Statement st, String filialPadrao, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, int digitosFilial, int digitosRequisicao, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, Callable<Boolean> arquivar, Callable<Boolean> anular) throws Exception {
        List<Registro> listaRequisicoesSoftLab = carregarExameRequisicao.carregar(isColetaWeb, requisicao, filial, labExterno, -1, agruparGuiasInterface, st, filialPadrao, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, digitosFilial, digitosRequisicao, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, arquivar, anular);
        if (!listaRequisicoesSoftLab.isEmpty()) {
            this.ordenarExames(isColetaWeb, listaRequisicoesSoftLab, st);
        }
        return listaRequisicoesSoftLab;
    }

    private void ordenarExames(boolean isColetaWeb, List<Registro> listaRequisicoes, Statement st) {
        for (Registro regRequisicoes : listaRequisicoes) {
            HashMap<String, Object> chave = new HashMap<String, Object>();
            chave.put("fil_codigo", regRequisicoes.getValor("fil_codigo"));
            chave.put("req_codigo", regRequisicoes.getValor("req_codigo"));
            List<ExameRequisicaoVO> listaExames = null;
            try {
                listaExames = new ExameRequisicaoService().getVOsIn(chave, st, Variaveis.filialPadrao, isColetaWeb);
            }
            catch (ThreadDaoException | SQLException exception) {
                // empty catch block
            }
            if (Funcoes.objectIsNull(listaExames)) continue;
            List listaExame = (List)regRequisicoes.getValor("listaexames");
            ArrayList<Registro> listaBase = new ArrayList<Registro>();
            listaBase.addAll(listaExame);
            this.adicionaListaExames(listaExames, listaExame, listaBase);
        }
    }

    private void adicionaListaExames(List<ExameRequisicaoVO> listaExames, List<Registro> listaExame, List<Registro> listaBase) {
        block0: for (Registro r : listaBase) {
            for (ExameRequisicaoVO bean : listaExames) {
                if (!bean.getExame().getCodigo().equals(r.getString("exa_codigo"))) continue;
                listaExame.remove(r);
                int ordem = bean.getOrdem();
                if (listaExame.size() < bean.getOrdem()) {
                    ordem = listaExame.size();
                }
                listaExame.add(ordem, r);
                continue block0;
            }
        }
    }
}

