/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.exame.externo.softlab;

import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.util.impressao.exame.externo.softlab.ImpressaoSoftLab;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ImpressaoSoftLabDao {
    public LaboratorioExterno localizaLabExternoSoftLab(String filialPadrao, String[] exames, Statement st) throws SQLException {
        LaboratorioExterno labExterno = null;
        StringBuilder buf = new StringBuilder();
        buf.append("select lab.lae_codigo, lab.lae_configuracao ");
        buf.append("from labexterno lab ");
        buf.append("join examematcoletalabexterno exame ");
        buf.append("on lab.lae_codigo = exame.lae_codigo ");
        buf.append("and lab.fil_codigo = exame.fil_codigo ");
        buf.append("where lab.fil_codigo = ").append(filialPadrao);
        buf.append(" and lab.lae_protocolo = '").append((Object)Protocolo.SoftLab).append("' ").append(" and (lab.lae_inativo is null or not lab.lae_inativo) ");
        buf.append("and exame.exa_codigo in (").append(this.createCondicaoExames(exames)).append(")");
        LaboratorioExterno[] listas = LaboratorioExterno.getDescricoes(st, false);
        ResultSet rs = st.executeQuery(buf.toString());
        while (rs.next()) {
            Boolean enviarPorWebService = false;
            if (!Funcoes.textoVazio(rs.getString("lae_configuracao")) && !Funcoes.textoVazio(StringUtil.getValor(rs.getString("lae_configuracao"), "enviarLoteWebService"))) {
                enviarPorWebService = StringUtil.getBoolean(rs.getString("lae_configuracao"), "enviarLoteWebService");
            }
            if (!Boolean.TRUE.equals(enviarPorWebService)) continue;
            for (LaboratorioExterno laboratorioExterno : listas) {
                if (!laboratorioExterno.codigoLab.equals(rs.getString("lae_codigo"))) continue;
                labExterno = laboratorioExterno;
            }
        }
        return labExterno;
    }

    private String createCondicaoExames(String[] exames) {
        StringBuilder condicao = new StringBuilder();
        for (String exame : exames) {
            condicao.append("'").append(exame).append("',");
        }
        condicao.deleteCharAt(condicao.length() - 1);
        return condicao.toString();
    }

    public String pesquisarEtiquetaPorRequisicao(String filial, Integer[] multiguias, String[] exames, int[] materiais, Statement st) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select distinct lot.lex_codigo, ");
        buf.append("       lot.leq_retornows as retornoWs");
        buf.append("  from loteexternorequisicao lot ");
        buf.append("  join loteexternoexamerequisicao lotex on lot.fil_codigo = lotex.fil_codigo and lot.req_codigo = lotex.req_codigo and lot.lex_codigo = lotex.lex_codigo ");
        buf.append(" where lot.fil_kodigo = ").append(filial);
        buf.append("   and lot.req_codigo in (").append(this.getCondicao(multiguias)).append(") ");
        buf.append("   and lot.leq_retornows is not null ");
        buf.append("   and lot.leq_dataestorno is null ");
        if (exames != null && exames.length > 0 && materiais != null && materiais.length > 0) {
            buf.append("  and (lotex.exa_codigo, lotex.mco_codigo) IN (");
            for (int i = 0; i < exames.length; ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append("(").append(StringUtil.textoDBEscape(exames[i]));
                buf.append(",").append(materiais[i]).append(")");
            }
            buf.append(" ) ");
        }
        StringBuilder retorno = new StringBuilder();
        ResultSet rs = st.executeQuery(buf.toString());
        while (rs.next()) {
            retorno.append((CharSequence)ImpressaoSoftLab.formataEtiquetaSoftLab(rs.getString("retornoWs")));
        }
        if (rs != null) {
            rs.close();
        }
        return retorno.toString();
    }

    private String getCondicao(Integer[] materiais) {
        StringBuilder condicao = new StringBuilder();
        Integer[] integerArray = materiais;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int material = integerArray[i];
            condicao.append(material).append(",");
        }
        condicao.deleteCharAt(condicao.length() - 1);
        return condicao.toString();
    }
}

