/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.exame.externo.softlab;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.impressao.ImpressaoException;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.InfoComplementar;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.exame.ExameMaterial;
import jalis.laboratorio.util.impressao.exame.ExameRequisicaoListHandler;
import jalis.laboratorio.util.impressao.exame.ImpressaoExame;
import jalis.laboratorio.util.impressao.exame.externo.ImpressaoVO;
import jalis.laboratorio.util.impressao.exame.externo.softlab.ImpressaoSoftLabDao;
import jalis.laboratorio.util.impressao.exame.externo.softlab.LoteSoftLab;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.util.Funcoes;
import jalis.util.impressao.termica.ImpressaoTermica;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class ImpressaoSoftLab
implements ImpressaoExame {
    private final ExameRequisicaoListHandler handler;
    private final LoteSoftLab lote;
    private final ImpressaoSoftLabDao dao;

    public ImpressaoSoftLab(LoteSoftLab lote, ExameRequisicaoListHandler handler, ImpressaoSoftLabDao dao) {
        this.lote = lote;
        this.handler = handler;
        this.dao = dao;
    }

    @Override
    public RetornoImpressaoEtiquetas imprimir(boolean isColetaWeb, ImpressaoVO dados, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean agruparGuiasInterface, String filialPadrao, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, ImpressorasLabExterno impressoras, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar, int casasPrecoExame, RoundingMode arredondamentoPrecoExame) throws ImpressaoException {
        int tipoEtq;
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        ArrayList<ExameMaterial> impressos = new ArrayList<ExameMaterial>();
        String filial = String.valueOf(dados.filial);
        String requisicao = String.valueOf(dados.getRequisicaoPai());
        LaboratorioExterno labExterno = this.buscarLabExterno(filial, dados.getListaExameRequisicaoVO(), st);
        int[] materiais = this.toIntArray(dados.getMateriais());
        String[] examesString = dados.getExames().toArray(new String[0]);
        retorno = this.lote.criarLoteFilialExame(labExterno, filial, requisicao, examesString, materiais, tipoEtq = dados.getTipoEtiqueta(), isColetaWeb, agruparInterface, st, stEtq2, stEtq3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, retorno, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar);
        impressos.addAll(retorno.getExames() == null || retorno.getExames().isEmpty() ? new ArrayList() : retorno.getExames());
        if (impressos.isEmpty()) {
            retorno = this.imprimirEtiquetaSoftLab(filial, requisicao, labExterno, examesString, materiais, impressoras.getImpressoraSoftLab(), st, isColetaWeb, retorno, arquivar, anular);
        }
        impressos.addAll(this.buscarExamesComLote(filial, requisicao, examesString, materiais, agruparInterface, st));
        retorno.setExames(impressos);
        return retorno;
    }

    @Override
    public RetornoImpressaoEtiquetas imprimirPadrao(boolean isColetaWeb, ImpressaoVO dados, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean agruparGuiasInterface, String filialPadrao, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, ImpressorasLabExterno impressoras, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar, int casasPrecoExame, RoundingMode arredondamentoPrecoExame) throws ImpressaoException {
        int tipoEtq;
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        ArrayList<ExameMaterial> impressos = new ArrayList<ExameMaterial>();
        String filial = String.valueOf(dados.filial);
        String requisicao = String.valueOf(dados.getRequisicaoPai());
        LaboratorioExterno labExterno = this.buscarLabExterno(filial, dados.getListaExameRequisicaoVO(), st);
        int[] materiais = this.toIntArray(dados.getMateriais());
        String[] examesString = dados.getExames().toArray(new String[0]);
        retorno = this.lote.criarLotePadraoExame(labExterno, filial, requisicao, examesString, materiais, tipoEtq = dados.getTipoEtiqueta(), isColetaWeb, agruparInterface, st, stEtq2, stEtq3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, retorno, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar);
        impressos.addAll(retorno.getExames() == null || retorno.getExames().isEmpty() ? new ArrayList() : retorno.getExames());
        if (impressos.isEmpty()) {
            retorno = this.imprimirEtiquetaSoftLab(filial, requisicao, labExterno, examesString, materiais, impressoras.getImpressoraSoftLab(), st, isColetaWeb, retorno, arquivar, anular);
        }
        impressos.addAll(this.buscarExamesComLote(filial, requisicao, examesString, materiais, agruparInterface, st));
        retorno.setExames(impressos);
        return retorno;
    }

    private LaboratorioExterno buscarLabExterno(String filial, List<ExameRequisicaoVO> examesRequisicao, Statement st) throws ImpressaoException {
        LaboratorioExterno labExterno = null;
        try {
            List<String> exames = this.handler.extrairExames(examesRequisicao);
            String[] arrayExames = exames.toArray(new String[0]);
            labExterno = this.dao.localizaLabExternoSoftLab(String.valueOf(filial), arrayExames, st);
        }
        catch (SQLException e) {
            throw new ImpressaoException("Erro ao localizar laboratorio externo\n" + e.getMessage(), e);
        }
        return labExterno;
    }

    private List<ExameMaterial> buscarExamesComLote(String filial, String requisicao, String[] exames, int[] materiais, int agruparInterface, Statement st) {
        ArrayList<ExameMaterial> listaExamesNaoImprimir = new ArrayList<ExameMaterial>();
        ArrayList<Registro> examesComLote = UtilExportadores.verificaExamesComLote(filial, requisicao, exames, materiais, agruparInterface, st);
        for (Registro r : examesComLote) {
            ExameMaterial exameMaterial = new ExameMaterial(r.getString("codigoExame".toLowerCase()), r.getInt("codigoMaterial".toLowerCase()));
            if (listaExamesNaoImprimir.contains(exameMaterial)) continue;
            listaExamesNaoImprimir.add(exameMaterial);
        }
        return listaExamesNaoImprimir;
    }

    public int[] toIntArray(List<Integer> dados) {
        int[] resultado = new int[dados.size()];
        int index = 0;
        for (Integer dado : dados) {
            resultado[index] = dado;
            ++index;
        }
        return resultado;
    }

    public RetornoImpressaoEtiquetas imprimirEtiquetaSoftLab(String filial, String requisicao, LaboratorioExterno labExterno, String[] exames, int[] materiais, String impressoraSoftlab, Statement st, boolean isColetaWeb, RetornoImpressaoEtiquetas retorno, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        ArrayList etqs = new ArrayList();
        Integer[] multiguias = null;
        ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(impressoraSoftlab), isColetaWeb);
        try {
            multiguias = RecepcaoUtil.verificaMultiGuias(st, filial, requisicao, true);
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e2o foi recuperar as requisi\u00e7\u00f5es multiguia\n" + e.getMessage(), e.getStackTrace());
        }
        if (labExterno != null && !Funcoes.textoVazio(requisicao)) {
            try {
                termica.imprimirDireto(this.dao.pesquisarEtiquetaPorRequisicao(filial, multiguias, exames, materiais, st), true, st, isColetaWeb, arquivar, anular);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e2o foi poss\u00edvel verificar lote externo.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        HashMap<String, List<byte[]>> etiquetasLab = new HashMap<String, List<byte[]>>();
        ArrayList etq = retorno.getEtiquetasLabExterno() != null && !retorno.getEtiquetasLabExterno().isEmpty() ? retorno.getEtiquetasLabExterno().get("softlab") : new ArrayList();
        etqs.addAll(etq);
        etiquetasLab.put("softlab", etqs);
        retorno.setEtiquetasLabExterno(etiquetasLab);
        return retorno;
    }

    public static StringBuilder formataEtiquetaSoftLab(String etiqueta) {
        return new StringBuilder(etiqueta.replaceAll("\\r\\n(ZT)?|\\r(ZT)?|\\n(ZT)?", "\r\n"));
    }
}

