/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.exame.externo.shift;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;

public class LoteShiftDao {
    public static boolean examesParaEnviar(String codigoFilial, String codigoRequisicao, Statement st) throws SQLException {
        Object[] multiguia = null;
        try {
            multiguia = RecepcaoUtil.verificaMultiGuias(st, codigoFilial, codigoRequisicao, true, false);
        }
        catch (SQLException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e2o foi poss\u00edvel verificiar multiguia no carregamento de lote.\n" + e1.getMessage(), e1.getStackTrace());
        }
        Arrays.sort(multiguia);
        String guias = StringUtil.implode(Arrays.asList(multiguia), ",");
        StringBuilder buf = new StringBuilder();
        buf.append(" select lab.lae_configuracao, (lote.lex_codigo is null or lr.leq_retornows is null) as exame ");
        buf.append("   from examerequisicao exr ");
        buf.append("   join requisicao req on exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo ");
        buf.append("   join examematcoletalabexterno ele on exr.fil_codigo = ele.fil_codigo and exr.exa_codigo = ele.exa_codigo and exr.mco_codigo = ele.mco_codigo ");
        buf.append(" left join loteexternorequisicao lr on lr.fil_kodigo = req.fil_codigo and lr.req_codigo = req.req_codigo ");
        buf.append(" left join labexterno lab on ele.fil_codigo = lab.fil_codigo and ele.lae_codigo = lab.lae_codigo ");
        buf.append(" left join loteexternoexamerequisicao lote on exr.fil_codigo = lote.fil_kodigo and exr.exa_codigo = lote.exa_codigo and exr.mco_codigo = lote.mco_codigo and exr.req_codigo = lote.req_codigo and exr.fil_codigo = lote.fil_kodigo ");
        buf.append("  where exr.fil_codigo = ").append(codigoFilial);
        buf.append("    and req.req_codigo IN (").append(guias).append(") ");
        buf.append("    and lr.leq_dataestorno is null ");
        buf.append("    and not req.req_excluida ");
        buf.append("    and not exr.exr_excluido ");
        buf.append("    and lab.lae_protocolo = '").append((Object)Protocolo.Shift).append("' ");
        buf.append("    and (lote.lex_codigo is null or lr.leq_retornows is null) ");
        ResultSet rs = st.executeQuery(buf.toString());
        if (rs.next()) {
            String configuracaoLabExterno = rs.getString("lae_configuracao");
            boolean enviarUsandoWS = !Funcoes.textoVazio(StringUtil.getValor(configuracaoLabExterno, "enviarLoteWebservice")) ? Boolean.valueOf(StringUtil.getValor(configuracaoLabExterno, "enviarLoteWebservice")) : Boolean.FALSE;
            boolean isEnvioAutomatico = !Funcoes.textoVazio(StringUtil.getValor(configuracaoLabExterno, "envioAutomatico")) ? Boolean.valueOf(StringUtil.getValor(configuracaoLabExterno, "envioAutomatico")) : Boolean.FALSE;
            if (!enviarUsandoWS || !isEnvioAutomatico) {
                return false;
            }
            return rs.getBoolean("exame");
        }
        return false;
    }

    public LaboratorioExterno pesquisarLabExterno(String filialPadrao, String[] exames, Statement st, Callable<Boolean> anular) {
        LaboratorioExterno labExterno = null;
        StringBuilder buf = new StringBuilder();
        try {
            buf.append("select lab.lae_codigo, lab.lae_configuracao ");
            buf.append("from labexterno lab ");
            buf.append("join examematcoletalabexterno exame ");
            buf.append("on lab.lae_codigo = exame.lae_codigo ");
            buf.append("and lab.fil_codigo = exame.fil_codigo ");
            buf.append("where lab.fil_codigo = ").append(filialPadrao);
            buf.append(" and lab.lae_protocolo = '").append((Object)Protocolo.Shift).append("' ").append(" and (lab.lae_inativo is null or not lab.lae_inativo) ");
            buf.append("and exame.exa_codigo in (").append(this.createCondicaoExames(exames)).append(")");
            LaboratorioExterno[] listas = LaboratorioExterno.getDescricoes(st, false);
            ResultSet rs = st.executeQuery(buf.toString());
            while (rs.next()) {
                boolean enviarPorWebService = false;
                if (!Funcoes.textoVazio(rs.getString("lae_configuracao")) && !Funcoes.textoVazio(StringUtil.getValor(rs.getString("lae_configuracao"), "enviarLoteWebservice"))) {
                    enviarPorWebService = StringUtil.getBoolean(rs.getString("lae_configuracao"), "enviarLoteWebservice");
                }
                if (!enviarPorWebService) continue;
                for (LaboratorioExterno laboratorioExterno : listas) {
                    if (!laboratorioExterno.codigoLab.equals(rs.getString("lae_codigo"))) continue;
                    labExterno = laboratorioExterno;
                }
            }
        }
        catch (Exception e) {
            try {
                anular.call();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return labExterno;
    }

    private String createCondicaoExames(String[] exames) {
        StringBuilder condicao = new StringBuilder();
        for (String exame : exames) {
            condicao.append("'").append(exame).append("',");
        }
        condicao.deleteCharAt(condicao.length() - 1);
        return condicao.toString();
    }

    public Set<String> recuperarEtiquetasRedeWS(String filial, String requisicao, String[] exames, int[] materiais, Statement st, Callable<Boolean> anular) {
        StringBuilder buf = new StringBuilder();
        buf.append(" select distinct lot.lex_codigo, ");
        buf.append(" lot.leq_retornows as retornoWs");
        buf.append(" from loteexternorequisicao lot ");
        buf.append(" join loteexternoexamerequisicao lotex on lot.fil_codigo = lotex.fil_codigo and lot.req_codigo = lotex.req_codigo and lot.lex_codigo = lotex.lex_codigo ");
        buf.append(" where lot.fil_kodigo = ").append(filial);
        buf.append(" and lot.req_codigo in (").append(requisicao).append(") ");
        buf.append(" and lot.leq_retornows is not null ");
        buf.append(" and lot.leq_dataestorno is null ");
        if (exames != null && exames.length > 0 && materiais != null && materiais.length > 0) {
            buf.append("  and (lotex.exa_codigo, lotex.mco_codigo) IN (");
            for (int i = 0; i < exames.length; ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append("(").append("'").append(exames[i]).append("'");
                buf.append(",").append(materiais[i]).append(")");
            }
            buf.append(" ) ");
        }
        StringBuilder retorno = new StringBuilder();
        try {
            ResultSet rs = st.executeQuery(buf.toString());
            while (rs.next()) {
                retorno.append(rs.getString("retornoWs"));
            }
            rs.close();
            return StringUtil.getSetValoresTagAberta(retorno.toString(), "etiqueta", true);
        }
        catch (Exception e) {
            try {
                anular.call();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            return Collections.emptySet();
        }
    }

    public Integer pesquisarLabExternoPadraoDoExame(String codFilial, String codExame, String codMaterial, Statement st, Callable<Boolean> anular) {
        StringBuilder sql = new StringBuilder(" select lae_codigo from examematcoletalabexterno ");
        sql.append(" where fil_codigo = ").append(codFilial);
        sql.append(" and exa_codigo = '").append(codExame).append("'");
        sql.append(" and mco_codigo = ").append(codMaterial);
        sql.append(" and ele_padrao = true ");
        Integer codLabPadrao = 0;
        try {
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                codLabPadrao = rs.getInt("lae_codigo");
            }
        }
        catch (Exception e) {
            try {
                anular.call();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return codLabPadrao;
    }

    public List<ExameRequisicaoVO> pesquisarExamesJaEnviados(String codFilial, String codRequisicao, String codLabExterno, Statement st, Callable<Boolean> anular) {
        ArrayList<ExameRequisicaoVO> examesEnviados = new ArrayList<ExameRequisicaoVO>();
        try {
            Object[] multiguia = null;
            multiguia = RecepcaoUtil.verificaMultiGuias(st, codFilial, codRequisicao, true, false);
            Arrays.sort(multiguia);
            String guias = StringUtil.implode(Arrays.asList(multiguia), ",");
            StringBuilder sql = new StringBuilder(" select leer.exa_codigo, leer.mco_codigo ");
            sql.append(" from loteexterno le ");
            sql.append(" left join loteexternorequisicao ler on le.fil_codigo = ler.fil_codigo and le.lae_codigo = ler.lae_codigo and le.lex_codigo = ler.lex_codigo ");
            sql.append(" left join loteexternoexamerequisicao leer on ler.fil_codigo = leer.fil_codigo and ler.lae_codigo = leer.lae_codigo and ler.lex_codigo = leer.lex_codigo and ler.req_codigo = leer.req_codigo ");
            sql.append(" where ler.fil_kodigo = ").append(codFilial);
            sql.append(" and ler.req_codigo in ( ");
            sql.append(guias);
            sql.append(" ) ");
            sql.append(" and ler.lae_codigo = ").append(codLabExterno);
            sql.append(" and (le.usr_codestorno is null and le.lex_dataestorno is null and ler.usr_codestorno is null and ler.leq_dataestorno is null) ");
            sql.append(" and ler.leq_retornows is not null ");
            ResultSet rs = st.executeQuery(sql.toString());
            while (rs.next()) {
                ExameVO exame = new ExameVO();
                exame.setCodigo(rs.getString("exa_codigo"));
                MaterialColetaVO material = new MaterialColetaVO();
                material.setCodigo(rs.getInt("mco_codigo"));
                ExameRequisicaoVO exameReq = new ExameRequisicaoVO();
                exameReq.setExame(exame);
                exameReq.setMaterial(material);
                examesEnviados.add(exameReq);
            }
        }
        catch (Exception e) {
            try {
                anular.call();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return examesEnviados;
    }
}

