/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.exame.externo.saoMarcos;

import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.util.impressao.exame.externo.saoMarcos.ImpressaoSaoMarcosDao;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.Callable;

public class ImpressaoSaoMarcosService {
    ImpressaoSaoMarcosDao dao = new ImpressaoSaoMarcosDao();

    public LaboratorioExterno localizaLabExternoSM(String filial, String[] exames, Statement st) throws SQLException {
        return this.dao.localizaLabExternoSM(filial, exames, st);
    }

    public boolean haExamesParaEnviarSM(String filial, String requisicao, String[] exames, Statement st) {
        String configuracaoLabExterno;
        Registro reg = this.dao.haExamesParaEnviarSM(filial, requisicao, exames, st);
        if (this.carregouRegistro(reg) && !Funcoes.textoVazio(configuracaoLabExterno = reg.getString("lae_configuracao")) && this.isEnvioWS(configuracaoLabExterno).booleanValue() && this.isEnvioPelaRequisicao(configuracaoLabExterno).booleanValue()) {
            return reg.getBoolean("haexame");
        }
        return false;
    }

    private boolean carregouRegistro(Registro reg) {
        return reg != null;
    }

    private Boolean isEnvioPelaRequisicao(String configuracaoLabExterno) {
        return !Funcoes.textoVazio(StringUtil.getValor(configuracaoLabExterno, "envioAutomatico")) ? Boolean.valueOf(StringUtil.getValor(configuracaoLabExterno, "envioAutomatico")) : Boolean.FALSE;
    }

    private Boolean isEnvioWS(String configuracaoLabExterno) {
        return !Funcoes.textoVazio(StringUtil.getValor(configuracaoLabExterno, "enviarLoteWebService")) ? Boolean.valueOf(StringUtil.getValor(configuracaoLabExterno, "enviarLoteWebService")) : Boolean.FALSE;
    }

    public List<Registro> verificaExamesComLote(String filial, String requisicao, String[] exames, int[] materiais, Statement st) throws SQLException {
        return this.dao.verificaExamesComLote(filial, requisicao, exames, materiais, st);
    }

    public void atualizarCodigoApoiadoExameRequisicao(Registro regExa, List<Registro> requisicoes, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar) throws Exception {
        String tabelaExameRequisicao = "examerequisicao";
        String tabelaExameRequisicaoRecip = "examerequisicaorecipiente";
        for (Registro reg : requisicoes) {
            if ((Funcoes.textoVazio(regExa.getString("req_codigomae")) || !reg.getString("req_codigomae").equalsIgnoreCase(regExa.getString("req_codigomae"))) && (Funcoes.textoVazio(reg.getString("req_codigomae")) || !reg.getString("req_codigomae").equalsIgnoreCase(regExa.getString("req_codigo")))) continue;
            if (this.dao.temRegistroExameRequisicao(tabelaExameRequisicao, reg, regExa.getString("exa_codigo"), regExa.getString("mco_codigo"), st)) {
                this.dao.atualizaCodigoApoiadoExameRequisicao(reg, regExa, tabelaExameRequisicao, st, isColetaWeb, arquivar);
            }
            if (!this.dao.temRegistroExameRequisicao(tabelaExameRequisicaoRecip, reg, regExa.getString("exa_codigo"), regExa.getString("mco_codigo"), st)) continue;
            this.dao.atualizaCodigoApoiadoExameRequisicao(reg, regExa, tabelaExameRequisicaoRecip, st, isColetaWeb, arquivar);
        }
    }

    public void atualizarLoteExterno(List<Registro> requisicoes, String codLabExterno, String filKodigo, String numeroLote, String etq, Statement st) throws SQLException {
        this.dao.atualizarLoteExterno(requisicoes, codLabExterno, filKodigo, numeroLote, etq, st);
    }

    public Registro requisicaoJaEnviada(Registro requisicoes, String codLabExterno, Statement st) throws SQLException {
        return this.dao.getRetornoWS(requisicoes, codLabExterno, st);
    }
}

