/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.exame.externo.saoMarcos;

import jalis.comum.Conexao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.sql.ValorIn;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;

public class ImpressaoSaoMarcosDao {
    public LaboratorioExterno localizaLabExternoSM(String filial, String[] exames, Statement st) throws SQLException {
        LaboratorioExterno labExterno = null;
        StringBuilder buf = new StringBuilder();
        buf.append("select lab.lae_codigo, lab.lae_configuracao ");
        buf.append("from labexterno lab ");
        buf.append("join examematcoletalabexterno exame ");
        buf.append("on lab.lae_codigo = exame.lae_codigo ");
        buf.append("and lab.fil_codigo = exame.fil_codigo ");
        buf.append("where lab.fil_codigo = ").append(filial);
        buf.append(" and lab.lae_protocolo = '").append((Object)Protocolo.SaoMarcos).append("' ").append(" and (lab.lae_inativo is null or not lab.lae_inativo) ");
        buf.append("and exame.exa_codigo in (").append(this.createCondicaoExames(exames)).append(")");
        LaboratorioExterno[] listas = LaboratorioExterno.getDescricoes(st, false);
        st.setPoolable(true);
        ResultSet rs = st.executeQuery(buf.toString());
        while (rs.next()) {
            boolean enviarPorWebService = false;
            if (!Funcoes.textoVazio(rs.getString("lae_configuracao")) && !Funcoes.textoVazio(StringUtil.getValor(rs.getString("lae_configuracao"), "enviarLoteWebService"))) {
                enviarPorWebService = StringUtil.getBoolean(rs.getString("lae_configuracao"), "enviarLoteWebService");
            }
            if (!enviarPorWebService) continue;
            for (LaboratorioExterno laboratorioExterno : listas) {
                if (!laboratorioExterno.codigoLab.equals(rs.getString("lae_codigo"))) continue;
                labExterno = laboratorioExterno;
            }
        }
        return labExterno;
    }

    private String createCondicaoExames(String[] exames) {
        StringBuilder condicao = new StringBuilder();
        for (String exame : exames) {
            condicao.append("'").append(exame).append("',");
        }
        condicao.deleteCharAt(condicao.length() - 1);
        return condicao.toString();
    }

    public Registro haExamesParaEnviarSM(String filial, String requisicao, String[] exames, Statement st) {
        Registro reg = null;
        try {
            ValorIn exa = ValorIn.criar(exames);
            Object[] multiguia = RecepcaoUtil.verificaMultiGuias(st, filial, requisicao, true, false);
            Arrays.sort(multiguia);
            String guias = StringUtil.implode(Arrays.asList(multiguia), ",");
            StringBuilder buf = new StringBuilder();
            buf.append(" select lab.lae_configuracao, (lote.lex_codigo is null or lr.leq_retornows is null) as haExame ");
            buf.append("   from examerequisicao exr ");
            buf.append("   join requisicao req on exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo ");
            buf.append("   join examematcoletalabexterno ele on exr.fil_codigo = ele.fil_codigo and exr.exa_codigo = ele.exa_codigo and exr.mco_codigo = ele.mco_codigo ");
            buf.append(" left join loteexternorequisicao lr on lr.fil_codigo = req.fil_codigo and lr.req_codigo = req.req_codigo ");
            buf.append(" left join labexterno lab on ele.fil_codigo = lab.fil_codigo and ele.lae_codigo = lab.lae_codigo ");
            buf.append(" left join loteexternoexamerequisicao lote on exr.fil_codigo = lote.fil_codigo and exr.exa_codigo = lote.exa_codigo and exr.mco_codigo = lote.mco_codigo and exr.req_codigo = lote.req_codigo and exr.fil_Codigo = lote.fil_codigo ");
            buf.append("  where exr.fil_codigo = ").append(filial);
            buf.append("    and req.req_codigo IN (").append(guias).append(") ");
            buf.append("    and lr.leq_dataestorno is null ");
            buf.append("    and not req.req_excluida ");
            buf.append("    and not exr.exr_excluido ");
            buf.append("    and (lote.lex_codigo is null or lr.leq_retornows is null) ");
            buf.append("    and exr.exr_dataloteexterno is null");
            buf.append("    and lab.lae_protocolo = '").append((Object)Protocolo.SaoMarcos).append("' ");
            buf.append("    and (lab.lae_inativo is null or not lab.lae_inativo) ");
            buf.append("    and exr.exa_codigo in (").append(exa).append(")");
            ResultSet rs = st.executeQuery(buf.toString());
            if (rs.next()) {
                reg = new Registro(rs);
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e2o foi poss\u00edvel verificiar multiguia no carregamento de lote.\n" + e.getMessage(), e.getStackTrace());
        }
        return reg;
    }

    public List<Registro> verificaExamesComLote(String filial, String requisicao, String[] exames, int[] materiais, Statement st) throws SQLException {
        ArrayList<Registro> lista = new ArrayList<Registro>();
        ValorIn exa = ValorIn.criar(exames);
        ValorIn mat = ValorIn.criar(materiais);
        StringBuilder buf = new StringBuilder();
        String guias = requisicao;
        Integer[] multiguia = null;
        multiguia = RecepcaoUtil.verificaMultiGuias(st, filial, requisicao, true, false);
        guias = StringUtil.implode(Arrays.asList(multiguia), ",");
        buf.append("select lot.lex_codigo, lotex.exa_codigo as codigoExame, ");
        buf.append("       lotex.mco_codigo as codigoMaterial, ");
        buf.append("       lot.leq_retornows as retornoWs");
        buf.append("  from loteexternorequisicao lot ");
        buf.append("  join loteexternoexamerequisicao lotex on lot.fil_codigo = lotex.fil_codigo and lot.req_codigo = lotex.req_codigo and lot.lex_codigo = lotex.lex_codigo ");
        buf.append(" where lot.fil_kodigo = ").append(filial);
        buf.append("   and lot.req_codigo in (").append(guias).append(") ");
        buf.append("   and lot.leq_retornows is not null ");
        buf.append("   and lot.leq_dataestorno is null ");
        buf.append("   and lotex.exa_codigo IN (").append(exa.toString()).append(" )");
        buf.append("   and lotex.mco_codigo IN ( ").append(((Object)mat).toString()).append(" )");
        ResultSet rs = st.executeQuery(buf.toString());
        Registro reg = null;
        while (rs.next()) {
            reg = new Registro(rs);
            lista.add(reg);
        }
        return lista;
    }

    public void atualizaCodigoApoiadoExameRequisicao(Registro reg, Registro regExa, String tabela, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        sql.append(" update ").append(tabela).append(" set ").append(this.getCampoApoiado(tabela)).append(" = ").append(regExa.getString("codigoApoioSaoMarcos"));
        sql.append(" where fil_codigo = ").append(reg.getString("fil_codigo"));
        sql.append("   and req_codigo = ").append(reg.getString("req_codigo"));
        sql.append("   and exa_codigo = '").append(regExa.getString("exa_codigo")).append("' ");
        sql.append(" and mco_codigo = ").append(regExa.getString("mco_codigo"));
        if (isColetaWeb) {
            st.executeUpdate(sql.toString());
        } else {
            Conexao.executeUpdate(regExa.getString("fil_codigo"), st, sql);
        }
        arquivar.call();
    }

    public boolean temRegistroExameRequisicao(String tabela, Registro req, String exame, String material, Statement st) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        sql.append(" select ").append(this.getCampoApoiado(tabela)).append(" from ").append(tabela);
        sql.append(" where fil_codigo = ").append(req.getString("fil_codigo"));
        sql.append(" and req_codigo =  ").append(req.getString("req_codigo"));
        sql.append(" and exa_codigo = '").append(exame).append("' ");
        ResultSet rs = st.executeQuery(sql.toString());
        return rs.next();
    }

    private String getCampoApoiado(String tabela) {
        if (tabela.equalsIgnoreCase("examerequisicaorecipiente")) {
            return "ere_codigoapoiado";
        }
        return "exr_codigoapoiado";
    }

    public void atualizarLoteExterno(List<Registro> requisicoes, String codLabExterno, String filKodigo, String numeroLote, String etq, Statement st) throws SQLException {
        for (Registro reg : requisicoes) {
            StringBuilder sqlpdate = new StringBuilder();
            sqlpdate.append(" update  loteexternorequisicao set leq_retornows = E'").append(StringUtil.textoDB(etq)).append("'");
            sqlpdate.append(" where fil_codigo = ").append(filKodigo);
            sqlpdate.append(" and lae_codigo = ").append(codLabExterno);
            sqlpdate.append(" and req_codigo = ").append(reg.getString("req_codigo"));
            sqlpdate.append(" and fil_kodigo = ").append(reg.getString("fil_codigo"));
            sqlpdate.append(" and lex_codigo = ").append(numeroLote);
            st.executeUpdate(sqlpdate.toString());
        }
    }

    public Registro getRetornoWS(Registro reg, String codigoLabExterno, Statement st) throws SQLException {
        StringBuilder sql = new StringBuilder();
        Registro retorno = null;
        sql.append(" select (case when (count(1) > 0) then 'POST' else 'PUT' end) as metodoEnvio, lex_codigo, leq_retornows from loteexternorequisicao ");
        sql.append("  where fil_kodigo = ").append(reg.getString("fil_codigo"));
        sql.append("    and req_codigo = ").append(reg.getString("req_codigomae"));
        sql.append("    and lae_codigo = ").append(codigoLabExterno);
        sql.append("    and leq_retornows is not null ");
        sql.append("  group by lex_codigo, leq_retornows ");
        ResultSet rs = st.executeQuery(sql.toString());
        if (rs.next()) {
            retorno = new Registro();
            retorno.setValor("metodoEnvio", rs.getString("metodoEnvio"));
            retorno.setValor("lex_codigo", rs.getString("lex_codigo"));
            retorno.setValor("leq_retornows", rs.getString("leq_retornows"));
        }
        return retorno;
    }
}

