/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.exame.externo.saoMarcos;

import jalis.laboratorio.impressao.ImpressaoException;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.InfoComplementar;
import jalis.laboratorio.triagem.externo.exportadores.saoMarcos.ExportacaoSaoMarcos;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.exame.ExameMaterial;
import jalis.laboratorio.util.impressao.exame.ExameRequisicaoListHandler;
import jalis.laboratorio.util.impressao.exame.ImpressaoExame;
import jalis.laboratorio.util.impressao.exame.externo.ImpressaoVO;
import jalis.laboratorio.util.impressao.exame.externo.saoMarcos.ConexaoSaoMarcos;
import jalis.laboratorio.util.impressao.exame.externo.saoMarcos.ImpressaoSaoMarcosService;
import jalis.laboratorio.util.impressao.exame.externo.saoMarcos.LoteSaoMarcos;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.util.StringUtil;
import jalis.util.impressao.termica.ImpressaoTermica;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class ImpressaoSaoMarcos
implements ImpressaoExame {
    private final ExameRequisicaoListHandler handler;
    private final ImpressaoSaoMarcosService service;
    private final LoteSaoMarcos lote;
    private ConexaoSaoMarcos conexao;
    private static final String ETIQUETA = "etiquetas";
    private static final String RETORNO = "retornows";

    public ImpressaoSaoMarcos(ExportacaoSaoMarcos sm, LoteSaoMarcos lote, ExameRequisicaoListHandler handler, ImpressaoSaoMarcosService service) {
        this.handler = handler;
        this.service = service;
        this.lote = lote;
        this.conexao = new ConexaoSaoMarcos();
    }

    @Override
    public RetornoImpressaoEtiquetas imprimir(boolean isColetaWeb, ImpressaoVO dados, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean agruparGuiasInterface, String filialPadrao, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, ImpressorasLabExterno impressoras, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar, int casasPrecoExame, RoundingMode arredondamentoPrecoExame) throws ImpressaoException {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        String filial = String.valueOf(dados.filial);
        ArrayList<ExameMaterial> impressos = new ArrayList<ExameMaterial>();
        LaboratorioExterno labExterno = this.buscarLabExterno(filial, dados.getListaExameRequisicaoVO(), st);
        String requisicao = String.valueOf(dados.getRequisicaoPai());
        int[] materiais = this.toIntArray(dados.getMateriais());
        String[] examesString = dados.getExames().toArray(new String[0]);
        int tipoEtq = dados.getTipoEtiqueta();
        if (this.conexao.validaToken(filial, labExterno, st, isColetaWeb)) {
            retorno = this.lote.criarLoteFilialExame(isColetaWeb, labExterno, filial, requisicao, examesString, materiais, tipoEtq, agruparGuiasInterface, st, filialPadrao, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, digitosTuboFilial, digitosTuboRequisicao, tipoExportacaoInterface, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, tipoEtiquetaSoroteca, retorno, arquivar, anular, mapInfoComplementar);
            impressos.addAll(retorno.getExames());
        }
        if (impressos.isEmpty() && dados.reimprimir) {
            impressos.addAll(this.reimprimirEtq(filial, requisicao, materiais, examesString, labExterno.configuracao, isColetaWeb, impressoras.getImpressoraSaoMarcos(), tamanhoNomeImpressora, impressorasLocais, st, retorno, arquivar, anular).getExames());
        }
        retorno.setExames(impressos);
        return retorno;
    }

    @Override
    public RetornoImpressaoEtiquetas imprimirPadrao(boolean isColetaWeb, ImpressaoVO dados, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean agruparGuiasInterface, String filialPadrao, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, ImpressorasLabExterno impressoras, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar, int casasPrecoExame, RoundingMode arredondamentoPrecoExame) throws ImpressaoException {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        String filial = String.valueOf(dados.filial);
        ArrayList<ExameMaterial> impressos = new ArrayList<ExameMaterial>();
        LaboratorioExterno labExterno = this.buscarLabExterno(filial, dados.getListaExameRequisicaoVO(), st);
        String requisicao = String.valueOf(dados.getRequisicaoPai());
        int[] materiais = this.toIntArray(dados.getMateriais());
        String[] examesString = dados.getExames().toArray(new String[0]);
        int tipoEtq = dados.getTipoEtiqueta();
        if (this.conexao.validaToken(filial, labExterno, st, isColetaWeb)) {
            retorno = this.lote.criarLotePadraoExame(isColetaWeb, labExterno, filial, requisicao, examesString, materiais, tipoEtq, agruparGuiasInterface, st, filialPadrao, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, digitosTuboFilial, digitosTuboRequisicao, tipoExportacaoInterface, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, tipoEtiquetaSoroteca, retorno, arquivar, anular, mapInfoComplementar);
            impressos.addAll(retorno.getExames());
            if (impressos.isEmpty() && dados.reimprimir) {
                impressos.addAll(this.reimprimirEtq(filial, requisicao, materiais, examesString, labExterno.configuracao, isColetaWeb, impressoras.getImpressoraSaoMarcos(), tamanhoNomeImpressora, impressorasLocais, st, retorno, arquivar, anular).getExames());
            }
        }
        retorno.setExames(impressos);
        return retorno;
    }

    private RetornoImpressaoEtiquetas reimprimirEtq(String filial, String requisicao, int[] materiais, String[] examesString, String configLabExterno, boolean isColetaWeb, String impressora, String tamanhoNomeImpressora, String[] impressorasLocais, Statement st, RetornoImpressaoEtiquetas retornoEtq, Callable<Boolean> arquivar, Callable<Boolean> anular) throws ImpressaoException {
        ArrayList<ExameMaterial> impressos = new ArrayList<ExameMaterial>();
        ArrayList<Object> etqs = new ArrayList<Object>();
        try {
            XMLStringBuilder retorno = new XMLStringBuilder();
            List<Registro> examesComLote = this.service.verificaExamesComLote(filial, requisicao, examesString, materiais, st);
            if (this.carregouExames(examesComLote)) {
                for (Registro exa : examesComLote) {
                    String[] etiquetas = StringUtil.getValores(exa.getString(RETORNO), ETIQUETA);
                    String etq = this.getTodasEtq(etiquetas);
                    retorno.escrever(ETIQUETA, etq);
                    ExameMaterial exameMaterial = new ExameMaterial(exa.getString("codigoExame".toLowerCase()), exa.getInt("codigoMaterial".toLowerCase()));
                    impressos.add(exameMaterial);
                }
                etqs.add(this.imprimirEtqSM(retorno.toString(), isColetaWeb, impressora, tamanhoNomeImpressora, impressorasLocais, st, arquivar, anular));
            }
        }
        catch (Exception e) {
            throw new ImpressaoException(e.getMessage());
        }
        etqs.addAll(retornoEtq.getEtiquetasLabExterno() != null && !retornoEtq.getEtiquetasLabExterno().isEmpty() ? (Collection)retornoEtq.getEtiquetasLabExterno().get("saomarcos") : new ArrayList());
        HashMap<String, List<byte[]>> etiquetasLab = new HashMap<String, List<byte[]>>();
        etiquetasLab.put("saomarcos", etqs);
        retornoEtq.setEtiquetasLabExterno(etiquetasLab);
        retornoEtq.setExames(impressos);
        return retornoEtq;
    }

    private boolean carregouExames(List<Registro> examesComLote) {
        return examesComLote != null && !examesComLote.isEmpty();
    }

    private String getTodasEtq(String[] etiquetas) {
        StringBuilder buff = new StringBuilder();
        for (String e : etiquetas) {
            buff.append(e);
        }
        return buff.toString();
    }

    private byte[] imprimirEtqSM(String retorno, boolean isColetaWeb, String impressora, String tamanhoNomeImpressora, String[] impressorasLocais, Statement st, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(impressora, tamanhoNomeImpressora, impressorasLocais), isColetaWeb);
        String[] etiquetas = StringUtil.getValores(retorno.toString(), ETIQUETA);
        String etiqueta = StringUtil.implode(this.removeEtiquetaDuplicada(etiquetas), " ");
        return termica.imprimirDireto(etiqueta, true, st, isColetaWeb, arquivar, anular);
    }

    private ArrayList<String> removeEtiquetaDuplicada(String[] etiquetas) {
        ArrayList<String> novaEtiqueta = new ArrayList<String>();
        for (String etq : etiquetas) {
            if (novaEtiqueta.contains(etq)) continue;
            novaEtiqueta.add(etq);
        }
        return novaEtiqueta;
    }

    private LaboratorioExterno buscarLabExterno(String filial, List<ExameRequisicaoVO> examesRequisicao, Statement st) throws ImpressaoException {
        LaboratorioExterno labExterno = null;
        try {
            List<String> exames = this.handler.extrairExames(examesRequisicao);
            String[] arrayExames = exames.toArray(new String[0]);
            labExterno = this.service.localizaLabExternoSM(String.valueOf(filial), arrayExames, st);
        }
        catch (SQLException e) {
            throw new ImpressaoException("Erro ao localizar laboratorio externo\n" + e.getMessage(), e);
        }
        return labExterno;
    }

    public int[] toIntArray(List<Integer> dados) {
        int[] resultado = new int[dados.size()];
        int index = 0;
        for (Integer dado : dados) {
            resultado[index] = dado;
            ++index;
        }
        return resultado;
    }
}

