/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.exame.externo.saoMarcos;

import com.fasterxml.jackson.databind.ObjectMapper;
import jalis.comum.Conexao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.ProcessaErroRetornoWebServiceLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.VisualizaErroRetornoWebService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;

public class ConexaoSaoMarcos {
    private static final String STATUS_FALSE = "false";
    private static final String SENHA_INVALIDA = "Senha";

    public boolean validaToken(String filial, LaboratorioExterno labExterno, Statement st, boolean isColetaWeb) {
        try {
            String config = labExterno.configuracao;
            String novoToken = this.getToken(config);
            if (Funcoes.textoVazio(novoToken) || !this.retornoValido(novoToken)) {
                return false;
            }
            this.atualizaToken(novoToken, config, labExterno, st, isColetaWeb);
        }
        catch (Exception e) {
            ProcessaErroRetornoWebServiceLabExterno erroRetornoWebServiceLabExterno = new ProcessaErroRetornoWebServiceLabExterno("N\u00e3o foi possivel atualizar os dados do Lab. Externo \n" + e.getMessage(), e.getStackTrace());
            VisualizaErroRetornoWebService.novaInstancia(Laboratorio.getInstancia(), "Mensagens ao atualizar dados.", erroRetornoWebServiceLabExterno, false, "S\u00e3o Marcos");
            return false;
        }
        return true;
    }

    public boolean retornoValido(String novoToken) {
        if (novoToken.contains(STATUS_FALSE)) {
            if (this.isSenhaInvalida(novoToken)) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel obter conex\u00e3o com o Laborat\u00f3rio S\u00e3o Marcos.\nSenha inv\u00e1lida", 2);
            } else {
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel obter conex\u00e3o com o Laborat\u00f3rio S\u00e3o Marcos.\nServi\u00e7o solicitante n\u00e3o encontrado", 2);
            }
            return false;
        }
        return true;
    }

    private boolean isSenhaInvalida(String novoToken) {
        return novoToken.contains(SENHA_INVALIDA);
    }

    private boolean isTokenValido(String validade) {
        return Funcoes.comparaData(validade, this.getNewDate()) >= 0;
    }

    public String enviaXML(String config, String xmlEnvio) throws IOException {
        String retorno = "";
        String endWS = StringUtil.getValor(config, "enderecoWebService");
        String token = StringUtil.getValor(config, "chave").replaceAll("\"", "");
        if (!Funcoes.textoVazio(endWS)) {
            URL url = new URL(endWS + "/amostra");
            HttpClient httpclient = new HttpClient();
            PostMethod post = new PostMethod(url.toString());
            post.setRequestHeader("X-AUTH-TOKEN", "{" + token + "}");
            StringRequestEntity sre = new StringRequestEntity(xmlEnvio, "application/xml", "UTF-8");
            post.setRequestEntity((RequestEntity)sre);
            int response = httpclient.executeMethod((HttpMethod)post);
            retorno = post.getResponseBodyAsString();
        }
        return retorno;
    }

    public String getToken(String config) {
        String token = "";
        String endWS = StringUtil.getValor(config, "enderecoWebService");
        String login = StringUtil.getValor(config, "codigo");
        String senha = StringUtil.getValor(config, "senha");
        try {
            if (!Funcoes.textoVazio(endWS)) {
                int c;
                HttpURLConnection conn = null;
                URL url = new URL(endWS + "/sessao");
                ObjectMapper mapper = new ObjectMapper();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("login", login);
                params.put("senha", senha);
                String jsonSaoMarcos = mapper.writeValueAsString(params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setDoOutput(true);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "application/json");
                OutputStream os = conn.getOutputStream();
                os.write(jsonSaoMarcos.getBytes());
                os.flush();
                BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
                while ((c = ((Reader)in).read()) >= 0) {
                    String caracter = Character.toString((char)c);
                    if (!this.ignoraChaves(caracter)) continue;
                    token = token + (char)c;
                }
            }
        }
        catch (IOException e) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel obter a chave de acesso.", 2);
        }
        return token;
    }

    public void atualizaToken(String novoToken, String config, LaboratorioExterno labExterno, Statement st, boolean isColetaWeb) throws Exception {
        StringBuilder xml = new StringBuilder(config);
        StringUtil.setValor(xml, "chave", novoToken);
        StringUtil.setValor(xml, "validadeChave", this.getNewDate());
        labExterno.setConfiguracao(xml.toString());
        labExterno.salvarConfiguracao(st, isColetaWeb);
        if (!isColetaWeb) {
            Conexao.arquivaSQL();
        }
    }

    private boolean ignoraChaves(String caracter) {
        return !caracter.equals("{") && !caracter.equals("}");
    }

    private String getNewDate() {
        return Funcoes.formataData("dd/MM/yyyy", new Date());
    }

    public String getRequisicaoResultado(String config, String end) throws IOException {
        String retorno = "";
        String token = StringUtil.getValor(config, "chave").replaceAll("\"", "");
        if (!Funcoes.textoVazio(end)) {
            URL url = new URL(end);
            HttpClient httpclient = new HttpClient();
            GetMethod get = new GetMethod(url.toString());
            get.setRequestHeader("X-AUTH-TOKEN", "{" + token + "}");
            int response = httpclient.executeMethod((HttpMethod)get);
            retorno = get.getResponseBodyAsString();
        }
        return retorno;
    }
}

