/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.exame.externo.redews;

import jalis.laboratorio.impressao.ImpressaoException;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.InfoComplementar;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.triagem.externo.exportadores.redews.ExportacaoParaRedeWS;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.exame.ExameMaterial;
import jalis.laboratorio.util.impressao.exame.ExameRequisicaoListHandler;
import jalis.laboratorio.util.impressao.exame.externo.CarregarExameRequisicaoFilial;
import jalis.laboratorio.util.impressao.exame.externo.ImpressaoVO;
import jalis.laboratorio.util.impressao.exame.externo.redews.LoteRedeWSDao;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.util.impressao.termica.ImpressaoTermica;
import jalis.util.tabela.Registro;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class LoteRedeWS {
    private final ExportacaoParaRedeWS exportacaoParaRedeWS = new ExportacaoParaRedeWS();
    private final ExameRequisicaoListHandler handler = new ExameRequisicaoListHandler();
    private final LoteRedeWSDao dao = new LoteRedeWSDao();

    public RetornoImpressaoEtiquetas criarLote(boolean isColetaWeb, ImpressaoVO dados, boolean agruparGuiasInterface, Statement st, String filialPadrao, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, int digitosTuboFilial, int digitosTuboRequisicao, String tipoExportacaoInterface, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar) throws ImpressaoException {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        ArrayList<Object> etiquetas = new ArrayList<Object>();
        ArrayList<ExameMaterial> impressos = new ArrayList<ExameMaterial>();
        String requisicao = this.handler.extrairRequisicaoPai(dados.getListaExameRequisicaoVO());
        int codigoLote = 0;
        FilialVO filial = dados.getListaExameRequisicaoVO().stream().map(exame -> exame.getFilial()).findFirst().orElse(new FilialVO());
        String[] exames = dados.getExames().toArray(new String[0]);
        int[] materiais = this.toIntArray(dados.getMateriais());
        LaboratorioExterno labExterno = this.dao.pesquisarLabExterno(filial.getCodigo().toString(), exames, st, anular);
        try {
            if (LoteRedeWSDao.examesParaEnviar(filial.getCodigo().toString(), requisicao, exames, materiais, st)) {
                this.exportacaoParaRedeWS.setTipoEtiqueta(dados.tipoEtiqueta);
                CarregarExameRequisicaoFilial carregarExameRequisicao = new CarregarExameRequisicaoFilial(this.exportacaoParaRedeWS);
                List<Registro> registrosRequisicoes = carregarExameRequisicao.carregar(isColetaWeb, requisicao, filial.getCodigo().toString(), labExterno, dados.tipoEtiqueta, agruparGuiasInterface, st, filialPadrao, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, digitosTuboFilial, digitosTuboRequisicao, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, arquivar, anular);
                List<Registro> examesLabRede = this.removerExamesDeOutrosLaboratorios(registrosRequisicoes, st, anular);
                retorno = this.exportacaoParaRedeWS.criarLote(examesLabRede, this.etiquetaSelecionada(dados.tipoEtiqueta), isColetaWeb, agruparInterface, st, stEtq2, stEtq3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, retorno, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar);
                codigoLote = retorno.getCodigoLote();
            }
        }
        catch (Exception e) {
            throw new ImpressaoException("Erro ao criar lote RedeWS\n" + e.getMessage(), e);
        }
        if (codigoLote < 1) {
            List<ExameRequisicaoVO> examesEnviados = this.dao.pesquisarExamesJaEnviados(filial.getCodigo().toString(), requisicao, labExterno.codigoLab, st, anular);
            int i = 0;
            exames = new String[examesEnviados.size()];
            materiais = new int[examesEnviados.size()];
            for (ExameRequisicaoVO exame2 : examesEnviados) {
                exames[i] = exame2.getExame().getCodigo();
                materiais[i] = exame2.getMaterial().getCodigo();
                ++i;
            }
            if (exames.length > 0) {
                etiquetas.add(this.imprimirEtiquetaRedeWS(filial.getCodigo().toString(), requisicao, exames, materiais, impressoras.getImpressoraRedeWS(), tamanhoNomeImpressora, impressorasLocais, st, isColetaWeb, arquivar, anular));
            }
        }
        impressos.addAll(this.buscarExamesComLote(filial.getCodigo().toString(), requisicao, exames, materiais, agruparInterface, st));
        etiquetas.addAll(retorno.getEtiquetasLabExterno() != null && !retorno.getEtiquetasLabExterno().isEmpty() ? (Collection)retorno.getEtiquetasLabExterno().get("redews") : new ArrayList());
        HashMap<String, List<byte[]>> etiquetasLab = new HashMap<String, List<byte[]>>();
        etiquetasLab.put("redews", etiquetas);
        retorno.setEtiquetasLabExterno(etiquetasLab);
        retorno.setExames(impressos);
        return retorno;
    }

    private List<Registro> removerExamesDeOutrosLaboratorios(List<Registro> registrosRequisicoes, Statement st, Callable<Boolean> anular) {
        ArrayList<Registro> requisicoes = new ArrayList<Registro>();
        for (Registro requisicao : registrosRequisicoes) {
            ArrayList<Registro> examesLabRede = new ArrayList<Registro>();
            List exames = (List)requisicao.getValor("listaexames");
            for (Registro exame : exames) {
                Integer codLabPadrao = this.dao.pesquisarLabExternoPadraoDoExame(exame.getString("fil_codigo"), exame.getString("exa_codigo"), exame.getString("mco_codigo"), st, anular);
                if (codLabPadrao == 0 || codLabPadrao.intValue() != exame.getInt("lae_codigo")) continue;
                examesLabRede.add(exame);
            }
            requisicao.setValor("listaexames", examesLabRede);
            requisicoes.add(requisicao);
        }
        return requisicoes;
    }

    private boolean etiquetaSelecionada(int tipoEtiqueta) {
        return tipoEtiqueta == 3 || tipoEtiqueta == 4;
    }

    private List<ExameMaterial> buscarExamesComLote(String filial, String requisicao, String[] exames, int[] materiais, int agruparInterface, Statement st) {
        ArrayList<ExameMaterial> listaExamesNaoImprimir = new ArrayList<ExameMaterial>();
        ArrayList<Registro> examesComLote = UtilExportadores.verificaExamesComLote(filial, requisicao, exames, materiais, agruparInterface, st);
        for (Registro r : examesComLote) {
            ExameMaterial exameMaterial = new ExameMaterial(r.getString("codigoExame".toLowerCase()), r.getInt("codigoMaterial".toLowerCase()));
            if (listaExamesNaoImprimir.contains(exameMaterial)) continue;
            listaExamesNaoImprimir.add(exameMaterial);
        }
        return listaExamesNaoImprimir;
    }

    private byte[] imprimirEtiquetaRedeWS(String filial, String requisicao, String[] exames, int[] materiais, String impressora, String tamanhoNomeImpressora, String[] impressorasLocais, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        byte[] retorno = new byte[]{};
        ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(impressora, tamanhoNomeImpressora, impressorasLocais), isColetaWeb);
        StringBuilder etiquetasImpressao = new StringBuilder();
        Set<String> etiquetas = this.dao.recuperarEtiquetasRedeWS(filial, requisicao, exames, materiais, st, anular);
        if (null != etiquetas && !etiquetas.isEmpty()) {
            for (String etiqueta : etiquetas) {
                etiqueta = etiqueta.substring(10, etiqueta.length() - 11);
                etiquetasImpressao.append(etiqueta);
            }
            retorno = termica.imprimirDireto(etiquetasImpressao.toString(), true, st, isColetaWeb, arquivar, anular);
        }
        return retorno;
    }

    private int[] toIntArray(List<Integer> materiais) {
        int[] resultado = new int[materiais.size()];
        int index = 0;
        for (Integer material : materiais) {
            resultado[index] = material;
            ++index;
        }
        return resultado;
    }
}

