/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.exame.externo.pardini;

import jalis.comum.ParametrosLocais;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.InterfaceDesmembrar;
import jalis.laboratorio.triagem.externo.exportadores.ExportacaoParaHPardini;
import jalis.laboratorio.triagem.externo.exportadores.InfoComplementar;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.exame.ExameMaterial;
import jalis.laboratorio.util.impressao.exame.ListaExameMaterial;
import jalis.laboratorio.util.impressao.exame.externo.pardini.DaoLotePardini;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.impressao.sql.ValorIn;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.impressao.termica.ImpressaoTermica;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.print.PrintService;

public class LotePardini {
    private final DaoLotePardini dao;
    private int numeroLote = -1;

    public LotePardini(DaoLotePardini dao) {
        this.dao = dao;
    }

    public RetornoImpressaoEtiquetas criarLote(List<Registro> listaRequisicoes, String filial, String requisicao, ListaExameMaterial<ExameMaterial> examesImpressos, boolean isColetaWeb, int tipoEtiqueta, ArrayList<InterfaceDesmembrar> examesDesm, boolean agruparGuiasInterface, Statement st, String filialPadrao, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, int digitosTuboFilial, int digitosTuboRequisicao, String tipoExportacaoInterface, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, RetornoImpressaoEtiquetas retorno, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar) {
        ListaExameMaterial<ExameMaterial> impressos = new ListaExameMaterial();
        ArrayList<Integer> listaLotesImpressos = new ArrayList<Integer>();
        retorno = this.exportarLote(tipoEtiqueta, listaRequisicoes, examesDesm, isColetaWeb, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, imprimirEtiquetaTriagemSemMaterial, agruparGuiasInterface, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar);
        impressos = this.getExamesComLoteImpresso(examesImpressos, listaLotesImpressos, listaRequisicoes, st);
        retorno.setExamesMaterial(impressos);
        return retorno;
    }

    private ListaExameMaterial<ExameMaterial> getExamesComLoteImpresso(ListaExameMaterial<ExameMaterial> examesImpressos, ArrayList<Integer> listaLotesImpressos, List<Registro> listaRequisicoes, Statement st) {
        ListaExameMaterial<ExameMaterial> impressos = new ListaExameMaterial<ExameMaterial>();
        for (Registro registroRequisicao : listaRequisicoes) {
            ArrayList listaExamesRequisicao = (ArrayList)registroRequisicao.getValor("backupListaExames");
            ArrayList<Registro> listaExamesLotesImpressos = DaoLotePardini.verificaExamesComLote(registroRequisicao.getString("fil_codigo"), registroRequisicao.getString("req_codigo"), listaExamesRequisicao, st);
            block1: for (Registro exa : listaExamesRequisicao) {
                for (Registro exaImpresso : listaExamesLotesImpressos) {
                    if (!this.isImpresso(exa, exaImpresso)) continue;
                    impressos.addAll(this.getExamesImpressos(exa, registroRequisicao));
                    continue block1;
                }
            }
        }
        return impressos;
    }

    private ListaExameMaterial<ExameMaterial> getExamesImpressos(Registro exa, Registro registro) {
        ListaExameMaterial listaHp = (ListaExameMaterial)registro.getValor("examesHermesPardini");
        ListaExameMaterial<ExameMaterial> listaAux = new ListaExameMaterial<ExameMaterial>();
        if (listaHp != null) {
            for (ExameMaterial exameMaterial : listaHp) {
                if (!exa.getString("exa_codigo").equalsIgnoreCase(exameMaterial.getCodigoExame()) || exa.getInt("mco_codigo") != exameMaterial.getCodigoMaterial().intValue() || !exa.getString("lae_codigo").equalsIgnoreCase(exameMaterial.getCodigoLabExterno())) continue;
                listaAux.add(exameMaterial);
            }
        }
        return listaAux;
    }

    private boolean isImpresso(Registro registroRequisicao, Registro exaImpresso) {
        boolean isImpresso = false;
        if (registroRequisicao.getString("exa_codigo").equalsIgnoreCase(exaImpresso.getString("exa_codigo")) && registroRequisicao.getString("mco_codigo").equalsIgnoreCase(exaImpresso.getString("mco_codigo"))) {
            isImpresso = true;
        }
        return isImpresso;
    }

    private RetornoImpressaoEtiquetas exportarLote(int tipoEtiqueta, List<Registro> listaRequisicoes, ArrayList<InterfaceDesmembrar> examesDesm, boolean isColetaWeb, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean agruparGuiasInterface, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar) {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        ExportacaoParaHPardini hp = new ExportacaoParaHPardini();
        hp.setTipoEtiqueta(tipoEtiqueta);
        hp.setCondicaoExamesDesm(examesDesm);
        ExportacaoParaHPardini.gravaSolicitanteExame(listaRequisicoes);
        retorno = hp.criarLote(listaRequisicoes, false, isColetaWeb, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, retorno, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar);
        this.numeroLote = retorno.getCodigoLote();
        return retorno;
    }

    private ArrayList<Registro> getExames(Registro registro) {
        return (ArrayList)registro.getValor("listaexames");
    }

    private static void verificaExamesJaEnviados(List<ExameMaterial> examesImpressos, ArrayList<Registro> listaExamesLotes, ArrayList<Integer> listaLotesImpressos, boolean imprimir) {
        if (listaExamesLotes != null && !listaExamesLotes.isEmpty()) {
            String imp = ParametrosLocais.getParametro("impressoraWebServiceHp");
            PrintService service = Funcoes.localizarImpressora(imp);
            ArrayList<String> etiquetas = new ArrayList<String>();
            for (int i = 0; i < listaExamesLotes.size(); ++i) {
                String[] recipientes;
                if (listaLotesImpressos.contains(listaExamesLotes.get(i).getInt("lex_codigo"))) {
                    ExameMaterial mat = new ExameMaterial(listaExamesLotes.get(i).getString("exa_codigo"), listaExamesLotes.get(i).getInt("mco_codigo"), null, null, null, null, null, null, null, 0, 0, null, null, null, null, null, null, null);
                    if (examesImpressos.contains(mat)) continue;
                    examesImpressos.add(mat);
                    continue;
                }
                listaLotesImpressos.add(listaExamesLotes.get(i).getInt("lex_codigo"));
                for (String recipiente : recipientes = StringUtil.getValores(listaExamesLotes.get(i).getString("LEQ_RETORNO_WS"), "Recipiente")) {
                    ExameMaterial mat;
                    String etiqueta = StringUtil.getValor(recipiente, "EtqCodBar");
                    if (!etiquetas.contains(etiqueta)) {
                        etiquetas.add(etiqueta);
                    }
                    if (examesImpressos.contains(mat = new ExameMaterial(listaExamesLotes.get(i).getString("exa_codigo"), listaExamesLotes.get(i).getInt("mco_codigo"), null, null, null, null, null, null, null, 0, 0, null, null, null, null, null, null, null))) continue;
                    examesImpressos.add(mat);
                }
            }
            if (imprimir) {
                StringBuilder etiq = new StringBuilder();
                for (String etq : etiquetas) {
                    etiq.append(etq).append("\n");
                }
                ImpressaoTermica.imprimirDireto(service, etiq.toString(), false);
            }
        }
    }

    public RetornoImpressaoEtiquetas imprimirEtiquetaHPWS(String filial, String requisicao, String[] exames, int[] materiais, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        RetornoImpressaoEtiquetas retornoImpressao = new RetornoImpressaoEtiquetas();
        ArrayList<Object> etqs = new ArrayList<Object>();
        boolean imprimiu = false;
        StringBuilder retorno = new StringBuilder();
        String etiqueta = "";
        String impressora = ParametrosLocais.getParametro("impressoraWebServiceHp");
        ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(impressora), false);
        if (!Funcoes.textoVazio(requisicao)) {
            StringBuilder buf = new StringBuilder();
            buf.append("select distinct lot.lex_codigo, ");
            buf.append("       lot.leq_retornows as retornoWs");
            buf.append("  from loteexternorequisicao lot ");
            buf.append("  join loteexternoexamerequisicao lotex on lot.fil_codigo = lotex.fil_codigo and lot.req_codigo = lotex.req_codigo and lot.lex_codigo = lotex.lex_codigo ");
            buf.append(" where lot.fil_kodigo = ").append(filial);
            buf.append("   and lot.req_codigo in (").append(requisicao).append(") ");
            buf.append("   and lot.leq_retornows is not null ");
            buf.append("   and lot.leq_dataestorno is null ");
            if (exames != null && exames.length > 0 && materiais != null && materiais.length > 0) {
                buf.append("  and (lotex.exa_codigo, lotex.mco_codigo) IN (");
                for (int i = 0; i < exames.length; ++i) {
                    if (i > 0) {
                        buf.append(",");
                    }
                    buf.append("(").append(StringUtil.textoDBEscape(exames[i]));
                    buf.append(",").append(materiais[i]).append(")");
                }
                buf.append(" ) ");
            }
            try {
                ResultSet rs = st.executeQuery(buf.toString());
                while (rs.next()) {
                    imprimiu = true;
                    retorno.append(rs.getString("retornoWs"));
                }
                String[] etiquetas = StringUtil.getValores(retorno.toString(), "EtqCodBar");
                etiqueta = StringUtil.implode(this.removeEtiquetaDuplicada(etiquetas), " ");
                etqs.add(termica.imprimirDireto(etiqueta, true, st, isColetaWeb, arquivar, anular));
                rs.close();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e2o foi poss\u00edvel verificar lote externo.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        HashMap<String, List<byte[]>> etiquetasLab = new HashMap<String, List<byte[]>>();
        ArrayList etq = retornoImpressao.getEtiquetasLabExterno() != null && !retornoImpressao.getEtiquetasLabExterno().isEmpty() ? retornoImpressao.getEtiquetasLabExterno().get("hpardini") : new ArrayList();
        etqs.addAll(etq);
        etiquetasLab.put("hpardini", etqs);
        retornoImpressao.setEtiquetasLabExterno(etiquetasLab);
        retornoImpressao.setImprimiu(imprimiu);
        return retornoImpressao;
    }

    public RetornoImpressaoEtiquetas imprimirEtiquetaHPWSAgrupandoMultiguias(String filial, String requisicao, String[] exames, int[] materiais, Statement st, String impressora, String tamanhoNomeImpressora, String[] impressorasLocais, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        RetornoImpressaoEtiquetas retornoImpressao = new RetornoImpressaoEtiquetas();
        ArrayList<Object> etqs = new ArrayList<Object>();
        boolean imprimiu = false;
        StringBuilder retorno = new StringBuilder();
        Object[] multiguias = new Integer[]{Integer.parseInt(requisicao)};
        String etiqueta = "";
        ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(impressora, tamanhoNomeImpressora, impressorasLocais), isColetaWeb);
        try {
            multiguias = RecepcaoUtil.verificaMultiGuias(st, filial, requisicao, true, false);
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e2o foi recuperar as requisi\u00e7\u00f5es multiguia\n" + e.getMessage(), e.getStackTrace());
        }
        if (!Funcoes.textoVazio(requisicao)) {
            StringBuilder buf = new StringBuilder();
            buf.append("select distinct lot.lex_codigo, ");
            buf.append("       lot.leq_retornows as retornoWs");
            buf.append("  from loteexternorequisicao lot ");
            buf.append("  join loteexternoexamerequisicao lotex on lot.fil_codigo = lotex.fil_codigo and lot.req_codigo = lotex.req_codigo and lot.lex_codigo = lotex.lex_codigo ");
            buf.append(" where (lot.fil_codigo = ").append(filial).append(" or lot.fil_kodigo = ").append(filial).append(")");
            buf.append("   and lot.req_codigo in (").append(ValorIn.criar(multiguias).toString()).append(") ");
            buf.append("   and lot.leq_retornows is not null ");
            buf.append("   and lot.leq_dataestorno is null ");
            if (exames != null && exames.length > 0 && materiais != null && materiais.length > 0) {
                buf.append("  and (lotex.exa_codigo, lotex.mco_codigo) IN (");
                for (int i = 0; i < exames.length; ++i) {
                    if (i > 0) {
                        buf.append(",");
                    }
                    buf.append("(").append(StringUtil.textoDBEscape(exames[i]));
                    buf.append(",").append(materiais[i]).append(")");
                }
                buf.append(" ) ");
            }
            try {
                ResultSet rs = st.executeQuery(buf.toString());
                while (rs.next()) {
                    imprimiu = true;
                    retorno.append(rs.getString("retornoWs"));
                }
                String[] etiquetas = StringUtil.getValores(retorno.toString(), "EtqCodBar");
                etiqueta = StringUtil.implode(this.removeEtiquetaDuplicada(etiquetas), " ");
                etqs.add(termica.imprimirDireto(etiqueta, true, st, isColetaWeb, arquivar, anular));
                rs.close();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e2o foi poss\u00edvel verificar lote externo.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        HashMap<String, List<byte[]>> etiquetasLab = new HashMap<String, List<byte[]>>();
        ArrayList etq = retornoImpressao.getEtiquetasLabExterno() != null && !retornoImpressao.getEtiquetasLabExterno().isEmpty() ? retornoImpressao.getEtiquetasLabExterno().get("hpardini") : new ArrayList();
        etqs.addAll(etq);
        etiquetasLab.put("hpardini", etqs);
        retornoImpressao.setEtiquetasLabExterno(etiquetasLab);
        retornoImpressao.setImprimiu(imprimiu);
        return retornoImpressao;
    }

    private ArrayList<String> removeEtiquetaDuplicada(String[] etiquetas) {
        ArrayList<String> novaEtiqueta = new ArrayList<String>();
        for (String etq : etiquetas) {
            if (novaEtiqueta.contains(etq)) continue;
            novaEtiqueta.add(etq);
        }
        return novaEtiqueta;
    }

    public int getNumeroLote() {
        return this.numeroLote;
    }
}

