/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.exame.externo.pardini;

import jalis.comum.Conexao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.ConfirmarCondicaoAmostra;
import jalis.laboratorio.cadastro.InterfaceDesmembrar;
import jalis.laboratorio.impressao.ImpressaoException;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.InfoComplementar;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.exame.ExameMaterial;
import jalis.laboratorio.util.impressao.exame.ExameMaterialListHandler;
import jalis.laboratorio.util.impressao.exame.ExameRequisicaoListHandler;
import jalis.laboratorio.util.impressao.exame.ImpressaoExame;
import jalis.laboratorio.util.impressao.exame.ListaExameMaterial;
import jalis.laboratorio.util.impressao.exame.externo.ImpressaoVO;
import jalis.laboratorio.util.impressao.exame.externo.pardini.ExamePardiniDao;
import jalis.laboratorio.util.impressao.exame.externo.pardini.ImpressaoHPDirect;
import jalis.laboratorio.util.impressao.exame.externo.pardini.LotePardini;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.impressao.sql.ValorIn;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.model.utils.ThreadDaoException;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Dialog;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class ImpressaoPardini
implements ImpressaoExame {
    private static final Protocolo PROTOCOLO = Protocolo.HPardini;
    private final ExamePardiniDao examesDao;
    private final ExameRequisicaoListHandler exameRequisicaoHandler;
    private final ExameMaterialListHandler exameMaterialHandler;
    private final ImpressaoHPDirect impressaoDirect;
    private final LotePardini lote;

    public ImpressaoPardini(ExamePardiniDao examesDao, ExameRequisicaoListHandler exameRequisicaoHandler, ExameMaterialListHandler exameMaterialHandler, ImpressaoHPDirect impressaoDirect, LotePardini lote) {
        this.examesDao = examesDao;
        this.exameRequisicaoHandler = exameRequisicaoHandler;
        this.exameMaterialHandler = exameMaterialHandler;
        this.impressaoDirect = impressaoDirect;
        this.lote = lote;
    }

    @Override
    public RetornoImpressaoEtiquetas imprimir(boolean isColetaWeb, ImpressaoVO dados, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean agruparGuiasInterface, String filialPadrao, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, ImpressorasLabExterno impressoras, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar, int casasPrecoExame, RoundingMode arredondamentoPrecoExame) throws ImpressaoException {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        ArrayList<InterfaceDesmembrar> examesDesm = new ArrayList<InterfaceDesmembrar>();
        ListaExameMaterial<ExameMaterial> impressos = new ListaExameMaterial<ExameMaterial>();
        ListaExameMaterial<ExameMaterial> examesHPDirect = new ListaExameMaterial<ExameMaterial>();
        String filial = String.valueOf(dados.filial);
        ArrayList<Registro> listaRequisicoes = new ArrayList<Registro>();
        String[] examesString = dados.getExames().toArray(new String[0]);
        int[] materiais = this.toIntArray(dados.getMateriais());
        String requisicao = String.valueOf(dados.getRequisicaoPai());
        LaboratorioExterno lab = this.getLabExterno(filial, st);
        if (ExamePardiniDao.isEnvioHpDirect(st)) {
            examesHPDirect = this.buscarExamesHPDirect(filial, requisicao, examesString, materiais, dados.tipoEtiqueta, dados.isAgendamento, agruparInterface, st);
        }
        if (!examesHPDirect.isEmpty() && !examesHPDirect.isEnviarRequisicaoWebService()) {
            this.imprimirEtiquetasHPDirect(dados.impressora, examesHPDirect, filial, requisicao, dados.tipoEtiqueta, st, retorno, casasPrecoExame, arredondamentoPrecoExame);
            impressos.addAll(examesHPDirect);
        } else {
            Integer[] multiguias = new Integer[]{Integer.parseInt(requisicao)};
            if (this.isAgruparMultiguia(filial, requisicao, examesString, materiais, agruparGuiasInterface, st)) {
                multiguias = this.buscarMultiguias(filial, requisicao, st);
            }
            for (Integer req : multiguias) {
                String reqString = String.valueOf(req);
                if (UtilExportadores.isEnvioHpDirect(st) || UtilExportadores.isEnvioRequisicaoHP(st)) {
                    examesHPDirect = this.buscarExamesHPDirect(filial, reqString, examesString, materiais, dados.tipoEtiqueta, dados.isAgendamento, agruparInterface, st);
                }
                if (!examesHPDirect.isEmpty() && !examesHPDirect.isEnviarRequisicaoWebService()) {
                    this.imprimirEtiquetasHPDirect(dados.impressora, examesHPDirect, filial, requisicao, dados.tipoEtiqueta, st, retorno, casasPrecoExame, arredondamentoPrecoExame);
                    impressos.addAll(examesHPDirect);
                    continue;
                }
                if (examesHPDirect == null || examesHPDirect.isEmpty()) continue;
                Registro registro = this.criarRegistros(examesHPDirect, filial, multiguias, reqString);
                examesDesm.addAll(this.confirmaCondicaoAmostra(filial, registro, lab.codigoLab, st));
                listaRequisicoes.add(registro);
            }
            retorno = this.lote.criarLote(listaRequisicoes, filial, requisicao, examesHPDirect, isColetaWeb, dados.tipoEtiqueta, examesDesm, agruparGuiasInterface, st, filialPadrao, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, digitosTuboFilial, digitosTuboRequisicao, tipoExportacaoInterface, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, retorno, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar);
            impressos.addAll(retorno.getExamesMaterial());
            if (impressos.isEmpty()) {
                retorno = this.imprimirEtiquetaHPWS(dados, impressos, st, impressoras.getImpressoraPardini(), tamanhoNomeImpressora, impressorasLocais, isColetaWeb, arquivar, anular, agruparGuiasInterface);
            }
            impressos.addAll(this.buscarExamesComLote(filial, requisicao, examesString, materiais, st, agruparInterface));
        }
        if (!impressos.isEmpty() && !examesDesm.isEmpty()) {
            this.atualizarDadosCondicaoAmostra(filial, examesDesm, this.lote.getNumeroLote(), lab.codigoLab, st, isColetaWeb, arquivar);
        }
        retorno.setExames(impressos);
        return retorno;
    }

    private void atualizarDadosCondicaoAmostra(String filial, ArrayList<InterfaceDesmembrar> examesDesm, int numeroLote, String codigoLab, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar) throws ImpressaoException {
        try {
            for (InterfaceDesmembrar exa : examesDesm) {
                this.examesDao.atualizarDadosCondicaoAmostra(filial, exa, numeroLote, codigoLab, st, isColetaWeb, arquivar);
            }
        }
        catch (SQLException e) {
            throw new ImpressaoException(e);
        }
    }

    private ArrayList<InterfaceDesmembrar> confirmaCondicaoAmostra(String filial, Registro registro, String codigoLab, Statement st) throws ImpressaoException {
        ArrayList<InterfaceDesmembrar> examesDesm = new ArrayList<InterfaceDesmembrar>();
        if (!Funcoes.objectIsNull(registro)) {
            List listaExame = (List)registro.getValor("listaexames");
            for (Registro reg : listaExame) {
                ConfirmarCondicaoAmostra confirmarCondicaoAmostra;
                boolean exigirCondicaoAmostra = Boolean.valueOf(StringUtil.getValor(reg.getString("ele_xmllabexterno"), "condicao-selecionada"));
                if (!exigirCondicaoAmostra || !(confirmarCondicaoAmostra = new ConfirmarCondicaoAmostra(new Dialog(Laboratorio.getInstancia()), reg.getString("exa_codigo"), reg.getString("mco_codigo"), codigoLab, reg.getString("req_codigo"))).contemExamesFilho()) continue;
                confirmarCondicaoAmostra.setVisible(!UtilExportadores.isEnvioRequisicaoHP(st));
                if (!confirmarCondicaoAmostra.isOK() && !UtilExportadores.isEnvioRequisicaoHP(st)) continue;
                examesDesm.addAll(confirmarCondicaoAmostra.getExames());
            }
        }
        return examesDesm;
    }

    private RetornoImpressaoEtiquetas imprimirEtiquetaHPWS(ImpressaoVO dados, ListaExameMaterial<ExameMaterial> impressos, Statement st, String impressora, String tamanhoNomeImpressora, String[] impressorasLocais, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular, boolean agruparGuiasInterface) throws ImpressaoException {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        String filial = String.valueOf(dados.filial);
        String[] examesString = dados.getExames().toArray(new String[0]);
        int[] materiais = this.toIntArray(dados.getMateriais());
        String requisicao = String.valueOf(dados.getRequisicaoPai());
        if (impressos.isEmpty() && dados.reimprimir && (retorno = this.deveAgruparMultiguias(dados, st) || agruparGuiasInterface ? this.lote.imprimirEtiquetaHPWSAgrupandoMultiguias(filial, requisicao, examesString, materiais, st, impressora, tamanhoNomeImpressora, impressorasLocais, isColetaWeb, arquivar, anular) : this.lote.imprimirEtiquetaHPWS(filial, requisicao, examesString, materiais, st, isColetaWeb, arquivar, anular)).isImprimiu()) {
            for (int posicao = 0; posicao < examesString.length; ++posicao) {
                impressos.add(new ExameMaterial(examesString[posicao], materiais[posicao]));
            }
        }
        return retorno;
    }

    private boolean deveAgruparMultiguias(ImpressaoVO dados, Statement st) throws ImpressaoException {
        try {
            return DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, dados.filial, dados.requisicaoPrincipal, dados.getExames(), dados.getMateriais(), PROTOCOLO);
        }
        catch (NumberFormatException | SQLException e) {
            throw new ImpressaoException(e);
        }
    }

    private LaboratorioExterno getLabExterno(String filial, Statement st) {
        LaboratorioExterno labExterno = null;
        try {
            labExterno = UtilExportadores.localizaLabExternoPardiniEnvioRequisicao(filial, st);
        }
        catch (ThreadDaoException | SQLException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel recuperar o codigo do Lab. Externo." + e1.getMessage(), e1.getStackTrace());
        }
        return labExterno;
    }

    private List<ExameMaterial> buscarExamesComLote(String filial, String requisicao, String[] exames, int[] materiais, Statement st, int agruparInterface) {
        ArrayList<ExameMaterial> listaExamesNaoImprimir = new ArrayList<ExameMaterial>();
        ArrayList<Registro> examesComLote = UtilExportadores.verificaExamesComLote(filial, requisicao, exames, materiais, agruparInterface, st);
        for (Registro r : examesComLote) {
            ExameMaterial exameMaterial = new ExameMaterial(r.getString("codigoExame".toLowerCase()), r.getInt("codigoMaterial".toLowerCase()));
            if (listaExamesNaoImprimir.contains(exameMaterial)) continue;
            listaExamesNaoImprimir.add(exameMaterial);
        }
        return listaExamesNaoImprimir;
    }

    private Registro criarRegistros(ListaExameMaterial<ExameMaterial> examesHPDirect, String filial, Integer[] multiguias, String reqString) {
        Registro registro = new Registro();
        if (!examesHPDirect.isEmpty()) {
            registro = this.exameMaterialHandler.converterExameMaterialToRegistro(examesHPDirect, filial, reqString);
            registro.setValor("req_codigomae", multiguias[0]);
            ArrayList listaExamesRequisicao = (ArrayList)registro.getValor("listaexames");
            registro.setValor("backupListaExames", listaExamesRequisicao.clone());
        }
        return registro;
    }

    private Integer[] buscarMultiguias(String filial, String requisicao, Statement st) {
        Object[] multiguia = new Integer[]{Integer.parseInt(requisicao)};
        try {
            multiguia = RecepcaoUtil.verificaMultiGuias(st, filial, requisicao, true, false);
        }
        catch (SQLException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e2o foi poss\u00edvel verificiar multiguia no carregamento de lote.\n" + e1.getMessage(), e1.getStackTrace());
        }
        Arrays.sort(multiguia);
        return multiguia;
    }

    private RetornoImpressaoEtiquetas imprimirEtiquetasHPDirect(String impressora, ListaExameMaterial<ExameMaterial> exames, String filial, String requisicao, int tipoEtiqueta, Statement st, RetornoImpressaoEtiquetas retorno, int casasPrecoExame, RoundingMode arredondamentoPrecoExame) throws ImpressaoException {
        if (!exames.isEmpty()) {
            ListaExameMaterial<ExameMaterial> examesEnviarWebservice = this.getExamesEnviarWebservice(exames);
            try {
                return this.impressaoDirect.imprimirEtiquetasHPDirect(filial, requisicao, exames, impressora, tipoEtiqueta, false, st, retorno, () -> {
                    try {
                        Conexao.arquivaSQL();
                        return true;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }, () -> {
                    try {
                        Conexao.anulaSQL();
                        return true;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }, casasPrecoExame, arredondamentoPrecoExame);
            }
            catch (SQLException e) {
                throw new ImpressaoException("N\u00e3o foi poss\u00edvel imprimir etiquetas HPDirect\n" + e.getMessage(), e);
            }
        }
        return retorno;
    }

    private ListaExameMaterial<ExameMaterial> buscarExamesHPDirect(String filial, String requisicao, String[] codExames, int[] materiais, int tipoEtiqueta, Boolean isAgendamento, int agruparInterface, Statement st) throws ImpressaoException {
        ListaExameMaterial<ExameMaterial> examesHPDirect = new ListaExameMaterial();
        try {
            examesHPDirect = this.examesDao.buscarExameHPDirect(filial, requisicao, codExames, materiais, tipoEtiqueta, isAgendamento, st, agruparInterface);
        }
        catch (SQLException e) {
            throw new ImpressaoException("N\u00e3o foi poss\u00edvel buscar exames HPDirect\n" + e.getMessage(), e);
        }
        return examesHPDirect;
    }

    private boolean isAgruparMultiguia(String filial, String requisicao, String[] exames, int[] materiais, boolean agruparGuiasInterface, Statement st) throws ImpressaoException {
        boolean agruparMultiguia = false;
        ValorIn exame = ValorIn.criar(exames);
        ValorIn material = ValorIn.criar(materiais);
        try {
            agruparMultiguia = agruparGuiasInterface || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, filial, requisicao, exame.toString(), ((Object)material).toString(), PROTOCOLO);
        }
        catch (SQLException e1) {
            throw new ImpressaoException("N\u00e3o foi poss\u00edvel verificar agrupamento de multiguia \n" + e1.getMessage(), e1);
        }
        return agruparMultiguia;
    }

    private ListaExameMaterial<ExameMaterial> getExamesEnviarWebservice(ListaExameMaterial<ExameMaterial> examesHPDirect) {
        ListaExameMaterial<ExameMaterial> filtrados = new ListaExameMaterial<ExameMaterial>();
        for (ExameMaterial exame : examesHPDirect) {
            if (!exame.isEnviarWebService()) continue;
            filtrados.add(exame);
        }
        return filtrados;
    }

    private int[] toIntArray(List<Integer> materiais) {
        int[] resultado = new int[materiais.size()];
        int index = 0;
        for (Integer material : materiais) {
            resultado[index] = material;
            ++index;
        }
        return resultado;
    }

    @Override
    public RetornoImpressaoEtiquetas imprimirPadrao(boolean isColetaWeb, ImpressaoVO dados, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean agruparGuiasInterface, String filialPadrao, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, ImpressorasLabExterno impressoras, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar, int casasPrecoExame, RoundingMode arredondamentoPrecoExame) throws ImpressaoException {
        return this.imprimir(isColetaWeb, dados, st, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, agruparGuiasInterface, filialPadrao, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, tuboPrimario, utilizarCapacidadeTuboPrimario, impressoras, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar, casasPrecoExame, arredondamentoPrecoExame);
    }
}

