/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.exame.externo.pardini;

import jalis.comum.Conexao;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.exame.ArrayListAgrupadorDados;
import jalis.laboratorio.util.impressao.exame.DadosGrupoExame;
import jalis.laboratorio.util.impressao.exame.ExameMaterial;
import jalis.laboratorio.util.impressao.exame.ListaExameMaterial;
import jalis.laboratorio.util.impressao.exame.externo.pardini.HPDirectDao;
import jalis.relatorio.Gerador;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.impressao.termica.ImpressaoTermica;
import jalis.util.logger.ErrorLogger;
import java.math.RoundingMode;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;

public class ImpressaoHPDirect {
    private final HPDirectDao dao = new HPDirectDao();

    public RetornoImpressaoEtiquetas imprimirEtiquetasHPDirect(String codigoFilial, String codigoRequisicao, ListaExameMaterial<ExameMaterial> listaExamesHPDirect, String impressora, int tipoEtiqueta, boolean isColetaWeb, Statement st, RetornoImpressaoEtiquetas retorno, Callable<Boolean> arquivar, Callable<Boolean> anular, int casasPrecoExame, RoundingMode arredondamentoPrecoExame) throws SQLException {
        ArrayList<DadosGrupoExame> listaDadosGrupoExame = this.getDadosGrupoExamesHPDirect(codigoFilial, codigoRequisicao, listaExamesHPDirect, tipoEtiqueta);
        for (DadosGrupoExame dadosGrupoExame : listaDadosGrupoExame) {
            if (dadosGrupoExame.getTipoImpressao().equalsIgnoreCase("C")) {
                Gerador gerador = new Gerador(casasPrecoExame, arredondamentoPrecoExame);
                gerador.setImpressora(Impressao.comparaNomeImpressoraReduzido(impressora));
                gerador.setCopias(dadosGrupoExame.getQtdeEtiquetas());
                gerador.executar(dadosGrupoExame.getLayoutEtiqueta(), dadosGrupoExame.getModelo());
                continue;
            }
            if (!dadosGrupoExame.getTipoImpressao().equalsIgnoreCase("T")) continue;
            ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(impressora), isColetaWeb);
            termica.setDados(dadosGrupoExame.getModelo());
            ArrayList<Object> etqs = new ArrayList<Object>();
            for (int i = 0; i < dadosGrupoExame.getQtdeEtiquetas(); ++i) {
                etqs.add(termica.imprimirDireto(termica.gerarEtiquetas(dadosGrupoExame.getLayoutEtiqueta()), true, st, isColetaWeb, arquivar, anular));
            }
            HashMap<String, List<byte[]>> etiquetasLab = new HashMap<String, List<byte[]>>();
            ArrayList etq = retorno.getEtiquetasLabExterno() != null && !retorno.getEtiquetasLabExterno().isEmpty() ? retorno.getEtiquetasLabExterno().get("hpardini") : new ArrayList();
            etqs.addAll(etq);
            etiquetasLab.put("hpardini", etqs);
            retorno.setEtiquetasLabExterno(etiquetasLab);
        }
        return retorno;
    }

    private ArrayList<DadosGrupoExame> getDadosGrupoExamesHPDirect(String codigoFilial, String codigoRequisicao, ListaExameMaterial<ExameMaterial> listaExamesHPDirect, int tipoEtiqueta) throws SQLException {
        HashMap<String, ArrayList> mapaExamesGrupo = new HashMap<String, ArrayList>();
        for (ExameMaterial exameMaterial : listaExamesHPDirect) {
            ArrayList aux;
            String grupo = Funcoes.textoVazio(exameMaterial.getEtiquetaArmazenada()) ? exameMaterial.getGrupo() : exameMaterial.getEtiquetaArmazenada();
            String grupoAux = grupo + "_" + exameMaterial.getCodigoLaboratorioExterno();
            if (mapaExamesGrupo.containsKey(grupoAux)) {
                aux = (ArrayList)mapaExamesGrupo.get(grupoAux);
                aux.add(exameMaterial);
                continue;
            }
            aux = new ArrayList();
            aux.add(exameMaterial);
            mapaExamesGrupo.put(grupoAux, aux);
        }
        ArrayList<DadosGrupoExame> listaDadosGrupoExame = new ArrayList<DadosGrupoExame>();
        for (String grupoAux : mapaExamesGrupo.keySet()) {
            String etiquetaHPDirect;
            ExameMaterial exameMaterialAux;
            ArrayList examesGrupo;
            Object[] linha;
            ModeloGridTable modelo;
            block30: {
                block29: {
                    modelo = new ModeloGridTable(Impressao.CAMPOS_ETIQUETA_HP_DIRECT);
                    linha = new Object[Impressao.CAMPOS_ETIQUETA_HP_DIRECT.length];
                    examesGrupo = (ArrayList)mapaExamesGrupo.get(grupoAux);
                    exameMaterialAux = (ExameMaterial)examesGrupo.get(0);
                    etiquetaHPDirect = null;
                    if (Funcoes.textoVazio(exameMaterialAux.getEtiquetaArmazenada())) break block29;
                    etiquetaHPDirect = exameMaterialAux.getEtiquetaArmazenada();
                    break block30;
                }
                Statement st = Conexao.getStatement();
                String sequencial = null;
                try {
                    sequencial = DBUtil.getSequencia(st, "labexterno_" + codigoFilial + "_" + exameMaterialAux.getCodigoLaboratorioExterno());
                }
                catch (SQLException e) {
                    try {
                        throw new SQLException("N\u00e3o foi poss\u00edvel obter o sequencial da etiqueta HP Direct. Filial = " + codigoFilial + ", lab. externo = " + exameMaterialAux.getCodigoLaboratorioExterno() + ".\n" + e.getMessage());
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                }
                Conexao.fecharStatement(st);
                etiquetaHPDirect = "9" + Funcoes.preencheZero(exameMaterialAux.getCodigoProtocolo(), 5) + Funcoes.preencheZero(sequencial, 6);
            }
            ArrayListAgrupadorDados<String> codigosExamesHPardini = new ArrayListAgrupadorDados<String>();
            ArrayListAgrupadorDados<String> codigosExames = new ArrayListAgrupadorDados<String>();
            ArrayListAgrupadorDados<Integer> codigosMateriais = new ArrayListAgrupadorDados<Integer>();
            ArrayListAgrupadorDados<String> codigosRecipientes = new ArrayListAgrupadorDados<String>();
            ArrayListAgrupadorDados<String> descricoesExames = new ArrayListAgrupadorDados<String>();
            ArrayListAgrupadorDados<String> descricoesMateriais = new ArrayListAgrupadorDados<String>();
            ArrayListAgrupadorDados<String> descricoesRecipientes = new ArrayListAgrupadorDados<String>();
            for (ExameMaterial aux : examesGrupo) {
                Object[] auxInt;
                codigosExamesHPardini.add(aux.getCodigoExamePardini());
                codigosExames.add(aux.getCodigoExame());
                codigosMateriais.add(aux.getCodigoMaterial());
                descricoesExames.add(aux.getDescricaoExame());
                descricoesMateriais.add(aux.getDescricaoMaterial());
                Array auxR = aux.getRecipiente();
                for (Object a : auxInt = (Object[])auxR.getArray()) {
                    codigosRecipientes.add(a.toString());
                    descricoesRecipientes.add(ImpressaoHPDirect.getDescricaoRecipiente(codigoFilial, a.toString()));
                }
            }
            for (int i = 0; i < Impressao.CAMPOS_ETIQUETA_HP_DIRECT.length; ++i) {
                String campo = Impressao.CAMPOS_ETIQUETA_HP_DIRECT[i];
                if (campo.equalsIgnoreCase("codigoFilial")) {
                    linha[i] = codigoFilial;
                    continue;
                }
                if (campo.equalsIgnoreCase("codigoRequisicao")) {
                    linha[i] = codigoRequisicao;
                    continue;
                }
                if (campo.equalsIgnoreCase("nomePaciente")) {
                    linha[i] = listaExamesHPDirect.getNomePaciente();
                    continue;
                }
                if (campo.equalsIgnoreCase("pedidoHPardini")) {
                    linha[i] = etiquetaHPDirect;
                    continue;
                }
                if (campo.equalsIgnoreCase("codigoConveniadoHPardini")) {
                    linha[i] = exameMaterialAux.getCodigoProtocolo();
                    continue;
                }
                if (campo.equalsIgnoreCase("pedidoConveniado")) {
                    linha[i] = codigoRequisicao;
                    continue;
                }
                if (campo.equalsIgnoreCase("materialBiologico")) {
                    linha[i] = exameMaterialAux.getMaterialBiologico();
                    continue;
                }
                if (campo.equalsIgnoreCase("conservante")) {
                    linha[i] = exameMaterialAux.getConservante();
                    continue;
                }
                if (campo.equalsIgnoreCase("codigoExameHPardini")) {
                    linha[i] = codigosExamesHPardini.toString();
                    continue;
                }
                if (campo.equalsIgnoreCase("codigoEtiquetaHPardini")) {
                    linha[i] = etiquetaHPDirect;
                    continue;
                }
                if (campo.equalsIgnoreCase("codigoExame")) {
                    linha[i] = codigosExames.toString();
                    continue;
                }
                if (campo.equalsIgnoreCase("descricaoExame")) {
                    linha[i] = descricoesExames.toString();
                    continue;
                }
                if (campo.equalsIgnoreCase("codigoMaterial")) {
                    linha[i] = codigosMateriais.toString();
                    continue;
                }
                if (campo.equalsIgnoreCase("descricaoMaterial")) {
                    linha[i] = descricoesMateriais.toString();
                    continue;
                }
                if (campo.equalsIgnoreCase("codigoConvenio")) {
                    linha[i] = listaExamesHPDirect.getCodigoConvenio();
                    continue;
                }
                if (campo.equalsIgnoreCase("fantasiaConvenio")) {
                    linha[i] = listaExamesHPDirect.getFantasiaConvenio();
                    continue;
                }
                if (campo.equalsIgnoreCase("codigoPaciente")) {
                    linha[i] = listaExamesHPDirect.getCodigoPaciente();
                    continue;
                }
                if (campo.equalsIgnoreCase("codigoRecipiente")) {
                    linha[i] = codigosRecipientes.toString();
                    continue;
                }
                if (!campo.equalsIgnoreCase("descricaoRecipiente")) continue;
                linha[i] = descricoesRecipientes.toString();
            }
            modelo.addLine(linha);
            DadosGrupoExame dadosGrupoExame = new DadosGrupoExame(exameMaterialAux.getGrupo());
            dadosGrupoExame.setModelo(modelo);
            dadosGrupoExame.setLayoutEtiqueta(exameMaterialAux.getXMLLayout());
            dadosGrupoExame.setTipoImpressao(exameMaterialAux.getTipoImpressao());
            int qtdeEtiquetas = 1;
            for (ExameMaterial aux : examesGrupo) {
                if (qtdeEtiquetas >= aux.getQtdeEtiquetas()) continue;
                qtdeEtiquetas = aux.getQtdeEtiquetas();
            }
            dadosGrupoExame.setQtdeEtiquetas(qtdeEtiquetas);
            listaDadosGrupoExame.add(dadosGrupoExame);
            this.dao.gravaEtiquetaHPDirectExameRequisicao(codigoFilial, codigoRequisicao, examesGrupo, etiquetaHPDirect, tipoEtiqueta);
        }
        return listaDadosGrupoExame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDescricaoRecipiente(String filial, String recipiente) {
        String retorno;
        Statement st;
        block4: {
            st = Conexao.getStatement();
            retorno = "";
            try {
                ResultSet rs = Conexao.executeQuery(st, "select rec_descricao from recipientes where fil_codigo = " + filial + " and rec_codigo = " + recipiente);
                if (!rs.next()) break block4;
                retorno = rs.getString(1);
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(null, "N\u00e3o foi poss\u00edvel buscar os recipientes para o tubo do HP Direct", e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return retorno;
    }
}

