/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.exame.externo.pardini;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.InterfaceDesmembrar;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.util.impressao.exame.ExameMaterial;
import jalis.laboratorio.util.impressao.exame.ListaExameMaterial;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.Callable;

public class ExamePardiniDao {
    public static final int TIPO_COLETA = 1;
    public static final int TIPO_TRIAGEM = 2;
    public static final int TIPO_COLETA_SELECIONADA = 3;
    public static final int TIPO_TRIAGEM_SELECIONADA = 4;

    public ListaExameMaterial<ExameMaterial> buscarExameHPDirect(String codigoFilial, String codigoRequisicao, String[] codigosExames, int[] codigosMateriais, int tipoEtiqueta, boolean isAgendamento, Statement st, int agruparInterface) throws SQLException {
        ResultSet rs = st.executeQuery(this.sqlExameHPDirect(codigoFilial, codigoRequisicao, codigosExames, codigosMateriais, isAgendamento, agruparInterface));
        ListaExameMaterial<ExameMaterial> exames = new ListaExameMaterial<ExameMaterial>();
        if (rs.next()) {
            String xmlConfiguracao = rs.getString("xmlConfiguracao");
            boolean isEnviarRequisicaoWebService = StringUtil.getBoolean(xmlConfiguracao, "envioAutomatico");
            exames = this.criarListaExameMaterial(rs, isEnviarRequisicaoWebService);
            rs.beforeFirst();
            while (rs.next()) {
                xmlConfiguracao = rs.getString("xmlConfiguracao");
                String tagHPardini = StringUtil.getValor(xmlConfiguracao, "hpardini");
                String tagTipoImpressao = StringUtil.getValor(tagHPardini, "tipoImpressao");
                String tagModelo = StringUtil.getValor(tagHPardini, "modelo");
                String tagModeloGrafico = StringUtil.getValor(tagModelo, "modeloGrafico");
                String tagModeloDireto = StringUtil.getValor(tagModelo, "modeloTermico");
                String tagCodigoProtocolo = StringUtil.getValor(tagHPardini, "codigoProtocolo");
                isEnviarRequisicaoWebService = StringUtil.getBoolean(xmlConfiguracao, "envioAutomatico");
                if (isEnviarRequisicaoWebService) {
                    exames.add(this.criarExameMaterial(rs, tagModelo, tagCodigoProtocolo));
                    continue;
                }
                if (!rs.getBoolean("isGerarHPDirect") || Funcoes.textoVazio(tagTipoImpressao) || Funcoes.textoVazio(tagModeloDireto) && Funcoes.textoVazio(tagModeloGrafico)) continue;
                Array recipientes = rs.getArray("recipiente");
                int qtdeEtiquetas = 1;
                if (recipientes != null && recipientes.getArray() != null && recipientes.getArray() instanceof Object[] && ((Object[])recipientes.getArray()).length > 0) {
                    qtdeEtiquetas = ExamePardiniDao.getQtdeEtiquetas(codigoFilial, rs.getString("codigoExame"), rs.getString("codigoMaterial"), ((Object[])recipientes.getArray())[0].toString(), tipoEtiqueta, st);
                }
                exames.add(this.criarExameMaterial(rs, tagTipoImpressao, tagModeloGrafico, tagModeloDireto, tagCodigoProtocolo, recipientes, qtdeEtiquetas));
            }
        }
        rs.close();
        return exames;
    }

    private ExameMaterial criarExameMaterial(ResultSet rs, String tagModelo, String tagCodigoProtocolo) throws SQLException {
        ExameMaterial exameMaterial = new ExameMaterial(rs.getString("codigoExame"), rs.getInt("codigoMaterial"), tagModelo, rs.getString("xmlExamePardini"), rs.getString("descricaoExame"), rs.getString("descricaoMaterial"), tagCodigoProtocolo, "T", rs.getString("codigoEtiquetaArmazenada"), rs.getInt("codigoLaboratorioExterno"), 1, rs.getArray("recipiente"), rs.getTimestamp("dataMaterial"), rs.getString("codigoApoiado"), rs.getString("tempoDiurese"), rs.getString("volumeDiurese"), rs.getString("codigoLabExterno"), rs.getString("materialInformado"));
        exameMaterial.setXmlConfiguracao(rs.getString("xmlConfiguracao"));
        return exameMaterial;
    }

    private ExameMaterial criarExameMaterial(ResultSet rs, String tagTipoImpressao, String tagModeloGrafico, String tagModeloDireto, String tagCodigoProtocolo, Array recipientes, int qtdeEtiquetas) throws SQLException {
        return new ExameMaterial(rs.getString("codigoExame"), rs.getInt("codigoMaterial"), tagTipoImpressao.equalsIgnoreCase("C") ? tagModeloGrafico : tagModeloDireto, rs.getString("xmlExamePardini"), rs.getString("descricaoExame"), rs.getString("descricaoMaterial"), tagCodigoProtocolo, tagTipoImpressao, rs.getString("codigoEtiquetaArmazenada"), rs.getInt("codigoLaboratorioExterno"), qtdeEtiquetas, recipientes, null, null, null, null, rs.getString("codigoLabExterno"), rs.getString("materialInformado"));
    }

    private ListaExameMaterial<ExameMaterial> criarListaExameMaterial(ResultSet rs, boolean isEnviarRequisicaoWebService) throws SQLException {
        ListaExameMaterial<ExameMaterial> listaExameMaterial = new ListaExameMaterial<ExameMaterial>(rs.getString("nomePaciente"), rs.getInt("codigoConvenio"), rs.getString("fantasiaConvenio"), rs.getInt("codigoPaciente"), isEnviarRequisicaoWebService, rs.getString("dataNascimentoPaciente"), rs.getDate("dataColeta"), rs.getString("horaColeta"), rs.getString("dumPaciente"), rs.getString("sexoPaciente"), rs.getString("idade"), rs.getString("observacao"), rs.getString("peso"), rs.getString("alturaPaciente"), rs.getString("nomeMedico"), rs.getString("crmMedico"), rs.getString("ufMedico"), rs.getString("conselhoMedico"));
        listaExameMaterial.setPeriodoGestacional(rs.getString("req_periodogestacional"));
        return listaExameMaterial;
    }

    private String sqlExameHPDirect(String codigoFilial, String codigoRequisicao, String[] codigosExames, int[] codigosMateriais, boolean isAgendamento, int agruparInterface) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select exr.exa_codigo as codigoExame ");
        buf.append("       ,exr.mco_codigo as codigoMaterial ");
        buf.append("       ,con.con_codigo as codigoConvenio ");
        buf.append("       ,con.con_fantasia as fantasiaConvenio ");
        buf.append("       ,pac.pac_nome as nomePaciente ");
        buf.append("       ,pac.pac_nomesocial as nomeSocialPaciente ");
        buf.append("       ,pac.pac_datanasc as dataNascimentoPaciente ");
        buf.append("       ,pac.pac_codigo as codigoPaciente ");
        buf.append("       ,pac.pac_sexo as sexoPaciente ");
        buf.append("       ,lae.lae_configuracao as xmlConfiguracao ");
        buf.append("       ,lae.lae_codigo as codigoLabExterno ");
        buf.append("       ,ele.ele_xmllabexterno as xmlExamePardini ");
        buf.append("       ,lae.lae_codigo as codigoLaboratorioExterno ");
        buf.append("       ,exa.exa_descricao as descricaoExame ");
        buf.append("       ,mco.mco_descricao as descricaoMaterial ");
        buf.append("       ,req.req_data as dataColeta ");
        buf.append("       ,req.req_hora as horaColeta ");
        buf.append("       ,req.req_dum as dumPaciente ");
        buf.append("       ,req.req_idade as idade ");
        buf.append("       ,req.req_obs as observacao");
        buf.append("       ,req.req_peso as peso ");
        buf.append("       ,req.req_altura as alturaPaciente ");
        buf.append("       ,exr.exr_datamaterial as dataMaterial");
        buf.append("       ,exr.exr_codigoapoiado as codigoApoiado ");
        buf.append("       ,exr.exr_tempodiurese as tempoDiurese ");
        buf.append("       ,exr.exr_volumediurese as volumeDiurese ");
        buf.append("       ,exr.exr_descricaomaterial as materialInformado ");
        buf.append("       ,m.med_nome AS nomeMedico ");
        buf.append("       ,m.med_crm AS crmMedico ");
        buf.append("       ,m.med_uf AS ufMedico ");
        buf.append("       ,m.med_conselho AS conselhoMedico ");
        buf.append("       ,(CASE WHEN (trim(exrc.ere_codigoapoiado) != '') THEN cast(trim(exrc.ere_codigoapoiado) AS varchar) ELSE cast(trim(exr.exr_codigoapoiado) AS varchar) END)\tAS codigoEtiquetaArmazenada ");
        buf.append("       ,lae.lae_configuracao ilike ").append(this.retornaTagHpDirectSQL()).append(" as isGerarHPDirect");
        if (this.agrupaPorEtiquetaColeta(agruparInterface)) {
            buf.append("    ,(select array (select rcp.rec_codigo from recipcoleta rcp where req.fil_codigo = rcp.fil_codigo ");
            buf.append("\t\t and exa.exa_codigo = rcp.exa_codigo ");
            buf.append("\t\t and emc.mco_codigo = rcp.mco_codigo))::varchar[]  as recipiente ");
        } else {
            buf.append("    ,(select array (select rcp.rec_codigo from reciptriagem rcp where req.fil_codigo = rcp.fil_codigo ");
            buf.append("\t\t and exa.exa_codigo = rcp.exa_codigo ");
            buf.append("\t\t and emc.mco_codigo = rcp.mco_codigo))::varchar[]  as recipiente ");
        }
        buf.append("       ,req.req_periodogestacional ");
        buf.append("   from requisicao req ");
        buf.append("   join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        buf.append("   join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("   join examerequisicao exr on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
        buf.append("\t join examematcoleta emc on exr.fil_codigo = emc.fil_codigo and exr.exa_codigo = emc.exa_codigo and exr.mco_codigo = emc.mco_codigo ");
        buf.append("   join exames exa on emc.fil_codigo = exa.fil_codigo and emc.exa_codigo = exa.exa_codigo ");
        buf.append("   join materialcoleta mco on emc.fil_codigo = mco.fil_codigo and emc.mco_codigo = mco.mco_codigo ");
        buf.append("   join examematcoletalabexterno ele on emc.fil_codigo = ele.fil_codigo and emc.exa_codigo = ele.exa_codigo and emc.mco_codigo = ele.mco_codigo");
        buf.append("   join labexterno lae on ele.fil_codigo = lae.fil_codigo and ele.lae_codigo = lae.lae_codigo ");
        buf.append("                       and lae.lae_protocolo = ").append(StringUtil.textoDBEscape(Protocolo.HPardini.getCodigo()));
        buf.append("   left join examerequisicaorecipiente exrc on exr.fil_codigo = exrc.fil_codigo and req.req_codigo = exrc.req_codigo and exa.exa_codigo = exrc.exa_codigo and emc.mco_codigo = exrc.mco_codigo ");
        buf.append("   LEFT JOIN loteexternorequisicao lr ON req.fil_codigo = lr.fil_kodigo AND req.req_codigo = lr.req_codigo AND lr.lae_codigo = lae.lae_codigo  ");
        buf.append("   LEFT JOIN loteexternoexamerequisicao ler ON exr.fil_codigo = ler.fil_kodigo AND exr.exa_codigo = ler.exa_codigo AND exr.mco_codigo = ler.mco_codigo AND exr.req_codigo = ler.req_codigo ");
        buf.append("   LEFT JOIN filiais_postocoleta fil ON (req.fil_codigo = fil.fil_codigo)");
        buf.append("   JOIN medico m on req.fil_codigo = m.fil_codigo and req.med_crm = m.med_crm and req.med_uf = m.med_uf and req.med_conselho = m.med_conselho");
        buf.append("  where exr.fil_codigo = ").append(codigoFilial);
        buf.append("    and exr.req_codigo = ").append(codigoRequisicao);
        buf.append("    and not exr.exr_excluido ");
        buf.append("    and exr.exr_situacao  != '").append("F").append("'");
        buf.append("    and exr.exr_situacao  != '").append("A").append("'");
        buf.append("    and exr.exr_situacao  != '").append("C").append("'");
        buf.append("    and exr.exr_situacao  != '").append("I").append("'");
        buf.append("    and exr.exr_situacao  != '").append("L").append("'");
        buf.append("    and exr.exr_situacao  != '").append("E").append("'");
        buf.append("    and (lr.leq_retornows is null or ler.lex_codigo is null)");
        buf.append("    and (ele.ele_padrao or ele.lae_codigo = fil.lae_codigo or ele.lae_codigo = con.lae_codigo)");
        if (!isAgendamento) {
            buf.append("    and exr.exr_datamaterial IS NOT NULL");
        }
        if (this.exameMaterialInformado(codigosExames, codigosMateriais)) {
            buf.append("  and (exr.exa_codigo, exr.mco_codigo) IN (");
            for (int i = 0; i < codigosExames.length; ++i) {
                if (this.possuiMultiplosExames(i)) {
                    buf.append(",");
                }
                buf.append("(").append(StringUtil.textoDBEscape(codigosExames[i]));
                buf.append(",").append(codigosMateriais[i]).append(")");
            }
            buf.append(" ) ");
        }
        return buf.toString();
    }

    private Object retornaTagHpDirectSQL() {
        return StringUtil.textoDBEscape("%<enviarEtiquetaHpDirect>true%");
    }

    private boolean agrupaPorEtiquetaColeta(int agruparInterface) {
        return agruparInterface == 0;
    }

    private boolean possuiMultiplosExames(int i) {
        return i > 0;
    }

    public boolean exameMaterialInformado(String[] codigosExames, int[] codigosMateriais) {
        return codigosExames != null && codigosMateriais != null && codigosExames.length > 0 && codigosMateriais.length > 0;
    }

    private static int getQtdeEtiquetas(String filial, String exame, String material, String recipiente, int tipoEtiqueta, Statement st) {
        int retorno = 1;
        try {
            StringBuilder sql = new StringBuilder("select ");
            if (tipoEtiqueta == 1 || tipoEtiqueta == 3) {
                sql.append("rco_qtde from recipcoleta ");
            } else {
                sql.append("rtr_qtde from reciptriagem ");
            }
            sql.append(" where fil_codigo = ").append(filial);
            sql.append("   and exa_codigo = '").append(StringUtil.textoDB(exame)).append("' ");
            sql.append("   and mco_codigo = ").append(material);
            sql.append("   and rec_codigo = ").append(recipiente);
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                retorno = rs.getInt(1);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, "N\u00e3o foi poss\u00edvel buscar a quantidade dos recipientes para o tubo do HP Direct", e.getStackTrace());
        }
        return retorno;
    }

    public static boolean isEnvioHpDirect(Statement st) {
        LaboratorioExterno labExterno = null;
        try {
            labExterno = ExamePardiniDao.localizaLabExternoPardini(Variaveis.filialPadrao, st);
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel localizar laborat\u00f3rio externo configurado.\n" + e.getMessage(), e.getStackTrace());
        }
        if (labExterno == null) {
            return false;
        }
        String enviarEtiquetaHpDirect = StringUtil.getValor(labExterno.configuracao, "enviarEtiquetaHpDirect");
        return !Funcoes.textoVazio(enviarEtiquetaHpDirect) && Boolean.valueOf(enviarEtiquetaHpDirect) != false;
    }

    public static LaboratorioExterno localizaLabExternoPardini(String filialPadrao, Statement st) throws SQLException {
        LaboratorioExterno labExterno = null;
        StringBuilder buf = new StringBuilder();
        LaboratorioExterno[] listas = LaboratorioExterno.getDescricoes(st, false);
        buf.append("select lae_codigo, lae_configuracao from labexterno where fil_codigo = ");
        buf.append(filialPadrao);
        buf.append(" and lae_protocolo = '").append((Object)Protocolo.HPardini).append("' ");
        st.setPoolable(true);
        ResultSet rs = st.executeQuery(buf.toString());
        while (rs.next()) {
            Boolean enviarHpDirect = !Funcoes.textoVazio(rs.getString("lae_configuracao")) && !Funcoes.textoVazio(StringUtil.getValor(rs.getString("lae_configuracao"), "enviarEtiquetaHpDirect")) ? Boolean.valueOf(StringUtil.getValor(rs.getString("lae_configuracao"), "enviarEtiquetaHpDirect")) : Boolean.FALSE;
            if (!enviarHpDirect.booleanValue()) continue;
            for (LaboratorioExterno laboratorioExterno : listas) {
                if (!laboratorioExterno.codigoLab.equals(rs.getString("lae_codigo"))) continue;
                labExterno = laboratorioExterno;
            }
        }
        if (labExterno != null) {
            return labExterno;
        }
        return null;
    }

    public void atualizarDadosCondicaoAmostra(String filial, InterfaceDesmembrar exa, int numeroLote, String codigoLab, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("UPDATE loteexternoexamerequisicaodesm SET led_condicao = ").append(StringUtil.textoDBEscape(exa.getCondicaoAmostra()));
        buf.append(" WHERE fil_codigo = ").append(filial);
        buf.append("   AND exa_codigo = ").append(StringUtil.textoDBEscape(exa.getCodigoPai()));
        buf.append("   AND exa_kodigo = ").append(StringUtil.textoDBEscape(exa.getCodigo()));
        buf.append("   AND mco_kodigo = ").append(exa.getMaterial().getCodigo());
        buf.append("   AND lae_codigo = ").append(codigoLab);
        buf.append("   AND lex_codigo = ").append(numeroLote);
        if (isColetaWeb) {
            st.executeUpdate(buf.toString());
        } else {
            Conexao.executeUpdate(filial, st, buf.toString());
        }
        try {
            arquivar.call();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

