/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.exame.externo.maricondi;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;

public class ImpressaoMaricondiDao {
    public LaboratorioExterno localizaLabExternoMaricondi(String filialPadrao, String[] exames, Statement st) throws SQLException {
        LaboratorioExterno labExterno = null;
        StringBuilder buf = new StringBuilder();
        buf.append("select lab.lae_codigo, lab.lae_configuracao ");
        buf.append("from labexterno lab ");
        buf.append("join examematcoletalabexterno exame ");
        buf.append("on lab.lae_codigo = exame.lae_codigo ");
        buf.append("and lab.fil_codigo = exame.fil_codigo ");
        buf.append("where lab.fil_codigo = ").append(filialPadrao);
        buf.append(" and lab.lae_protocolo = '").append((Object)Protocolo.Maricondi).append("' ").append(" and (lab.lae_inativo is null or not lab.lae_inativo) ");
        buf.append("and exame.exa_codigo in (").append(this.createCondicaoExames(exames)).append(")");
        LaboratorioExterno[] listas = LaboratorioExterno.getDescricoes(st, false);
        ResultSet rs = st.executeQuery(buf.toString());
        while (rs.next()) {
            boolean enviarPorWebService = false;
            String xml = rs.getString("lae_configuracao");
            if (!Funcoes.textoVazio(xml) && !Funcoes.textoVazio(StringUtil.getValor(xml, "enviarLoteWebservice"))) {
                enviarPorWebService = StringUtil.getBoolean(xml, "enviarLoteWebservice");
            }
            if (!enviarPorWebService) continue;
            for (LaboratorioExterno laboratorioExterno : listas) {
                if (!laboratorioExterno.codigoLab.equals(rs.getString("lae_codigo"))) continue;
                labExterno = laboratorioExterno;
            }
        }
        return labExterno;
    }

    private String createCondicaoExames(String[] exames) {
        StringBuilder condicao = new StringBuilder();
        for (String exame : exames) {
            condicao.append("'").append(exame).append("',");
        }
        condicao.deleteCharAt(condicao.length() - 1);
        return condicao.toString();
    }

    public static ArrayList<Registro> verificaExamesComLote(String filial, String requisicao, String[] exames, int[] materiais, int agruparInterface, Statement st) throws SQLException {
        ArrayList<Registro> lista = new ArrayList<Registro>();
        String guias = requisicao;
        if (agruparInterface == 0 || agruparInterface == 1) {
            Integer[] multiguia = null;
            try {
                multiguia = RecepcaoUtil.verificaMultiGuias(st, filial, requisicao, true);
            }
            catch (Exception e1) {
                throw new SQLException("N\u00e2o foi poss\u00edvel verificiar multiguia no carregamento de lote.\n" + e1.getMessage(), e1);
            }
            guias = StringUtil.implode(Arrays.asList(multiguia), ",");
        }
        StringBuilder buf = new StringBuilder();
        buf.append("select lot.lex_codigo, lotex.exa_codigo as codigoExame, ");
        buf.append("       lotex.mco_codigo as codigoMaterial, ");
        buf.append("       lot.leq_retornows as retornoWs");
        buf.append("  from loteexternorequisicao lot ");
        buf.append("  join loteexternoexamerequisicao lotex on lot.fil_codigo = lotex.fil_codigo and lot.req_codigo = lotex.req_codigo and lot.lex_codigo = lotex.lex_codigo ");
        buf.append(" where lot.fil_codigo = ").append(filial);
        buf.append("   and lot.req_codigo in (").append(guias).append(") ");
        buf.append("   and lot.leq_retornows is not null ");
        buf.append("   and lot.leq_dataestorno is null ");
        if (exames != null && exames.length > 0 && materiais != null && materiais.length > 0) {
            buf.append("  and (lotex.exa_codigo, lotex.mco_codigo) IN (");
            for (int i = 0; i < exames.length; ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append("(").append(StringUtil.textoDBEscape(exames[i]));
                buf.append(",").append(materiais[i]).append(")");
            }
            buf.append(" ) ");
        }
        try {
            ResultSet rs = st.executeQuery(buf.toString());
            Registro reg = null;
            while (rs.next()) {
                reg = new Registro(rs);
                lista.add(reg);
            }
            rs.close();
        }
        catch (Exception e) {
            throw new SQLException("N\u00e2o foi poss\u00edvel verificar lote externo.\n" + e.getMessage(), e);
        }
        return lista;
    }

    public boolean haExamesEnviarMaricondi(String codigoFilial, String codigoRequisicao, String[] exames, Statement st) throws SQLException {
        Object[] multiguia = null;
        try {
            multiguia = RecepcaoUtil.verificaMultiGuias(st, codigoFilial, codigoRequisicao, true);
        }
        catch (SQLException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e2o foi poss\u00edvel verificiar multiguia no carregamento de lote.\n" + e1.getMessage(), e1.getStackTrace());
        }
        Arrays.sort(multiguia);
        String guias = StringUtil.implode(Arrays.asList(multiguia), ",");
        StringBuilder buf = new StringBuilder();
        buf.append(" select lab.lae_configuracao, (lote.lex_codigo is null or lr.leq_retornows is null) as haExame ");
        buf.append("   from examerequisicao exr ");
        buf.append("   join requisicao req on exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo ");
        buf.append("   join examematcoletalabexterno ele on exr.fil_codigo = ele.fil_codigo and exr.exa_codigo = ele.exa_codigo and exr.mco_codigo = ele.mco_codigo ");
        buf.append(" left join loteexternorequisicao lr on lr.fil_codigo = req.fil_codigo and lr.req_codigo = req.req_codigo and lr.lae_codigo = ele.lae_codigo");
        buf.append(" left join labexterno lab on ele.fil_codigo = lab.fil_codigo and ele.lae_codigo = lab.lae_codigo ");
        buf.append(" left join loteexternoexamerequisicao lote on exr.fil_codigo = lote.fil_codigo and exr.exa_codigo = lote.exa_codigo and exr.mco_codigo = lote.mco_codigo and exr.req_codigo = lote.req_codigo and exr.fil_Codigo = lote.fil_codigo ");
        buf.append("  where exr.fil_codigo = ").append(codigoFilial);
        buf.append("    and req.req_codigo IN (").append(guias).append(") ");
        buf.append("    and lr.leq_dataestorno is null ");
        buf.append("    and (not req.req_excluida or req.req_origemagendamento) ");
        buf.append("    and not exr.exr_excluido ");
        buf.append("    and (lote.lex_codigo is null or lr.leq_retornows is null) ");
        buf.append("    and exr.exr_dataloteexterno is null");
        buf.append("    and lab.lae_protocolo = '").append((Object)Protocolo.Maricondi).append("' ");
        buf.append("    and (lab.lae_inativo is null or not lab.lae_inativo) ");
        buf.append("    and exr.exa_codigo in (");
        if (null != exames && exames.length > 1) {
            for (int i = 0; i < exames.length; ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append("'").append(exames[i]).append("'");
            }
            buf.append(")");
        } else {
            buf.append("'").append(exames[0]).append("')");
        }
        ResultSet rs = st.executeQuery(buf.toString());
        if (rs.next()) {
            String configuracaoLabExterno = rs.getString("lae_configuracao");
            if (Funcoes.textoVazio(configuracaoLabExterno)) {
                return false;
            }
            boolean enviarUsandoWS = !Funcoes.textoVazio(StringUtil.getValor(configuracaoLabExterno, "enviarLoteWebservice")) ? Boolean.valueOf(StringUtil.getValor(configuracaoLabExterno, "enviarLoteWebservice")) : Boolean.FALSE;
            boolean isEnvioAutomatico = !Funcoes.textoVazio(StringUtil.getValor(configuracaoLabExterno, "envioAutomatico")) ? Boolean.valueOf(StringUtil.getValor(configuracaoLabExterno, "envioAutomatico")) : Boolean.FALSE;
            if (!enviarUsandoWS || !isEnvioAutomatico) {
                return false;
            }
            return rs.getBoolean("haExame");
        }
        StringBuilder buf2 = new StringBuilder();
        buf2.append(" select lab.lae_configuracao, (lote.lex_codigo is null or lr.leq_retornows is null) as haExame ");
        buf2.append("   from examerequisicao exr ");
        buf2.append("   join requisicao req on exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo ");
        buf2.append("   join examematcoletalabexterno ele on exr.fil_codigo = ele.fil_codigo and exr.exa_codigo = ele.exa_codigo and exr.mco_codigo = ele.mco_codigo ");
        buf2.append(" left join loteexternorequisicao lr on lr.fil_codigo = req.fil_codigo and lr.req_codigo = req.req_codigo and lr.lae_codigo = ele.lae_codigo");
        buf2.append(" left join labexterno lab on ele.fil_codigo = lab.fil_codigo and ele.lae_codigo = lab.lae_codigo ");
        buf2.append(" left join loteexternoexamerequisicao lote on exr.fil_codigo = lote.fil_codigo and exr.exa_codigo = lote.exa_codigo and exr.mco_codigo = lote.mco_codigo and exr.req_codigo = lote.req_codigo and exr.fil_Codigo = lote.fil_codigo ");
        buf2.append("  where exr.fil_codigo = ").append(codigoFilial);
        buf2.append("    and req.req_codigo IN (").append(guias).append(") ");
        buf2.append("    and (not req.req_excluida or req.req_origemagendamento) ");
        buf2.append("    and not exr.exr_excluido ");
        buf2.append("    and (lote.lex_codigo is null or lr.leq_retornows is null or lr.leq_dataestorno is null) ");
        buf2.append("    and exr.exr_dataloteexterno is null");
        buf2.append("    and lab.lae_protocolo = '").append((Object)Protocolo.Maricondi).append("' ");
        buf2.append("    and (lab.lae_inativo is null or not lab.lae_inativo) ");
        buf2.append("    and exr.exa_codigo in (");
        if (null != exames && exames.length > 1) {
            for (int i = 0; i < exames.length; ++i) {
                if (i > 0) {
                    buf2.append(",");
                }
                buf2.append("'").append(exames[i]).append("'");
            }
            buf2.append(")");
        } else {
            buf2.append("'").append(exames[0]).append("')");
        }
        buf2.append(" order by lr.leq_dataestorno desc ");
        ResultSet rs2 = st.executeQuery(buf2.toString());
        if (rs2.next()) {
            String configuracaoLabExterno = rs2.getString("lae_configuracao");
            if (Funcoes.textoVazio(configuracaoLabExterno)) {
                return false;
            }
            boolean enviarUsandoWS = !Funcoes.textoVazio(StringUtil.getValor(configuracaoLabExterno, "enviarLoteWebservice")) ? Boolean.valueOf(StringUtil.getValor(configuracaoLabExterno, "enviarLoteWebservice")) : Boolean.FALSE;
            boolean isEnvioAutomatico = !Funcoes.textoVazio(StringUtil.getValor(configuracaoLabExterno, "enviarLotePelaRequisicao")) ? Boolean.valueOf(StringUtil.getValor(configuracaoLabExterno, "enviarLotePelaRequisicao")) : Boolean.FALSE;
            if (!enviarUsandoWS || !isEnvioAutomatico) {
                return false;
            }
            return rs2.getBoolean("haExame");
        }
        return false;
    }

    public static boolean isEnvioAutomatico(LaboratorioExterno labExterno) {
        if (labExterno == null) {
            return false;
        }
        String envioAutomatico = StringUtil.getValor(labExterno.configuracao, "envioAutomatico");
        return !Funcoes.textoVazio(envioAutomatico) && Boolean.valueOf(envioAutomatico) != false;
    }
}

