/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.exame.externo.maricondi;

import jalis.laboratorio.impressao.ImpressaoException;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.InfoComplementar;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.triagem.externo.exportadores.maricondi.ExportacaoParaMaricondi;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.exame.ExameMaterial;
import jalis.laboratorio.util.impressao.exame.ExameRequisicaoListHandler;
import jalis.laboratorio.util.impressao.exame.ImpressaoExame;
import jalis.laboratorio.util.impressao.exame.externo.ImpressaoVO;
import jalis.laboratorio.util.impressao.exame.externo.maricondi.ImpressaoMaricondiDao;
import jalis.laboratorio.util.impressao.exame.externo.maricondi.LoteMaricondi;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.util.tabela.Registro;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class ImpressaoMaricondi
implements ImpressaoExame {
    private final ExameRequisicaoListHandler handler;
    private final ExportacaoParaMaricondi maricondi;
    private final LoteMaricondi lote;
    private final ImpressaoMaricondiDao dao;

    public ImpressaoMaricondi(ExportacaoParaMaricondi maricondi, LoteMaricondi lote, ExameRequisicaoListHandler handler, ImpressaoMaricondiDao dao) {
        this.maricondi = maricondi;
        this.lote = lote;
        this.handler = handler;
        this.dao = dao;
    }

    @Override
    public RetornoImpressaoEtiquetas imprimir(boolean isColetaWeb, ImpressaoVO dados, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean agruparGuiasInterface, String filialPadrao, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, ImpressorasLabExterno impressoras, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar, int casasPrecoExame, RoundingMode arredondamentoPrecoExame) throws ImpressaoException {
        int tipoEtq;
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        ArrayList<ExameMaterial> impressos = new ArrayList<ExameMaterial>();
        String filial = String.valueOf(dados.filial);
        String requisicao = String.valueOf(dados.getRequisicaoPai());
        LaboratorioExterno labExterno = this.buscarLabExterno(filial, dados.getListaExameRequisicaoVO(), st);
        int[] materiais = this.toIntArray(dados.getMateriais());
        String[] examesString = dados.getExames().toArray(new String[0]);
        retorno = this.lote.criarLoteFilialExame(isColetaWeb, labExterno, filial, requisicao, examesString, materiais, tipoEtq = dados.getTipoEtiqueta(), agruparGuiasInterface, st, filialPadrao, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, digitosTuboFilial, digitosTuboRequisicao, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, arquivar, anular, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, retorno, tipoEtiquetaSoroteca, mapInfoComplementar);
        impressos.addAll(retorno.getExames() == null || retorno.getExames().isEmpty() ? new ArrayList() : retorno.getExames());
        if (impressos.isEmpty()) {
            byte[] retornoEtq = this.maricondi.imprimirEtiqueta(isColetaWeb, filial, requisicao, labExterno, examesString, materiais, impressoras.getImpressoraMaricondi(), st, arquivar, anular);
            ArrayList<Object> listEtq = new ArrayList<Object>();
            HashMap<String, List<byte[]>> etiquetasLab = new HashMap<String, List<byte[]>>();
            ArrayList etq = retorno.getEtiquetasLabExterno() != null && !retorno.getEtiquetasLabExterno().isEmpty() ? retorno.getEtiquetasLabExterno().get("maricondi") : new ArrayList();
            listEtq.addAll(etq);
            listEtq.add(retornoEtq);
            etiquetasLab.put("maricondi", listEtq);
            retorno.setEtiquetasLabExterno(etiquetasLab);
        }
        impressos.addAll(this.buscarExamesComLote(filial, requisicao, examesString, materiais, impressos, agruparInterface, st));
        retorno.setExames(impressos);
        return retorno;
    }

    @Override
    public RetornoImpressaoEtiquetas imprimirPadrao(boolean isColetaWeb, ImpressaoVO dados, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean agruparGuiasInterface, String filialPadrao, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, ImpressorasLabExterno impressoras, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar, int casasPrecoExame, RoundingMode arredondamentoPrecoExame) throws ImpressaoException {
        int tipoEtq;
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        ArrayList<ExameMaterial> impressos = new ArrayList<ExameMaterial>();
        String filial = String.valueOf(dados.filial);
        String requisicao = String.valueOf(dados.getRequisicaoPai());
        LaboratorioExterno labExterno = this.buscarLabExterno(filial, dados.getListaExameRequisicaoVO(), st);
        int[] materiais = this.toIntArray(dados.getMateriais());
        String[] examesString = dados.getExames().toArray(new String[0]);
        retorno = this.lote.criarLotePadraoExame(isColetaWeb, labExterno, filial, requisicao, examesString, materiais, tipoEtq = dados.getTipoEtiqueta(), agruparGuiasInterface, st, filialPadrao, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, digitosTuboFilial, digitosTuboRequisicao, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, arquivar, anular, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, retorno, tipoEtiquetaSoroteca, mapInfoComplementar);
        impressos.addAll(retorno.getExames() == null || retorno.getExames().isEmpty() ? new ArrayList() : retorno.getExames());
        if (impressos.isEmpty()) {
            byte[] retornoEtq = this.maricondi.imprimirEtiqueta(isColetaWeb, filial, requisicao, labExterno, examesString, materiais, impressoras.getImpressoraMaricondi(), st, arquivar, anular);
            ArrayList<Object> listEtq = new ArrayList<Object>();
            HashMap<String, List<byte[]>> etiquetasLab = new HashMap<String, List<byte[]>>();
            ArrayList etq = retorno.getEtiquetasLabExterno() != null && !retorno.getEtiquetasLabExterno().isEmpty() ? retorno.getEtiquetasLabExterno().get("maricondi") : new ArrayList();
            listEtq.addAll(etq);
            listEtq.add(retornoEtq);
            etiquetasLab.put("maricondi", listEtq);
            retorno.setEtiquetasLabExterno(etiquetasLab);
        }
        impressos.addAll(this.buscarExamesComLote(filial, requisicao, examesString, materiais, impressos, agruparInterface, st));
        retorno.setExames(impressos);
        return retorno;
    }

    private LaboratorioExterno buscarLabExterno(String filial, List<ExameRequisicaoVO> examesRequisicao, Statement st) throws ImpressaoException {
        LaboratorioExterno labExterno = null;
        try {
            List<String> exames = this.handler.extrairExames(examesRequisicao);
            String[] arrayExames = exames.toArray(new String[0]);
            labExterno = this.dao.localizaLabExternoMaricondi(String.valueOf(filial), arrayExames, st);
        }
        catch (SQLException e) {
            throw new ImpressaoException("Erro ao localizar laboratorio externo\n" + e.getMessage(), e);
        }
        return labExterno;
    }

    private List<ExameMaterial> buscarExamesComLote(String filial, String requisicao, String[] exames, int[] materiais, List<ExameMaterial> impressos, int agruparInterface, Statement st) {
        ArrayList<ExameMaterial> listaExamesNaoImprimir = new ArrayList<ExameMaterial>();
        ArrayList<Registro> examesComLote = UtilExportadores.verificaExamesComLote(filial, requisicao, exames, materiais, agruparInterface, st);
        for (Registro r : examesComLote) {
            ExameMaterial exameMaterial = new ExameMaterial(r.getString("codigoExame".toLowerCase()), r.getInt("codigoMaterial".toLowerCase()));
            if (listaExamesNaoImprimir.contains(exameMaterial)) continue;
            listaExamesNaoImprimir.add(exameMaterial);
        }
        return listaExamesNaoImprimir;
    }

    public int[] toIntArray(List<Integer> dados) {
        int[] resultado = new int[dados.size()];
        int index = 0;
        for (Integer dado : dados) {
            resultado[index] = dado;
            ++index;
        }
        return resultado;
    }
}

