/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.exame.externo.jalisws;

import jalis.laboratorio.impressao.ImpressaoException;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.ExportacaoParaJalisWS;
import jalis.laboratorio.triagem.externo.exportadores.InfoComplementar;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.ImprimirEtiquetasColetaTriagem;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.exame.ExameMaterial;
import jalis.laboratorio.util.impressao.exame.ExameRequisicaoListHandler;
import jalis.laboratorio.util.impressao.exame.externo.CarregaExameRequisicao;
import jalis.laboratorio.util.impressao.exame.externo.CarregaExameRequisicaoPadrao;
import jalis.laboratorio.util.impressao.exame.externo.CarregarExameRequisicaoFilial;
import jalis.laboratorio.util.impressao.exame.externo.jalisws.LoteJalisWSDao;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.service.triagem.LoteExternoExameRequisicaoService;
import jalis.util.Funcoes;
import jalis.util.impressao.termica.ImpressaoTermica;
import jalis.util.tabela.Registro;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.print.PrintService;

public class LoteJalisWS {
    private final ExameRequisicaoListHandler handler;
    private final LoteJalisWSDao dao;
    private final LoteExternoExameRequisicaoService loteService;
    private final ExportacaoParaJalisWS jalisWs = new ExportacaoParaJalisWS();

    public LoteJalisWS(LoteJalisWSDao dao, ExameRequisicaoListHandler handler, LoteExternoExameRequisicaoService loteService) {
        this.handler = handler;
        this.dao = dao;
        this.loteService = loteService;
    }

    public RetornoImpressaoEtiquetas criarLoteFilialExame(boolean isColetaWeb, List<ExameRequisicaoVO> listExames, String impressora, int tipoEtiqueta, String[] exames, int[] materiais, boolean agruparGuiasInterface, Statement st, String filialPadrao, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, int digitosTuboFilial, int digitosTuboRequisicao, String tipoExportacaoInterface, int digitosTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, RetornoImpressaoEtiquetas retorno, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar) throws ImpressaoException {
        CarregarExameRequisicaoFilial carregarExameRequisicao = new CarregarExameRequisicaoFilial(this.jalisWs);
        return this.criarLote(isColetaWeb, listExames, impressora, tipoEtiqueta, carregarExameRequisicao, exames, materiais, agruparGuiasInterface, st, filialPadrao, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, digitosTuboFilial, digitosTuboRequisicao, tipoExportacaoInterface, digitosTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, retorno, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar);
    }

    public RetornoImpressaoEtiquetas criarLotePadraoExame(boolean isColetaWeb, List<ExameRequisicaoVO> listExames, String impressora, int tipoEtiqueta, String[] exames, int[] materiais, boolean agruparGuiasInterface, Statement st, String filialPadrao, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, int digitosTuboFilial, int digitosTuboRequisicao, String tipoExportacaoInterface, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, RetornoImpressaoEtiquetas retorno, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar) throws ImpressaoException {
        CarregaExameRequisicaoPadrao carregarExameRequisicao = new CarregaExameRequisicaoPadrao(this.jalisWs);
        return this.criarLote(isColetaWeb, listExames, impressora, tipoEtiqueta, carregarExameRequisicao, exames, materiais, agruparGuiasInterface, st, filialPadrao, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, digitosTuboFilial, digitosTuboRequisicao, tipoExportacaoInterface, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, retorno, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar);
    }

    private RetornoImpressaoEtiquetas criarLote(boolean isColetaWeb, List<ExameRequisicaoVO> listExames, String impressora, int tipoEtiqueta, CarregaExameRequisicao carregarExameRequisicao, String[] exames, int[] materiais, boolean agruparGuiasInterface, Statement st, String filialPadrao, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, int digitosTuboFilial, int digitosTuboRequisicao, String tipoExportacaoInterface, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, RetornoImpressaoEtiquetas retorno, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar) throws ImpressaoException {
        ArrayList<ExameMaterial> impressos = new ArrayList<ExameMaterial>();
        String requisicao = this.handler.extrairRequisicaoPai(listExames);
        boolean etiquetaSelecionada = false;
        int codigoLote = -1;
        String filial = this.findFilial(listExames, requisicao);
        try {
            LaboratorioExterno labExterno = UtilExportadores.localizaLabExternoJalisWS(filial, st);
            if (LoteJalisWSDao.haExamesEnviarLabJalisWS(filial, requisicao, st)) {
                List<Registro> registrosRequisicoes = carregarExameRequisicao.carregar(isColetaWeb, requisicao, filial, labExterno, tipoEtiqueta, agruparGuiasInterface, st, filialPadrao, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, digitosTuboFilial, digitosTuboRequisicao, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, arquivar, anular);
                ArrayList<Registro> listaRequisicoes = new ArrayList<Registro>();
                if (tipoEtiqueta == 3 || tipoEtiqueta == 4) {
                    Registro exa = this.jalisWs.getExameSelecionado(requisicao, exames, registrosRequisicoes);
                    if (exa != null) {
                        listaRequisicoes.add(exa);
                    }
                    registrosRequisicoes.clear();
                    etiquetaSelecionada = true;
                }
                this.jalisWs.setImpressora(impressora);
                retorno = this.jalisWs.criarLote(!registrosRequisicoes.isEmpty() ? registrosRequisicoes : listaRequisicoes, etiquetaSelecionada, isColetaWeb, agruparInterface, st, stEtq2, stEtq3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, retorno, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar);
                codigoLote = retorno.getCodigoLote();
            }
        }
        catch (Exception e) {
            throw new ImpressaoException("N\u00e3o foi poss\u00edvel criar lote \u00c1lvaro\n" + e.getMessage(), e);
        }
        if (codigoLote > -1) {
            ImprimirEtiquetasColetaTriagem.criaRecipiente(isColetaWeb, filial, requisicao, tipoEtiqueta, true, true, st, stEtq, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, agruparInterface, agruparGuiasInterface);
            impressos.addAll(this.buscarExamesComLote(filial, requisicao, exames, materiais, impressos, agruparInterface, st));
        }
        retorno.setExames(impressos);
        return retorno;
    }

    private String findFilial(List<ExameRequisicaoVO> exames, String requisicao) throws ImpressaoException {
        ExameRequisicaoVO exameRequisicao = this.handler.findByID(Integer.valueOf(requisicao), exames);
        FilialVO filial = exameRequisicao.getFilial();
        if (filial != null) {
            return String.valueOf(filial.getCodigo());
        }
        throw new ImpressaoException("N\u00e3o foi poss\u00edvel verificar filial do exame");
    }

    private List<ExameMaterial> buscarExamesComLote(String filial, String requisicao, String[] exames, int[] materiais, List<ExameMaterial> impressos, int agruparInterface, Statement st) {
        ArrayList<ExameMaterial> listaExamesNaoImprimir = new ArrayList<ExameMaterial>();
        ArrayList<Registro> examesComLote = UtilExportadores.verificaExamesComLote(filial, requisicao, exames, materiais, agruparInterface, st);
        for (Registro r : examesComLote) {
            ExameMaterial exameMaterial = new ExameMaterial(r.getString("codigoExame".toLowerCase()), r.getInt("codigoMaterial".toLowerCase()));
            if (listaExamesNaoImprimir.contains(exameMaterial)) continue;
            listaExamesNaoImprimir.add(exameMaterial);
        }
        return listaExamesNaoImprimir;
    }

    public RetornoImpressaoEtiquetas imprimirEtiquetasComLote(List<ExameRequisicaoVO> exames, ImpressorasLabExterno impressoras, Statement st, Statement st2, int agruparInterface, String tamanhoNomeImpressora, String[] impressorasLocais, boolean isColetaWeb, RetornoImpressaoEtiquetas retornoEtq, Callable<Boolean> arquivar, Callable<Boolean> anular) throws ImpressaoException {
        ArrayList<byte[]> etqs = retornoEtq.getEtiquetasLabExterno() != null && !retornoEtq.getEtiquetasLabExterno().isEmpty() ? retornoEtq.getEtiquetasLabExterno().get("jalisws") : new ArrayList<byte[]>();
        ArrayList<ExameMaterial> impressos = new ArrayList<ExameMaterial>();
        ArrayList<String> retorno = new ArrayList<String>();
        String filial = String.valueOf(exames.get(0).getFilial().getCodigo());
        String requisicao = this.handler.extrairRequisicaoPai(exames);
        String[] codExames = this.handler.extrairExames(exames).toArray(new String[0]);
        int[] materiais = this.handler.extrairMateriaisArray(exames);
        ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(this.getImpressora(impressoras, agruparInterface), tamanhoNomeImpressora, impressorasLocais), isColetaWeb);
        ArrayList<Registro> listaExamesLotesJalisWS = LoteJalisWSDao.verificaExamesComLote(filial, requisicao, codExames, materiais, st, agruparInterface);
        List<Registro> listaRegistro = this.carregarRegistro(filial, requisicao, listaExamesLotesJalisWS, st, st2);
        for (Registro reg : listaRegistro) {
            List amostras = (List)reg.getValor("amostras");
            ExameMaterial exa = new ExameMaterial(reg.getString("exa_codigo"), reg.getInt("mco_codigo"));
            impressos.add(exa);
            for (Registro amostra : amostras) {
                String etq = amostra.getString("layout");
                if (retorno.contains(etq)) continue;
                retorno.add(etq);
            }
        }
        for (String etq : retorno) {
            PrintService service = Funcoes.localizarImpressora(Impressao.comparaNomeImpressoraReduzido(this.getImpressora(impressoras, agruparInterface), tamanhoNomeImpressora, impressorasLocais));
            etqs.add(ImpressaoTermica.imprimirDireto(service, etq, true, st, isColetaWeb, arquivar, anular));
        }
        HashMap<String, List<byte[]>> etiquetasLab = new HashMap<String, List<byte[]>>();
        etiquetasLab.put("jalisws", etqs);
        retornoEtq.setEtiquetasLabExterno(etiquetasLab);
        return retornoEtq;
    }

    public String getImpressora(ImpressorasLabExterno impressoras, int agruparInterface) {
        String impressora = impressoras.getImpressoraJalisWS();
        if (Funcoes.textoVazio(impressora)) {
            impressora = impressoras.getImpressoraEtqTriagem();
            if (agruparInterface == 0) {
                impressora = impressoras.getImpressoraEtqColeta();
            }
        }
        return impressora;
    }

    private List<Registro> carregarRegistro(String filial, String requisicao, ArrayList<Registro> listaExamesLotesJalisWS, Statement st, Statement st2) throws ImpressaoException {
        List<Registro> registro = new ArrayList<Registro>();
        if (listaExamesLotesJalisWS != null && !listaExamesLotesJalisWS.isEmpty()) {
            try {
                registro = this.loteService.requisicaoEnviadaParaJalisWS(requisicao, filial, true, st, st2);
            }
            catch (Exception e) {
                throw new ImpressaoException("N\u00e3o foi poss\u00edvel verificar laborat\u00f3rio externo para a requisi\u00e7\u00e3o.\n" + e.getMessage(), e);
            }
        }
        return registro;
    }
}

