/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.exame.externo.indlab;

import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;

public class LoteIndLabDao {
    public boolean haExamesEnviar(String codigoFilial, String codigoRequisicao, Statement st) throws SQLException {
        Object[] multiguia = RecepcaoUtil.verificaMultiGuias(st, codigoFilial, codigoRequisicao, true, false);
        Arrays.sort(multiguia);
        String guias = StringUtil.implode(Arrays.asList(multiguia), ",");
        StringBuilder buf = new StringBuilder();
        buf.append(" select lab.lae_configuracao, (lote.lex_codigo is null or lr.leq_retornows is null) as haExame ");
        buf.append("   from examerequisicao exr ");
        buf.append("   join requisicao req on exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo ");
        buf.append("   join examematcoletalabexterno ele on exr.fil_codigo = ele.fil_codigo and exr.exa_codigo = ele.exa_codigo and exr.mco_codigo = ele.mco_codigo ");
        buf.append(" left join loteexternorequisicao lr on lr.fil_kodigo = req.fil_codigo and lr.req_codigo = req.req_codigo ");
        buf.append(" left join labexterno lab on ele.fil_codigo = lab.fil_codigo and ele.lae_codigo = lab.lae_codigo ");
        buf.append(" left join loteexternoexamerequisicao lote on exr.fil_codigo = lote.fil_kodigo and exr.exa_codigo = lote.exa_codigo and exr.mco_codigo = lote.mco_codigo and exr.req_codigo = lote.req_codigo and exr.fil_codigo = lote.fil_kodigo ");
        buf.append(" left join loteexterno on loteexterno.fil_codigo  = lote.fil_codigo and loteexterno.lex_codigo  = lote.lex_codigo and loteexterno.lae_codigo = lote.lae_codigo ");
        buf.append("  where exr.fil_codigo = ").append(codigoFilial);
        buf.append("    and req.req_codigo IN (").append(guias).append(") ");
        buf.append("    and (not req.req_excluida or req.req_origemagendamento) ");
        buf.append("    and not exr.exr_excluido ");
        buf.append("    and lab.lae_protocolo = '").append((Object)Protocolo.INDLab).append("' ");
        buf.append("    and (lote.lex_codigo is null or lr.leq_retornows is null or lr.leq_dataestorno is not null) ");
        buf.append("  and loteexterno.lae_codigo  is null ");
        buf.append(" order by lr.leq_dataestorno desc ");
        ResultSet rs = st.executeQuery(buf.toString());
        if (rs.next()) {
            return rs.getBoolean("haExame");
        }
        rs.close();
        return false;
    }

    public LaboratorioExterno pesquisarLabExternoINDLab(String codFilial, Statement st) throws SQLException {
        LaboratorioExterno labExterno = null;
        StringBuilder buf = new StringBuilder();
        buf.append(" select lae_codigo, lae_configuracao ");
        buf.append(" from labexterno where fil_codigo = ").append(codFilial);
        buf.append(" and lae_protocolo = '").append((Object)Protocolo.INDLab).append("' ");
        LaboratorioExterno[] listas = LaboratorioExterno.getDescricoes(st, false);
        st.setPoolable(true);
        ResultSet rs = st.executeQuery(buf.toString());
        block0: while (rs.next()) {
            for (LaboratorioExterno laboratorioExterno : listas) {
                if (!laboratorioExterno.codigoLab.equals(rs.getString("lae_codigo"))) continue;
                labExterno = laboratorioExterno;
                continue block0;
            }
        }
        return labExterno;
    }

    public boolean exameTemLote(Registro exame, Statement st) throws SQLException {
        StringBuilder sql = new StringBuilder(" select leer.lex_codigo ");
        sql.append(" from loteexternoexamerequisicao leer ");
        sql.append(" join loteexternorequisicao ler on ler.fil_codigo = leer.fil_codigo ");
        sql.append(" and ler.lex_codigo = leer.lex_codigo and ler.fil_kodigo = leer.fil_kodigo ");
        sql.append(" and ler.lae_codigo = leer.lae_codigo and ler.req_codigo = leer.req_codigo ");
        sql.append(" join loteexterno le on leer.fil_codigo = le.fil_codigo and leer.lex_codigo = le.lex_codigo and leer.lae_codigo = le.lae_codigo ");
        sql.append(" where leer.fil_kodigo = ").append(exame.getString("fil_codigo"));
        sql.append(" and leer.req_codigo = ").append(exame.getString("req_codigo"));
        sql.append(" and leer.exa_codigo = ").append(StringUtil.textoDBEscape(exame.getString("exa_codigo")));
        sql.append(" and leer.mco_codigo = ").append(exame.getString("mco_codigo"));
        sql.append(" and ( le.lex_dataestorno is null and le.usr_codestorno is null ");
        sql.append(" and ler.leq_dataestorno is null and ler.usr_codestorno is null ");
        sql.append(" and leer.ler_datahoraestorno is null and leer.usr_codestorno is null) ");
        boolean temLote = false;
        st.setPoolable(true);
        ResultSet rs = st.executeQuery(sql.toString());
        while (rs.next()) {
            temLote = true;
        }
        return temLote;
    }

    public static ArrayList<Registro> verificaExamesComLote(String filial, String requisicao, String[] exames, Integer[] materiais, Statement st, int agruparInterface) throws SQLException {
        ArrayList<Registro> lista = new ArrayList<Registro>();
        String guias = requisicao;
        if (agruparInterface == 0 || agruparInterface == 1) {
            Integer[] multiguia = null;
            try {
                multiguia = RecepcaoUtil.verificaMultiGuias(st, filial, requisicao, true, false);
            }
            catch (Exception e1) {
                throw new SQLException("N\u00e2o foi poss\u00edvel verificiar multiguia no carregamento de lote.\n" + e1.getMessage(), e1);
            }
            guias = StringUtil.implode(Arrays.asList(multiguia), ",");
        }
        StringBuilder buf = new StringBuilder();
        buf.append("select lot.lex_codigo, lotex.exa_codigo as codigoExame, ");
        buf.append("       lotex.mco_codigo as codigoMaterial, ");
        buf.append("       lot.leq_retornows as retornoWs");
        buf.append("  from loteexternorequisicao lot ");
        buf.append("  join loteexternoexamerequisicao lotex on lot.fil_codigo = lotex.fil_codigo and lot.req_codigo = lotex.req_codigo and lot.lex_codigo = lotex.lex_codigo ");
        buf.append(" where lot.fil_kodigo = ").append(filial);
        buf.append("   and lot.req_codigo in (").append(guias).append(") ");
        buf.append("   and lot.leq_retornows is not null ");
        buf.append("   and lot.leq_dataestorno is null ");
        if (exames != null && exames.length > 0 && materiais != null && materiais.length > 0) {
            buf.append("  and (lotex.exa_codigo, lotex.mco_codigo) IN (");
            for (int i = 0; i < exames.length; ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append("(").append(StringUtil.textoDBEscape(exames[i]));
                buf.append(",").append(materiais[i]).append(")");
            }
            buf.append(" ) ");
        }
        try {
            ResultSet rs = st.executeQuery(buf.toString());
            Registro reg = null;
            while (rs.next()) {
                reg = new Registro(rs);
                lista.add(reg);
            }
            rs.close();
        }
        catch (Exception e) {
            throw new SQLException("N\u00e2o foi poss\u00edvel verificar lote externo.\n" + e.getMessage(), e);
        }
        return lista;
    }
}

