/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.exame.externo.db;

import jalis.comum.Variaveis;
import jalis.laboratorio.impressao.ImpressaoException;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.InfoComplementar;
import jalis.laboratorio.triagem.externo.exportadores.db2.ExportacaoParaDB;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.exame.ExameMaterial;
import jalis.laboratorio.util.impressao.exame.externo.CarregaExameRequisicao;
import jalis.laboratorio.util.impressao.exame.externo.CarregaExameRequisicaoPadrao;
import jalis.laboratorio.util.impressao.exame.externo.CarregarExameRequisicaoFilial;
import jalis.laboratorio.util.impressao.exame.externo.db.LoteDBDao;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.service.recepcao.ExameRequisicaoService;
import jalis.util.Funcoes;
import jalis.util.tabela.Registro;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class LoteDB {
    private final LoteDBDao dao;
    private final ExportacaoParaDB db = new ExportacaoParaDB();

    public LoteDB(LoteDBDao dao) {
        this.dao = dao;
    }

    public RetornoImpressaoEtiquetas criarLoteFilialExame(boolean isColetaWeb, LaboratorioExterno labExterno, String filial, String requisicao, String[] exames, int[] materiais, int tipoEtq, boolean agruparGuiasInterface, Statement st, String filialPadrao, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, int digitosTuboFilial, int digitosTuboRequisicao, String tipoExportacaoInterface, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar) throws ImpressaoException {
        CarregarExameRequisicaoFilial carregarExameRequisicao = new CarregarExameRequisicaoFilial(this.db);
        return this.criarLote(isColetaWeb, labExterno, filial, requisicao, exames, materiais, carregarExameRequisicao, tipoEtq, agruparGuiasInterface, st, filialPadrao, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, digitosTuboFilial, digitosTuboRequisicao, tipoExportacaoInterface, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar);
    }

    public RetornoImpressaoEtiquetas criarLotePadraoExame(boolean isColetaWeb, LaboratorioExterno labExterno, String filial, String requisicao, String[] exames, int[] materiais, int tipoEtq, boolean agruparGuiasInterface, Statement st, String filialPadrao, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, int digitosTuboFilial, int digitosTuboRequisicao, String tipoExportacaoInterface, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar) throws ImpressaoException {
        CarregaExameRequisicaoPadrao carregarExameRequisicao = new CarregaExameRequisicaoPadrao(this.db);
        return this.criarLote(isColetaWeb, labExterno, filial, requisicao, exames, materiais, carregarExameRequisicao, tipoEtq, agruparGuiasInterface, st, filialPadrao, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, digitosTuboFilial, digitosTuboRequisicao, tipoExportacaoInterface, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar);
    }

    private RetornoImpressaoEtiquetas criarLote(boolean isColetaWeb, LaboratorioExterno labExterno, String filial, String requisicao, String[] exames, int[] materiais, CarregaExameRequisicao carregarExameRequisicao, int tipoEtq, boolean agruparGuiasInterface, Statement st, String filialPadrao, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, int digitosTuboFilial, int digitosTuboRequisicao, String tipoExportacaoInterface, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar) throws ImpressaoException {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        ArrayList<ExameMaterial> criados = new ArrayList<ExameMaterial>();
        try {
            block11: {
                int lote = -1;
                ExportacaoParaDB db = new ExportacaoParaDB();
                boolean etiquetaSelecionada = false;
                if (!this.dao.haExamesEnviarDB(filial, requisicao, exames, st)) break block11;
                if (!LoteDBDao.isEnvioAutomaticoDB(labExterno, st)) {
                    retorno.setExames(criados);
                    return retorno;
                }
                try {
                    ArrayList<Registro> listaRequisicoes;
                    List<Registro> listaRequisicoesDB;
                    block13: {
                        Registro exa;
                        block12: {
                            listaRequisicoesDB = carregarExameRequisicao.carregar(isColetaWeb, requisicao, filial, labExterno, -1, agruparGuiasInterface, st, filialPadrao, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, digitosTuboFilial, digitosTuboRequisicao, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, arquivar, anular);
                            if (!listaRequisicoesDB.isEmpty()) {
                                this.ordenarExames(listaRequisicoesDB, st, isColetaWeb);
                            }
                            listaRequisicoes = new ArrayList<Registro>();
                            if (tipoEtq == 3) break block12;
                            if (tipoEtq != 4) break block13;
                        }
                        if ((exa = db.getExameSelecionado(requisicao, exames, listaRequisicoesDB)) != null && exa.getHashOriginal() != null && !exa.getHashOriginal().isEmpty()) {
                            listaRequisicoes.add(exa);
                        }
                        listaRequisicoesDB.clear();
                        etiquetaSelecionada = true;
                    }
                    retorno = db.criarLote(listaRequisicoesDB.isEmpty() ? listaRequisicoes : listaRequisicoesDB, etiquetaSelecionada, isColetaWeb, agruparInterface, st, stEtq2, stEtq3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, retorno, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar);
                    lote = retorno.getCodigoLote();
                }
                catch (Exception e) {
                    throw new ImpressaoException("Erro ao carregar requisicoes DB\n" + e.getMessage(), e);
                }
                ArrayList<Registro> examesComLote = LoteDBDao.verificaExamesComLote(filial, requisicao, exames, materiais, st, agruparInterface);
                for (Registro r : examesComLote) {
                    ExameMaterial exameMaterial = new ExameMaterial(r.getString("codigoExame".toLowerCase()), r.getInt("codigoMaterial".toLowerCase()));
                    criados.add(exameMaterial);
                }
            }
            retorno.setExames(criados);
            return retorno;
        }
        catch (Exception e1) {
            throw new ImpressaoException(e1.getMessage(), e1);
        }
    }

    private void ordenarExames(List<Registro> listaRequisicoes, Statement st, boolean isColetaWeb) {
        for (Registro regRequisicoes : listaRequisicoes) {
            HashMap<String, Object> chave = new HashMap<String, Object>();
            chave.put("fil_codigo", regRequisicoes.getValor("fil_codigo"));
            chave.put("req_codigo", regRequisicoes.getValor("req_codigo"));
            List<ExameRequisicaoVO> examesRequisicao = null;
            try {
                examesRequisicao = new ExameRequisicaoService().getVOsIn(chave, st, Variaveis.filialPadrao, isColetaWeb);
            }
            catch (ThreadDaoException | SQLException e) {
                e.printStackTrace();
            }
            if (Funcoes.objectIsNull(examesRequisicao)) continue;
            List listaExame = (List)regRequisicoes.getValor("listaexames");
            ArrayList listaBase = new ArrayList();
            listaBase.addAll(listaExame);
            block3: for (Registro r : listaBase) {
                for (ExameRequisicaoVO vo : examesRequisicao) {
                    if (!vo.getExame().getCodigo().equals(r.getString("exa_codigo"))) continue;
                    listaExame.remove(r);
                    int ordem = vo.getOrdem();
                    if (listaExame.size() < vo.getOrdem()) {
                        ordem = listaExame.size();
                    }
                    listaExame.add(ordem, r);
                    continue block3;
                }
            }
        }
    }
}

