/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.exame.externo.db;

import jalis.laboratorio.impressao.ImpressaoException;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.InfoComplementar;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.triagem.externo.exportadores.db2.ExportacaoParaDB;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.exame.ExameMaterial;
import jalis.laboratorio.util.impressao.exame.ExameRequisicaoListHandler;
import jalis.laboratorio.util.impressao.exame.ImpressaoExame;
import jalis.laboratorio.util.impressao.exame.externo.ImpressaoVO;
import jalis.laboratorio.util.impressao.exame.externo.db.ImpressaoDiagnosticoBrasilDao;
import jalis.laboratorio.util.impressao.exame.externo.db.LoteDB;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.util.tabela.Registro;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class ImpressaoDiagnosticoBrasil
implements ImpressaoExame {
    private final ExameRequisicaoListHandler handler;
    private final ExportacaoParaDB db;
    private final LoteDB lote;
    private final ImpressaoDiagnosticoBrasilDao dao;

    public ImpressaoDiagnosticoBrasil(ExportacaoParaDB db, LoteDB lote, ExameRequisicaoListHandler handler, ImpressaoDiagnosticoBrasilDao dao) {
        this.db = db;
        this.lote = lote;
        this.handler = handler;
        this.dao = dao;
    }

    @Override
    public RetornoImpressaoEtiquetas imprimir(boolean isColetaWeb, ImpressaoVO dados, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean agruparGuiasInterface, String filialPadrao, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, ImpressorasLabExterno impressoras, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar, int casasPrecoExame, RoundingMode arredondamentoPrecoExame) throws ImpressaoException {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        ArrayList<ExameMaterial> impressos = new ArrayList<ExameMaterial>();
        String filial = String.valueOf(dados.filial);
        String requisicao = String.valueOf(dados.getRequisicaoPai());
        LaboratorioExterno labExterno = this.buscarLabExterno(filial, dados.getListaExameRequisicaoVO(), st);
        int[] materiais = this.toIntArray(dados.getMateriais());
        String[] examesString = dados.getExames().toArray(new String[0]);
        int tipoEtq = dados.getTipoEtiqueta();
        retorno = this.lote.criarLoteFilialExame(isColetaWeb, labExterno, filial, requisicao, examesString, materiais, tipoEtq, agruparGuiasInterface, st, filialPadrao, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, digitosTuboFilial, digitosTuboRequisicao, tipoExportacaoInterface, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar);
        impressos.addAll(retorno.getExames());
        if (impressos.isEmpty()) {
            this.db.imprimirEtiquetaDBWS(filial, requisicao, labExterno, examesString, materiais, isColetaWeb, st, impressoras.getImpressoraDiagnosticosBrasil(), tamanhoNomeImpressora, impressorasLocais, retorno, arquivar, anular);
        }
        impressos.addAll(this.buscarExamesComLote(filial, requisicao, examesString, materiais, agruparInterface, st));
        retorno.setExames(impressos);
        return retorno;
    }

    @Override
    public RetornoImpressaoEtiquetas imprimirPadrao(boolean isColetaWeb, ImpressaoVO dados, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean agruparGuiasInterface, String filialPadrao, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, ImpressorasLabExterno impressoras, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar, int casasPrecoExame, RoundingMode arredondamentoPrecoExame) throws ImpressaoException {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        ArrayList<ExameMaterial> impressos = new ArrayList<ExameMaterial>();
        String filial = String.valueOf(dados.filial);
        String requisicao = String.valueOf(dados.getRequisicaoPai());
        LaboratorioExterno labExterno = this.buscarLabExterno(filial, dados.getListaExameRequisicaoVO(), st);
        int[] materiais = this.toIntArray(dados.getMateriais());
        String[] examesString = dados.getExames().toArray(new String[0]);
        int tipoEtq = dados.getTipoEtiqueta();
        retorno = this.lote.criarLotePadraoExame(isColetaWeb, labExterno, filial, requisicao, examesString, materiais, tipoEtq, agruparGuiasInterface, st, filialPadrao, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, digitosTuboFilial, digitosTuboRequisicao, tipoExportacaoInterface, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar);
        impressos.addAll(retorno.getExames());
        if (impressos.isEmpty() && dados.reimprimir) {
            this.db.imprimirEtiquetaDBWS(filial, requisicao, labExterno, examesString, materiais, isColetaWeb, st, impressoras.getImpressoraDiagnosticosBrasil(), tamanhoNomeImpressora, impressorasLocais, retorno, arquivar, anular);
        }
        if (impressos.isEmpty()) {
            impressos.addAll(this.buscarExamesComLote(filial, requisicao, examesString, materiais, agruparInterface, st));
        }
        retorno.setExames(impressos);
        return retorno;
    }

    private LaboratorioExterno buscarLabExterno(String filial, List<ExameRequisicaoVO> examesRequisicao, Statement st) throws ImpressaoException {
        LaboratorioExterno labExterno = null;
        try {
            List<String> exames = this.handler.extrairExames(examesRequisicao);
            String[] arrayExames = exames.toArray(new String[0]);
            labExterno = this.dao.localizaLabExternoDB(String.valueOf(filial), arrayExames, st);
        }
        catch (SQLException e) {
            throw new ImpressaoException("Erro ao localizar laboratorio externo\n" + e.getMessage(), e);
        }
        return labExterno;
    }

    private List<ExameMaterial> buscarExamesComLote(String filial, String requisicao, String[] exames, int[] materiais, int agruparInterface, Statement st) {
        ArrayList<ExameMaterial> listaExamesNaoImprimir = new ArrayList<ExameMaterial>();
        ArrayList<Registro> examesComLote = UtilExportadores.verificaExamesComLote(filial, requisicao, exames, materiais, agruparInterface, st);
        for (Registro r : examesComLote) {
            ExameMaterial exameMaterial = new ExameMaterial(r.getString("codigoExame".toLowerCase()), r.getInt("codigoMaterial".toLowerCase()));
            if (listaExamesNaoImprimir.contains(exameMaterial)) continue;
            listaExamesNaoImprimir.add(exameMaterial);
        }
        return listaExamesNaoImprimir;
    }

    public int[] toIntArray(List<Integer> dados) {
        int[] resultado = new int[dados.size()];
        int index = 0;
        for (Integer dado : dados) {
            resultado[index] = dado;
            ++index;
        }
        return resultado;
    }
}

