/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.exame.externo.alvaro;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LoteAlvaroDao {
    public static boolean haExamesEnviarLabAlvaro(String codigoFilial, String codigoRequisicao, Statement st) throws SQLException {
        Object[] multiguia = null;
        try {
            multiguia = RecepcaoUtil.verificaMultiGuias(st, codigoFilial, codigoRequisicao, true, false);
        }
        catch (SQLException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e2o foi poss\u00edvel verificiar multiguia no carregamento de lote.\n" + e1.getMessage(), e1.getStackTrace());
        }
        Arrays.sort(multiguia);
        String guias = StringUtil.implode(Arrays.asList(multiguia), ",");
        StringBuilder buf = new StringBuilder();
        buf.append(" select lab.lae_configuracao, (lote.lex_codigo is null or lr.leq_retornows is null) as haExame ");
        buf.append("   from examerequisicao exr ");
        buf.append("   join requisicao req on exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo ");
        buf.append("   join examematcoletalabexterno ele on exr.fil_codigo = ele.fil_codigo and exr.exa_codigo = ele.exa_codigo and exr.mco_codigo = ele.mco_codigo ");
        buf.append(" left join loteexternorequisicao lr on lr.fil_kodigo = req.fil_codigo and lr.req_codigo = req.req_codigo ");
        buf.append(" left join labexterno lab on ele.fil_codigo = lab.fil_codigo and ele.lae_codigo = lab.lae_codigo ");
        buf.append(" left join loteexternoexamerequisicao lote on exr.fil_codigo = lote.fil_kodigo and exr.exa_codigo = lote.exa_codigo and exr.mco_codigo = lote.mco_codigo and exr.req_codigo = lote.req_codigo and exr.fil_codigo = lote.fil_kodigo ");
        buf.append(" left join loteexterno on loteexterno.fil_codigo  = lote.fil_codigo and loteexterno.lex_codigo  = lote.lex_codigo and loteexterno.lae_codigo = lote.lae_codigo ");
        buf.append("  where exr.fil_codigo = ").append(codigoFilial);
        buf.append("    and req.req_codigo IN (").append(guias).append(") ");
        buf.append("    and not req.req_excluida ");
        buf.append("    and not exr.exr_excluido ");
        buf.append("    and lab.lae_protocolo = '").append((Object)Protocolo.Alvaro).append("' ");
        buf.append("    and (lote.lex_codigo is null or lr.leq_retornows is null or lr.leq_dataestorno is not null) ");
        buf.append("  and loteexterno.lae_codigo  is null ");
        buf.append(" order by lr.leq_dataestorno desc ");
        ResultSet rs = st.executeQuery(buf.toString());
        if (rs.next()) {
            String configuracaoLabExterno = rs.getString("lae_configuracao");
            boolean enviarUsandoWS = !Funcoes.textoVazio(StringUtil.getValor(configuracaoLabExterno, "enviarLoteWebService")) ? Boolean.valueOf(StringUtil.getValor(configuracaoLabExterno, "enviarLoteWebService")) : Boolean.FALSE;
            boolean isEnvioAutomatico = !Funcoes.textoVazio(StringUtil.getValor(configuracaoLabExterno, "envioAutomatico")) ? Boolean.valueOf(StringUtil.getValor(configuracaoLabExterno, "envioAutomatico")) : Boolean.FALSE;
            if (!enviarUsandoWS || !isEnvioAutomatico) {
                return false;
            }
            return rs.getBoolean("haExame");
        }
        return false;
    }

    public static List<Registro> verificaExamesComLote(String filial, String requisicao, String[] exames, int[] materiais, Statement st, boolean agruparGuiasInterface, int agruparInterface) {
        ArrayList<Registro> lista = new ArrayList<Registro>();
        String guias = requisicao;
        if (agruparGuiasInterface && (agruparInterface == 0 || agruparInterface == 1)) {
            Integer[] multiguia = null;
            try {
                multiguia = RecepcaoUtil.verificaMultiGuias(st, filial, requisicao, true, false);
            }
            catch (SQLException e1) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e2o foi poss\u00edvel verificiar multiguia no carregamento de lote.\n" + e1.getMessage(), e1.getStackTrace());
            }
            guias = StringUtil.implode(Arrays.asList(multiguia), ",");
        }
        StringBuilder buf = new StringBuilder();
        buf.append("select lot.lex_codigo, lotex.exa_codigo as codigoExame, ");
        buf.append("       lotex.mco_codigo as codigoMaterial, ");
        buf.append("       lot.leq_retornows as retornoWs");
        buf.append("  from loteexternorequisicao lot ");
        buf.append("  join loteexternoexamerequisicao lotex on lot.fil_kodigo = lotex.fil_kodigo and lot.req_codigo = lotex.req_codigo and lot.lex_codigo = lotex.lex_codigo ");
        buf.append(" where lot.fil_kodigo = ").append(filial);
        buf.append("   and lot.req_codigo in (").append(guias).append(") ");
        buf.append("   and lot.leq_retornows is not null ");
        buf.append("   and lot.leq_dataestorno is null ");
        if (exames != null && exames.length > 0 && materiais != null && materiais.length > 0) {
            buf.append("  and (lotex.exa_codigo, lotex.mco_codigo) IN (");
            for (int i = 0; i < exames.length; ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append("(").append(StringUtil.textoDBEscape(exames[i]));
                buf.append(",").append(materiais[i]).append(")");
            }
            buf.append(" ) ");
        }
        try {
            ResultSet rs = st.executeQuery(buf.toString());
            Registro reg = null;
            while (rs.next()) {
                reg = new Registro(rs);
                lista.add(reg);
            }
            rs.close();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e2o foi poss\u00edvel verificar lote externo.\n" + e.getMessage(), e.getStackTrace());
        }
        return lista;
    }
}

