/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.exame.externo.alvaro;

import jalis.laboratorio.impressao.ImpressaoException;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.ExportacaoParaAlvaro;
import jalis.laboratorio.triagem.externo.exportadores.InfoComplementar;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.ImprimirEtiquetasColetaTriagem;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.exame.ExameMaterial;
import jalis.laboratorio.util.impressao.exame.ExameRequisicaoListHandler;
import jalis.laboratorio.util.impressao.exame.externo.CarregaExameRequisicao;
import jalis.laboratorio.util.impressao.exame.externo.CarregaExameRequisicaoPadrao;
import jalis.laboratorio.util.impressao.exame.externo.CarregarExameRequisicaoFilial;
import jalis.laboratorio.util.impressao.exame.externo.alvaro.LoteAlvaroDao;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.service.triagem.LoteExternoExameRequisicaoService;
import jalis.util.Funcoes;
import jalis.util.impressao.termica.ImpressaoTermica;
import jalis.util.tabela.Registro;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class LoteAlvaro {
    private final ExameRequisicaoListHandler handler;
    private final LoteAlvaroDao dao;
    private final LoteExternoExameRequisicaoService loteService;
    private final ExportacaoParaAlvaro alvaro = new ExportacaoParaAlvaro();
    private String impressora;

    public LoteAlvaro(LoteAlvaroDao dao, ExameRequisicaoListHandler handler, LoteExternoExameRequisicaoService loteService) {
        this.handler = handler;
        this.dao = dao;
        this.loteService = loteService;
    }

    public RetornoImpressaoEtiquetas criarLoteFilialExame(boolean isColetaWeb, List<ExameRequisicaoVO> listExames, String impressora, int tipoEtiqueta, String[] exames, int[] materiais, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean agruparGuiasInterface, String filialPadrao, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar) throws ImpressaoException {
        CarregarExameRequisicaoFilial carregarExameRequisicao = new CarregarExameRequisicaoFilial(this.alvaro);
        return this.criarLote(isColetaWeb, listExames, impressora, tipoEtiqueta, carregarExameRequisicao, exames, materiais, st, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, agruparGuiasInterface, filialPadrao, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar);
    }

    public RetornoImpressaoEtiquetas criarLotePadraoExame(boolean isColetaWeb, List<ExameRequisicaoVO> listExames, String impressora, int tipoEtiqueta, String[] exames, int[] materiais, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean agruparGuiasInterface, String filialPadrao, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar) throws ImpressaoException {
        CarregaExameRequisicaoPadrao carregarExameRequisicao = new CarregaExameRequisicaoPadrao(this.alvaro);
        return this.criarLote(isColetaWeb, listExames, impressora, tipoEtiqueta, carregarExameRequisicao, exames, materiais, st, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, agruparGuiasInterface, filialPadrao, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar);
    }

    private RetornoImpressaoEtiquetas criarLote(boolean isColetaWeb, List<ExameRequisicaoVO> listExames, String impressora, int tipoEtiqueta, CarregaExameRequisicao carregarExameRequisicao, String[] exames, int[] materiais, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean agruparGuiasInterface, String filialPadrao, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar) throws ImpressaoException {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        ArrayList<ExameMaterial> impressos = new ArrayList<ExameMaterial>();
        String requisicao = this.handler.extrairRequisicaoPai(listExames);
        boolean etiquetaSelecionada = false;
        int codigoLote = -1;
        String filial = this.findFilial(listExames, requisicao);
        try {
            LaboratorioExterno labExterno = UtilExportadores.localizaLabExterno(filial, st);
            if (LoteAlvaroDao.haExamesEnviarLabAlvaro(filial, requisicao, st)) {
                List<Registro> registrosRequisicoes = carregarExameRequisicao.carregar(isColetaWeb, requisicao, filial, labExterno, tipoEtiqueta, agruparGuiasInterface, st, filialPadrao, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, digitosTuboFilial, digitosTuboRequisicao, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, arquivar, anular);
                ArrayList<Registro> listaRequisicoes = new ArrayList<Registro>();
                if (tipoEtiqueta == 3 || tipoEtiqueta == 4) {
                    Registro exa = this.alvaro.getExameSelecionado(requisicao, exames, registrosRequisicoes);
                    if (exa != null && exa.getQtdeColunas() > 0) {
                        listaRequisicoes.add(exa);
                    }
                    registrosRequisicoes.clear();
                    etiquetaSelecionada = true;
                }
                this.alvaro.setImpressora(impressora);
                retorno = this.alvaro.criarLote(!registrosRequisicoes.isEmpty() ? registrosRequisicoes : listaRequisicoes, etiquetaSelecionada, isColetaWeb, agruparInterface, st, stEtq2, stEtq3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, retorno, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar);
                codigoLote = retorno.getCodigoLote();
            }
        }
        catch (Exception e) {
            throw new ImpressaoException("N\u00e3o foi poss\u00edvel criar lote \u00c1lvaro\n" + e.getMessage(), e);
        }
        if (codigoLote > -1) {
            impressos.addAll(this.buscarExamesComLote(filial, requisicao, exames, materiais, agruparInterface, st));
            ImprimirEtiquetasColetaTriagem.criaRecipiente(isColetaWeb, filial, requisicao, tipoEtiqueta, true, true, st, stEtq, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, agruparInterface, agruparGuiasInterface);
        }
        retorno.setExames(impressos);
        return retorno;
    }

    private String findFilial(List<ExameRequisicaoVO> exames, String requisicao) throws ImpressaoException {
        ExameRequisicaoVO exameRequisicao = this.handler.findByID(Integer.valueOf(requisicao), exames);
        FilialVO filial = exameRequisicao.getFilial();
        if (filial != null) {
            return String.valueOf(filial.getCodigo());
        }
        throw new ImpressaoException("N\u00e3o foi poss\u00edvel verificar filial do exame");
    }

    private List<ExameMaterial> buscarExamesComLote(String filial, String requisicao, String[] exames, int[] materiais, int agruparInterface, Statement st) {
        ArrayList<ExameMaterial> listaExamesNaoImprimir = new ArrayList<ExameMaterial>();
        ArrayList<Registro> examesComLote = UtilExportadores.verificaExamesComLote(filial, requisicao, exames, materiais, agruparInterface, st);
        for (Registro r : examesComLote) {
            ExameMaterial exameMaterial = new ExameMaterial(r.getString("codigoExame".toLowerCase()), r.getInt("codigoMaterial".toLowerCase()));
            if (listaExamesNaoImprimir.contains(exameMaterial)) continue;
            listaExamesNaoImprimir.add(exameMaterial);
        }
        return listaExamesNaoImprimir;
    }

    public List<ExameMaterial> imprimirEtiquetasComLote(List<ExameRequisicaoVO> exames, String impressora, int agruparInterface, ImpressorasLabExterno impressoras, String tamanhoNomeImpressora, String[] impressorasLocais, Statement st, Statement st2, boolean isColetaWeb, RetornoImpressaoEtiquetas retorno, boolean agruparGuiasInterface, Callable<Boolean> arquivar, Callable<Boolean> anular) throws ImpressaoException {
        ArrayList<ExameMaterial> impressos = new ArrayList<ExameMaterial>();
        ArrayList<String> amostrasExame = new ArrayList<String>();
        String filial = String.valueOf(exames.get(0).getFilial().getCodigo());
        String requisicao = this.handler.extrairRequisicaoPai(exames);
        String[] codExames = this.handler.extrairExames(exames).toArray(new String[0]);
        int[] materiais = this.handler.extrairMateriaisArray(exames);
        ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(this.getImpressora(agruparInterface, impressoras), tamanhoNomeImpressora, impressorasLocais), isColetaWeb);
        List<Registro> listaExamesLotesAlvaro = LoteAlvaroDao.verificaExamesComLote(filial, requisicao, codExames, materiais, st, agruparGuiasInterface, agruparInterface);
        List<Registro> listaRegistro = this.carregarRegistro(filial, requisicao, listaExamesLotesAlvaro, st, st2, agruparGuiasInterface);
        for (Registro registro : listaRegistro) {
            List list = (List)registro.getValor("amostras");
            ExameMaterial exa = new ExameMaterial(registro.getString("exa_codigo"), registro.getInt("mco_codigo"));
            impressos.add(exa);
            for (Registro amostra : list) {
                String etq2 = amostra.getString("layout");
                if (amostrasExame.contains(etq2)) continue;
                amostrasExame.add(etq2);
            }
        }
        ArrayList<Object> etiquetas = new ArrayList<Object>();
        for (String string : amostrasExame) {
            etiquetas.add(termica.imprimirDireto(string, true, st, isColetaWeb, arquivar, anular));
        }
        HashMap<String, List<byte[]>> hashMap = new HashMap<String, List<byte[]>>();
        ArrayList arrayList = retorno.getEtiquetasLabExterno() != null && !retorno.getEtiquetasLabExterno().isEmpty() ? retorno.getEtiquetasLabExterno().get("alvaro") : new ArrayList();
        etiquetas.addAll(arrayList);
        hashMap.put("alvaro", etiquetas);
        retorno.setEtiquetasLabExterno(hashMap);
        retorno.setExames(impressos);
        return impressos;
    }

    public String getImpressora(int agruparInterface, ImpressorasLabExterno impressoras) {
        this.impressora = impressoras.getImpressoraAlvaro();
        if (Funcoes.textoVazio(this.impressora)) {
            this.impressora = impressoras.getImpressoraEtqTriagem();
            if (agruparInterface == 0) {
                this.impressora = impressoras.getImpressoraEtqColeta();
            }
        }
        return this.impressora;
    }

    private List<Registro> carregarRegistro(String filial, String requisicao, List<Registro> listaExamesLotesAlvaro, Statement st, Statement st2, boolean agruparGuiasInterface) throws ImpressaoException {
        List<Registro> registro = new ArrayList<Registro>();
        if (listaExamesLotesAlvaro != null && !listaExamesLotesAlvaro.isEmpty()) {
            try {
                registro = this.loteService.requisicaoEnviadaParaAlvaro(requisicao, filial, true, st, st2, agruparGuiasInterface);
            }
            catch (Exception e) {
                throw new ImpressaoException("N\u00e3o foi poss\u00edvel verificar laborat\u00f3rio externo para a requisi\u00e7\u00e3o.\n" + e.getMessage(), e);
            }
        }
        return registro;
    }
}

