/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.exame.externo;

import jalis.laboratorio.impressao.ImpressaoException;
import jalis.laboratorio.util.impressao.exame.externo.ImpressaoExameDao;
import jalis.laboratorio.util.impressao.exame.externo.ImpressaoVO;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.model.bean.cadastro.exame.LabExternoBean;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.util.Funcoes;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ValidadorExameLabExterno {
    private final ImpressaoExameDao dao = new ImpressaoExameDao();

    public List<ExameRequisicaoVO> filtrar(ImpressaoVO dados, LabExternoBean labExterno, boolean agruparGuiasInterface, Statement st, String filialPadrao, boolean isColetaWeb) throws ImpressaoException {
        List<ExameRequisicaoVO> configurados = null;
        try {
            configurados = this.dao.buscarExamesConfigurados(dados, labExterno, st, agruparGuiasInterface, filialPadrao, isColetaWeb);
        }
        catch (SQLException e) {
            throw new ImpressaoException(e);
        }
        return configurados;
    }

    public List<ExameRequisicaoVO> filtrarExamesComLote(ImpressaoVO dados, LabExternoBean labExterno, Statement st, boolean agruparGuiasInterface, boolean isColetaWeb) throws ImpressaoException {
        List<ExameRequisicaoVO> configurados = null;
        try {
            configurados = this.dao.buscarExamesComLoteCriado(dados, labExterno, st, agruparGuiasInterface, isColetaWeb);
        }
        catch (SQLException e) {
            throw new ImpressaoException(e);
        }
        return configurados;
    }

    public List<ExameRequisicaoVO> filtrarPadrao(ImpressaoVO dados, Protocolo protocolo, Statement st, boolean agruparGuiasInterface, boolean isColetaWeb) throws ImpressaoException {
        List<ExameRequisicaoVO> configurados = null;
        if (dados.possuiExames()) {
            try {
                configurados = this.dao.buscarExamesConfiguradosPadrao(dados, protocolo, st, agruparGuiasInterface, isColetaWeb);
            }
            catch (SQLException e) {
                throw new ImpressaoException("Erro ao buscar exames configurados\n" + e.getMessage(), e);
            }
        }
        return configurados;
    }

    public Protocolo pesquisarProtocoloLabExternoPadraoPorExame(ExameRequisicaoVO exameVO, Statement st) throws ImpressaoException {
        Protocolo protocolo = null;
        try {
            String resultado = this.dao.pesquisarProtocoloLabExternoPadraoPorExame(exameVO, st);
            protocolo = !Funcoes.textoVazio(resultado) ? Protocolo.getProtocolo(resultado) : null;
        }
        catch (SQLException e) {
            throw new ImpressaoException("Erro ao buscar protocolo do Laboratorio externo\n" + e.getMessage(), e);
        }
        return protocolo;
    }

    public Protocolo pesquisarProtocoloLabExternoPorLoteEnviado(ExameRequisicaoVO exameVO, Statement st) throws ImpressaoException {
        Protocolo protocolo = null;
        try {
            String resultado = this.dao.pesquisarProtocoloLabExternoPorLoteEnviado(exameVO, st);
            protocolo = !Funcoes.textoVazio(resultado) ? Protocolo.getProtocolo(resultado) : null;
        }
        catch (SQLException e) {
            throw new ImpressaoException("Erro ao buscar protocolo do Laboratorio externo\n" + e.getMessage(), e);
        }
        return protocolo;
    }

    public Boolean examesEnviadosEmAlgumLote(ImpressaoVO dados, Protocolo protocolo) throws ImpressaoException {
        try {
            boolean deveAgruparMultiguias = this.agrupaMultiguias(dados, protocolo);
            StringBuilder codRequisicoes = new StringBuilder();
            if (deveAgruparMultiguias) {
                codRequisicoes.append("'");
                dados.getRequisicoes().forEach(req -> codRequisicoes.append((String)req).append("','"));
                codRequisicoes.replace(codRequisicoes.length() - 2, codRequisicoes.length(), "");
            } else {
                codRequisicoes.append("'").append(dados.requisicaoPrincipal).append("'");
            }
            ArrayList<Boolean> enviados = new ArrayList<Boolean>();
            for (ExameRequisicaoVO exame : dados.getListaExameRequisicaoVO()) {
                enviados.add(this.dao.exameJaEnviadoEmAlgumLote(exame, dados.filial, codRequisicoes.toString()));
            }
            return !enviados.contains(Boolean.FALSE);
        }
        catch (SQLException e) {
            throw new ImpressaoException(e);
        }
    }

    public Boolean agrupaMultiguias(ImpressaoVO dados, Protocolo protocolo) throws ImpressaoException {
        try {
            return this.dao.deveAgruparMultiguias(dados, protocolo);
        }
        catch (SQLException e) {
            throw new ImpressaoException(e);
        }
    }
}

