/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.exame.externo;

import jalis.laboratorio.util.impressao.exame.ExameRequisicaoListHandler;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import java.util.ArrayList;
import java.util.List;

public class ImpressaoVO {
    public final Integer requisicaoPrincipal;
    public final Integer filial;
    private List<ExameRequisicaoVO> exames;
    public final String impressora;
    public final int tipoEtiqueta;
    public final Boolean isAgendamento;
    public final boolean reimprimir;
    private final ExameRequisicaoListHandler handler = new ExameRequisicaoListHandler();

    public ImpressaoVO(Integer requisicao, List<ExameRequisicaoVO> exames, String impressora, int tipoEtiqueta, Boolean isAgendamento, boolean reimprimir) {
        this.filial = exames.get(0).getFilial().getCodigo();
        this.requisicaoPrincipal = requisicao;
        this.exames = exames;
        this.impressora = impressora;
        this.tipoEtiqueta = tipoEtiqueta;
        this.isAgendamento = isAgendamento;
        this.reimprimir = reimprimir;
    }

    public void setListExameRequisicaoVo(List<ExameRequisicaoVO> exames) {
        if (exames != null) {
            this.exames = exames;
        } else {
            this.exames.clear();
        }
    }

    public List<ExameRequisicaoVO> getListaExameRequisicaoVO() {
        return this.exames;
    }

    public List<String> getRequisicoes() {
        return this.handler.extrairRequisicoes(this.exames);
    }

    public List<String> getExames() {
        return this.handler.extrairExames(this.exames);
    }

    public List<Integer> getMateriais() {
        return this.handler.extrairMateriaisInteger(this.exames);
    }

    public int getTipoEtiqueta() {
        return this.tipoEtiqueta;
    }

    public boolean possuiExames() {
        return !this.exames.isEmpty();
    }

    public Integer getRequisicaoPai() {
        return Integer.valueOf(this.handler.extrairRequisicaoPai(this.exames));
    }

    public ImpressaoVO clone() {
        String impressora2 = this.impressora != null ? this.impressora : "";
        return new ImpressaoVO(this.requisicaoPrincipal, new ArrayList<ExameRequisicaoVO>(this.exames), impressora2, this.tipoEtiqueta, this.isAgendamento, this.reimprimir);
    }

    public ImpressaoVO removerExameRequisicaoVO(List<ExameRequisicaoVO> exames) {
        if (!exames.isEmpty()) {
            ArrayList<ExameRequisicaoVO> novaLista = new ArrayList<ExameRequisicaoVO>();
            this.exames.forEach(e -> novaLista.add((ExameRequisicaoVO)e));
            for (ExameRequisicaoVO exame : this.exames) {
                exames.forEach(er -> {
                    if (exame.getFilial().getCodigo().equals(er.getFilial().getCodigo()) && exame.getRequisicao().equals(er.getRequisicao()) && exame.getExame().getCodigo().equals(er.getExame().getCodigo()) && exame.getMaterial().getCodigo().equals(er.getMaterial().getCodigo())) {
                        novaLista.remove(exame);
                    }
                });
            }
            this.exames = new ArrayList<ExameRequisicaoVO>();
            this.exames = novaLista;
        }
        return this;
    }

    public ImpressaoVO removerTodosOsExames() {
        this.exames.clear();
        return this;
    }

    public void adicionarExames(List<ExameRequisicaoVO> exames) {
        this.exames.addAll(exames);
    }

    public ImpressaoVO removerExameRequisicaoVO(ImpressaoVO dadosImpressos) {
        return this.removerExameRequisicaoVO(dadosImpressos.getListaExameRequisicaoVO());
    }
}

