/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.exame.externo;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.impressao.ImpressaoException;
import jalis.laboratorio.triagem.externo.exportadores.InfoComplementar;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.exame.ExameMaterial;
import jalis.laboratorio.util.impressao.exame.ImpressaoExame;
import jalis.laboratorio.util.impressao.exame.externo.ImpressaoExameLabExterno;
import jalis.laboratorio.util.impressao.exame.externo.ImpressaoVO;
import jalis.laboratorio.util.impressao.exame.externo.ValidadorExameLabExterno;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.model.bean.cadastro.exame.LabExternoBean;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.service.cadastro.ConvenioService;
import jalis.service.cadastro.FilialService;
import jalis.service.cadastro.exame.LabExternoService;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

public class ImpressaoExameLabExternoService {
    private final ValidadorExameLabExterno validador = new ValidadorExameLabExterno();
    private final String protocoloFilial;
    private boolean naoImprimiuLabExterno = false;
    private static final String PROTOCOLO_NAO_ENCONTRADO = "Protocolo n\u00e3o encontrado.";

    public ImpressaoExameLabExternoService() throws ImpressaoException {
        this.protocoloFilial = this.carregarProtocoloLabExternoFilial(Variaveis.filialPadrao, Conexao.getStatement());
    }

    public ImpressaoExameLabExternoService(String filialPadrao, Statement st) throws ImpressaoException {
        this.protocoloFilial = this.carregarProtocoloLabExternoFilial(filialPadrao, st);
    }

    public RetornoImpressaoEtiquetas imprimir(boolean isColetaWeb, ImpressaoVO dados, boolean agruparGuiasInterface, Statement st, String filialPadrao, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, ImpressorasLabExterno impressoras, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar, int casasPrecoExame, RoundingMode arredondamentoPrecoExame) throws ImpressaoException {
        ArrayList<ExameRequisicaoVO> impressos = new ArrayList<ExameRequisicaoVO>();
        RetornoImpressaoEtiquetas retorno = this.imprimirConfiguracaoConvenio(isColetaWeb, dados, agruparGuiasInterface, st, filialPadrao, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, tuboPrimario, utilizarCapacidadeTuboPrimario, impressoras, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar, casasPrecoExame, arredondamentoPrecoExame);
        retorno = this.getExamesRemover(dados.getListaExameRequisicaoVO(), retorno.getExames(), retorno);
        impressos.addAll(retorno.getExamesRequisicao());
        if (this.naoImprimiuLabExterno || !impressos.isEmpty()) {
            retorno.setExamesRequisicao(impressos);
            return retorno;
        }
        retorno = this.imprimirConfiguracaoFilial(isColetaWeb, dados, agruparGuiasInterface, st, filialPadrao, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, tuboPrimario, utilizarCapacidadeTuboPrimario, impressoras, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar, casasPrecoExame, arredondamentoPrecoExame);
        retorno = this.getExamesRemover(dados.getListaExameRequisicaoVO(), retorno.getExames(), retorno);
        impressos.addAll(retorno.getExamesRequisicao());
        if (this.naoImprimiuLabExterno || !impressos.isEmpty()) {
            retorno.setExamesRequisicao(impressos);
            return retorno;
        }
        if (dados.possuiExames()) {
            retorno = this.imprimirExamesLabPadrao(isColetaWeb, dados, filialPadrao, st, agruparGuiasInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, tuboPrimario, utilizarCapacidadeTuboPrimario, impressoras, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar, casasPrecoExame, arredondamentoPrecoExame);
            impressos.addAll(retorno.getExamesRequisicao());
            dados.removerExameRequisicaoVO(impressos);
        }
        retorno.setExamesRequisicao(impressos);
        return retorno;
    }

    private RetornoImpressaoEtiquetas imprimirExamesLabPadrao(boolean isColetaWeb, ImpressaoVO dados, String filialPadrao, Statement st, boolean agruparGuiasInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, ImpressorasLabExterno impressoras, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar, int casasPrecoExame, RoundingMode arredondamentoPrecoExame) throws ImpressaoException {
        ImpressaoVO dadosImpressos;
        RetornoImpressaoEtiquetas retorno;
        block9: {
            retorno = new RetornoImpressaoEtiquetas();
            HashMap<String, List<byte[]>> etiquetasLaboratorio = new HashMap<String, List<byte[]>>();
            HashMap<String, String> mensagensLabExterno = new HashMap<String, String>();
            dadosImpressos = dados.clone().removerTodosOsExames();
            if (dados.possuiExames()) {
                try {
                    ArrayList<Protocolo> protocolos = new ArrayList<Protocolo>();
                    for (ExameRequisicaoVO exame : dados.getListaExameRequisicaoVO()) {
                        Protocolo prot = this.validador.pesquisarProtocoloLabExternoPorLoteEnviado(exame, st);
                        if (prot == null) {
                            prot = this.validador.pesquisarProtocoloLabExternoPadraoPorExame(exame, st);
                        }
                        if (prot != null && !prot.equals((Object)Protocolo.Jalis) && !protocolos.contains((Object)prot)) {
                            ArrayList exameImpressos;
                            ImpressaoVO dadosImp = dados.clone().removerExameRequisicaoVO(dadosImpressos);
                            retorno = this.imprimir(isColetaWeb, dadosImp, prot, st, agruparGuiasInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, filialPadrao, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, tuboPrimario, utilizarCapacidadeTuboPrimario, impressoras, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar, casasPrecoExame, arredondamentoPrecoExame);
                            if (retorno.getEtiquetasLabExterno() != null && !retorno.getEtiquetasLabExterno().isEmpty()) {
                                for (Map.Entry<String, List<byte[]>> etiquetasLab : retorno.getEtiquetasLabExterno().entrySet()) {
                                    etiquetasLaboratorio.put(etiquetasLab.getKey(), etiquetasLab.getValue());
                                }
                            }
                            dadosImpressos.adicionarExames((exameImpressos = retorno.getExamesRequisicao()) == null ? new ArrayList() : exameImpressos);
                        }
                        if (!protocolos.contains((Object)prot)) {
                            protocolos.add(prot);
                        }
                        if (retorno.getMensagensRetornoLabExterno() == null) continue;
                        mensagensLabExterno.putAll(retorno.getMensagensRetornoLabExterno());
                    }
                    retorno.setMensagensRetornoLabExterno(mensagensLabExterno);
                    retorno.setEtiquetasLabExterno(etiquetasLaboratorio);
                }
                catch (ImpressaoException e) {
                    if (e.getMessage().contains(PROTOCOLO_NAO_ENCONTRADO)) break block9;
                    throw e;
                }
            }
        }
        retorno.setExamesRequisicao(dadosImpressos.getListaExameRequisicaoVO());
        return retorno;
    }

    private RetornoImpressaoEtiquetas imprimir(boolean isColetaWeb, ImpressaoVO dados, Protocolo protocolo, Statement st, boolean agruparGuiasInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, String filialPadrao, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, ImpressorasLabExterno impressoras, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar, int casasPrecoExame, RoundingMode arredondamentoPrecoExame) throws ImpressaoException {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        if (!this.protocoloEstaConfiguradoNaFilial(protocolo) && dados.possuiExames()) {
            List<ExameRequisicaoVO> examesFiltradosPadrao;
            ImpressaoVO dadosParaImprimir = dados.clone();
            List<ExameRequisicaoVO> examesFiltrados = this.pesquiscaExamesComLote(protocolo, dadosParaImprimir, examesFiltradosPadrao = this.validador.filtrarPadrao(dadosParaImprimir, protocolo, st, agruparGuiasInterface, isColetaWeb), st, agruparGuiasInterface, isColetaWeb);
            if (examesFiltrados.isEmpty()) {
                examesFiltrados = examesFiltradosPadrao;
            }
            dadosParaImprimir.setListExameRequisicaoVo(examesFiltrados);
            if (dadosParaImprimir.possuiExames()) {
                ImpressaoExame impressaoLabExterno = ImpressaoExameLabExterno.criar(protocolo);
                retorno = impressaoLabExterno.imprimirPadrao(isColetaWeb, dadosParaImprimir, st, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, agruparGuiasInterface, filialPadrao, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, tuboPrimario, utilizarCapacidadeTuboPrimario, impressoras, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar, casasPrecoExame, arredondamentoPrecoExame);
                List<ExameMaterial> examesEnviados = retorno.getExames();
                return this.getExamesRemover(dadosParaImprimir.getListaExameRequisicaoVO(), examesEnviados, retorno);
            }
        }
        return retorno;
    }

    private boolean protocoloEstaConfiguradoNaFilial(Protocolo protocolo) {
        return protocolo.getCodigo().equalsIgnoreCase(this.protocoloFilial);
    }

    private RetornoImpressaoEtiquetas getExamesRemover(List<ExameRequisicaoVO> exames, List<ExameMaterial> examesMaterial, RetornoImpressaoEtiquetas retorno) {
        ArrayList<ExameRequisicaoVO> remover = new ArrayList();
        remover = exames.stream().filter(exame -> examesMaterial.stream().anyMatch(exrMaterial -> exame.getExame().getCodigo().equalsIgnoreCase(exrMaterial.getCodigoExame()) && exame.getMaterial().getCodigo().equals(exrMaterial.getCodigoMaterial()))).collect(Collectors.toList());
        retorno.setExamesRequisicao(remover);
        return retorno;
    }

    private RetornoImpressaoEtiquetas imprimirConfiguracaoConvenio(boolean isColetaWeb, ImpressaoVO dados, boolean agruparGuiasInterface, Statement st, String filialPadrao, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, ImpressorasLabExterno impressoras, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar, int casasPrecoExame, RoundingMode arredondamentoPrecoExame) throws ImpressaoException {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        List<ExameMaterial> impressos = new ArrayList<ExameMaterial>();
        LabExternoBean labExterno = this.carregarBeanLabExternoConvenio(dados, st, agruparGuiasInterface, filialPadrao);
        if (dados.possuiExames() && labExterno != null) {
            ImpressaoVO imprimir = dados.clone();
            imprimir.setListExameRequisicaoVo(this.validador.filtrar(imprimir, labExterno, agruparGuiasInterface, st, filialPadrao, isColetaWeb));
            if (imprimir.possuiExames()) {
                block6: {
                    try {
                        Protocolo protocoloConvenio = Protocolo.getProtocolo(labExterno.getProtocolo());
                        ImpressaoExame impressao = ImpressaoExameLabExterno.criar(protocoloConvenio);
                        retorno = impressao.imprimir(isColetaWeb, imprimir, st, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, agruparGuiasInterface, filialPadrao, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, tuboPrimario, utilizarCapacidadeTuboPrimario, impressoras, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar, casasPrecoExame, arredondamentoPrecoExame);
                        impressos = retorno.getExames();
                    }
                    catch (ImpressaoException e) {
                        if (e.getMessage().contains(PROTOCOLO_NAO_ENCONTRADO)) break block6;
                        throw e;
                    }
                }
                if (impressos.isEmpty()) {
                    this.naoImprimiuLabExterno = true;
                }
            }
        }
        if (labExterno != null && impressos.isEmpty()) {
            this.naoImprimiuLabExterno = true;
        }
        retorno.setExames(impressos);
        return retorno;
    }

    private RetornoImpressaoEtiquetas imprimirConfiguracaoFilial(boolean isColetaWeb, ImpressaoVO dados, boolean agruparGuiasInterface, Statement st, String filialPadrao, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, ImpressorasLabExterno impressoras, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar, int casasPrecoExame, RoundingMode arredondamentoPrecoExame) throws ImpressaoException {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        List<ExameMaterial> impressos = new ArrayList<ExameMaterial>();
        LabExternoBean labExterno = this.carregarBeanLabExternoFilial(dados, st, filialPadrao);
        if (dados.possuiExames() && labExterno != null) {
            ImpressaoVO imprimir = dados.clone();
            imprimir.setListExameRequisicaoVo(this.validador.filtrar(imprimir, labExterno, agruparGuiasInterface, st, filialPadrao, isColetaWeb));
            if (imprimir.possuiExames()) {
                block6: {
                    try {
                        Protocolo protocolo = Protocolo.getProtocolo(labExterno.getProtocolo());
                        ImpressaoExame impressao = ImpressaoExameLabExterno.criar(protocolo);
                        retorno = impressao.imprimir(isColetaWeb, imprimir, st, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, agruparGuiasInterface, filialPadrao, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, tuboPrimario, utilizarCapacidadeTuboPrimario, impressoras, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar, casasPrecoExame, arredondamentoPrecoExame);
                        impressos = retorno.getExames();
                    }
                    catch (ImpressaoException e) {
                        if (e.getMessage().contains(PROTOCOLO_NAO_ENCONTRADO)) break block6;
                        throw e;
                    }
                }
                if (impressos.isEmpty()) {
                    this.naoImprimiuLabExterno = true;
                }
            }
        }
        if (labExterno != null && impressos.isEmpty()) {
            this.naoImprimiuLabExterno = true;
        }
        retorno.setExames(impressos);
        return retorno;
    }

    private LabExternoBean carregarBeanLabExternoConvenio(ImpressaoVO dados, Statement st, boolean agruparGuiasInterface, String filialPadrao) throws ImpressaoException {
        try {
            Integer codConvAux;
            ConvenioService service = new ConvenioService();
            Integer codigoConvenio = service.retornaConvenioRequisicao(dados.filial, dados.requisicaoPrincipal, st);
            Integer codigoLabExterno = service.getCodigoLabExterno(dados.filial, codigoConvenio, st);
            if (codigoLabExterno == 0) {
                return null;
            }
            boolean agruparMultiguia = new LabExternoService().isAgruparMultiguia(dados.filial, codigoLabExterno, st);
            if ((agruparMultiguia || agruparGuiasInterface) && !(codConvAux = new Integer(codigoConvenio.toString())).equals(codigoConvenio = service.retornaConvenioRequisicao(dados.filial, dados.getRequisicaoPai(), st))) {
                codigoLabExterno = service.getCodigoLabExterno(dados.filial, codigoConvenio, st);
            }
            StringBuilder where = new StringBuilder("where");
            where.append(" fil_codigo = ").append(dados.filial);
            where.append(" and lae_codigo = ").append(codigoLabExterno);
            Set bean = new LabExternoService().loadBean(where.toString(), st);
            Iterator iterator = bean.iterator();
            if (iterator.hasNext()) {
                return (LabExternoBean)iterator.next();
            }
            return null;
        }
        catch (Exception e) {
            throw new ImpressaoException("Uma situa\u00e7\u00e3o inesperada ocorreu ao carregar o Laborat\u00f3rio Externo configurado para o conv\u00eanio.", e);
        }
    }

    private LabExternoBean carregarBeanLabExternoFilial(ImpressaoVO dados, Statement st, String filialPadrao) throws ImpressaoException {
        try {
            Integer codigoLabExterno = new FilialService().getCodigoLabExterno(dados.filial, st);
            StringBuilder where = new StringBuilder("where");
            where.append(" fil_codigo = ").append(dados.filial);
            where.append(" and lae_codigo = ").append(codigoLabExterno);
            Set beans = new LabExternoService().loadBean(where.toString(), st);
            Iterator iterator = beans.iterator();
            if (iterator.hasNext()) {
                return (LabExternoBean)iterator.next();
            }
            return null;
        }
        catch (Exception e) {
            throw new ImpressaoException("Uma situa\u00e7\u00e3o inesperada ocorreu ao carregar o Laborat\u00f3rio Externo configurado na filial.", e);
        }
    }

    private String carregarProtocoloLabExternoFilial(String filialPadrao, Statement st) throws ImpressaoException {
        Integer filial = Integer.valueOf(filialPadrao);
        String protocolo = "";
        try {
            protocolo = new FilialService().getProtocoloLabExterno(filial, st);
        }
        catch (SQLException e) {
            throw new ImpressaoException("N\u00e3o foi possivel buscar protocolo\n" + e.getMessage(), e);
        }
        return protocolo;
    }

    private void labExternoNullo(List<ExameMaterial> impressos, LabExternoBean labExterno) {
        if (labExterno != null && impressos.isEmpty()) {
            this.naoImprimiuLabExterno = true;
        }
    }

    private void listaVazia(List<ExameMaterial> impressos) {
        if (impressos.isEmpty()) {
            this.naoImprimiuLabExterno = true;
        }
    }

    private List<ExameRequisicaoVO> pesquiscaExamesComLote(Protocolo protocolo, ImpressaoVO dadosParaImprimir, List<ExameRequisicaoVO> examesFiltrados, Statement st, boolean agruparGuiasInterface, boolean isColetaWeb) throws ImpressaoException {
        if (examesFiltrados.size() != dadosParaImprimir.getExames().size()) {
            LabExternoBean labExterno = new LabExternoBean();
            labExterno.setProtocolo(protocolo.getCodigo());
            examesFiltrados = this.validador.filtrarExamesComLote(dadosParaImprimir, labExterno, st, agruparGuiasInterface, isColetaWeb);
        }
        return examesFiltrados;
    }
}

