/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.exame.externo;

import jalis.laboratorio.impressao.ImpressaoException;
import jalis.laboratorio.triagem.externo.exportadores.InfoComplementar;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.exame.ExameMaterial;
import jalis.laboratorio.util.impressao.exame.ImpressaoExame;
import jalis.laboratorio.util.impressao.exame.ImpressaoExameFactory;
import jalis.laboratorio.util.impressao.exame.externo.ImpressaoVO;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import java.math.RoundingMode;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public enum ImpressaoExameLabExterno {
    Pardini(Protocolo.HPardini),
    DiagnosticoBrasil(Protocolo.DBV2),
    Alvaro(Protocolo.Alvaro),
    SaoMarcos(Protocolo.SaoMarcos),
    RedeWs(Protocolo.RedeWS),
    INDLab(Protocolo.INDLab),
    JalisWS(Protocolo.JalisWS),
    MercolabWS(Protocolo.MercolabWS),
    Maricondi(Protocolo.Maricondi),
    Shift(Protocolo.Shift),
    SoftLab(Protocolo.SoftLab);

    private final ImpressaoExame impressao;
    private final Protocolo protocolo;

    private ImpressaoExameLabExterno(Protocolo protocolo) {
        this.impressao = ImpressaoExameFactory.criar(protocolo);
        this.protocolo = protocolo;
    }

    public RetornoImpressaoEtiquetas imprimir(boolean isColetaWeb, ImpressaoVO dados, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean agruparGuiasInterface, String filialPadrao, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, ImpressorasLabExterno impressoras, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar, int casasPrecoExame, RoundingMode arredondamentoPrecoExame) throws ImpressaoException {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        if (dados.possuiExames()) {
            return this.impressao.imprimir(isColetaWeb, dados, st, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, agruparGuiasInterface, filialPadrao, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, tuboPrimario, utilizarCapacidadeTuboPrimario, impressoras, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar, casasPrecoExame, arredondamentoPrecoExame);
        }
        retorno.setExames(new ArrayList<ExameMaterial>());
        return retorno;
    }

    public static ImpressaoExame criar(Protocolo protocolo) throws ImpressaoException {
        for (ImpressaoExameLabExterno impressao : ImpressaoExameLabExterno.values()) {
            if (!impressao.protocolo.getCodigo().equalsIgnoreCase(protocolo.getCodigo())) continue;
            return impressao.impressao;
        }
        throw new ImpressaoException("Protocolo n\u00e3o encontrado.");
    }

    public static ImpressaoExame criar(Protocolo protocolo, Boolean isAgendamento) throws ImpressaoException {
        for (ImpressaoExameLabExterno impressao : ImpressaoExameLabExterno.values()) {
            if (!impressao.protocolo.getCodigo().equalsIgnoreCase(protocolo.getCodigo())) continue;
            return impressao.impressao;
        }
        throw new ImpressaoException("Protocolo n\u00e3o encontrado.");
    }
}

