/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.exame.externo;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.impressao.exame.externo.ImpressaoVO;
import jalis.laboratorio.util.impressao.sql.ValorIn;
import jalis.laboratorio.util.impressao.sql.ValorInException;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.model.bean.cadastro.exame.LabExternoBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.service.recepcao.ExameRequisicaoService;
import jalis.util.DBUtil;
import jalis.util.StringUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ImpressaoExameDao {
    private static final String TABLE = " FROM       examematcoletalabexterno ele INNER JOIN labexterno lae ON         ele.fil_codigo = lae.fil_codigo AND        ele.lae_codigo = lae.lae_codigo INNER JOIN examerequisicao req ON         ele.fil_codigo = req.fil_codigo AND        ele.exa_codigo = req.exa_codigo AND        ele.mco_codigo = req.mco_codigo ";
    private final ExameRequisicaoService exameRequisicaoService = new ExameRequisicaoService();

    public boolean estaConfigurado(ExameRequisicaoVO exame, Protocolo protocolo) throws SQLException {
        int filial = Integer.parseInt(Variaveis.filialPadrao);
        String codExame = exame.getExame().getCodigo();
        int material = exame.getMaterial().getCodigo();
        StringBuilder sql = new StringBuilder();
        sql.append(" select 1 ");
        sql.append(" where ele.fil_codigo = ? ");
        sql.append(" and ele.exa_codigo = ? ");
        sql.append(" and ele.mco_codigo = ? ");
        sql.append(" and lae.lae_protocolo = ? ");
        PreparedStatement prep = Conexao.getPreparedStatement(sql.toString());
        prep.setInt(1, filial);
        prep.setString(2, codExame);
        prep.setInt(3, material);
        prep.setString(4, StringUtil.textoDBEscape(protocolo.getCodigo()));
        ResultSet diagnosticoBrasil = prep.executeQuery();
        return diagnosticoBrasil.next();
    }

    public List<ExameRequisicaoVO> buscarExamesConfigurados(ImpressaoVO dados, LabExternoBean labExterno, Statement st, boolean agruparGuiasInterface, String filialPadrao, boolean isColetaWeb) throws SQLException {
        List<ExameRequisicaoVO> examesConfigurados = new ArrayList<ExameRequisicaoVO>();
        boolean agruparMultiguia = this.deveAgruparMultiguias(dados, labExterno, agruparGuiasInterface, st);
        List<String> req = this.getChaveRequisicao(dados, agruparMultiguia);
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" select ");
            sql.append(" ele.fil_codigo, ele.exa_codigo, ele.mco_codigo ");
            sql.append(TABLE);
            sql.append(" where ele.exa_codigo in (").append(ValorIn.criar(dados.getExames())).append(")");
            sql.append(" and ele.mco_codigo in (").append(ValorIn.criar(dados.getMateriais())).append(")");
            sql.append(" and lae.lae_protocolo = ").append(StringUtil.textoDBEscape(labExterno.getProtocolo()));
            sql.append((CharSequence)this.andReqCodigo(dados, agruparMultiguia));
            sql.append(" and ele.fil_codigo = ").append(dados.filial);
            sql.append(" and ele.ele_bloqueado = false ");
            ResultSet rs = st.executeQuery(sql.toString());
            Map<String, Object> chaves = this.createChaves(rs, req);
            if (!chaves.isEmpty()) {
                chaves.put("fil_codigo", dados.filial);
                examesConfigurados = this.exameRequisicaoService.getVOsIn(chaves, st, filialPadrao, isColetaWeb);
            }
        }
        catch (ValorInException | ThreadDaoException e) {
            throw new SQLException(e);
        }
        return examesConfigurados;
    }

    public List<ExameRequisicaoVO> buscarExamesComLoteCriado(ImpressaoVO dados, LabExternoBean labExterno, Statement st, boolean agruparGuiasInterface, boolean isColetaWeb) throws SQLException {
        List<ExameRequisicaoVO> examesConfigurados = new ArrayList<ExameRequisicaoVO>();
        try {
            boolean agruparMultiguia = this.deveAgruparMultiguias(dados, labExterno, agruparGuiasInterface, st);
            List<String> req = this.getChaveRequisicao(dados, agruparMultiguia);
            ResultSet rs = st.executeQuery(this.getSqlExameComLoteCriado(dados, labExterno, agruparMultiguia, req).toString());
            Map<String, Object> chaves = this.createChaves(rs, req);
            if (!chaves.isEmpty()) {
                chaves.put("fil_codigo", dados.filial);
                examesConfigurados = this.exameRequisicaoService.getVOsIn(chaves, st, Variaveis.filialPadrao, isColetaWeb);
            }
        }
        catch (ValorInException | ThreadDaoException e) {
            throw new SQLException(e);
        }
        return examesConfigurados;
    }

    private StringBuilder getSqlExameComLoteCriado(ImpressaoVO dados, LabExternoBean labExterno, boolean deveAgruparMultiguias, List<String> req) throws ValorInException {
        StringBuilder sql = new StringBuilder();
        sql.append(" select lab.lae_protocolo, exa_codigo, mco_codigo ");
        sql.append(" from loteexternoexamerequisicao leer ");
        sql.append(" join loteexternorequisicao ler on leer.fil_codigo = ler.fil_codigo and leer.lex_codigo = ler.lex_codigo  ");
        sql.append(" and leer.lae_codigo = ler.lae_codigo and leer.req_codigo = ler.req_codigo and leer.fil_kodigo = ler.fil_kodigo ");
        sql.append(" join loteexterno le on leer.fil_codigo = le.fil_codigo and leer.lex_codigo = le.lex_codigo and leer.lae_codigo = le.lae_codigo  ");
        sql.append(" join labexterno lab on leer.fil_kodigo = lab.fil_codigo and leer.lae_codigo = lab.lae_codigo ");
        sql.append(" where leer.fil_kodigo = ").append(dados.filial);
        if (deveAgruparMultiguias) {
            sql.append(" and leer.req_codigo in ( ").append(ValorIn.criar(req)).append(")");
        } else {
            sql.append(" and leer.req_codigo = ").append(dados.requisicaoPrincipal);
        }
        sql.append(" and leer.exa_codigo in (").append(ValorIn.criar(dados.getExames())).append(") ");
        sql.append(" and leer.mco_codigo in ( ").append(ValorIn.criar(dados.getMateriais())).append(") ");
        sql.append(" and lab.lae_protocolo = ").append(StringUtil.textoDBEscape(labExterno.getProtocolo()));
        sql.append(" and leer.usr_codestorno is null and leer.ler_datahoraestorno is null ");
        sql.append(" and ler.usr_codestorno is null and ler.leq_dataestorno is null ");
        sql.append(" and le.usr_codestorno is null and le.lex_dataestorno is null ");
        sql.append(" and ler.leq_retornows is not null and length(ler.leq_retornows) > 1 ");
        return sql;
    }

    private List<String> getChaveRequisicao(ImpressaoVO dados, boolean agruparMultiguia) {
        ArrayList<String> req = new ArrayList<String>();
        if (agruparMultiguia) {
            req.addAll(dados.getRequisicoes());
        } else {
            req.add(String.valueOf(dados.requisicaoPrincipal));
        }
        return req.size() > 1 ? req.stream().distinct().collect(Collectors.toList()) : req;
    }

    private StringBuilder andReqCodigo(ImpressaoVO dados, boolean agruparMultiguia) throws ValorInException {
        StringBuilder req = new StringBuilder();
        if (agruparMultiguia) {
            req.append(" and req.req_codigo in (").append(ValorIn.criar(dados.getRequisicoes())).append(")");
        } else {
            req.append(" and req.req_codigo = ").append(dados.requisicaoPrincipal);
        }
        return req;
    }

    private boolean deveAgruparMultiguias(ImpressaoVO dados, Protocolo protocolo, boolean agruparGuiasInterface, Statement st) throws SQLException {
        return agruparGuiasInterface || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, dados.filial, dados.requisicaoPrincipal, dados.getExames(), dados.getMateriais(), protocolo);
    }

    private boolean deveAgruparMultiguias(ImpressaoVO dados, LabExternoBean labExterno, boolean agruparGuiasInterface, Statement st) throws SQLException {
        Protocolo protocolo = Protocolo.getProtocolo(labExterno.getProtocolo());
        return agruparGuiasInterface || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, dados.filial, dados.requisicaoPrincipal, dados.getExames(), dados.getMateriais(), protocolo);
    }

    public boolean deveAgruparMultiguias(ImpressaoVO dados, Protocolo protocolo) throws SQLException {
        return ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(Conexao.getStatement(), dados.filial, dados.requisicaoPrincipal, protocolo);
    }

    public List<ExameRequisicaoVO> buscarExamesConfiguradosPadrao(ImpressaoVO dados, Protocolo protocolo, Statement st, boolean agruparGuiasInterface, boolean isColetaWeb) throws SQLException {
        List<ExameRequisicaoVO> examesConfigurados = new ArrayList<ExameRequisicaoVO>();
        boolean deveAgruparMultiguias = this.deveAgruparMultiguias(dados, protocolo, agruparGuiasInterface, st);
        List<String> req = this.getChaveRequisicao(dados, deveAgruparMultiguias);
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" select ");
            sql.append(" ele.fil_codigo, ele.exa_codigo, ele.mco_codigo ");
            sql.append(TABLE);
            sql.append(" where ");
            sql.append(" ele.exa_codigo in (").append(ValorIn.criar(dados.getExames())).append(")");
            sql.append(" and ele.mco_codigo in (").append(ValorIn.criar(dados.getMateriais())).append(")");
            sql.append(" and lae.lae_protocolo = ").append(StringUtil.textoDBEscape(protocolo.getCodigo()));
            sql.append(" and ele.fil_codigo = ").append(dados.filial);
            sql.append(" and ele.ele_bloqueado = false ");
            sql.append(" and ele.ele_padrao");
            if (deveAgruparMultiguias) {
                sql.append(" and req_codigo in ( ").append(ValorIn.criar(req)).append(")");
            } else {
                sql.append(" and req_codigo = ").append(dados.requisicaoPrincipal);
            }
            ResultSet rs = st.executeQuery(sql.toString());
            Map<String, Object> chaves = this.createChaves(rs, req);
            if (!chaves.isEmpty()) {
                chaves.put("fil_codigo", dados.filial);
                examesConfigurados = this.exameRequisicaoService.getVOsIn(chaves, st, Variaveis.filialPadrao, isColetaWeb);
            }
        }
        catch (ValorInException | ThreadDaoException e) {
            throw new SQLException(e);
        }
        return examesConfigurados;
    }

    private Map<String, Object> createChaves(ResultSet rs, List<String> requisicoes) throws SQLException {
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        try {
            if (rs.next()) {
                HashSet<String> material = new HashSet<String>();
                HashSet<String> exame = new HashSet<String>();
                rs.beforeFirst();
                while (rs.next()) {
                    exame.add(rs.getString("exa_codigo"));
                    material.add(rs.getString("mco_codigo"));
                }
                ValorIn condicaoRequisicao = ValorIn.criar(requisicoes);
                ValorIn condicaoExame = ValorIn.criar(exame);
                ValorIn condicaoMaterial = ValorIn.criar(material);
                chaves.put("req_codigo", condicaoRequisicao);
                chaves.put("exa_codigo", condicaoExame);
                chaves.put("mco_codigo", condicaoMaterial);
            }
        }
        catch (ValorInException e) {
            throw new SQLException(e);
        }
        return chaves;
    }

    public String pesquisarProtocoloLabExternoPadraoPorExame(ExameRequisicaoVO exameVO, Statement st) throws SQLException {
        StringBuilder sql = new StringBuilder(" select l.lae_protocolo ");
        sql.append(" from  examerequisicao er");
        sql.append(" left join examematcoletalabexterno e on er.fil_codigo = e.fil_codigo and er.exa_codigo = e.exa_codigo and er.mco_codigo = e.mco_codigo and e.ele_padrao = true ");
        sql.append(" left join labexterno l on l.fil_codigo = e.fil_codigo and l.lae_codigo = e.lae_codigo ");
        sql.append(" where ");
        sql.append(" er.fil_codigo = ").append(exameVO.getFilial().getCodigo());
        sql.append(" and er.req_codigo = ").append(exameVO.getRequisicao());
        sql.append(" and er.exa_codigo = '").append(exameVO.getExame().getCodigo()).append("'");
        sql.append(" and er.mco_codigo = ").append(exameVO.getMaterial().getCodigo());
        String protocolo = "";
        ResultSet rs = st.executeQuery(sql.toString());
        if (rs.next()) {
            protocolo = rs.getString("lae_protocolo");
        }
        return protocolo;
    }

    public String pesquisarProtocoloLabExternoPorLoteEnviado(ExameRequisicaoVO exameVO, Statement st) throws SQLException {
        StringBuilder sql = new StringBuilder(" select lab.lae_protocolo ");
        sql.append(" from loteexternoexamerequisicao leer ");
        sql.append(" join loteexternorequisicao ler ");
        sql.append(" on leer.fil_codigo = ler.fil_codigo ");
        sql.append(" and leer.lex_codigo = ler.lex_codigo ");
        sql.append(" and leer.lae_codigo = ler.lae_codigo ");
        sql.append(" and leer.req_codigo = ler.req_codigo ");
        sql.append(" and leer.fil_kodigo = ler.fil_kodigo ");
        sql.append(" join loteexterno le ");
        sql.append(" on leer.fil_codigo = le.fil_codigo ");
        sql.append(" and leer.lex_codigo = le.lex_codigo ");
        sql.append(" and leer.lae_codigo = le.lae_codigo ");
        sql.append(" join labexterno lab ");
        sql.append(" on leer.fil_kodigo = lab.fil_codigo ");
        sql.append(" and leer.lae_codigo = lab.lae_codigo ");
        sql.append(" where leer.fil_kodigo = ").append(exameVO.getFilial().getCodigo());
        sql.append(" and leer.req_codigo = ").append(exameVO.getRequisicao());
        sql.append(" and leer.exa_codigo = ").append(StringUtil.textoDBEscape(exameVO.getExame().getCodigo()));
        sql.append(" and leer.mco_codigo = ").append(exameVO.getMaterial().getCodigo());
        sql.append(" and leer.usr_codestorno is null and leer.ler_datahoraestorno is null ");
        sql.append(" and ler.usr_codestorno is null and ler.leq_dataestorno is null ");
        sql.append(" and le.usr_codestorno is null and le.lex_dataestorno is null ");
        sql.append(" and ler.leq_retornows is not null and length(ler.leq_retornows) > 1 ");
        ResultSet rs = st.executeQuery(sql.toString());
        return rs.next() ? rs.getString("lae_protocolo") : "";
    }

    public Boolean exameJaEnviadoEmAlgumLote(ExameRequisicaoVO exame, Integer codFilial, String codRequisicoes) throws SQLException {
        Boolean enviado = false;
        StringBuilder sql = new StringBuilder(" select le.lex_codigo ");
        sql.append(" from loteexterno le ");
        sql.append(" left join loteexternorequisicao ler on le.fil_codigo = ler.fil_codigo and le.lex_codigo = ler.lex_codigo and le.lae_codigo = ler.lae_codigo ");
        sql.append(" left join loteexternoexamerequisicao leer on ler.fil_codigo = leer.fil_codigo and ler.lex_codigo = leer.lex_codigo and ler.req_codigo = leer.req_codigo and ler.lae_codigo = leer.lae_codigo and ler.fil_kodigo = leer.fil_kodigo ");
        sql.append(" where ler.fil_kodigo = ").append(codFilial);
        sql.append(" and leer.exa_codigo = '").append(exame.getExame().getCodigo()).append("'");
        sql.append(" and leer.mco_codigo = ").append(exame.getMaterial().getCodigo());
        sql.append(" and (le.lex_dataestorno is null and le.usr_codestorno is null and ler.leq_dataestorno is null and ler.usr_codestorno is null) ");
        sql.append(" and ler.leq_retornows is not null ");
        sql.append(" and ler.req_codigo in ( ").append(codRequisicoes).append(")");
        try (Statement st = Conexao.getStatement();){
            ResultSet rs = Conexao.executeQuery(st, sql);
            rs = Conexao.executeQuery(st, sql);
            enviado = rs.next();
            rs.close();
        }
        return enviado;
    }
}

