/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.exame;

import jalis.laboratorio.triagem.externo.exportadores.ExportacaoParaMercolab;
import jalis.laboratorio.triagem.externo.exportadores.db2.ExportacaoParaDB;
import jalis.laboratorio.triagem.externo.exportadores.maricondi.ExportacaoParaMaricondi;
import jalis.laboratorio.triagem.externo.exportadores.saoMarcos.ExportacaoSaoMarcos;
import jalis.laboratorio.util.impressao.exame.ExameMaterialListHandler;
import jalis.laboratorio.util.impressao.exame.ExameRequisicaoListHandler;
import jalis.laboratorio.util.impressao.exame.ImpressaoExame;
import jalis.laboratorio.util.impressao.exame.externo.alvaro.ImpressaoAlvaro;
import jalis.laboratorio.util.impressao.exame.externo.alvaro.LoteAlvaro;
import jalis.laboratorio.util.impressao.exame.externo.alvaro.LoteAlvaroDao;
import jalis.laboratorio.util.impressao.exame.externo.db.ImpressaoDiagnosticoBrasil;
import jalis.laboratorio.util.impressao.exame.externo.db.ImpressaoDiagnosticoBrasilDao;
import jalis.laboratorio.util.impressao.exame.externo.db.LoteDB;
import jalis.laboratorio.util.impressao.exame.externo.db.LoteDBDao;
import jalis.laboratorio.util.impressao.exame.externo.indlab.ImpressaoIndLab;
import jalis.laboratorio.util.impressao.exame.externo.jalisws.ImpressaoJalisWS;
import jalis.laboratorio.util.impressao.exame.externo.jalisws.LoteJalisWS;
import jalis.laboratorio.util.impressao.exame.externo.jalisws.LoteJalisWSDao;
import jalis.laboratorio.util.impressao.exame.externo.maricondi.ImpressaoMaricondi;
import jalis.laboratorio.util.impressao.exame.externo.maricondi.ImpressaoMaricondiDao;
import jalis.laboratorio.util.impressao.exame.externo.maricondi.LoteMaricondi;
import jalis.laboratorio.util.impressao.exame.externo.mercolab.ImpressaoMercolab;
import jalis.laboratorio.util.impressao.exame.externo.mercolab.ImpressaoMercolabDao;
import jalis.laboratorio.util.impressao.exame.externo.mercolab.LoteMercolab;
import jalis.laboratorio.util.impressao.exame.externo.mercolab.LoteMercolabDao;
import jalis.laboratorio.util.impressao.exame.externo.pardini.DaoLotePardini;
import jalis.laboratorio.util.impressao.exame.externo.pardini.ExamePardiniDao;
import jalis.laboratorio.util.impressao.exame.externo.pardini.ImpressaoHPDirect;
import jalis.laboratorio.util.impressao.exame.externo.pardini.ImpressaoPardini;
import jalis.laboratorio.util.impressao.exame.externo.pardini.LotePardini;
import jalis.laboratorio.util.impressao.exame.externo.redews.ImpressaoRedeWS;
import jalis.laboratorio.util.impressao.exame.externo.saoMarcos.ImpressaoSaoMarcos;
import jalis.laboratorio.util.impressao.exame.externo.saoMarcos.ImpressaoSaoMarcosService;
import jalis.laboratorio.util.impressao.exame.externo.saoMarcos.LoteSaoMarcos;
import jalis.laboratorio.util.impressao.exame.externo.shift.ImpressaoShift;
import jalis.laboratorio.util.impressao.exame.externo.softlab.ImpressaoSoftLab;
import jalis.laboratorio.util.impressao.exame.externo.softlab.ImpressaoSoftLabDao;
import jalis.laboratorio.util.impressao.exame.externo.softlab.LoteSoftLab;
import jalis.laboratorio.util.impressao.exame.externo.softlab.LoteSoftLabDao;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.service.triagem.LoteExternoExameRequisicaoService;
import jalis.util.impressao.termica.ImpressaoTermica;
import java.util.HashMap;
import java.util.Map;

public class ImpressaoExameFactory {
    public static Map<String, ImpressaoExame> impressoes = ImpressaoExameFactory.criarImpressao();

    private static Map<String, ImpressaoExame> criarImpressao() {
        HashMap<String, ImpressaoExame> result = new HashMap<String, ImpressaoExame>();
        result.put(Protocolo.HPardini.getCodigo(), ImpressaoExameFactory.criarImpressaoPardini());
        result.put(Protocolo.DBV2.getCodigo(), ImpressaoExameFactory.criarImpressaoDignosticoBrasil());
        result.put(Protocolo.JalisWS.getCodigo(), ImpressaoExameFactory.criarImpressaoJalisWS());
        result.put(Protocolo.Alvaro.getCodigo(), ImpressaoExameFactory.criarImpressaoAlvaro());
        result.put(Protocolo.SaoMarcos.getCodigo(), ImpressaoExameFactory.criarImpressaoSaoMarcos());
        result.put(Protocolo.RedeWS.getCodigo(), ImpressaoExameFactory.criarImpressaoRedeWS());
        result.put(Protocolo.INDLab.getCodigo(), ImpressaoExameFactory.criarImpressaoIndLab());
        result.put(Protocolo.MercolabWS.getCodigo(), ImpressaoExameFactory.criarImpressaoMercolab());
        result.put(Protocolo.Shift.getCodigo(), ImpressaoExameFactory.criarImpressaoShift());
        result.put(Protocolo.SoftLab.getCodigo(), ImpressaoExameFactory.criarImpressaoSoftLab());
        result.put(Protocolo.Maricondi.getCodigo(), ImpressaoExameFactory.criarImpressaoMaricondi());
        return result;
    }

    private static ImpressaoPardini criarImpressaoPardini() {
        return new ImpressaoPardini(new ExamePardiniDao(), new ExameRequisicaoListHandler(), new ExameMaterialListHandler(), new ImpressaoHPDirect(), new LotePardini(new DaoLotePardini()));
    }

    private static ImpressaoDiagnosticoBrasil criarImpressaoDignosticoBrasil() {
        return new ImpressaoDiagnosticoBrasil(new ExportacaoParaDB(), new LoteDB(new LoteDBDao()), new ExameRequisicaoListHandler(), new ImpressaoDiagnosticoBrasilDao());
    }

    private static ImpressaoAlvaro criarImpressaoAlvaro() {
        return new ImpressaoAlvaro(new LoteAlvaro(new LoteAlvaroDao(), new ExameRequisicaoListHandler(), new LoteExternoExameRequisicaoService()), new ExameRequisicaoListHandler(), new ImpressaoTermica());
    }

    private static ImpressaoJalisWS criarImpressaoJalisWS() {
        return new ImpressaoJalisWS(new LoteJalisWS(new LoteJalisWSDao(), new ExameRequisicaoListHandler(), new LoteExternoExameRequisicaoService()), new ExameRequisicaoListHandler(), new ImpressaoTermica());
    }

    private static ImpressaoSaoMarcos criarImpressaoSaoMarcos() {
        return new ImpressaoSaoMarcos(new ExportacaoSaoMarcos(), new LoteSaoMarcos(), new ExameRequisicaoListHandler(), new ImpressaoSaoMarcosService());
    }

    private static ImpressaoRedeWS criarImpressaoRedeWS() {
        return new ImpressaoRedeWS();
    }

    private static ImpressaoIndLab criarImpressaoIndLab() {
        return new ImpressaoIndLab();
    }

    private static ImpressaoMercolab criarImpressaoMercolab() {
        return new ImpressaoMercolab(new ExportacaoParaMercolab(), new LoteMercolab(new LoteMercolabDao()), new ExameRequisicaoListHandler(), new ImpressaoMercolabDao());
    }

    private static ImpressaoSoftLab criarImpressaoSoftLab() {
        return new ImpressaoSoftLab(new LoteSoftLab(new LoteSoftLabDao()), new ExameRequisicaoListHandler(), new ImpressaoSoftLabDao());
    }

    private static ImpressaoShift criarImpressaoShift() {
        return new ImpressaoShift();
    }

    private static ImpressaoMaricondi criarImpressaoMaricondi() {
        return new ImpressaoMaricondi(new ExportacaoParaMaricondi(), new LoteMaricondi(new ImpressaoMaricondiDao()), new ExameRequisicaoListHandler(), new ImpressaoMaricondiDao());
    }

    public static ImpressaoExame criar(Protocolo protocolo) {
        return impressoes.get(protocolo.getCodigo());
    }
}

