/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao.exame;

import jalis.laboratorio.util.impressao.exame.ExameMaterial;
import jalis.laboratorio.util.impressao.exame.ListaExameMaterial;
import jalis.util.Funcoes;
import jalis.util.tabela.Registro;
import java.util.ArrayList;

public class ExameMaterialListHandler {
    public Registro converterExameMaterialToRegistro(ListaExameMaterial<ExameMaterial> listaExamesHPDirect, String filial, String codigoRequisicao) {
        if (listaExamesHPDirect == null || listaExamesHPDirect.isEmpty() || Funcoes.textoVazio(filial) || Funcoes.textoVazio(codigoRequisicao)) {
            return null;
        }
        Registro reg = new Registro();
        reg.setValor("fil_codigo", filial);
        reg.setValor("req_codigo", Integer.parseInt(codigoRequisicao));
        reg.setValor("pac_codigo", listaExamesHPDirect.getCodigoPaciente());
        reg.setValor("pac_nome", listaExamesHPDirect.getNomePaciente());
        reg.setValor("pac_sexo", listaExamesHPDirect.getSexoPaciente());
        reg.setValor("pac_dum", listaExamesHPDirect.getDumPaciente());
        reg.setValor("req_data", listaExamesHPDirect.getDataColeta());
        reg.setValor("req_hora", listaExamesHPDirect.getHoraColeta());
        reg.setValor("req_peso", listaExamesHPDirect.getPesoPaciente());
        reg.setValor("req_altura", listaExamesHPDirect.getAlturaPaciente());
        reg.setValor("req_idade", listaExamesHPDirect.getIdadePaciente());
        reg.setValor("req_obs", listaExamesHPDirect.getObservacaoRequisicao());
        reg.setValor("pac_datanasc", listaExamesHPDirect.getDataNascimentoPaciente());
        reg.setValor("con_codigo", listaExamesHPDirect.getCodigoConvenio());
        reg.setValor("lae_codigo", ((ExameMaterial)listaExamesHPDirect.get(0)).getCodigoLaboratorioExterno());
        reg.setValor("examesHermesPardini", listaExamesHPDirect);
        reg.setValor("med_nome", listaExamesHPDirect.getNomeMedico());
        reg.setValor("med_crm", listaExamesHPDirect.getCrmMedico());
        reg.setValor("med_conselho", listaExamesHPDirect.getConselhoMedico());
        reg.setValor("med_uf", listaExamesHPDirect.getUfMedico());
        reg.setValor("req_periodogestacional", listaExamesHPDirect.getPeriodoGestacional());
        ArrayList<Registro> listaExames = new ArrayList<Registro>();
        for (ExameMaterial exame : listaExamesHPDirect) {
            Registro regExames = new Registro();
            regExames.setValor("fil_codigo", filial);
            regExames.setValor("exa_codigo", exame.getCodigoExame());
            regExames.setValor("mco_codigo", (int)exame.getCodigoMaterial());
            regExames.setValor("ele_xmllabexterno", exame.getXMLExamePardini());
            regExames.setValor("exa_descricao", exame.getDescricaoExame());
            regExames.setValor("mco_descricao", exame.getDescricaoMaterial());
            regExames.setValor("codigoProtocolo", exame.getCodigoProtocolo());
            regExames.setValor("tipoImpressao", exame.getTipoImpressao());
            regExames.setValor("etiquetaArmazenada", exame.getEtiquetaArmazenada());
            regExames.setValor("lae_codigo", exame.getCodigoLaboratorioExterno());
            regExames.setValor("qtdeEtiquetas", exame.getQtdeEtiquetas());
            regExames.setValor("rec_kodigo", exame.getRecipiente());
            regExames.setValor("exr_datamaterial", exame.getDataMaterial());
            regExames.setValor("exr_codigoapoiado", exame.getCodigoApoiado());
            regExames.setValor("exr_volumediurese", exame.getVolumeDiurese());
            regExames.setValor("exr_tempodiurese", exame.getTempoDiurese());
            regExames.setValor("codigoLabExterno", exame.getCodigoLabExterno());
            regExames.setValor("exr_descricaomaterial", exame.getMaterialInformado());
            regExames.setValor("req_codigo", Integer.parseInt(codigoRequisicao));
            listaExames.add(regExames);
        }
        reg.setValor("listaexames", listaExames);
        return reg;
    }
}

