/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao;

import jalis.comum.ParametrosGerais;
import jalis.laboratorio.util.impressao.ImprimirGuia;
import jalis.laboratorio.util.impressao.PanelGuia;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class TelaGuias
extends JDialog
implements ActionListener {
    private static final String TITULO = "Guias";
    private final JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private final JButton buttonImprimirTodos = ComponenteFactory.novoJButton("Imprimir todos", 't', this);
    JPanel panelGuias = new JPanel(new GridBagLayout());
    private final ArrayList<String> guias = new ArrayList();
    private String filial;
    private String requisicao;
    private boolean agrupaAmb;
    private boolean faturarFaltante;
    private boolean imprimirExameFaltaMaterial;
    private int tipoGuia = -1;

    public static TelaGuias novaInstancia(Object owner) {
        if (owner instanceof Dialog) {
            return new TelaGuias((Dialog)owner, TITULO);
        }
        if (owner instanceof Frame) {
            return new TelaGuias((Frame)owner, TITULO);
        }
        return null;
    }

    public TelaGuias(Frame owner, String titulo) {
        super(owner, titulo);
        this.montaTela();
    }

    public TelaGuias(Dialog owner, String titulo) {
        super(owner, titulo);
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(new Dimension(300, 320));
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.setResizable(false);
        GridBagConstraints c = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        this.setContentPane(panel);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        panel.add((Component)new JLabel("Selecione a guia que ser\u00e1 impressa"), c);
        c.gridy = 2;
        panel.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonImprimirTodos, this.buttonFechar), c);
        c.weighty = 1.0;
        c.fill = 1;
        c.gridy = 1;
        panel.add((Component)new JScrollPane(this.panelGuias), c);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (TelaGuias.this.guias.size() > 0) {
                    for (int i = 0; i < TelaGuias.this.guias.size(); ++i) {
                        GridBagConstraints g = new GridBagConstraints();
                        g.gridx = 0;
                        g.gridy = i;
                        g.weightx = 1.0;
                        g.fill = 2;
                        TelaGuias.this.panelGuias.add((Component)new PanelGuia(TelaGuias.this.filial, TelaGuias.this.requisicao, (String)TelaGuias.this.guias.get(i), TelaGuias.this.agrupaAmb, TelaGuias.this.tipoGuia), g);
                    }
                    GridBagConstraints g = new GridBagConstraints();
                    g.gridx = 0;
                    g.gridy = TelaGuias.this.guias.size();
                    g.weightx = 1.0;
                    g.weighty = 1.0;
                    g.fill = 1;
                    TelaGuias.this.panelGuias.add((Component)new JPanel(), g);
                    TelaGuias.this.panelGuias.revalidate();
                    TelaGuias.this.panelGuias.repaint();
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.buttonImprimirTodos) {
            try {
                Registro configTiss = ImprimirGuia.getConfiguracaoTiss(this.filial, this.requisicao);
                for (String g : this.guias) {
                    ImprimirGuia.imprimir(this.filial, this.requisicao, g, this.agrupaAmb, this.imprimirExameFaltaMaterial, this.tipoGuia, configTiss, ParametrosGerais.getOrdenarSetor(), ParametrosGerais.getOrdemComprovante(), ParametrosGerais.getPrecoMetodologia(), ParametrosGerais.getQtdeExamesCC(), ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
            }
            catch (Exception e2) {
                ErrorLogger.mostraMensagem(null, e2.getMessage(), e2.getStackTrace(), "TelaGuias(707)");
            }
        }
    }

    public void setDadosRequisicao(String filial, String requisicao, boolean agrupaAmb, boolean faturarFaltante, boolean imprimirExameFaltaMaterial, int tipoGuia) {
        this.filial = filial;
        this.requisicao = requisicao;
        this.agrupaAmb = agrupaAmb;
        this.faturarFaltante = faturarFaltante;
        this.imprimirExameFaltaMaterial = imprimirExameFaltaMaterial;
        this.tipoGuia = tipoGuia;
    }

    public void adicionaGuia(String guia) {
        if (this.guias != null && this.guias.indexOf(guia) < 0) {
            this.guias.add(guia);
        }
    }
}

