/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao;

import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.digitacao.Digitacao;
import jalis.laboratorio.digitacao.evento.DigitacaoEvento;
import jalis.laboratorio.digitacao.evento.DigitacaoListener;
import jalis.util.ScreenUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.KeyStroke;

class TelaAtestado
extends JDialog
implements DisposeListener {
    private Digitacao digitacao = new Digitacao();
    private boolean salvarPressionado = false;
    private String digitado = "";

    public TelaAtestado(Frame owner) {
        super(owner);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    public TelaAtestado(Dialog owner) {
        super(owner);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    public void setPerguntas(String perguntas, HashMap<String, Object> dados) {
        this.digitacao.carregarCampos(perguntas, dados);
        this.pack();
        this.setSize(this.getPreferredSize());
        this.setLocationRelativeTo(this.getParent());
        this.digitacao.setFocoPrimeiroCampo();
    }

    public void jbInit() throws Exception {
        this.setModal(true);
        this.setLayout(new BorderLayout());
        this.setTitle("Atestado");
        this.setLocationRelativeTo(this.getParent());
        this.getContentPane().add((Component)this.digitacao, "Center");
        this.digitacao.exibirCheckBoxImprimir(false);
        this.digitacao.exibirBotaoFechar(true);
        ScreenUtil.addActionMap(this.digitacao, KeyStroke.getKeyStroke(10, 0, true), "enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component owner = FocusManager.getCurrentManager().getFocusOwner();
                if (owner instanceof JButton) {
                    ((JButton)owner).doClick();
                } else {
                    TelaAtestado.this.digitacao.setFocoProximo();
                }
            }
        });
        this.digitacao.addDigitacaoListener(new DigitacaoListener(){

            @Override
            public void acaoSalvar(DigitacaoEvento e) {
                TelaAtestado.this.salvarPressionado = true;
                if (TelaAtestado.this.digitacao != null) {
                    TelaAtestado.this.digitado = TelaAtestado.this.digitacao.getResultado();
                    TelaAtestado.this.digitacao = null;
                }
                TelaAtestado.this.setVisible(false);
            }

            @Override
            public void acaoSalvarParcial(DigitacaoEvento e) {
            }

            @Override
            public void acaoImprimir(DigitacaoEvento e) {
            }

            @Override
            public void acaoFechar(DigitacaoEvento digitacaoEvento) {
                TelaAtestado.this.salvarPressionado = false;
                TelaAtestado.this.setVisible(false);
            }

            @Override
            @Deprecated
            public void acaoRemover(DigitacaoEvento e) {
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (TelaAtestado.this.digitacao != null) {
                    TelaAtestado.this.digitacao.setFocoPrimeiroCampo();
                }
            }
        });
    }

    public boolean getSalvarPressionado() {
        return this.salvarPressionado;
    }

    public String getAtestado() {
        return this.digitado;
    }
}

