/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.RetornoTermoConsentimento;
import jalis.model.dao.impressao.ImprimirTermoConsentimentoDao;
import jalis.model.dao.recepcao.RequisicaoTermoConsentimentoVO;
import jalis.service.impressao.ImprimirTermoConsentimentoService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.Callable;

public class ImprimirTermoConsentimento {
    private final ImprimirTermoConsentimentoService service = new ImprimirTermoConsentimentoService();

    public String[] getCampos(int qtdeExamesCC, int colunasRodapeComprovante) {
        return this.service.getCampos(qtdeExamesCC, colunasRodapeComprovante);
    }

    public synchronized RetornoTermoConsentimento imprimir(String codigoFilial, String codigoRequisicao, String codTermo, Integer codigoLayout, String codigoPaciente, Statement st, Statement st2, boolean agruparImpressaoTermo, boolean isColetaWeb, String impressoraTermo, String tamanhoNomeImpressora, String[] impressorasLocais, boolean isAlimentos, int casasPrecoExame, RoundingMode arredondamentoPrecoExame, boolean precoMetodologia, boolean ocultarApenasFaturamento, boolean ordenarSetor, String ordemComprovante, int qtdeExamesCC, String tipoIntegracao, int colunasRodapeComprovante, boolean agruparGuiasInterface, String tipoExportacaoInterface, int agruparInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, Callable<Boolean> arquivar, Callable<Boolean> anular) throws Exception {
        return new ImprimirTermoConsentimentoService().imprimir(codigoFilial, codigoRequisicao, codTermo, codigoLayout, codigoPaciente, st, st2, agruparImpressaoTermo, isColetaWeb, impressoraTermo, tamanhoNomeImpressora, impressorasLocais, isAlimentos, casasPrecoExame, arredondamentoPrecoExame, precoMetodologia, ocultarApenasFaturamento, ordenarSetor, ordemComprovante, qtdeExamesCC, tipoIntegracao, colunasRodapeComprovante, agruparGuiasInterface, tipoExportacaoInterface, agruparInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, arquivar, anular);
    }

    public boolean solicitarImpressaoTermo() {
        if (Funcoes.mensagem(null, "Deseja imprimir apenas o termo de consentimento dessa requisi\u00e7\u00e3o?\n", 4) == 0) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, "N\u00e3o foi solicitar a impress\u00e3o do termo de consentimento.\n" + e.getMessage(), e.getStackTrace());
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean enviarImpressao(String codFilial, String codRequisicao, String itemTermo, long acessoImprimirTermoConsentimento, String codigoPaciente) {
        ImprimirTermoConsentimentoDao dao = new ImprimirTermoConsentimentoDao();
        Statement st = Conexao.getStatement();
        String mensagem = dao.pesquisarTermosImpressos(this.getFiliais(codFilial), codigoPaciente, codRequisicao, st);
        Conexao.fecharStatement(st);
        if (ParametrosGerais.isAvisarTermoConsentimento() && mensagem != null) {
            if (Funcoes.mensagem(null, mensagem, 4) != 0) return false;
            this.imprimirTermoConsentimento(codFilial, codRequisicao, itemTermo, acessoImprimirTermoConsentimento, codigoPaciente);
            return false;
        } else {
            this.imprimirTermoConsentimento(codFilial, codRequisicao, itemTermo, acessoImprimirTermoConsentimento, codigoPaciente);
        }
        return false;
    }

    private String getFiliais(String codFilial) {
        String filiais;
        filiais = Funcoes.textoVazio(ParametrosGerais.getCopiaPaciente()) ? (filiais = codFilial) : codFilial + "," + StringUtil.getValor(ParametrosGerais.getCopiaPaciente(), "filiais");
        return filiais;
    }

    private void imprimirTermoConsentimento(String codFilial, String codRequisicao, String itemTermo, long acessoImprimirTermoConsentimento, String codigoPaciente) {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        this.imprimirTermoConsentimento(codFilial, codRequisicao, itemTermo, acessoImprimirTermoConsentimento, codigoPaciente, st, ParametrosGerais.getAgruparImpressaoTermo(), st2, false, ParametrosLocais.getParametro("impressoraTermoConsentimento"), ParametrosLocais.getParametro("tamanhoNomeImpressoras"), Funcoes.getNomeImpressorasLocais(), Variaveis.tipoFilialPadrao.equals("A"), ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame(), ParametrosGerais.getPrecoMetodologia(), ParametrosGerais.isOcultarApenasFaturamento(), ParametrosGerais.getOrdenarSetor(), ParametrosGerais.getOrdemComprovante(), ParametrosGerais.getQtdeExamesCC(), ParametrosGerais.getTipoIntegracao(), ParametrosGerais.getColunasRodapeComprovante(), ParametrosGerais.isAgruparGuiasInterface(), ParametrosGerais.getTipoExportacaoInterface(), ParametrosGerais.getAgruparInterface(), ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), ParametrosGerais.getDigitosTuboTubo(), ParametrosGerais.getTuboPrimario(), null, () -> {
            try {
                Conexao.arquivaSQL();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }, () -> {
            try {
                Conexao.anulaSQL();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
        Conexao.fecharStatement(st, st2);
    }

    public RetornoTermoConsentimento imprimirTermoConsentimento(String codFilial, String codRequisicao, String itemTermo, long acessoImprimirTermoConsentimento, String codigoPaciente, Statement st, boolean agruparImpressaoTermo, Statement st2, boolean isColetaWeb, String impressoraTermo, String tamanhoNomeImpressora, String[] impressorasLocais, boolean isAlimentos, int casasPrecoExame, RoundingMode arredondamentoPrecoExame, boolean precoMetodologia, boolean ocultarApenasFaturamento, boolean ordenarSetor, String ordemComprovante, int qtdeExamesCC, String tipoIntegracao, int colunasRodapeComprovante, boolean agruparGuiasInterface, String tipoExportacaoInterface, int agruparInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, Boolean respostaPerguntaMultiguiaColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        RetornoTermoConsentimento retornoTermo = new RetornoTermoConsentimento();
        try {
            if (isColetaWeb || Acesso.getAcesso(acessoImprimirTermoConsentimento)) {
                boolean isMultiguia;
                String codTermo = Funcoes.isNumeric(itemTermo) ? itemTermo : new ImprimirTermoConsentimentoService().getTermo(codFilial, itemTermo, st).toString();
                ArrayList<Integer> layoutsImpressos = new ArrayList<Integer>();
                boolean respostaPergunta = false;
                Integer[] guias = RecepcaoUtil.verificaMultiGuias(st, codFilial, codRequisicao, true, false);
                boolean bl = isMultiguia = guias.length > 1;
                if (!agruparImpressaoTermo && isMultiguia) {
                    respostaPergunta = isColetaWeb ? respostaPerguntaMultiguiaColetaWeb.booleanValue() : this.solicitarImpressaoTermo();
                }
                for (Integer req : guias) {
                    RequisicaoTermoConsentimentoVO requisicao = this.service.getDadosRequisicao(codFilial, String.valueOf(req), st);
                    Registro reg = new Registro();
                    reg = this.service.validarImpressaoPorConvenioEDestino(codFilial, requisicao.getCodigoConvenio(), requisicao.getCodigoDestino(), st);
                    if (!reg.getString("imprimeTermo").equals("t")) continue;
                    Integer codLayout = this.service.getCodigoLayout(requisicao, codTermo, reg.getInt("codLayout"), st);
                    if (codLayout > 0) {
                        if (!agruparImpressaoTermo) {
                            if (!respostaPergunta) {
                                retornoTermo = this.imprimir(codFilial, isColetaWeb ? codRequisicao : String.valueOf(req), codTermo, codLayout, codigoPaciente, st, st2, agruparImpressaoTermo, isColetaWeb, impressoraTermo, tamanhoNomeImpressora, impressorasLocais, isAlimentos, casasPrecoExame, arredondamentoPrecoExame, precoMetodologia, ocultarApenasFaturamento, ordenarSetor, ordemComprovante, qtdeExamesCC, tipoIntegracao, colunasRodapeComprovante, agruparGuiasInterface, tipoExportacaoInterface, agruparInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, arquivar, anular);
                                if (!isColetaWeb) continue;
                                return retornoTermo;
                            }
                            if (layoutsImpressos.contains(codLayout)) continue;
                            layoutsImpressos.add(codLayout);
                            retornoTermo = this.imprimir(codFilial, codRequisicao, codTermo, codLayout, codigoPaciente, st, st2, agruparImpressaoTermo, isColetaWeb, impressoraTermo, tamanhoNomeImpressora, impressorasLocais, isAlimentos, casasPrecoExame, arredondamentoPrecoExame, precoMetodologia, ocultarApenasFaturamento, ordenarSetor, ordemComprovante, qtdeExamesCC, tipoIntegracao, colunasRodapeComprovante, agruparGuiasInterface, tipoExportacaoInterface, agruparInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, arquivar, anular);
                            if (!isColetaWeb) continue;
                            return retornoTermo;
                        }
                        if (isMultiguia && layoutsImpressos.contains(codLayout)) continue;
                        layoutsImpressos.add(codLayout);
                        retornoTermo = this.imprimir(codFilial, codRequisicao, codTermo, codLayout, codigoPaciente, st, st2, agruparImpressaoTermo, isColetaWeb, impressoraTermo, tamanhoNomeImpressora, impressorasLocais, isAlimentos, casasPrecoExame, arredondamentoPrecoExame, precoMetodologia, ocultarApenasFaturamento, ordenarSetor, ordemComprovante, qtdeExamesCC, tipoIntegracao, colunasRodapeComprovante, agruparGuiasInterface, tipoExportacaoInterface, agruparInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, arquivar, anular);
                        if (!isColetaWeb) continue;
                        return retornoTermo;
                    }
                    if (isColetaWeb) {
                        retornoTermo.setMensagem("Modelo n\u00e3o localizado ou n\u00e3o definido");
                        return retornoTermo;
                    }
                    Funcoes.mensagem(null, "Modelo n\u00e3o localizado ou n\u00e3o definido", 1);
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ex.getMessage(), ex.getStackTrace());
        }
        return retornoTermo;
    }

    public Runnable enviarImpressaoRun(final String codFilial, final String codRequisicao, final String itemTermo, final long acessoImprimirTermoConsentimento, final String codPaciente) {
        return new Runnable(){

            @Override
            public void run() {
                ImprimirTermoConsentimento.this.enviarImpressao(codFilial, codRequisicao, itemTermo, acessoImprimirTermoConsentimento, codPaciente);
            }
        };
    }
}

