/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.relatorio.Gerador;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ImprimirReciboMaterialEnviado {
    private static ModeloGridTable geraModeloDados(String filial, String codigoEnvio, Statement st) throws SQLException {
        ModeloGridTable modeloDados = new ModeloGridTable(Impressao.CAMPOS_RECIBO_MATERIAL_ENVIADO);
        StringBuilder buf = new StringBuilder();
        buf.append(" select a.con_codigo as codigoConvenio, e.con_fantasia as fantasiaConvenio, e.con_razao as razaoSocialConvenio, ");
        buf.append(" e.con_endereco as enderecoConvenio, e.con_numeroendereco as numeroEnderecoConvenio, e.con_tipologradouroendereco as tipoLogradouroConvenio, e.con_complemento as complementoConvenio, e.con_cep as cepConvenio, ");
        buf.append(" e.con_fone as foneConvenio, e.con_email1 as email1Convenio, e.con_email2 as email2Convenio, e.con_site as siteConvenio, ");
        buf.append(" a.con_codigo as codigoPaciente, d.pac_nome as nomePaciente, d.pac_razaosocial as SocialPaciente, ");
        buf.append(" d.pac_endereco as enderecoPaciente, d.pac_numeroendereco as numeroEnderecoPaciente, d.pac_tipologradouroendereco as tipoLogradouroPaciente, d.pac_complemento as complementoPaciente, d.pac_cep as cepPaciente, ");
        buf.append(" d.pac_fone as fonePaciente, d.pac_email as emailPaciente, d.pac_razaosocial as razaoSocialPaciente, ");
        buf.append(" b.cel_codigo as codigoCelulaEstoqueOrigem, b.cel_descricao as descricaoCelulaEstoqueOrigem, ");
        buf.append(" c.cel_codigo as codigoCelulaEstoqueDestino, c.cel_descricao as descricaoCelulaEstoqueDestino, COUNT(1) as quantidadeMaterialEnviado, ");
        buf.append(" cidconvenio.cid_codigo as codigoCidadeConvenio, cidconvenio.cid_nome as nomeCidadeConvenio, cidconvenio.cid_uf as ufCidadeConvenio, ");
        buf.append(" cidpaciente.cid_codigo as codigoCidadePaciente, cidpaciente.cid_nome as nomeCidadePaciente, cidpaciente.cid_uf as ufCidadePaciente, ");
        buf.append(" baiconvenio.bai_codigo as codigoBairroConvenio, baiconvenio.bai_descricao as descricaoBairroConvenio, ");
        buf.append(" baipaciente.bai_codigo as codigoBairroPaciente, baipaciente.bai_descricao as descricaoBairroPaciente, ");
        buf.append(" ma.mat_codigo as codigoMaterial, ma.mat_descricao as descricaoMaterial, ma.mat_marca as marcaMaterial, ma.mat_modelo as modeloMaterial, ");
        buf.append(" ma.unm_codigo as codigoUnidadeMedida, u.unm_descricao as descricaoUnidadeMedida, ");
        buf.append(" ma.tpm_codigo as codigoTipoMaterial, t.tpm_descricao as descricaoTipoMaterial, ");
        buf.append(" ma.usr_codigo as codigoUsuarioResponsavelMaterial, usrmat.usr_nome as nomeUsuarioResponsavelMaterial, ");
        buf.append(" mi.mid_dataenvio as dataEnvioMaterialEnviado, ");
        buf.append(" mi.usr_codenvio as codigoUsuarioMaterialEnviado, usr.usr_nome as nomeUsuarioEnvioMaterialEnviado, ");
        buf.append(" a.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial,");
        buf.append(" cidfilial.cid_codigo as codigoCidadeFilial, cidfilial.cid_nome as descricaoCidadeFilial, cidfilial.cid_uf as estadoCidadeFilial,");
        buf.append(" baifilial.bai_codigo as codigoBairroFilial, baifilial.bai_descricao as descricaoBairroFilial ");
        buf.append(" from materialenviado a ");
        buf.append(" join materialidentificado mi on a.fil_codigo = mi.fil_codigo and a.men_codigo = mi.men_codigo ");
        buf.append(" join material ma on mi.fil_codigo = ma.fil_codigo and mi.mat_codigo = ma.mat_codigo ");
        buf.append(" join celulaestoque b on a.fil_codigo = b.fil_codigo and a.cel_codorigem = b.cel_codigo ");
        buf.append(" join celulaestoque c on a.fil_codigo = c.fil_codigo and a.cel_coddestino = c.cel_codigo ");
        buf.append(" left join paciente d on a.fil_codigo = d.fil_codigo and a.pac_codigo = d.pac_codigo ");
        buf.append(" left join convenios e on a.fil_codigo = e.fil_codigo and a.con_codigo = e.con_codigo ");
        buf.append(" left join unidademedida u on ma.fil_codigo = u.fil_codigo and ma.unm_codigo = u.unm_codigo ");
        buf.append(" left join tipomaterial t on ma.fil_codigo = t.fil_codigo and ma.tpm_codigo = t.tpm_codigo ");
        buf.append(" left join usuario usr on mi.usr_codenvio = usr.usr_codigo ");
        buf.append(" left join usuario usrmat on ma.usr_codigo = usrmat.usr_codigo ");
        buf.append(" left join cidades cidconvenio on a.fil_codigo = cidconvenio.fil_codigo and e.cid_codigo = cidconvenio.cid_codigo ");
        buf.append(" left join cidades cidpaciente on a.fil_codigo = cidpaciente.fil_codigo and d.cid_codigo = cidpaciente.cid_codigo ");
        buf.append(" left join bairro baiconvenio on a.fil_codigo = baiconvenio.fil_codigo and e.bai_codigo = baiconvenio.bai_codigo ");
        buf.append(" left join bairro baipaciente on a.fil_codigo = baipaciente.fil_codigo and d.bai_codigo = baipaciente.bai_codigo ");
        buf.append(" left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo ");
        buf.append(" left join cidades cidfilial on filial.fil_codigo = cidfilial.fil_codigo and filial.cid_codigo = cidfilial.cid_codigo ");
        buf.append(" left join bairro baifilial on filial.fil_codigo = baifilial.fil_codigo and filial.bai_codigo = baifilial.bai_codigo ");
        buf.append(" where a.fil_codigo = ").append(filial);
        buf.append("   and a.men_codigo = ").append(codigoEnvio);
        buf.append(" group by a.con_codigo, e.con_fantasia, e.con_razao, e.con_endereco, e.con_numeroendereco, e.con_tipologradouroendereco, e.con_complemento, ");
        buf.append("          e.con_cep, e.con_fone, e.con_email1, e.con_email2, e.con_site, a.con_codigo, ");
        buf.append("          d.pac_nome, d.pac_razaosocial, d.pac_endereco, d.pac_numeroendereco, d.pac_tipologradouroendereco, d.pac_complemento, d.pac_cep, ");
        buf.append("          d.pac_fone, d.pac_email, d.pac_razaosocial, b.cel_codigo, b.cel_descricao, ");
        buf.append("          c.cel_codigo, c.cel_descricao, cidconvenio.cid_codigo, cidconvenio.cid_nome, ");
        buf.append("          cidconvenio.cid_uf, cidpaciente.cid_codigo, cidpaciente.cid_nome, cidpaciente.cid_uf, ");
        buf.append("          baiconvenio.bai_codigo, baiconvenio.bai_descricao, baipaciente.bai_codigo, baipaciente.bai_descricao, ");
        buf.append("          ma.mat_codigo, ma.mat_descricao, ma.mat_marca, ma.mat_modelo, ma.unm_codigo, u.unm_descricao, ma.tpm_codigo, ");
        buf.append("          t.tpm_descricao, ma.usr_codigo, usrmat.usr_nome, mi.mid_dataenvio, mi.usr_codenvio, usr.usr_nome, ");
        buf.append("          a.fil_codigo, filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, filial.fil_complemento, ");
        buf.append("          filial.fil_cep, filial.fil_fone, filial.fil_fax, filial.fil_razaosocial, cidfilial.cid_codigo, cidfilial.cid_nome, ");
        buf.append("          cidfilial.cid_uf, baifilial.bai_codigo, baifilial.bai_descricao ");
        buf.append(" order by b.cel_codigo ");
        ResultSet rs = Conexao.executeQuery(st, buf);
        while (rs.next()) {
            Object[] linha = new Object[Impressao.CAMPOS_RECIBO_MATERIAL_ENVIADO.length];
            for (String campo : Impressao.CAMPOS_RECIBO_MATERIAL_ENVIADO) {
                int pos = modeloDados.findColumn(campo);
                if (pos <= -1) continue;
                linha[pos] = Impressao.CAMPOS_RECIBO_MATERIAL_ENVIADO[pos].equalsIgnoreCase("tipoLogradouroPaciente") || Impressao.CAMPOS_RECIBO_MATERIAL_ENVIADO[pos].equalsIgnoreCase("tipoLogradouroConvenio") ? Tipos.tipoLogradouroDescricao(rs.getString(campo)) : rs.getObject(campo);
            }
            modeloDados.addLine(linha);
        }
        return modeloDados;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void imprimir(String filial, String codigoEnvio, String codigoConvenio) throws SQLException {
        Statement st = Conexao.getStatement();
        ModeloGridTable modeloDados = ImprimirReciboMaterialEnviado.geraModeloDados(filial, codigoEnvio, st);
        if (modeloDados.getRowCount() > 0) {
            StringBuilder str = new StringBuilder();
            String codigoLayout = String.valueOf(ParametrosGerais.getLayCodigo());
            if (!Variaveis.tipoFilialPadrao.equals("A") || !Funcoes.isNumeric(codigoConvenio)) {
                str.append("select lay_codigo from convenios where fil_codigo = ");
                str.append(filial);
                str.append(" and con_codigo = ");
                str.append(codigoConvenio);
                try (ResultSet res = null;){
                    res = st.executeQuery(str.toString());
                    if (res.next() && res.getString("lay_codigo") != null) {
                        codigoLayout = res.getString("lay_codigo");
                    }
                }
            }
            StringBuffer buf = new StringBuffer("");
            buf.append("select lay_recibocaixa, lay_tiporecibocaixa from layout where fil_codigo = ");
            buf.append(filial);
            buf.append(" and lay_codigo = ");
            buf.append(codigoLayout);
            ResultSet rsLayout = st.executeQuery(buf.toString());
            String impressora = ParametrosLocais.getParametro("impressoraRelatorio");
            if (rsLayout.next() && !Funcoes.textoVazio(rsLayout.getString("lay_recibocaixa"))) {
                Gerador gerador = new Gerador(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                gerador.setImpressora(Impressao.comparaNomeImpressoraReduzido(impressora));
                gerador.setPreVisualizar(true);
                gerador.executar(rsLayout.getString("lay_recibocaixa"), modeloDados);
            } else {
                Funcoes.mensagem(null, "Modelo n\u00e3o localizado ou n\u00e3o definido", 1);
            }
            if (rsLayout != null) {
                rsLayout.close();
            }
            st.close();
        }
    }
}

