/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import java.awt.Dimension;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.table.TableModel;
import org.postgresql.util.PGInterval;

public class ImprimirProtocoloDestino {
    private static final String[] ADICIONAIS_PROTOCOLO_DESTINO = new String[]{"codigoExame", "descricaoExame", "ambExame", "chExame", "valorExame", "valorMateriaisExame", "tempoJejumExame", "descricaoMaterial", "codigoMaterial", "abreviaturaMaterial", "dataColetaExame", "horaColetaExame", "usuarioColetaExame", "descricaoPrazo", "codigoPrazo", "codigoMetodo", "situacaoExame", "descricaoSituacaoExame", "descricaoMetodo", "materialInformadoExame", "dataEntregaExame", "horaEntregaExame", "valorCH", "autorizacaoExame", "observacaoPrazoCarenciaExame", "valorExameConvenio", "codigoSetorExame", "custoCBHPMExame", "ucoCBHPMExame", "valorPorteCBHPMExame", "porteCHBPMExame", "descricaoSetorExame", "abreviaturaSetorExame", "urgenteExame"};
    private static final int QTDE_CAMPOS_PROTOCOLO_DESTINO = ADICIONAIS_PROTOCOLO_DESTINO.length;

    public static void imprimir(String filial, String requisicao, boolean mostrarMensagem, boolean visualizar) throws SQLException {
        ImprimirProtocoloDestino protocolo = new ImprimirProtocoloDestino();
        protocolo.imprimir(filial, requisicao, false, mostrarMensagem, visualizar, Conexao.getStatement(), Conexao.getStatement(), ParametrosGerais.getOrdemComprovante(), ParametrosGerais.getOrdenarSetor(), ParametrosGerais.getQtdeExamesCC(), ParametrosGerais.getPrecoMetodologia(), ParametrosGerais.getArredondamentoPrecoExame(), ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.isOcultarApenasFaturamento());
    }

    /*
     * WARNING - void declaration
     */
    public byte[] imprimir(String filial, String requisicao, boolean isColetaWeb, boolean mostrarMensagem, boolean visualizar, Statement st, Statement stResult, String ordemComprovante, boolean ordenarSetor, int qtdeExamesCC, boolean precoMetodologia, RoundingMode arredondamentoPrecoExame, int parametrosCasasPrecoExame, boolean isOcultarApenasFaturamento) throws SQLException {
        if (st == null) {
            return new byte[0];
        }
        String sql = ImprimirProtocoloDestino.getSQl(filial, requisicao, ordemComprovante, ordenarSetor, isOcultarApenasFaturamento);
        HashMap<String, Object> hash = Impressao.buscaDadosLancamentoRequisicao(filial, requisicao, st);
        String datasParciais = Impressao.pegaDatasEntregaParcial(st, filial, requisicao);
        boolean semMaterial = Impressao.verificaExamesSemMaterial(st, filial, requisicao);
        String[] campos = ImprimirProtocoloDestino.adicionaColunasProtocoloDestino(Impressao.CAMPOS_PROTOCOLO_DESTINO, qtdeExamesCC);
        String[] perguntasFilial = RecepcaoUtil.getPerguntasFilial(filial, st);
        if (perguntasFilial.length > 0) {
            campos = ArraysUtil.concatenar(campos, perguntasFilial);
        }
        ModeloGridTable modeloDados = new ModeloGridTable(ArraysUtil.concatenar(campos, Impressao.CAMPOS_LANCAMENTO_CAIXA));
        ResultSet rs = stResult.executeQuery(sql);
        if (rs.next()) {
            int ultimaPosicao = Impressao.CAMPOS_PROTOCOLO_DESTINO.length;
            int contador = 1;
            String codigoConvenio = rs.getString("codigoConvenio");
            String codigoDestino = rs.getString("codigoDestino");
            if (qtdeExamesCC <= 1) {
                do {
                    modeloDados.addLine(new Object[modeloDados.getColumnCount()]);
                    if (!hash.isEmpty()) {
                        Set<String> set = hash.keySet();
                        for (String string : set) {
                            Object value = hash.get(string);
                            int pos = modeloDados.findColumn(string);
                            if (pos <= -1) continue;
                            modeloDados.setValueAt(value, modeloDados.getRowCount() - 1, pos);
                        }
                    }
                    for (int i = 0; i < Impressao.CAMPOS_PROTOCOLO_DESTINO.length; ++i) {
                        if (DBUtil.campoNull(rs.getString(Impressao.CAMPOS_PROTOCOLO_DESTINO[i]))) {
                            modeloDados.setValueAt("", modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_PROTOCOLO_DESTINO[i].equals("tipoLogradouroConvenio") || Impressao.CAMPOS_PROTOCOLO_DESTINO[i].equals("tipoLogradouroMedico") || Impressao.CAMPOS_PROTOCOLO_DESTINO[i].equals("tipoLogradouroPaciente")) {
                            modeloDados.setValueAt(Tipos.tipoLogradouroDescricao(rs.getString(Impressao.CAMPOS_PROTOCOLO_DESTINO[i])), modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_PROTOCOLO_DESTINO[i].equals("sexoPaciente")) {
                            modeloDados.setValueAt(Tipos.tipoSexo(rs.getString(Impressao.CAMPOS_PROTOCOLO_DESTINO[i])), modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_PROTOCOLO_DESTINO[i].equals("corPaciente")) {
                            modeloDados.setValueAt(Tipos.tipoCor(rs.getString(Impressao.CAMPOS_PROTOCOLO_DESTINO[i])), modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_PROTOCOLO_DESTINO[i].equalsIgnoreCase("estadoCivilPaciente")) {
                            modeloDados.setValueAt(Tipos.tipoEstadoCivil(rs.getString(Impressao.CAMPOS_PROTOCOLO_DESTINO[i])), modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_PROTOCOLO_DESTINO[i].equalsIgnoreCase("descricaoSituacaoExame")) {
                            modeloDados.setValueAt(Tipos.tipoSituacaoExame(rs.getString(Impressao.CAMPOS_PROTOCOLO_DESTINO[i])), modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_PROTOCOLO_DESTINO[i].equalsIgnoreCase("tipoUltimoPagamentoRequisicao")) {
                            modeloDados.setValueAt(Tipos.tipoPagamento(rs.getString("tipoUltimoPagamentoRequisicao")), modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_PROTOCOLO_DESTINO[i].equals("datasEntregaParcialRequisicao")) {
                            modeloDados.setValueAt(datasParciais, modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_PROTOCOLO_DESTINO[i].equals("existeExamesSemMaterial")) {
                            modeloDados.setValueAt(semMaterial, modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_PROTOCOLO_DESTINO[i].equals("idadeRequisicaoPaciente")) {
                            modeloDados.setValueAt(Funcoes.getIntervaloParaString((PGInterval)rs.getObject(Impressao.CAMPOS_PROTOCOLO_DESTINO[i]), null), modeloDados.getRowCount() - 1, i);
                            continue;
                        }
                        if (Impressao.CAMPOS_PROTOCOLO_DESTINO[i].equals("perguntasRequisicao")) {
                            if (Funcoes.textoVazio(rs.getString("perguntasRequisicao"))) continue;
                            Map<String, Object> respostasRequisicao = Resultado.getCamposResultado(rs.getString("perguntasRequisicao"));
                            for (Map.Entry<String, Object> resposta : respostasRequisicao.entrySet()) {
                                if (modeloDados.findColumn(resposta.getKey()) <= -1) continue;
                                modeloDados.setValueAt(resposta.getValue(), modeloDados.getRowCount() - 1, modeloDados.findColumn(resposta.getKey()));
                            }
                            continue;
                        }
                        modeloDados.setValueAt(rs.getObject(Impressao.CAMPOS_PROTOCOLO_DESTINO[i]), modeloDados.getRowCount() - 1, i);
                    }
                    for (int j = 0; j < QTDE_CAMPOS_PROTOCOLO_DESTINO; ++j) {
                        if (ADICIONAIS_PROTOCOLO_DESTINO[j].indexOf("ambExame") > -1) {
                            modeloDados.setValueAt(Impressao.pegaAMB(st, filial, rs.getString("codigoExame"), rs.getString("codigoMaterial"), rs.getString("codigoConvenio"), rs.getString("codigoMetodo"), precoMetodologia), modeloDados.getRowCount() - 1, ultimaPosicao++);
                            continue;
                        }
                        if (ADICIONAIS_PROTOCOLO_DESTINO[j].indexOf("descricaoSituacaoExame") > -1) {
                            modeloDados.setValueAt(Tipos.tipoSituacaoExame(rs.getString("descricaoSituacaoExame")), modeloDados.getRowCount() - 1, ultimaPosicao++);
                            continue;
                        }
                        if (ADICIONAIS_PROTOCOLO_DESTINO[j].indexOf("valorExameConvenio") > -1) {
                            modeloDados.setValueAt(ExameUtil.calculaPrecoExameConvenio(st, filial, rs.getString("codigoExame"), rs.getInt("codigoMaterial"), rs.getInt("codigoConvenio"), null, null, rs.getInt("codigoMetodo"), precoMetodologia, arredondamentoPrecoExame, parametrosCasasPrecoExame), modeloDados.getRowCount() - 1, ultimaPosicao++);
                            continue;
                        }
                        modeloDados.setValueAt(rs.getObject(ADICIONAIS_PROTOCOLO_DESTINO[j]), modeloDados.getRowCount() - 1, ultimaPosicao++);
                    }
                } while (rs.next());
            } else {
                boolean fimTabela = false;
                while (!fimTabela) {
                    void var29_40;
                    modeloDados.addLine(new Object[modeloDados.getColumnCount()]);
                    if (!hash.isEmpty()) {
                        Set<String> set = hash.keySet();
                        for (String s : set) {
                            Iterator<Map.Entry<String, Object>> value = hash.get(s);
                            int pos = modeloDados.findColumn(s);
                            if (pos <= -1) continue;
                            modeloDados.setValueAt(value, modeloDados.getRowCount() - 1, pos);
                        }
                    }
                    int linhaModelo = modeloDados.getRowCount() - 1;
                    boolean bl = false;
                    while (var29_40 < Impressao.CAMPOS_PROTOCOLO_DESTINO.length) {
                        if (DBUtil.campoNull(rs.getString(Impressao.CAMPOS_PROTOCOLO_DESTINO[var29_40]))) {
                            modeloDados.setValueAt("", linhaModelo, (int)var29_40);
                        } else if (Impressao.CAMPOS_PROTOCOLO_DESTINO[var29_40].equals("tipoLogradouroConvenio") || Impressao.CAMPOS_PROTOCOLO_DESTINO[var29_40].equals("tipoLogradouroMedico") || Impressao.CAMPOS_PROTOCOLO_DESTINO[var29_40].equals("tipoLogradouroPaciente")) {
                            modeloDados.setValueAt(Tipos.tipoLogradouroDescricao(rs.getString(Impressao.CAMPOS_PROTOCOLO_DESTINO[var29_40])), linhaModelo, (int)var29_40);
                        } else if (Impressao.CAMPOS_PROTOCOLO_DESTINO[var29_40].equals("sexoPaciente")) {
                            modeloDados.setValueAt(Tipos.tipoSexo(rs.getString(Impressao.CAMPOS_PROTOCOLO_DESTINO[var29_40])), linhaModelo, (int)var29_40);
                        } else if (Impressao.CAMPOS_PROTOCOLO_DESTINO[var29_40].equals("corPaciente")) {
                            modeloDados.setValueAt(Tipos.tipoCor(rs.getString(Impressao.CAMPOS_PROTOCOLO_DESTINO[var29_40])), linhaModelo, (int)var29_40);
                        } else if (Impressao.CAMPOS_PROTOCOLO_DESTINO[var29_40].equalsIgnoreCase("estadoCivilPaciente")) {
                            modeloDados.setValueAt(Tipos.tipoEstadoCivil(rs.getString(Impressao.CAMPOS_PROTOCOLO_DESTINO[var29_40])), linhaModelo, (int)var29_40);
                        } else if (Impressao.CAMPOS_PROTOCOLO_DESTINO[var29_40].equalsIgnoreCase("descricaoSituacaoExame")) {
                            modeloDados.setValueAt(Tipos.tipoSituacaoExame(rs.getString(Impressao.CAMPOS_PROTOCOLO_DESTINO[var29_40])), linhaModelo, (int)var29_40);
                        } else if (Impressao.CAMPOS_PROTOCOLO_DESTINO[var29_40].equals("existeExamesSemMaterial")) {
                            modeloDados.setValueAt(semMaterial, linhaModelo, (int)var29_40);
                        } else if (Impressao.CAMPOS_PROTOCOLO_DESTINO[var29_40].equals("datasEntregaParcialRequisicao")) {
                            modeloDados.setValueAt(datasParciais, linhaModelo, (int)var29_40);
                        } else if (Impressao.CAMPOS_PROTOCOLO_DESTINO[var29_40].equals("idadeRequisicaoPaciente")) {
                            modeloDados.setValueAt(Funcoes.getIntervaloParaString((PGInterval)rs.getObject(Impressao.CAMPOS_PROTOCOLO_DESTINO[var29_40]), null), modeloDados.getRowCount() - 1, (int)var29_40);
                        } else if (Impressao.CAMPOS_PROTOCOLO_DESTINO[var29_40].equals("perguntasRequisicao")) {
                            if (!Funcoes.textoVazio(rs.getString("perguntasRequisicao"))) {
                                Map<String, Object> respostasRequisicao = Resultado.getCamposResultado(rs.getString("perguntasRequisicao"));
                                for (Map.Entry<String, Object> resposta : respostasRequisicao.entrySet()) {
                                    if (modeloDados.findColumn(resposta.getKey()) <= -1) continue;
                                    modeloDados.setValueAt(resposta.getValue(), modeloDados.getRowCount() - 1, modeloDados.findColumn(resposta.getKey()));
                                }
                            }
                        } else {
                            modeloDados.setValueAt(rs.getObject(Impressao.CAMPOS_PROTOCOLO_DESTINO[var29_40]), linhaModelo, (int)var29_40);
                        }
                        ++var29_40;
                    }
                    while (contador <= qtdeExamesCC) {
                        for (int i = 0; i < QTDE_CAMPOS_PROTOCOLO_DESTINO; ++i) {
                            if (ADICIONAIS_PROTOCOLO_DESTINO[i].indexOf("ambExame") > -1) {
                                modeloDados.setValueAt(fimTabela ? "" : Impressao.pegaAMB(st, filial, rs.getString("codigoExame"), rs.getString("codigoMaterial"), rs.getString("codigoConvenio"), rs.getString("codigoMetodo"), precoMetodologia), linhaModelo, ultimaPosicao++);
                                continue;
                            }
                            if (ADICIONAIS_PROTOCOLO_DESTINO[i].indexOf("descricaoSituacaoExame") > -1) {
                                modeloDados.setValueAt(fimTabela ? "" : Tipos.tipoSituacaoExame(rs.getString("descricaoSituacaoExame")), linhaModelo, ultimaPosicao++);
                                continue;
                            }
                            if (ADICIONAIS_PROTOCOLO_DESTINO[i].indexOf("valorExameConvenio") > -1) {
                                modeloDados.setValueAt(fimTabela ? "" : ExameUtil.calculaPrecoExameConvenio(st, filial, rs.getString("codigoExame"), rs.getInt("codigoMaterial"), rs.getInt("codigoConvenio"), null, null, rs.getInt("codigoMetodo"), precoMetodologia, arredondamentoPrecoExame, parametrosCasasPrecoExame), linhaModelo, ultimaPosicao++);
                                continue;
                            }
                            modeloDados.setValueAt(fimTabela ? "" : rs.getObject(ADICIONAIS_PROTOCOLO_DESTINO[i]), linhaModelo, ultimaPosicao++);
                        }
                        fimTabela = !rs.next();
                        ++contador;
                    }
                    if (fimTabela) continue;
                    contador = 1;
                    ultimaPosicao = Impressao.CAMPOS_PROTOCOLO_DESTINO.length;
                }
            }
            Impressao.adicionaMedicamento(filial, requisicao, modeloDados, st);
            StringBuilder buf = new StringBuilder("");
            buf.append("select des_protocolo from destino where fil_codigo = ");
            buf.append(filial);
            buf.append(" and des_codigo = '");
            buf.append(StringUtil.textoDB(codigoDestino)).append("'");
            ResultSet rsLayout = st.executeQuery(buf.toString());
            if (rsLayout.next() && !Funcoes.textoVazio(rsLayout.getString("des_protocolo")) && !Gerador.vazio(rsLayout.getString("des_protocolo"))) {
                String string = rsLayout.getString("des_protocolo");
                String impressora = "";
                if (!isColetaWeb) {
                    impressora = ParametrosLocais.getParametro("impressoraRelatorio");
                }
                Gerador gerador = new Gerador(parametrosCasasPrecoExame, arredondamentoPrecoExame);
                if (isColetaWeb) {
                    gerador.setTituloImpressao("Impressao_relatorio_jalis_" + Funcoes.formataData("dd_MM_yyyy_kk:mm:ss", new Date()) + StringUtil.removerAcentos(modeloDados.getValueAt(0, modeloDados.findColumn("nomePaciente")).toString()));
                    gerador.executar(string, modeloDados, null, false, true, isColetaWeb);
                    return Impressao.gerarPdfRelatorio(gerador.getRelatorio(), string);
                }
                final JDialog dialogo = new JDialog(Laboratorio.getInstancia());
                if (visualizar) {
                    dialogo.setModal(true);
                    dialogo.setSize(new Dimension(750, 600));
                    gerador.setPai(dialogo);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            dialogo.dispose();
                        }
                    });
                    gerador.setPreVisualizar(true);
                }
                gerador.setImpressora(Impressao.comparaNomeImpressoraReduzido(impressora));
                gerador.setTituloImpressao("Impressao_relatorio_jalis_" + Funcoes.formataData("dd_MM_yyyy_kk:mm:ss", new Date()) + StringUtil.removerAcentos(modeloDados.getValueAt(0, modeloDados.findColumn("nomePaciente")).toString()));
                gerador.executar(string, (TableModel)modeloDados, false);
                if (visualizar) {
                    dialogo.setVisible(true);
                }
            } else if (mostrarMensagem) {
                Funcoes.mensagem(null, "Modelo de protocolo de destino n\u00e3o localizado ou n\u00e3o definido.\nFilial: " + filial + ", c\u00f3digo requisi\u00e7\u00e3o: " + requisicao + ".", 2);
            }
            rsLayout.close();
        }
        rs.close();
        st.close();
        stResult.close();
        return new byte[0];
    }

    private static String getSQl(String filial, String requisicao, String ordemComprovante, boolean ordenarSetor, boolean isOcultarApenasFaturamento) {
        StringBuilder buf = new StringBuilder();
        buf.append("select a.req_codigo as codigoRequisicao, a.req_data as dataRequisicao, a.req_dtfatura as dataFaturaRequisicao, a.req_urgente as urgenteRequisicao, a.req_dataentregaprev as dataEntregaRequisicao,");
        buf.append("a.req_dclinicos as dadosClinicosRequisicao, a.req_obs as obsRequisicao, a.req_totpago as totalPagoRequisicao, a.req_horaentregaprev as horaEntregaRequisicao, a.req_total as totalRequisicao,");
        buf.append("a.req_responsavel as responsavelPacienteRequisicao, a.req_cpfresponsavel as cpfResponsavelPacienteRequisicao, coalesce(a.req_incapacitado, false) as incapacitadoPacienteRequisicao,");
        buf.append("j.pac_responsavel as responsavelPaciente, j.pac_cpfresponsavel as cpfResponsavelPaciente, coalesce(j.pac_incapacitado, false) as incapacitadoPaciente,");
        buf.append("a.req_horafatura as horaFaturaRequisicao, a.req_hora as horaRequisicao, a.req_gestante as gestanteRequisicao, a.req_dum as dumRequisicao, a.req_idade as idadeRequisicao, a.req_anomes as anoMesRequisicao,");
        buf.append("a.req_matricula as matriculaRequisicao, a.req_avisarpaciente as avisarPacienteRequisicao, a.req_senhaweb as senhaWebRequisicao, a.req_titular as titularRequisicao, a.req_peso as pesoRequisicao,");
        buf.append("a.req_altura as alturaRequisicao, a.req_desconto as descontoRequisicao, a.req_vlrdesconto as valorDescontoRequisicao, a.req_notacaixa as notaCaixaRequisicao, ");
        buf.append("a.req_vlrexames as valorExamesRequisicao, a.req_vlrmateriais as valorMateriaisRequisicao, a.req_guia as guiaRequisicao, ");
        buf.append("a.req_acrescimo as acrescimoRequisicao, a.req_vlracrescimo as valorAcrescimoRequisicao, a.req_tipoultpagamento as tipoUltimoPagamentoRequisicao, ");
        buf.append("a.req_imprimirseparado as imprimirSeparadoRequisicao, '' as datasEntregaParcialRequisicao, ");
        buf.append("a.req_complementodestino as complementoDestinoRequisicao, false as existeExamesSemMaterial, ");
        buf.append("a.sit_codigo as codigoSituacao, g.sit_descricao as descricaoSituacao,  a.req_cartaosus as cartaoSUSRequisicao, ");
        buf.append("a.usr_codigo as codigoUsuario, h.usr_nome as nomeUsuario, h.usr_assinatura as assinaturaUsuario,");
        buf.append("a.usr_codabertura as codigoUsuarioAbertura, ab.usr_nome as nomeUsuarioAbertura, ab.usr_assinatura as assinaturaUsuarioAbertura,");
        buf.append("k.cid_codigo as codigoCidadeConvenio, k.cid_nome as descricaoCidadeConvenio, k.cid_uf as estadoCidadeConvenio,");
        buf.append("l.cid_codigo as codigoCidadeMedico, l.cid_nome as descricaoCidadeMedico, l.cid_uf as estadoCidadeMedico,");
        buf.append("m.cid_codigo as codigoCidadeDestino, m.cid_nome as descricaoCidadeDestino, m.cid_uf as estadoCidadeDestino,");
        buf.append("n.cid_codigo as codigoCidadeColeta, n.cid_nome as descricaoCidadeColeta, n.cid_uf as estadoCidadeColeta,");
        buf.append("o.cid_codigo as codigoCidadePaciente, o.cid_nome as descricaoCidadePaciente, o.cid_uf as estadoCidadePaciente,");
        buf.append("p.bai_codigo as codigoBairroConvenio, p.bai_descricao as descricaoBairroConvenio,");
        buf.append("q.bai_codigo as codigoBairroMedico, q.bai_descricao as descricaoBairroMedico,");
        buf.append("r.bai_codigo as codigoBairroDestino, r.bai_descricao as descricaoBairroDestino,");
        buf.append("s.bai_codigo as codigoBairroColeta, s.bai_descricao as descricaoBairroColeta,");
        buf.append("t.bai_codigo as codigoBairroPaciente, t.bai_descricao as descricaoBairroPaciente,");
        buf.append("a.des_codigo as codigoDestino, e.des_descricao as descricaoDestino, e.des_endereco as enderecoDestino, e.des_complemento as complementoDestino,e.des_cep as cepDestino, e.des_fone as foneDestino, e.des_enviarweb as enviarParaWebDestino, ");
        buf.append("a.col_codigo as codigoColeta, f.col_descricao as descricaoColeta, f.col_endereco as enderecoColeta, f.col_complemento as complementoColeta, f.col_cep as cepColeta, f.col_fone as foneColeta,");
        buf.append("a.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial,");
        buf.append("cidfilial.cid_codigo as codigoCidadeFilial, cidfilial.cid_nome as descricaoCidadeFilial, cidfilial.cid_uf as estadoCidadeFilial,");
        buf.append("baifilial.bai_codigo as codigoBairroFilial, baifilial.bai_descricao as descricaoBairroFilial,");
        buf.append("d.med_conselho as conselhoMedico, d.med_crm as crmMedico, d.med_uf as estadoCrmMedico, d.med_nome as nomeMedico, d.med_abrev as tratamentoMedico, d.med_endereco as enderecoMedico, d.med_numeroendereco as numeroEnderecoMedico, d.med_tipologradouroendereco as tipoLogradouroMedico, d.med_complemento as complementoMedico, d.med_cep as cepMedico, d.med_fone as foneMedico, d.med_celular as celularMedico, d.med_fax as faxMedico, d.med_email as emailMedico, d.med_site as siteMedico,");
        buf.append("c.con_codigo as codigoConvenio, c.con_fantasia as fantasiaConvenio, c.con_razao as razaoSocialConvenio, c.con_endereco as enderecoConvenio, c.con_numeroendereco as numeroEnderecoConvenio, c.con_tipologradouroendereco as tipoLogradouroConvenio, c.con_complemento as complementoConvenio, c.con_cep as cepConvenio, c.con_fone as foneConvenio, c.con_email1 as email1Convenio, c.con_email2 as email2Convenio, c.con_site as siteConvenio,");
        buf.append("j.pac_codigo as codigoPaciente, j.pac_nome as nomePaciente, j.pac_nomesocial as nomeSocialPaciente, j.pac_sexo as sexoPaciente, j.pac_datanasc as dataNascimentoPaciente, j.pac_grpsangue as grupoSanguineoPaciente, j.pac_fatorrh as fatorRHPaciente, j.pac_fatordu as fatorDUPaciente, j.pac_cor as corPaciente,");
        buf.append("j.pac_profissao as profissaoPaciente, j.pac_rg as rgPaciente, j.pac_cpf as cpfPaciente, j.pac_estcivil as estadoCivilPaciente, j.pac_dum as dumPaciente, j.pac_fone as fonePaciente, j.pac_celular as celularPaciente, j.pac_fax as faxPaciente, j.pac_fonecomercial as foneComercialPaciente,");
        buf.append("j.pac_cartaosus as cartaoSUSPaciente, j.pac_endereco as enderecoPaciente, j.pac_numeroendereco as numeroEnderecoPaciente, j.pac_tipologradouroendereco as tipoLogradouroPaciente, j.pac_complemento as complementoPaciente, j.pac_cep as cepPaciente, j.pac_email as emailPaciente, j.pac_fonecontato as foneContatoPaciente, j.pac_nomecontato as contatoPaciente, b.exr_vlrch as valorCH,");
        buf.append("j.pac_whatsapp as whatsAppPaciente, ");
        buf.append("b.exr_valorcusto as custoCBHPMExame, b.exr_valoruco as ucoCBHPMExame, b.exr_valorporte as valorPorteCBHPMExame, b.exr_porte as porteCHBPMExame, ");
        buf.append("b.exa_codigo as codigoExame, w.exa_descricao as descricaoExame, b.exr_vlrchexame as ambExame, b.exr_vlrchexame as chExame, b.exr_vlrexame as valorExame, b.exr_vlrmaterial as valorMateriaisExame, b.exr_situacao as situacaoExame, '' as descricaoSituacaoExame, ");
        buf.append("v.mco_descricao as descricaoMaterial, v.mco_codigo as codigoMaterial, v.mco_abreviatura as abreviaturaMaterial, b.exr_datamaterial as dataColetaExame, b.exr_datamaterial as horaColetaExame, ");
        buf.append("coalesce(b.exr_urgente, false) as urgenteExame, ");
        buf.append("b.usr_codmaterial as usuarioColetaExame, prazo.prz_descricao as descricaoPrazo, prazo.prz_codigo as codigoPrazo, metodo.met_codigo as codigoMetodo, ");
        buf.append("metodo.met_descricao as descricaoMetodo, b.exr_descricaomaterial as materialInformadoExame, b.exr_dataentregaprev as dataEntregaExame, b.exr_dataentregaprev as horaEntregaExame, ");
        buf.append("b.exr_codautorizacao as autorizacaoExame, CASE WHEN exr_intervaloJejum is null then TO_CHAR(exr_tempoJejum,'HH24:MI:SS') else TO_CHAR(exr_intervaloJejum,'HH24:MI:SS') end  as tempoJejumExame, b.exr_motivoprazo as observacaoPrazoCarenciaExame, ");
        buf.append("j.pac_senhaweb as senhaWebPaciente, b.exr_vlrexame as valorExameConvenio, ");
        buf.append("exmsetor.set_codigo as codigoSetorExame, setores.set_descricao as descricaoSetorExame, setores.set_sigla as abreviaturaSetorExame, ");
        buf.append("a.req_quarto as quartoRequisicao, a.req_leito as leitoRequisicao, a.ala_codigo as codigoAla, ala.ala_descricao as descricaoAla, a.req_procedencia as procedenciaRequisicao  ");
        buf.append(", age(a.req_data, j.pac_datanasc) as idadeRequisicaoPaciente ");
        buf.append(", a.req_periodogestacional as periodoGestacionalRequisicao ");
        buf.append(", a.req_perguntas as perguntasRequisicao ");
        buf.append("from requisicao a ");
        buf.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
        if (isOcultarApenasFaturamento) {
            buf.append(" and b.exr_situacao <> 'A' ");
        }
        buf.append("left join convenios c on a.fil_codigo = c.fil_codigo and a.con_codigo = c.con_codigo ");
        buf.append("left join medico d on a.fil_codigo = d.fil_codigo and a.med_conselho = d.med_conselho and upper(a.med_crm) = upper(d.med_crm) and a.med_uf = d.med_uf ");
        buf.append("left join destino e on a.fil_codigo = e.fil_codigo and upper(a.des_codigo) = upper(e.des_codigo) ");
        buf.append("left join coletas f on a.fil_codigo = f.fil_codigo and upper(a.col_codigo) = upper(f.col_codigo) ");
        buf.append("left join situacao g on a.fil_codigo = g.fil_codigo and a.sit_codigo = g.sit_codigo ");
        buf.append("left join usuario h on upper(a.usr_codigo) = upper(h.usr_codigo) ");
        buf.append("left join usuario ab on upper(a.usr_codabertura) = upper(ab.usr_codigo) ");
        buf.append("left join paciente j on a.fil_codigo = j.fil_codigo and a.pac_codigo = j.pac_codigo ");
        buf.append("left join cidades k on c.fil_codigo = k.fil_codigo and c.cid_codigo = k.cid_codigo ");
        buf.append("left join cidades l on d.fil_codigo = l.fil_codigo and d.cid_codigo = l.cid_codigo ");
        buf.append("left join cidades m on e.fil_codigo = m.fil_codigo and e.cid_codigo = m.cid_codigo ");
        buf.append("left join cidades n on f.fil_codigo = n.fil_codigo and f.cid_codigo = n.cid_codigo ");
        buf.append("left join cidades o on j.fil_codigo = o.fil_codigo and j.cid_codigo = o.cid_codigo ");
        buf.append("left join bairro p on c.fil_codigo = p.fil_codigo and c.bai_codigo = p.bai_codigo ");
        buf.append("left join bairro q on d.fil_codigo = q.fil_codigo and d.bai_codigo = q.bai_codigo ");
        buf.append("left join bairro r on e.fil_codigo = r.fil_codigo and e.bai_codigo = r.bai_codigo ");
        buf.append("left join bairro s on f.fil_codigo = s.fil_codigo and f.bai_codigo = s.bai_codigo ");
        buf.append("left join bairro t on j.fil_codigo = t.fil_codigo and j.bai_codigo = t.bai_codigo ");
        buf.append("left join examematcoleta u on b.fil_codigo = u.fil_codigo and upper(b.exa_codigo) = upper(u.exa_codigo) and b.mco_codigo = u.mco_codigo ");
        buf.append("left join materialcoleta v on u.fil_codigo = v.fil_codigo and u.mco_codigo = v.mco_codigo ");
        buf.append("left join exames w on b.fil_codigo = w.fil_codigo and upper(b.exa_codigo) = upper(w.exa_codigo) ");
        buf.append("left join prazoentrega prazo on u.fil_codigo = prazo.fil_codigo and u.prz_codigo = prazo.prz_codigo ");
        buf.append("left join metodologia metodo on u.fil_codigo = metodo.fil_codigo and u.met_codigo = metodo.met_codigo ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo ");
        buf.append("left join cidades cidfilial on filial.fil_codigo = cidfilial.fil_codigo and filial.cid_codigo = cidfilial.cid_codigo ");
        buf.append("left join bairro baifilial on filial.fil_codigo = baifilial.fil_codigo and filial.bai_codigo = baifilial.bai_codigo ");
        buf.append("left join examesetor exmsetor on w.fil_codigo = exmsetor.fil_codigo and w.exa_codigo = exmsetor.exa_codigo and exmsetor.ese_default = true ");
        buf.append("left join setores setores on exmsetor.fil_codigo = setores.fil_codigo and exmsetor.set_codigo = setores.set_codigo ");
        buf.append("left join alahospital ala on a.fil_codigo = ala.fil_codigo and a.ala_codigo = ala.ala_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and a.req_codigo = ");
        buf.append(requisicao);
        buf.append(" and (a.req_excluida = false or (a.req_excluida = true and a.req_origemagendamento = true)) and b.exr_excluido = false ");
        buf.append(" order by ");
        if (ordemComprovante.equals("A")) {
            buf.append(" b.exr_ordem ");
        } else {
            if (ordenarSetor) {
                buf.append(" exmsetor.set_codigo, ");
            }
            buf.append(" a.req_codigo ");
            if (ordemComprovante.equals("C")) {
                buf.append(", b.exa_codigo");
            } else if (ordemComprovante.equals("P")) {
                buf.append(", u.emc_pagina, u.emc_ordem, b.exa_codigo, b.mco_codigo ");
            }
        }
        return buf.toString();
    }

    public static String[] adicionaColunasProtocoloDestino(String[] campos, int qtdeExamesCC) {
        int i;
        String[] medicamento = Impressao.getCamposMedicamento();
        String[] novo = new String[campos.length + QTDE_CAMPOS_PROTOCOLO_DESTINO * qtdeExamesCC + medicamento.length];
        for (int i2 = 0; i2 < campos.length; ++i2) {
            novo[i2] = campos[i2];
        }
        int ultimaPosicao = campos.length;
        if (qtdeExamesCC <= 1) {
            for (i = 0; i < QTDE_CAMPOS_PROTOCOLO_DESTINO; ++i) {
                novo[ultimaPosicao++] = ADICIONAIS_PROTOCOLO_DESTINO[i];
            }
        } else {
            for (int contador = 1; contador <= qtdeExamesCC; ++contador) {
                for (i = 0; i < QTDE_CAMPOS_PROTOCOLO_DESTINO; ++i) {
                    novo[ultimaPosicao++] = ADICIONAIS_PROTOCOLO_DESTINO[i] + String.valueOf(contador);
                }
            }
        }
        for (String s : medicamento) {
            novo[ultimaPosicao++] = s;
        }
        return novo;
    }
}

