/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.impressao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.digitacao.TabelaSimbolos;
import jalis.laboratorio.impressao.Documento;
import jalis.laboratorio.impressao.ExameMaterialPagina;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.RetornoImpressaoMapa;
import jalis.model.bean.cadastro.exame.SetorBean;
import jalis.service.cadastro.exame.SetorService;
import jalis.util.ArraysUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.impressao.matricial.ImpressaoMapa;
import jalis.util.impressao.matricial.Mapa;
import jalis.util.logger.ErrorLogger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.postgresql.util.PGInterval;

public class ImprimirMapa {
    static int idade;
    static String tipoIdade;

    public static boolean imprimir(String filial, String requisicao, boolean naoPermiteVisualizarPaciente) throws Exception {
        return ImprimirMapa.imprimir(filial, requisicao, null, null, true, false, naoPermiteVisualizarPaciente, -1);
    }

    public static boolean imprimir(String filial, String requisicao, boolean reimprimir, boolean naoPermiteVisualizarPaciente) throws Exception {
        return ImprimirMapa.imprimir(filial, requisicao, null, null, reimprimir, false, naoPermiteVisualizarPaciente, -1);
    }

    public static boolean imprimir(String filial, String requisicao, String exame, int material, boolean reimprimir, boolean naoPermiteVisualizarPaciente) throws Exception {
        return ImprimirMapa.imprimir(filial, requisicao, new String[]{exame, String.valueOf(material)}, null, reimprimir, false, naoPermiteVisualizarPaciente, -1);
    }

    public static boolean imprimir(String filial, String requisicao, String[] setores, boolean naoPermiteVisualizarPaciente) throws Exception {
        return ImprimirMapa.imprimir(filial, requisicao, null, setores, true, false, naoPermiteVisualizarPaciente, -1);
    }

    public static boolean imprimir(String filial, String requisicao, String[] setores, boolean reimprimir, boolean naoPermiteVisualizarPaciente) throws Exception {
        return ImprimirMapa.imprimir(filial, requisicao, null, setores, reimprimir, false, naoPermiteVisualizarPaciente, -1);
    }

    public static boolean imprimir(String filial, String requisicao, String[] exames, String[] setores, boolean reimprimir, boolean apenasMapasComTriagem, boolean naoPermiteVisualizarPaciente, int metodoSelecionado) throws Exception {
        return ImprimirMapa.imprimir(filial, requisicao, exames, setores, reimprimir, apenasMapasComTriagem, true, naoPermiteVisualizarPaciente, metodoSelecionado);
    }

    public static boolean imprimir(String filial, String requisicao, String[] exames, String[] setores, boolean reimprimir, boolean apenasMapasComTriagem, boolean filtroExamesComMaterial, boolean naoPermiteVisualizarPaciente, int metodoSelecionado) throws Exception {
        ImprimirMapa mapa = new ImprimirMapa();
        return mapa.imprimir(filial, requisicao, exames, setores, reimprimir, apenasMapasComTriagem, filtroExamesComMaterial, null, naoPermiteVisualizarPaciente, false, metodoSelecionado, Conexao.getStatement(), Conexao.getStatement(), ParametrosGerais.isAgruparImpress\u00e3oMapaMultiguia(), ParametrosGerais.isImprimirMapaPorMetodo(), ImprimirMapa.isAlimentos(), ParametrosGerais.isAgruparGuiasInterface(), ParametrosGerais.getLayCodigo(), ParametrosLocais.getParametro("impressoraMapa"), ParametrosLocais.getParametro("tamanhoNomeImpressoras"), Funcoes.getNomeImpressorasLocais(), ParametrosGerais.isUtilizaMetodoParaBuscarResultadoAnterior(), ParametrosGerais.getOrdenarExamesAnteriores(), ParametrosGerais.getConferencia(), ParametrosGerais.getPrecoMetodologia(), Variaveis.tipoFilialPadrao, Variaveis.login, false, ParametrosGerais.isPesquisarAnterioresAutocopiaPaciente(), ParametrosGerais.getCopiaPaciente(), Variaveis.filialPadrao, ParametrosGerais.isOcultarApenasFaturamento()).isImprimiu();
    }

    public static boolean imprimir(String filial, String requisicao, String[] exames, String[] setores, boolean reimprimir, boolean apenasMapasComTriagem, boolean filtroExamesComMaterial, String[] materialColetado, boolean naoPermiteVisualizarPaciente, boolean ocultarConvenio, int metodoSelecionado) throws Exception {
        ImprimirMapa mapa = new ImprimirMapa();
        return mapa.imprimir(filial, requisicao, exames, setores, reimprimir, apenasMapasComTriagem, filtroExamesComMaterial, null, naoPermiteVisualizarPaciente, false, metodoSelecionado, Conexao.getStatement(), Conexao.getStatement(), ParametrosGerais.isAgruparImpress\u00e3oMapaMultiguia(), ParametrosGerais.isImprimirMapaPorMetodo(), ImprimirMapa.isAlimentos(), ParametrosGerais.isAgruparGuiasInterface(), ParametrosGerais.getLayCodigo(), ParametrosLocais.getParametro("impressoraMapa"), ParametrosLocais.getParametro("tamanhoNomeImpressoras"), Funcoes.getNomeImpressorasLocais(), ParametrosGerais.isUtilizaMetodoParaBuscarResultadoAnterior(), ParametrosGerais.getOrdenarExamesAnteriores(), ParametrosGerais.getConferencia(), ParametrosGerais.getPrecoMetodologia(), Variaveis.tipoFilialPadrao, Variaveis.login, false, ParametrosGerais.isPesquisarAnterioresAutocopiaPaciente(), ParametrosGerais.getCopiaPaciente(), Variaveis.filialPadrao, ParametrosGerais.isOcultarApenasFaturamento()).isImprimiu();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RetornoImpressaoMapa imprimir(String filial, String requisicao, String[] exames, String[] setores, boolean reimprimir, boolean apenasMapasComTriagem, boolean filtroExamesComMaterial, String[] materialColetado, boolean naoPermiteVisualizarPaciente, boolean ocultarConvenio, int metodoSelecionado, Statement st, Statement stTemp, boolean agruparImpressaoMapaMultiguia, boolean imprimirMapaPorMetodo, boolean isAlimentos, boolean agruparGuiasInterface, int codigoLayoutPadrao, String impressoraMapa, String tamanhoNomeImpressora, String[] impressorasLocais, boolean utilizaMetodoParaBuscarResultadoAnterior, String ordenarExamesAnteriores, boolean considerarConferencia, boolean precoMetodologia, String tipoFilialPadrao, String login, boolean isColetaWeb, boolean pesquisarAnterioresAutocopiaPaciente, String copiaPaciente, String filialPadrao, boolean isOcultarApenasFaturamento) throws Exception {
        int i;
        RetornoImpressaoMapa retorno = new RetornoImpressaoMapa();
        ArrayList<String> listaMapas = new ArrayList<String>();
        if (st == null) {
            retorno.setImprimiu(false);
            return retorno;
        }
        StringBuilder buf = new StringBuilder("");
        buf.append("select a.exa_codigo, a.exr_situacao from examerequisicao a ");
        buf.append("left join examematcoleta g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo ");
        buf.append(" where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and a.req_codigo = ");
        buf.append(requisicao);
        buf.append(" and a.exr_excluido = false ");
        if (isOcultarApenasFaturamento) {
            buf.append(" and a.exr_situacao <> 'A' ");
        }
        buf.append(" order by g.emc_pagina, g.emc_ordem, a.exa_codigo, a.mco_codigo ");
        ResultSet rs = st.executeQuery(buf.toString());
        StringBuilder exm = new StringBuilder("");
        while (rs.next()) {
            if (!Funcoes.textoVazio(exm.toString())) {
                exm.append(" ");
            }
            if (rs.getString("exr_situacao").equalsIgnoreCase("A")) {
                exm.append(rs.getString("exa_codigo")).append("^");
                continue;
            }
            exm.append(rs.getString("exa_codigo"));
        }
        buf.delete(0, buf.length());
        buf.append("select a.mto_codigo, b.mto_descricao ");
        buf.append("from requisicaomedicamento a ");
        buf.append("left join medicamentos b on a.fil_codigo = b.fil_codigo and a.mto_codigo = b.mto_codigo ");
        buf.append("where a.fil_codigo = ").append(filial);
        buf.append(" and a.req_codigo = ").append(requisicao);
        buf.append(" order by b.mto_descricao");
        rs = st.executeQuery(buf.toString());
        StringBuilder medicamentos = new StringBuilder("");
        while (rs.next()) {
            if (!Funcoes.textoVazio(medicamentos.toString())) {
                medicamentos.append(", ");
            }
            medicamentos.append(rs.getString("mto_descricao"));
        }
        Integer[] multiguiasTemp = RecepcaoUtil.verificaMultiGuias(st, filial, requisicao, true, false);
        String multiguiaPrincipal = requisicao;
        for (Integer i2 : multiguiasTemp) {
            if (i2 >= Integer.parseInt(multiguiaPrincipal)) continue;
            multiguiaPrincipal = String.valueOf(i2);
        }
        StringBuilder multiguias = new StringBuilder("");
        for (Integer i3 : multiguiasTemp) {
            if (multiguias.length() > 0) {
                multiguias.append(", ");
            }
            multiguias.append(i3);
        }
        if (multiguiasTemp.length > 0) {
            for (Integer codigo : multiguiasTemp) {
                if (Integer.parseInt(requisicao) == codigo) continue;
                buf.delete(0, buf.length());
                buf.append("select a.exa_codigo, a.exr_situacao  from examerequisicao a ");
                buf.append("left join examematcoleta g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo ");
                buf.append(" where a.fil_codigo = ");
                buf.append(filial);
                buf.append(" and a.req_codigo = ");
                buf.append(codigo);
                buf.append(" and a.exr_excluido = false ");
                if (isOcultarApenasFaturamento) {
                    buf.append(" and a.exr_situacao <> 'A' ");
                }
                buf.append(" order by g.emc_pagina, g.emc_ordem, a.exa_codigo, a.mco_codigo ");
                rs = st.executeQuery(buf.toString());
                if (!rs.next()) continue;
                do {
                    if (exm.toString().indexOf("<") > 0 && !exm.toString().trim().endsWith(">")) {
                        exm.append(" ");
                    } else {
                        exm.append(" <");
                    }
                    if (rs.getString("exr_situacao").equalsIgnoreCase("A")) {
                        exm.append(rs.getString("exa_codigo")).append("^");
                        continue;
                    }
                    exm.append(rs.getString("exa_codigo"));
                } while (rs.next());
                exm.append(">");
            }
        }
        String datasParciais = Impressao.pegaDatasEntregaParcial(st, filial, requisicao);
        buf.delete(0, buf.length());
        buf.append("select ");
        if (agruparImpressaoMapaMultiguia) {
            buf.append(multiguiaPrincipal);
        } else {
            buf.append("a.req_codigo");
        }
        buf.append(" as codigoRequisicao, a.req_data as dataRequisicao, a.req_dtfatura as dataFaturaRequisicao, a.req_urgente as urgenteRequisicao, a.req_dataentregaprev as dataEntregaRequisicao,");
        buf.append("a.req_responsavel as responsavelPacienteRequisicao, a.req_cpfresponsavel as cpfResponsavelPacienteRequisicao,coalesce(a.req_incapacitado,false) as incapacitadoPacienteRequisicao,");
        buf.append("j.pac_responsavel as responsavelPaciente, j.pac_cpfresponsavel as cpfResponsavelPaciente, coalesce(j.pac_incapacitado,false) as incapacitadoPaciente,");
        buf.append("a.req_dclinicos as dadosClinicosRequisicao, a.req_obs as obsRequisicao, a.req_totpago as totalPagoRequisicao, a.req_horaentregaprev as horaEntregaRequisicao, a.req_total as totalRequisicao,");
        buf.append("a.req_horafatura as horaFaturaRequisicao, a.req_hora as horaRequisicao, a.req_gestante as gestanteRequisicao, a.req_dum as dumRequisicao, a.req_idade as idadeRequisicao, a.req_anomes as anoMesRequisicao,");
        buf.append("a.req_matricula as matriculaRequisicao, a.req_avisarpaciente as avisarPacienteRequisicao, a.req_senhaweb as senhaWebRequisicao, a.req_titular as titularRequisicao, a.req_peso as pesoRequisicao,");
        buf.append("a.req_altura as alturaRequisicao, a.req_desconto as descontoRequisicao, a.req_vlrdesconto as valorDescontoRequisicao,");
        buf.append("a.req_acrescimo as acrescimoRequisicao, a.req_vlracrescimo as valorAcrescimoRequisicao, ");
        buf.append("a.req_imprimirseparado as imprimirSeparadoRequisicao, '' as datasEntregaParcialRequisicao, ");
        buf.append("a.req_prontuario as prontuarioRequisicao, a.req_complementodestino as complementoDestinoRequisicao, ");
        buf.append("a.sit_codigo as codigoSituacao, g.sit_descricao as descricaoSituacao,");
        buf.append("a.req_quarto as quartoRequisicao, a.req_leito as leitoRequisicao, a.ala_codigo as codigoAla, ala.ala_descricao as descricaoAla, ");
        buf.append("'" + exm.toString() + "' as codigosExames, ");
        buf.append("'" + StringUtil.textoDB(medicamentos.toString()) + "' as medicamentosRequisicao, ");
        buf.append(multiguiaPrincipal).append(" as codigoPrincipalMultiGuiaRequisicao, ");
        buf.append("'").append(multiguias.toString()).append("' as codigosMultiGuiaRequisicao, ");
        buf.append("a.usr_codigo as codigoUsuario, h.usr_nome as nomeUsuario,");
        buf.append("a.usr_codigo as codigoUsuarioAbertura, usrabriu.usr_nome as nomeUsuarioAbertura,");
        buf.append("k.cid_codigo as codigoCidadeConvenio, k.cid_nome as descricaoCidadeConvenio, k.cid_uf as estadoCidadeConvenio,");
        buf.append("l.cid_codigo as codigoCidadeMedico, l.cid_nome as descricaoCidadeMedico, l.cid_uf as estadoCidadeMedico,");
        buf.append("m.cid_codigo as codigoCidadeDestino, m.cid_nome as descricaoCidadeDestino, m.cid_uf as estadoCidadeDestino,");
        buf.append("n.cid_codigo as codigoCidadeColeta, n.cid_nome as descricaoCidadeColeta, n.cid_uf as estadoCidadeColeta,");
        buf.append("o.cid_codigo as codigoCidadePaciente, o.cid_nome as descricaoCidadePaciente, o.cid_uf as estadoCidadePaciente,");
        buf.append("p.bai_codigo as codigoBairroConvenio, p.bai_descricao as descricaoBairroConvenio,");
        buf.append("q.bai_codigo as codigoBairroMedico, q.bai_descricao as descricaoBairroMedico,");
        buf.append("r.bai_codigo as codigoBairroDestino, r.bai_descricao as descricaoBairroDestino,");
        buf.append("s.bai_codigo as codigoBairroColeta, s.bai_descricao as descricaoBairroColeta,");
        buf.append("t.bai_codigo as codigoBairroPaciente, t.bai_descricao as descricaoBairroPaciente,");
        buf.append("a.des_codigo as codigoDestino, e.des_descricao as descricaoDestino, e.des_endereco as enderecoDestino, e.des_complemento as complementoDestino,e.des_cep as cepDestino, e.des_fone as foneDestino,");
        buf.append("a.col_codigo as codigoColeta, f.col_descricao as descricaoColeta, f.col_endereco as enderecoColeta, f.col_complemento as complementoColeta, f.col_cep as cepColeta, f.col_fone as foneColeta,");
        buf.append("a.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, ");
        buf.append("filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial,");
        buf.append("cidfilial.cid_codigo as codigoCidadeFilial, cidfilial.cid_nome as descricaoCidadeFilial, cidfilial.cid_uf as estadoCidadeFilial,");
        buf.append("baifilial.bai_codigo as codigoBairroFilial, baifilial.bai_descricao as descricaoBairroFilial,");
        buf.append("d.med_conselho as conselhoMedico, d.med_crm as crmMedico, d.med_uf as estadoCrmMedico, d.med_nome as nomeMedico, d.med_abrev as tratamentoMedico, d.med_endereco as enderecoMedico, d.med_numeroendereco as numeroEnderecoMedico, d.med_tipologradouroendereco as tipoLogradouroMedico, ");
        buf.append("d.med_complemento as complementoMedico, d.med_cep as cepMedico, d.med_fone as foneMedico, d.med_celular as celularMedico, d.med_fax as faxMedico, d.med_email as emailMedico, d.med_site as siteMedico,");
        buf.append("c.con_codigo as codigoConvenio, ");
        if (ocultarConvenio) {
            buf.append("'Visualiza\u00e7\u00e3o n\u00e3o permitida' as fantasiaConvenio, ");
            buf.append("'Visualiza\u00e7\u00e3o n\u00e3o permitida' as razaoSocialConvenio, ");
        } else {
            buf.append("c.con_fantasia as fantasiaConvenio, c.con_razao as razaoSocialConvenio, ");
        }
        buf.append("c.con_endereco as enderecoConvenio, c.con_numeroendereco as numeroEnderecoConvenio, c.con_tipologradouroendereco as tipoLogradouroConvenio,   c.con_complemento as complementoConvenio, c.con_cep as cepConvenio, ");
        buf.append("c.con_fone as foneConvenio, c.con_email1 as email1Convenio, c.con_email2 as email2Convenio, c.con_site as siteConvenio,");
        buf.append("conrepasse.con_codigo as codigoConvenioRepasse, conrepasse.con_fantasia as fantasiaConvenioRepasse, conrepasse.con_razao as razaoSocialConvenioRepasse, conrepasse.con_endereco as enderecoConvenioRepasse, ");
        buf.append("conrepasse.con_complemento as complementoConvenioRepasse, conrepasse.con_cep as cepConvenioRepasse, conrepasse.con_fone as foneConvenioRepasse, conrepasse.con_email1 as email1ConvenioRepasse, ");
        buf.append("conrepasse.con_email2 as email2ConvenioRepasse, conrepasse.con_site as siteConvenioRepasse,");
        buf.append("j.pac_codigo as codigoPaciente, j.pac_nome as nomePaciente, j.pac_sexo as sexoPaciente, j.pac_datanasc as dataNascimentoPaciente, j.pac_grpsangue as grupoSanguineoPaciente, j.pac_fatorrh as fatorRHPaciente, ");
        buf.append("j.pac_fatordu as fatorDUPaciente, j.pac_cor as corPaciente,");
        buf.append("j.pac_profissao as profissaoPaciente, j.pac_rg as rgPaciente, j.pac_cpf as cpfPaciente, j.pac_estcivil as estadoCivilPaciente, j.pac_dum as dumPaciente, j.pac_fone as fonePaciente, ");
        buf.append("j.pac_celular as celularPaciente, j.pac_fax as faxPaciente, j.pac_fonecomercial as foneComercialPaciente,");
        buf.append("j.pac_endereco as enderecoPaciente, j.pac_numeroendereco as numeroEnderecoPaciente, j.pac_tipologradouroendereco as tipoLogradouroPaciente, j.pac_complemento as complementoPaciente, j.pac_cep as cepPaciente, j.pac_email as emailPaciente, j.pac_fonecontato as foneContatoPaciente, j.pac_nomecontato as contatoPaciente,");
        buf.append("j.pac_diabetico as diabeticoPaciente, j.pac_fumante as fumantePaciente, j.pac_codigoapoiado as codigoApoiadoPaciente, ");
        buf.append("b.exa_codigo as codigoExame, w.exa_descricao as descricaoExame, b.exr_vlrchexame as ambExame, b.exr_vlrchexame as chExame, b.exr_vlrexame as valorExame, a.req_vlrexames as valorExamesRequisicao, ");
        buf.append("a.req_vlrmateriais as valorMateriaisRequisicao, b.exr_situacao as situacaoExame, '' as descricaoSituacaoExame, ");
        buf.append("v.mco_descricao as descricaoMaterial, v.mco_codigo as codigoMaterial, v.mco_abreviatura as abreviaturaMaterial, b.exr_datamaterial as dataColetaExame, b.exr_datamaterial as horaColetaExame, ");
        buf.append("coalesce(b.exr_urgente, false) as urgenteExame, ");
        buf.append("b.usr_codmaterial as usuarioColetaExame, usrcoleta.usr_nome as nomeUsuarioColetaExame, prazo.prz_descricao as descricaoPrazo, prazo.prz_codigo as codigoPrazo, CASE WHEN exr_intervaloJejum is null then TO_CHAR(exr_tempoJejum,'HH24:MI:SS') else TO_CHAR(exr_intervaloJejum,'HH24:MI:SS') end  as tempoJejumExame, ");
        buf.append("b.exr_tempodiurese as tempoDiureseExame, b.exr_volumediurese as volumeDiureseExame, ");
        buf.append("metodo.met_descricao as descricaoMetodo, b.exr_descricaomaterial as materialInformadoExame, b.exr_dataentregaprev as dataEntregaExame, b.exr_dataentregaprev as horaEntregaExame, ");
        buf.append("set.set_codigo as codigoSetor, set.set_descricao as descricaoSetor, set.set_responsavel as responsavelSetor, set.set_Sigla as siglaSetor, ");
        buf.append("a.req_codcopia as codigoCopiaRequisicao, ");
        buf.append("b.exr_resposta as respostaExameRequisicao, ");
        buf.append("a.req_perguntas as perguntasRequisicao, ");
        if (imprimirMapaPorMetodo) {
            buf.append("b.met_codigo as codigoMetodo, ");
        } else {
            buf.append("metodo.met_codigo as codigoMetodo, ");
        }
        buf.append("pri.pri_codigo as codigoPrioridade, pri.pri_descricao as descricaoPrioridade, ");
        buf.append("us.uns_codigo as codigoUnidadeSaude, us.uns_descricao as descricaoUnidadeSaude, us.uns_endereco as enderecoUnidadeSaude, us.uns_complemento as complementoUnidadeSaude, us.uns_cep as cepUnidadeSaude, us.uns_fone as foneUnidadeSaude,");
        buf.append("cidadeus.cid_codigo as codigoCidadeUnidadeSaude, cidadeus.cid_nome as descricaoCidadeUnidadeSaude, cidadeus.cid_uf as estadoCidadeUnidadeSaude,");
        buf.append("bairrous.bai_codigo as codigoBairroUnidadeSaude, bairrous.bai_descricao as descricaoBairroUnidadeSaude, ");
        buf.append("a.req_descricaoproduto as descricaoProdutoRequisicao, ");
        buf.append("a.req_datafabricacao as dataFabricacaoProdutoRequisicao, ");
        buf.append("a.req_numeroregistroproduto as numeroRegistroProdutoRequisicao, ");
        buf.append("a.req_temperaturacoletaproduto as temperaturaColetaProdutoRequisicao, ");
        buf.append("a.req_numeroloteproduto as numeroLoteProdutoRequisicao, ");
        buf.append("a.req_datavalidade as dataValidadeProdutoRequisicao, ");
        buf.append("a.req_marcaproduto as marcaProdutoRequisicao, ");
        buf.append("a.req_datacoletaproduto as dataColetaProdutoRequisicao, ");
        buf.append("a.req_horacoletaproduto as horaColetaProdutoRequisicao, ");
        buf.append("a.req_lacreproduto as lacreProdutoRequisicao, ");
        buf.append("a.req_lacreprodutocontra as lacreContraProvaProdutoRequisicao, ");
        buf.append("a.req_lacreprodutocontraempresa as lacreContraProvaEmpresaProdutoRequisicao, ");
        buf.append("a.req_doctoreferenciaproduto as documentoReferenciaProdutoRequisicao, ");
        buf.append("a.req_temperaturarecebimento as temperaturaRecebimentoProdutoRequisicao, ");
        buf.append("a.req_sanitariasproduto as caracteristicasSanitariasProdutoRequisicao, ");
        buf.append("a.req_condicoesambproduto as condicoesAmbientaisProdutoRequisicao, ");
        buf.append("a.req_procedimentocoletaproduto as procedimentoColetaProdutoRequisicao, ");
        buf.append("a.req_tiporecebimentoproduto as tipoRecebimentoProdutoRequisicao, ");
        buf.append("a.req_partidaproduto as partidaProdutoRequisicao, ");
        buf.append("a.req_qtdeamostraproduto as qtdeAmostrasProdutoRequisicao, ");
        buf.append("a.req_qtdeunidadeproduto as qtdeUnidadeProdutoRequisicao, ");
        buf.append("a.unm_codigo as codigoUnidadeProdutoRequisicao, ");
        buf.append("unidademedida.unm_descricao as descricaoUnidadeProdutoRequisicao, ");
        buf.append("a.emb_codigo as codigoEmbalagemProdutoRequisicao, ");
        buf.append("emb.emb_descricao as descricaoEmbalagemProdutoRequisicao, ");
        buf.append("a.req_anoprpproduto as anoPRPProdutoRequisicao, a.req_cicloprpproduto as cicloPRPProdutoRequisicao, ");
        buf.append("a.req_amostraprpproduto as amostraPRPProdutoRequisicao, a.req_amostrasupprpproduto as amostraSupervisaoPRPProdutoRequisicao, ");
        buf.append("a.req_horainicioturnoprpproduto as horaInicioTurnoPRPProdutoRequisicao, a.req_linhaprpproduto as linhaPRPProdutoRequisicao, ");
        buf.append("a.req_volumeabateprpproduto as volumeAbatePRPProdutoRequisicao, a.req_turnoprpproduto as turnoPRPProdutoRequisicao, ");
        if (isAlimentos) {
            buf.append("pal.pal_codigo as codigoProdutoAlimento, ");
            buf.append("pal.pal_descricao as descricaoProdutoAlimento, ");
            buf.append("cpl.cpl_codigo as codigoCategoriaProdutoAlimento, ");
            buf.append("cpl.cpl_descricao as descricaoCategoriaProdutoAlimento, ");
        } else {
            buf.append("'' as codigoProdutoAlimento, ");
            buf.append("'' as descricaoProdutoAlimento, ");
            buf.append("'' as codigoCategoriaProdutoAlimento, ");
            buf.append("'' as descricaoCategoriaProdutoAlimento, ");
        }
        buf.append("a.req_areaproduto as areaProdutoRequisicao, ");
        buf.append("paccontatos.pco_nome as nomeResponsavelRequisicao_, ");
        buf.append("paccontatos.pco_cargo as cargoResponsavelRequisicao_, ");
        buf.append("paccontatos.pco_email as emailResponsavelRequisicao_, ");
        buf.append("paccontatos.pco_fone as foneResponsavelRequisicao_, ");
        buf.append("ent.ent_fantasia as nomeResponsavelRequisicao, ");
        buf.append("ent.ent_cargo as cargoResponsavelRequisicao, ");
        buf.append("ent.ent_email as emailResponsavelRequisicao, ");
        buf.append("ent.ent_fone as foneResponsavelRequisicao, ");
        buf.append("a.req_datarecebimentoproduto as dataRecebimentoProdutoRequisicao, ");
        buf.append("a.req_horarecebimentoproduto as horaRecebimentoProdutoRequisicao, ");
        buf.append("a.req_localcoletaproduto as localColetaProdutoRequisicao, ");
        buf.append("a.req_nrsolicitacaoproduto as numeroSolicitacaoProdutoRequisicao, ");
        buf.append("j.bai_codigocobranca as codigoBairroCobrancaPaciente, ");
        buf.append("baicobranca.bai_descricao as descricaoBairroCobrancaPaciente, ");
        buf.append("j.cid_codigocobranca as codigoCidadeCobrancaPaciente, ");
        buf.append("cidcobranca.cid_nome as descricaoCidadeCobrancaPaciente, ");
        buf.append("cidcobranca.cid_uf as estadoCidadeCobrancaPaciente, ");
        buf.append("j.pac_razaosocial as razaoSocialPaciente, ");
        buf.append("j.pac_cnpj as cnpjPaciente, ");
        buf.append("j.pac_ie as inscricaoEstadualPaciente, ");
        buf.append("j.pac_proprietario as proprietarioPaciente, ");
        buf.append("j.pac_sif as sifPaciente, ");
        buf.append("j.pac_tipologradouroendcobranca as tipoLogradouroCobrancaPaciente, ");
        buf.append("j.pac_enderecocobranca as enderecoCobrancaPaciente, ");
        buf.append("j.pac_numeroenderecocobranca as numeroEnderecoCobrancaPaciente, ");
        buf.append("j.pac_complementocobranca as complementoCobrancaPaciente, ");
        buf.append("j.pac_cepcobranca as cepCobrancaPaciente, ");
        buf.append("j.pac_fonecobranca as foneCobrancaPaciente, ");
        buf.append("j.pac_responsavelcobranca as responsavelCobrancaPaciente, ");
        buf.append("j.pac_nomesocial as nomeSocialPaciente, ");
        buf.append("j.pac_whatsapp as whatsAppPaciente, ");
        buf.append("u.emc_instrcoleta as instrucoesColetaExame, ");
        buf.append("j.pac_pelagem as pelagemPaciente, ");
        buf.append("especie.epc_codigo as codigoEspecie, especie.epc_descricao as descricaoEspecie, especie.epc_cientifico as cientificoEspecie, ");
        buf.append("raca.rac_codigo as codigoRaca, raca.rac_descricao as descricaoRaca, raca.rac_cientifico as cientificoRaca ");
        buf.append(" ,b.exr_datarecoleta IS NOT NULL as temRecoleta, ");
        buf.append("a.req_procedencia as procedenciaRequisicao, ");
        buf.append("CASE WHEN a.req_nrsuplemento = 0 THEN '' ELSE 's' || a.req_nrsuplemento END  as suplementoRequisicao, ");
        buf.append("a.req_cartaosus as cartaoSUSRequisicao, ");
        buf.append("j.pac_cartaosus as cartaoSUSPaciente ");
        buf.append(", age(a.req_data, j.pac_datanasc) as idadeRequisicaoPaciente ");
        buf.append(", a.req_periodogestacional as periodoGestacionalRequisicao, j.pac_passaporte as passaportePaciente ");
        buf.append("from requisicao a ");
        buf.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
        if (isOcultarApenasFaturamento) {
            buf.append(" and b.exr_situacao <> 'A' ");
        }
        buf.append("left join convenios c on a.fil_codigo = c.fil_codigo and a.con_codigo = c.con_codigo ");
        buf.append("left join convenios conrepasse on a.fil_codigo = conrepasse.fil_codigo and a.con_codrepasse = conrepasse.con_codigo ");
        buf.append("left join medico d on a.fil_codigo = d.fil_codigo and a.med_conselho = d.med_conselho and upper(a.med_crm) = upper(d.med_crm) and a.med_uf = d.med_uf ");
        buf.append("left join destino e on a.fil_codigo = e.fil_codigo and upper(a.des_codigo) = upper(e.des_codigo) ");
        buf.append("left join coletas f on a.fil_codigo = f.fil_codigo and upper(a.col_codigo) = upper(f.col_codigo) ");
        buf.append("left join situacao g on a.fil_codigo = g.fil_codigo and a.sit_codigo = g.sit_codigo ");
        buf.append("left join usuario h on upper(a.usr_codigo) = upper(h.usr_codigo) ");
        buf.append("left join usuario usrabriu on upper(a.usr_codabertura) = upper(usrabriu.usr_codigo) ");
        buf.append("left join usuario usrcoleta on upper(b.usr_codmaterial) = upper(usrcoleta.usr_codigo) ");
        buf.append("left join paciente j on a.fil_codigo = j.fil_codigo and a.pac_codigo = j.pac_codigo ");
        buf.append("left join cidades k on c.fil_codigo = k.fil_codigo and c.cid_codigo = k.cid_codigo ");
        buf.append("left join cidades l on d.fil_codigo = l.fil_codigo and d.cid_codigo = l.cid_codigo ");
        buf.append("left join cidades m on e.fil_codigo = m.fil_codigo and e.cid_codigo = m.cid_codigo ");
        buf.append("left join cidades n on f.fil_codigo = n.fil_codigo and f.cid_codigo = n.cid_codigo ");
        buf.append("left join cidades o on j.fil_codigo = o.fil_codigo and j.cid_codigo = o.cid_codigo ");
        buf.append("left join bairro p on c.fil_codigo = p.fil_codigo and c.bai_codigo = p.bai_codigo ");
        buf.append("left join bairro q on d.fil_codigo = q.fil_codigo and d.bai_codigo = q.bai_codigo ");
        buf.append("left join bairro r on e.fil_codigo = r.fil_codigo and e.bai_codigo = r.bai_codigo ");
        buf.append("left join bairro s on f.fil_codigo = s.fil_codigo and f.bai_codigo = s.bai_codigo ");
        buf.append("left join bairro t on j.fil_codigo = t.fil_codigo and j.bai_codigo = t.bai_codigo ");
        buf.append("left join examematcoleta u on b.fil_codigo = u.fil_codigo and b.exa_codigo = u.exa_codigo and b.mco_codigo = u.mco_codigo ");
        buf.append("left join materialcoleta v on u.fil_codigo = v.fil_codigo and u.mco_codigo = v.mco_codigo ");
        buf.append("left join exames w on b.fil_codigo = w.fil_codigo and b.exa_codigo = w.exa_codigo ");
        buf.append("join examesetor ese on w.fil_codigo = ese.fil_codigo and w.exa_codigo = ese.exa_codigo ");
        buf.append(" and ese.ese_printmapa = true ");
        buf.append("left join setores set on ese.fil_codigo = set.fil_codigo and ese.set_codigo = set.set_codigo ");
        buf.append("left join prazoentrega prazo on u.fil_codigo = prazo.fil_codigo and u.prz_codigo = prazo.prz_codigo ");
        if (imprimirMapaPorMetodo) {
            buf.append("left join metodologia metodo on b.fil_codigo = metodo.fil_codigo and b.met_codigo = metodo.met_codigo ");
        } else {
            buf.append("left join metodologia metodo on u.fil_codigo = metodo.fil_codigo and u.met_codigo = metodo.met_codigo ");
        }
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo ");
        buf.append("left join cidades cidfilial on filial.fil_codigo = cidfilial.fil_codigo and filial.cid_codigo = cidfilial.cid_codigo ");
        buf.append("left join bairro baifilial on filial.fil_codigo = baifilial.fil_codigo and filial.bai_codigo = baifilial.bai_codigo ");
        buf.append("left join alahospital ala on a.fil_codigo = ala.fil_codigo and a.ala_codigo = ala.ala_codigo ");
        buf.append("left join unidadesaude us on a.fil_codigo = us.fil_codigo and a.uns_codigo = us.uns_codigo ");
        buf.append("left join cidades cidadeus on us.fil_codigo = cidadeus.fil_codigo and us.cid_codigo = cidadeus.cid_codigo ");
        buf.append("left join bairro bairrous on us.fil_codigo = bairrous.fil_codigo and us.bai_codigo = bairrous.bai_codigo ");
        buf.append("left join unidademedida on a.fil_codigo = unidademedida.fil_codigo and a.unm_codigo = unidademedida.unm_codigo ");
        buf.append("left join pacientescontatos paccontatos on a.fil_codigo = paccontatos.fil_codigo and a.pac_codigo = paccontatos.pac_codigo and a.pco_codigo = paccontatos.pco_codigo ");
        buf.append("left join entidade ent on a.fil_codigo = ent.fil_codigo and a.ent_codigo = ent.ent_codigo ");
        buf.append("left join cidades cidcobranca on j.fil_codigo = cidcobranca.fil_codigo and j.cid_codigocobranca = cidcobranca.cid_codigo ");
        buf.append("left join bairro baicobranca on j.fil_codigo = baicobranca.fil_codigo and j.bai_codigocobranca = baicobranca.bai_codigo ");
        buf.append("left join embalagemproduto emb on a.fil_codigo = emb.fil_codigo and a.emb_codigo = emb.emb_codigo ");
        buf.append("left join especie on j.fil_codigo = especie.fil_codigo and j.epc_codigo = especie.epc_codigo ");
        buf.append("left join raca on especie.fil_codigo = raca.fil_codigo and especie.epc_codigo = raca.epc_codigo and j.rac_codigo = raca.rac_codigo ");
        buf.append("left join prioridade pri on c.fil_codigo = pri.fil_codigo and c.pri_codigo = pri.pri_codigo ");
        if (isAlimentos) {
            buf.append("left join categoriaprodutoalimentos cpl on a.fil_codigo = cpl.fil_codigo and a.cpl_codigo = cpl.cpl_codigo ");
            buf.append("left join produtoalimentos pal on a.fil_codigo = pal.fil_codigo and pal.pal_codigo = a.pal_codigo and cpl.cpl_codigo = pal.cpl_codigo ");
        }
        buf.append("where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and a.req_codigo");
        if (agruparImpressaoMapaMultiguia) {
            buf.append(" in ( ").append((CharSequence)multiguias).append(" )");
        } else {
            buf.append(" = ").append(requisicao);
        }
        buf.append(" and a.req_excluida = false and b.exr_excluido = false ");
        if (apenasMapasComTriagem) {
            buf.append(" and b.exr_dataetqtriagem is not null ");
        }
        buf.append("and (u.emc_imprimirmapa = true or u.emc_imprimirmapa is null) ");
        if (exames != null && exames.length > 0) {
            if (filtroExamesComMaterial) {
                buf.append(" and (");
                for (i = 0; i < exames.length; i += 2) {
                    buf.append("(b.exa_codigo = '");
                    buf.append(exames[i]);
                    buf.append("' and b.mco_codigo = ");
                    buf.append(exames[i + 1]);
                    buf.append(") ");
                    if (i + 1 >= exames.length - 1) continue;
                    buf.append(" or ");
                }
                buf.append(") ");
            } else {
                buf.append(" and (");
                for (i = 0; i < exames.length; ++i) {
                    buf.append("(b.exa_codigo = '");
                    buf.append(exames[i]);
                    buf.append("') ");
                    if (i >= exames.length - 1) continue;
                    buf.append(" or ");
                }
                buf.append(") ");
            }
        }
        if (setores != null && setores.length > 0) {
            buf.append(" and ese.set_codigo in (");
            for (i = 0; i < setores.length; ++i) {
                buf.append(setores[i]);
                if (i >= setores.length - 1) continue;
                buf.append(" , ");
            }
            buf.append(") ");
        }
        if (materialColetado != null && materialColetado.length > 0) {
            buf.append(" and b.mco_codigo in (");
            for (i = 0; i < materialColetado.length; ++i) {
                buf.append(materialColetado[i]);
                if (i >= materialColetado.length - 1) continue;
                buf.append(" , ");
            }
            buf.append(") ");
        }
        buf.append(" and (b.exr_situacao = ' ' or b.exr_situacao is null or b.exr_situacao = '' ");
        if (imprimirMapaPorMetodo) {
            buf.append(" or b.exr_situacao = '").append("C").append("'");
            buf.append(" or b.exr_situacao = '").append("L").append("'");
            buf.append(" or b.exr_situacao = '").append("I").append("'");
            buf.append(" or b.exr_situacao = '").append("E").append("'");
            buf.append(" or b.exr_situacao = '").append("O").append("'");
            buf.append(" or b.exr_situacao = '").append("P").append("'");
            buf.append(" or b.exr_situacao = '").append("N").append("'");
        }
        buf.append(")");
        if (!reimprimir) {
            buf.append(" and b.exr_datamapa is null");
        }
        buf.append(" order by codigoRequisicao, ese.set_codigo, u.emc_pagina, u.emc_ordem, b.exa_codigo, b.mco_codigo");
        String[] campos = Impressao.CAMPOS_MAPA;
        String[] perguntasFilial = RecepcaoUtil.getPerguntasFilial(filial, st);
        if (perguntasFilial.length > 0) {
            campos = ArraysUtil.concatenar(Impressao.CAMPOS_MAPA, perguntasFilial);
        }
        ModeloGridTable modeloDados = new ModeloGridTable(campos);
        String codigoConvenio = "";
        String codigoDestino = "";
        String codigoLayout = "";
        rs = st.executeQuery(buf.toString());
        while (rs.next()) {
            if (agruparGuiasInterface) {
                boolean jaAdicionado = false;
                for (int x = 0; x < modeloDados.getRowCount(); ++x) {
                    if (!ImprimirMapa.contemRegistro(modeloDados, x, rs)) continue;
                    jaAdicionado = true;
                    break;
                }
                if (jaAdicionado) continue;
            }
            codigoConvenio = rs.getString("codigoConvenio");
            codigoDestino = rs.getString("codigoDestino");
            idade = rs.getInt("idadeRequisicao");
            tipoIdade = rs.getString("anoMesRequisicao");
            modeloDados.addLine(new Object[campos.length]);
            buf.delete(0, buf.length());
            buf.append(" and exa_codigo = '");
            buf.append(rs.getString("codigoExame"));
            buf.append("' and mco_codigo = ");
            buf.append(rs.getString("codigoMaterial"));
            listaMapas.add(buf.toString());
            Map<String, Object> respostasRequisicao = null;
            for (int i4 = 0; i4 < Impressao.CAMPOS_MAPA.length; ++i4) {
                if (DBUtil.campoNull(rs.getString(Impressao.CAMPOS_MAPA[i4]))) {
                    modeloDados.setValueAt(null, modeloDados.getRowCount() - 1, i4);
                } else if (Impressao.CAMPOS_MAPA[i4].equals("tipoLogradouroMedico") || Impressao.CAMPOS_MAPA[i4].equals("tipoLogradouroConvenio") || Impressao.CAMPOS_MAPA[i4].equals("tipoLogradouroCobrancaPaciente") || Impressao.CAMPOS_MAPA[i4].equals("tipoLogradouroPaciente")) {
                    modeloDados.setValueAt(Tipos.tipoLogradouroDescricao(rs.getString(Impressao.CAMPOS_MAPA[i4])), modeloDados.getRowCount() - 1, i4);
                } else if (Impressao.CAMPOS_MAPA[i4].equals("sexoPaciente")) {
                    modeloDados.setValueAt(Tipos.tipoSexo(rs.getString(Impressao.CAMPOS_MAPA[i4])), modeloDados.getRowCount() - 1, i4);
                } else if (Impressao.CAMPOS_MAPA[i4].equals("corPaciente")) {
                    modeloDados.setValueAt(Tipos.tipoCor(rs.getString(Impressao.CAMPOS_MAPA[i4])), modeloDados.getRowCount() - 1, i4);
                } else if (Impressao.CAMPOS_MAPA[i4].equalsIgnoreCase("estadoCivilPaciente")) {
                    modeloDados.setValueAt(Tipos.tipoEstadoCivil(rs.getString(Impressao.CAMPOS_MAPA[i4])), modeloDados.getRowCount() - 1, i4);
                } else if (Impressao.CAMPOS_MAPA[i4].equalsIgnoreCase("descricaoSituacaoExame")) {
                    modeloDados.setValueAt(Tipos.tipoEstadoCivil(rs.getString("descricaoSituacaoExame")), modeloDados.getRowCount() - 1, i4);
                } else if (Impressao.CAMPOS_MAPA[i4].equals("datasEntregaParcialRequisicao")) {
                    modeloDados.setValueAt(datasParciais, modeloDados.getRowCount() - 1, i4);
                } else if (Impressao.CAMPOS_MAPA[i4].equals("obsRequisicao")) {
                    modeloDados.setValueAt(ImprimirMapa.retirarEnter(rs.getString("obsRequisicao")), modeloDados.getRowCount() - 1, i4);
                } else if (Impressao.CAMPOS_MAPA[i4].equals("cartaoSUSPaciente")) {
                    modeloDados.setValueAt(rs.getString("cartaoSUSPaciente"), modeloDados.getRowCount() - 1, i4);
                } else if (Impressao.CAMPOS_MAPA[i4].equals("cartaoSUSRequisicao")) {
                    modeloDados.setValueAt(rs.getString("cartaoSUSRequisicao"), modeloDados.getRowCount() - 1, i4);
                } else if (Impressao.CAMPOS_MAPA[i4].equalsIgnoreCase("tempoDiureseExame")) {
                    modeloDados.setValueAt(rs.getString(Impressao.CAMPOS_MAPA[i4]), modeloDados.getRowCount() - 1, i4);
                }
                if (Impressao.CAMPOS_MAPA[i4].equalsIgnoreCase("nomePaciente")) {
                    if (naoPermiteVisualizarPaciente) {
                        modeloDados.setValueAt("Visualiza\u00e7\u00e3o n\u00e3o permitida", modeloDados.getRowCount() - 1, i4);
                        continue;
                    }
                    modeloDados.setValueAt(rs.getString(Impressao.CAMPOS_MAPA[i4]), modeloDados.getRowCount() - 1, i4);
                    continue;
                }
                if (Impressao.CAMPOS_MAPA[i4].equals("idadeRequisicaoPaciente")) {
                    modeloDados.setValueAt(Funcoes.getIntervaloParaString((PGInterval)rs.getObject(Impressao.CAMPOS_MAPA[i4]), null), modeloDados.getRowCount() - 1, i4);
                    continue;
                }
                if (Impressao.CAMPOS_MAPA[i4].equals("codigoMetodo") && metodoSelecionado > 0) {
                    modeloDados.setValueAt(metodoSelecionado, modeloDados.getRowCount() - 1, i4);
                    continue;
                }
                if (Impressao.CAMPOS_MAPA[i4].equals("perguntasRequisicao")) {
                    if (Funcoes.textoVazio(rs.getString("perguntasRequisicao"))) continue;
                    respostasRequisicao = Resultado.getCamposResultado(rs.getString("perguntasRequisicao"));
                    for (Map.Entry<String, Object> resposta : respostasRequisicao.entrySet()) {
                        if (modeloDados.findColumn(resposta.getKey()) <= -1) continue;
                        modeloDados.setValueAt(resposta.getValue(), modeloDados.getRowCount() - 1, modeloDados.findColumn(resposta.getKey()));
                    }
                    continue;
                }
                modeloDados.setValueAt(rs.getObject(Impressao.CAMPOS_MAPA[i4]), modeloDados.getRowCount() - 1, i4);
            }
        }
        rs.close();
        if (Funcoes.textoVazio(codigoConvenio) || Funcoes.textoVazio(codigoDestino)) {
            retorno.setImprimiu(false);
            return retorno;
        }
        codigoLayout = ExameUtil.getCodigoLayout(filial, codigoConvenio, codigoDestino, st, codigoLayoutPadrao);
        buf.delete(0, buf.length());
        buf.append("select lay_cabecmapa, lay_tipomapa from layout where fil_codigo = ");
        buf.append(filial);
        buf.append(" and lay_codigo = ");
        buf.append(codigoLayout);
        ResultSet rsLayout = st.executeQuery(buf.toString());
        if (rsLayout.next() && !Funcoes.textoVazio(rsLayout.getString("lay_cabecmapa"))) {
            String tipo = rsLayout.getString("lay_tipomapa");
            String layout = rsLayout.getString("lay_cabecmapa");
            if (tipo.equalsIgnoreCase("C")) {
                Iterator perguntasRequisicao;
                Hashtable<String, Documento> impressoras = new Hashtable<String, Documento>();
                int ultimoSetor = -1;
                Documento doc = null;
                while (modeloDados.getRowCount() > 0) {
                    if (impressoraMapa.equalsIgnoreCase("Impressora setor")) {
                        int codigoSetor = ultimoSetor > -1 ? ultimoSetor : -1;
                        int colunaSetor = ImprimirMapa.achaColunaSetor(modeloDados);
                        int linha = 0;
                        if (codigoSetor == -1 || codigoSetor != Integer.parseInt(modeloDados.getValueAt(linha, colunaSetor).toString())) {
                            codigoSetor = Integer.parseInt(modeloDados.getValueAt(linha, colunaSetor).toString());
                        }
                        SetorBean setor = null;
                        setor = (SetorBean)new SetorService().get(filial, String.valueOf(codigoSetor));
                        if (setor != null) {
                            String impressora = setor.getImpressora();
                            if (impressora == null || Funcoes.textoVazio(impressora)) throw new Exception("Nenhuma impressora configurada para o setor (c\u00f3d. setor = " + ultimoSetor + ").");
                            if (impressoras != null && impressoras.get(Impressao.comparaNomeImpressoraReduzido(impressora, tamanhoNomeImpressora, impressorasLocais)) != null) {
                                doc = (Documento)impressoras.get(Impressao.comparaNomeImpressoraReduzido(impressora));
                            } else {
                                doc = new Documento();
                                impressoras.put(Impressao.comparaNomeImpressoraReduzido(impressora, tamanhoNomeImpressora, impressorasLocais), doc);
                            }
                        }
                    } else {
                        String impressora = impressoraMapa;
                        if (impressoras != null && impressoras.get(Impressao.comparaNomeImpressoraReduzido(impressora, tamanhoNomeImpressora, impressorasLocais)) != null) {
                            doc = (Documento)impressoras.get(Impressao.comparaNomeImpressoraReduzido(impressora, tamanhoNomeImpressora, impressorasLocais));
                        } else {
                            doc = new Documento();
                            impressoras.put(Impressao.comparaNomeImpressoraReduzido(impressora, tamanhoNomeImpressora, impressorasLocais), doc);
                        }
                    }
                    doc.setSempreReposicionarEntrePaginas(true);
                    doc.setCabecalhoRodape(layout);
                    perguntasRequisicao = null;
                    int coluna = ImprimirMapa.achaColunaPerguntasRequisicao(modeloDados);
                    if (coluna > -1 && modeloDados.getValueAt(0, coluna) != null && !Funcoes.textoVazio(modeloDados.getValueAt(0, coluna).toString())) {
                        perguntasRequisicao = Resultado.getCamposResultado(modeloDados.getValueAt(0, coluna).toString());
                    }
                    Map mapRequisicao = ImprimirMapa.tableModel2Hash(modeloDados, 0);
                    if (perguntasRequisicao != null) {
                        mapRequisicao.putAll(perguntasRequisicao);
                    }
                    if (modeloDados.getRowCount() > 0) {
                        doc.setDadosBanco(mapRequisicao);
                    }
                    ultimoSetor = ImprimirMapa.criaPaginaDocumento(filial, doc, modeloDados, ultimoSetor, layout, codigoLayout, st, stTemp, utilizaMetodoParaBuscarResultadoAnterior, ordenarExamesAnteriores, considerarConferencia, precoMetodologia, tipoFilialPadrao, login, pesquisarAnterioresAutocopiaPaciente, copiaPaciente, filialPadrao);
                }
                if (isColetaWeb) {
                    perguntasRequisicao = impressoras.entrySet().iterator();
                    if (perguntasRequisicao.hasNext()) {
                        Map.Entry impressora = perguntasRequisicao.next();
                        retorno.setByteArray(Impressao.gerarPdfDocumento((Documento)impressora.getValue()));
                        return retorno;
                    }
                } else {
                    for (String impressora : impressoras.keySet()) {
                        Documento documento = (Documento)impressoras.get(impressora);
                        if (documento.getQuantidadeResultados() <= 0) continue;
                        jalis.laboratorio.impressao.Impressao impressao = new jalis.laboratorio.impressao.Impressao(impressora);
                        impressao.imprimir(documento);
                        retorno.setImprimiu(true);
                    }
                }
            } else if (tipo.equalsIgnoreCase("D")) {
                int ultimoSetor = -1;
                ArrayList<Mapa> mapas = new ArrayList<Mapa>();
                Map<String, Object> perguntasRequisicao = null;
                int coluna = ImprimirMapa.achaColunaPerguntasRequisicao(modeloDados);
                if (coluna > -1 && modeloDados.getValueAt(0, coluna) != null && !Funcoes.textoVazio(modeloDados.getValueAt(0, coluna).toString())) {
                    perguntasRequisicao = Resultado.getCamposResultado(modeloDados.getValueAt(0, coluna).toString());
                }
                while (modeloDados.getRowCount() > 0) {
                    Mapa mapa = new Mapa();
                    if ((ultimoSetor = ImprimirMapa.criaPagina(filial, mapa, modeloDados, ultimoSetor, layout, codigoLayout, perguntasRequisicao)) <= -1) continue;
                    if (ParametrosLocais.getParametro("impressaoLaserMapa") != null && ParametrosLocais.getParametro("impressaoLaserMapa").equalsIgnoreCase("1")) {
                        mapas.add(mapa);
                    } else {
                        ImpressaoMapa impressao = null;
                        if (impressoraMapa != null && impressoraMapa.equalsIgnoreCase("Impressora setor")) {
                            SetorBean setor = null;
                            setor = (SetorBean)new SetorService().get(filial, String.valueOf(ultimoSetor));
                            if (setor != null) {
                                String impressora = setor.getImpressora();
                                if (impressora == null || Funcoes.textoVazio(impressora)) throw new Exception("Nenhuma impressora configurada para o setor (c\u00f3d. setor = " + ultimoSetor + ").");
                                impressao = new ImpressaoMapa(Impressao.comparaNomeImpressoraReduzido(impressora));
                            }
                        } else {
                            impressao = new ImpressaoMapa(Impressao.comparaNomeImpressoraReduzido(impressoraMapa));
                        }
                        if (impressao == null) throw new Exception("N\u00e3o foi poss\u00edvel gerar a impress\u00e3o.");
                        impressao.imprimir(mapa);
                    }
                    retorno.setImprimiu(true);
                }
                ImpressaoMapa imprimir = null;
                if (impressoraMapa.equalsIgnoreCase("Impressora setor")) {
                    SetorBean setor = null;
                    setor = (SetorBean)new SetorService().get(Variaveis.filialPadrao, String.valueOf(ultimoSetor));
                    if (setor != null) {
                        String impressora = setor.getImpressora();
                        if (impressora == null || Funcoes.textoVazio(impressora)) throw new Exception("Nenhuma impressora configurada para o setor (c\u00f3d. setor = " + ultimoSetor + ").");
                        imprimir = new ImpressaoMapa(Impressao.comparaNomeImpressoraReduzido(impressora));
                    }
                } else {
                    imprimir = new ImpressaoMapa(Impressao.comparaNomeImpressoraReduzido(impressoraMapa));
                }
                if (!mapas.isEmpty()) {
                    imprimir.imprimir(mapas.toArray(new Mapa[mapas.size()]));
                }
                if (ParametrosLocais.getParametro("impressaoLaserMapa") != null && ParametrosLocais.getParametro("impressaoFinalizarMapa") != null && ParametrosLocais.getParametro("impressaoLaserMapa").equalsIgnoreCase("1") && ParametrosLocais.getParametro("impressaoFinalizarMapa").equalsIgnoreCase("1")) {
                    imprimir.terminar();
                }
            }
            ImprimirMapa.atualizaDataMapa(filial, requisicao, st, listaMapas, login, isColetaWeb);
        } else {
            Funcoes.mensagem(null, "Modelo n\u00e3o localizado ou n\u00e3o definido", 1);
        }
        rsLayout.close();
        st.close();
        stTemp.close();
        return retorno;
    }

    private static void atualizaDataMapa(String filial, String requisicao, Statement st, ArrayList listaMapas, String login, boolean isColetaWeb) throws SQLException {
        try {
            for (int i = 0; i < listaMapas.size(); ++i) {
                StringBuilder buf = new StringBuilder();
                buf.append("update examerequisicao set exr_datamapa = current_timestamp, usr_codmapa = '");
                buf.append(login);
                buf.append("' where fil_codigo = ");
                buf.append(filial);
                buf.append(" and req_codigo = ");
                buf.append(requisicao);
                buf.append(listaMapas.get(i).toString());
                Conexao.execute(filial, st, buf.toString());
            }
            if (!isColetaWeb) {
                Conexao.arquivaSQL();
            }
        }
        catch (SQLException ex) {
            if (!isColetaWeb) {
                Conexao.anulaSQL();
            }
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "ImprimirMapa (348)");
        }
    }

    private static boolean isAlimentos() {
        return Variaveis.tipoFilialPadrao.equals("A");
    }

    private static boolean contemRegistro(ModeloGridTable modeloDados, int linha, ResultSet rs) throws SQLException {
        return !Funcoes.objectIsNull(modeloDados.getValueAt(linha, modeloDados.findColumn("codigoExame"))) && !Funcoes.objectIsNull(modeloDados.getValueAt(linha, modeloDados.findColumn("codigoMaterial"))) && modeloDados.getValueAt(linha, modeloDados.findColumn("codigoExame")).toString().toUpperCase().equals(rs.getString("codigoExame").toString().toUpperCase()) && modeloDados.getValueAt(linha, modeloDados.findColumn("codigoMaterial")).toString().toUpperCase().equals(rs.getString("codigoMaterial").toString().toUpperCase()) && modeloDados.getValueAt(linha, modeloDados.findColumn("siglaSetor")).toString().toUpperCase().equals(rs.getString("siglaSetor").toString().toUpperCase());
    }

    private static String retirarEnter(String texto) {
        return texto.replaceAll("\n", " ");
    }

    private static int criaPagina(String filial, Mapa mapa, ModeloGridTable modelo, int ultimoSetor, String formato, String layout, Map<String, Object> perguntasRequisicao) throws SQLException {
        if (modelo.getRowCount() == 0) {
            return -1;
        }
        int colunaSetor = ImprimirMapa.achaColunaSetor(modelo);
        int colunaResposta = ImprimirMapa.achaColuna(modelo, "respostaExameRequisicao");
        int colunaPerguntas = ImprimirMapa.achaColunaPerguntasRequisicao(modelo);
        int linha = 0;
        if (ultimoSetor == -1 || ultimoSetor != Integer.parseInt(modelo.getValueAt(linha, colunaSetor).toString())) {
            ultimoSetor = Integer.parseInt(modelo.getValueAt(linha, colunaSetor).toString());
        }
        while (modelo.getRowCount() > 0 && Integer.parseInt(modelo.getValueAt(linha, colunaSetor).toString()) == ultimoSetor) {
            String xmlLayout;
            int camposRstAnterior;
            ModeloGridTable modeloTemp = new ModeloGridTable(Impressao.CAMPOS_MAPA);
            modeloTemp.copyLine(modelo.getLine(linha));
            String paciente = ImprimirMapa.pegaCodigoPaciente(modeloTemp, modeloTemp.getRowCount() - 1);
            String exame = ImprimirMapa.pegaCodigoExame(modeloTemp, modeloTemp.getRowCount() - 1);
            int material = ImprimirMapa.pegaCodigoMaterial(modeloTemp, modeloTemp.getRowCount() - 1);
            String metodo = String.valueOf(ImprimirMapa.pegaCodigoMetodo(modeloTemp, modeloTemp.getRowCount() - 1));
            Map<Integer, String> map = ExameUtil.getResultadosAnteriores(filial, "", paciente, exame, String.valueOf(material), metodo);
            HashMap<Integer, String> mapAnteriores = new HashMap<Integer, String>();
            Map<String, Object> externos = null;
            if (modeloTemp.getValueAt(modeloTemp.getRowCount() - 1, colunaResposta) != null) {
                externos = Resultado.getCamposResultado(modeloTemp.getValueAt(modeloTemp.getRowCount() - 1, colunaResposta).toString());
            }
            if (colunaPerguntas > -1 && perguntasRequisicao != null) {
                for (String k : perguntasRequisicao.keySet()) {
                    modeloTemp.insertColumn(k);
                    Object valor = perguntasRequisicao.get(k);
                    for (int i = 0; i < modeloTemp.getRowCount(); ++i) {
                        modeloTemp.setValueAt(valor, i, modeloTemp.getColumnCount() - 1);
                    }
                }
            }
            if ((camposRstAnterior = Mapa.getQuantidadeResultadosAnteriores(xmlLayout = ExameUtil.pegaLayoutIdade(filial, idade, tipoIdade, layout, exame, material, Integer.parseInt(metodo), "elm_mapa"))) < map.size() && ParametrosGerais.getOrdenarExamesAnteriores().equals("C")) {
                int diferenca = map.size() - camposRstAnterior;
                for (Integer key : map.keySet()) {
                    if (key - diferenca <= 0) continue;
                    mapAnteriores.put(key - diferenca, map.get(key));
                }
            } else {
                mapAnteriores.putAll(map);
            }
            mapa.addExame(xmlLayout, modeloTemp, mapAnteriores, externos);
            if (linha + 1 >= modelo.getRowCount()) {
                mapa.setCabecalhoRodape(formato, modeloTemp);
            } else if (Funcoes.isNumeric(modelo.getValueAt(linha + 1, colunaSetor).toString()) && ultimoSetor != Integer.parseInt(modelo.getValueAt(linha + 1, colunaSetor).toString())) {
                mapa.setCabecalhoRodape(formato, modeloTemp);
            }
            modelo.removeLine(0);
        }
        return ultimoSetor;
    }

    private static int criaPaginaDocumento(String filial, Documento doc, ModeloGridTable modelo, int ultimoSetor, String formato, String layout) {
        return ImprimirMapa.criaPaginaDocumento(filial, doc, modelo, ultimoSetor, formato, layout, Conexao.getStatement(), Conexao.getStatement(), ParametrosGerais.isUtilizaMetodoParaBuscarResultadoAnterior(), ParametrosGerais.getOrdenarExamesAnteriores(), ParametrosGerais.getConferencia(), ParametrosGerais.getPrecoMetodologia(), Variaveis.tipoFilialPadrao, Variaveis.login, ParametrosGerais.isPesquisarAnterioresAutocopiaPaciente(), ParametrosGerais.getCopiaPaciente(), Variaveis.filialPadrao);
    }

    private static int criaPaginaDocumento(String filial, Documento doc, ModeloGridTable modelo, int ultimoSetor, String formato, String layout, Statement st, Statement stTemp, boolean utilizaMetodoParaBuscarResultadoAnterior, String ordenarExamesAnteriores, boolean considerarConferencia, boolean precoMetodologia, String tipoFilialPadrao, String login, boolean pesquisarAnterioresAutocopiaPaciente, String copiaPaciente, String filialPadrao) {
        if (modelo.getRowCount() == 0) {
            return -1;
        }
        int colunaSetor = ImprimirMapa.achaColunaSetor(modelo);
        int colunaResposta = ImprimirMapa.achaColuna(modelo, "respostaExameRequisicao");
        int linha = 0;
        if (ultimoSetor == -1 || ultimoSetor != Integer.parseInt(modelo.getValueAt(linha, colunaSetor).toString())) {
            ultimoSetor = Integer.parseInt(modelo.getValueAt(linha, colunaSetor).toString());
        }
        ArrayList<String> mapas = new ArrayList<String>();
        ArrayList<ExameMaterialPagina> exames = new ArrayList<ExameMaterialPagina>();
        while (modelo.getRowCount() > 0 && Integer.parseInt(modelo.getValueAt(linha, colunaSetor).toString()) == ultimoSetor) {
            String layoutXML;
            ModeloGridTable modeloTemp = new ModeloGridTable(Impressao.CAMPOS_MAPA);
            modeloTemp.copyLine(modelo.getLine(linha));
            int posicaoCodigoRequisicao = modeloTemp.findColumn("codigoRequisicao");
            String codigoRequisicao = posicaoCodigoRequisicao > -1 ? modeloTemp.getValueAt(modeloTemp.getRowCount() - 1, posicaoCodigoRequisicao).toString() : "";
            String paciente = ImprimirMapa.pegaCodigoPaciente(modeloTemp, modeloTemp.getRowCount() - 1);
            String exame = ImprimirMapa.pegaCodigoExame(modeloTemp, modeloTemp.getRowCount() - 1);
            int material = ImprimirMapa.pegaCodigoMaterial(modeloTemp, modeloTemp.getRowCount() - 1);
            String metodo = String.valueOf(ImprimirMapa.pegaCodigoMetodo(modeloTemp, modeloTemp.getRowCount() - 1));
            Map<Integer, String> resAnteriores = null;
            if (!(Funcoes.textoVazio(codigoRequisicao) || Funcoes.textoVazio(paciente) || Funcoes.textoVazio(exame) || material <= -1)) {
                resAnteriores = ExameUtil.getResultadosAnteriores(filial, codigoRequisicao, paciente, exame, String.valueOf(material), metodo, st, utilizaMetodoParaBuscarResultadoAnterior, ordenarExamesAnteriores, tipoFilialPadrao.equals("A"), pesquisarAnterioresAutocopiaPaciente, copiaPaciente, filialPadrao);
            }
            if (Funcoes.textoVazio(layoutXML = ExameUtil.pegaLayoutIdade(filial, idade, tipoIdade, layout, exame, material, Integer.parseInt(metodo), "elm_mapa", null, false, st))) {
                layoutXML = ExameUtil.pegaLayoutIdade(filial, idade, tipoIdade, layout, exame, material, -1, "elm_mapa", null, false, st);
            }
            if (!Funcoes.textoVazio(layoutXML)) {
                String resultado = new Resultado(layoutXML, (Map<String, Object>)ImprimirMapa.tableModel2Hash(modeloTemp, modeloTemp.getRowCount() - 1), colunaResposta > -1 && modeloTemp.getValueAt(modeloTemp.getRowCount() - 1, colunaResposta) != null ? Resultado.getCamposResultado(modeloTemp.getValueAt(modeloTemp.getRowCount() - 1, colunaResposta).toString()) : null, resAnteriores, ordenarExamesAnteriores.equals("C") ? 0 : 1, true).getResultado();
                if (linha + 1 >= modelo.getRowCount()) {
                    doc.setCabecalhoRodape(formato);
                } else if (ultimoSetor != Integer.parseInt(modelo.getValueAt(linha + 1, colunaSetor).toString())) {
                    doc.setCabecalhoRodape(formato);
                }
                Map<String, Object> dados = ExameUtil.getDadosExameRequisicao2(st, stTemp, codigoRequisicao, exame, String.valueOf(material), filial, false, false, null, false, considerarConferencia, false, precoMetodologia, tipoFilialPadrao, login);
                TabelaSimbolos tabelaSimbolo = new TabelaSimbolos();
                tabelaSimbolo.setDados(dados);
                exames.add(new ExameMaterialPagina(exame, material, tabelaSimbolo));
                mapas.add(resultado);
            }
            modelo.removeLine(0);
        }
        String setor = "";
        try {
            setor = ImprimirMapa.getDescricaoSetor(ultimoSetor, filialPadrao, st);
        }
        catch (Exception posicaoCodigoRequisicao) {
            // empty catch block
        }
        ArrayList<String> tmpSetor = new ArrayList<String>();
        for (int i = 0; i < exames.size(); ++i) {
            tmpSetor.add(setor);
        }
        if (!tmpSetor.isEmpty()) {
            doc.addResultados(exames.toArray(new ExameMaterialPagina[exames.size()]), mapas.toArray(new String[mapas.size()]), tmpSetor.toArray(new String[tmpSetor.size()]));
        }
        exames.clear();
        return ultimoSetor;
    }

    private static String getDescricaoSetor(int setor, String filial, Statement st) throws SQLException {
        String retorno = "";
        StringBuilder sql = new StringBuilder();
        sql.append("select set_descricao from setores where fil_codigo = ").append(filial);
        sql.append(" and set_codigo = ").append(setor);
        ResultSet rs = st.executeQuery(sql.toString());
        if (rs.next()) {
            retorno = rs.getString("set_descricao");
        }
        rs.close();
        return retorno;
    }

    private static int achaColunaSetor(ModeloGridTable modelo) {
        return ImprimirMapa.achaColuna(modelo, "codigoSetor");
    }

    private static int achaColunaPerguntasRequisicao(ModeloGridTable modelo) {
        return ImprimirMapa.achaColuna(modelo, "perguntasRequisicao");
    }

    private static int achaColuna(ModeloGridTable modelo, String coluna) {
        int retorno = -1;
        for (int i = 0; i < modelo.getColumnCount(); ++i) {
            if (!modelo.getColumnName(i).equalsIgnoreCase(coluna)) continue;
            retorno = i;
            break;
        }
        return retorno;
    }

    private static Map tableModel2Hash(ModeloGridTable modelo, int linha) {
        if (modelo == null || modelo.getRowCount() < linha) {
            return null;
        }
        HashMap<String, Object> retorno = new HashMap<String, Object>();
        for (int i = 0; i < modelo.getColumnCount(); ++i) {
            retorno.put(modelo.getColumnName(i), modelo.getValueAt(linha, i));
        }
        return retorno;
    }

    private static String pegaCodigoPaciente(ModeloGridTable modelo, int linha) {
        String retorno = "";
        int pos = -1;
        for (int i = 0; i < modelo.getColumnCount(); ++i) {
            if (!modelo.getColumnName(i).equalsIgnoreCase("codigoPaciente")) continue;
            pos = i;
            break;
        }
        if (pos > -1) {
            retorno = String.valueOf(modelo.getValueAt(linha, pos));
        }
        return retorno;
    }

    private static String pegaCodigoExame(ModeloGridTable modelo, int linha) {
        String retorno = "";
        int pos = -1;
        for (int i = 0; i < modelo.getColumnCount(); ++i) {
            if (!modelo.getColumnName(i).equalsIgnoreCase("codigoExame")) continue;
            pos = i;
            break;
        }
        if (pos > -1) {
            retorno = (String)modelo.getValueAt(linha, pos);
        }
        return retorno;
    }

    private static int pegaCodigoMaterial(ModeloGridTable modelo, int linha) {
        int retorno = -1;
        int pos = -1;
        for (int i = 0; i < modelo.getColumnCount(); ++i) {
            if (!modelo.getColumnName(i).equalsIgnoreCase("codigoMaterial")) continue;
            pos = i;
            break;
        }
        if (pos > -1) {
            retorno = Integer.parseInt(modelo.getValueAt(linha, pos).toString());
        }
        return retorno;
    }

    private static int pegaCodigoMetodo(ModeloGridTable modelo, int linha) {
        int retorno = -1;
        int pos = -1;
        for (int i = 0; i < modelo.getColumnCount(); ++i) {
            if (!modelo.getColumnName(i).equalsIgnoreCase("codigoMetodo")) continue;
            pos = i;
            break;
        }
        if (pos > -1) {
            retorno = Integer.parseInt(modelo.getValueAt(linha, pos).toString());
        }
        return retorno;
    }
}

